
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_dcom.h"
#include "librpc/gen_ndr/ndr_dcom_ejs.h"



static NTSTATUS ejs_pull_UseProtSeq(struct ejs_rpc *ejs, struct MprVar *v, struct UseProtSeq *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_UseProtSeq(struct ejs_rpc *ejs, struct MprVar *v, const struct UseProtSeq *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_UseProtSeq(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dcom_Unknown, DCERPC_USEPROTSEQ, (ejs_pull_function_t)ejs_pull_UseProtSeq, (ejs_push_function_t)ejs_push_UseProtSeq);
}


static NTSTATUS ejs_pull_GetCustomProtseqInfo(struct ejs_rpc *ejs, struct MprVar *v, struct GetCustomProtseqInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_GetCustomProtseqInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct GetCustomProtseqInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_GetCustomProtseqInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dcom_Unknown, DCERPC_GETCUSTOMPROTSEQINFO, (ejs_pull_function_t)ejs_pull_GetCustomProtseqInfo, (ejs_push_function_t)ejs_push_GetCustomProtseqInfo);
}


static NTSTATUS ejs_pull_UpdateResolverBindings(struct ejs_rpc *ejs, struct MprVar *v, struct UpdateResolverBindings *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_UpdateResolverBindings(struct ejs_rpc *ejs, struct MprVar *v, const struct UpdateResolverBindings *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_UpdateResolverBindings(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dcom_Unknown, DCERPC_UPDATERESOLVERBINDINGS, (ejs_pull_function_t)ejs_pull_UpdateResolverBindings, (ejs_push_function_t)ejs_push_UpdateResolverBindings);
}

static int ejs_dcom_Unknown_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "dcom_Unknown", argc, argv);
	mprSetCFunction(obj, "UseProtSeq", ejs_UseProtSeq);
	mprSetCFunction(obj, "GetCustomProtseqInfo", ejs_GetCustomProtseqInfo);
	mprSetCFunction(obj, "UpdateResolverBindings", ejs_UpdateResolverBindings);
	return ejs_rpc_init(obj, "dcom_Unknown");
}

NTSTATUS ejs_init_dcom_Unknown(void)
{
	ejsDefineCFunction(-1, "dcom_Unknown_init", ejs_dcom_Unknown_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IUnknown, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IUnknown, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IUnknown, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}

static int ejs_IUnknown_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IUnknown", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	return ejs_rpc_init(obj, "IUnknown");
}

NTSTATUS ejs_init_IUnknown(void)
{
	ejsDefineCFunction(-1, "IUnknown_init", ejs_IUnknown_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassFactory, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassFactory, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassFactory, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_CreateInstance(struct ejs_rpc *ejs, struct MprVar *v, struct CreateInstance *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "pUnknown")) {
		r->in.pUnknown = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.pUnknown);
		NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "pUnknown", r->in.pUnknown));
	}
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_CreateInstance(struct ejs_rpc *ejs, struct MprVar *v, const struct CreateInstance *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.ppv) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.ppv) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "ppv", *r->out.ppv));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_CreateInstance(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassFactory, DCERPC_CREATEINSTANCE, (ejs_pull_function_t)ejs_pull_CreateInstance, (ejs_push_function_t)ejs_push_CreateInstance);
}


static NTSTATUS ejs_pull_RemoteCreateInstance(struct ejs_rpc *ejs, struct MprVar *v, struct RemoteCreateInstance *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemoteCreateInstance(struct ejs_rpc *ejs, struct MprVar *v, const struct RemoteCreateInstance *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemoteCreateInstance(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassFactory, DCERPC_REMOTECREATEINSTANCE, (ejs_pull_function_t)ejs_pull_RemoteCreateInstance, (ejs_push_function_t)ejs_push_RemoteCreateInstance);
}


static NTSTATUS ejs_pull_LockServer(struct ejs_rpc *ejs, struct MprVar *v, struct LockServer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "lock", &r->in.lock));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_LockServer(struct ejs_rpc *ejs, struct MprVar *v, const struct LockServer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_LockServer(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassFactory, DCERPC_LOCKSERVER, (ejs_pull_function_t)ejs_pull_LockServer, (ejs_push_function_t)ejs_push_LockServer);
}


static NTSTATUS ejs_pull_RemoteLockServer(struct ejs_rpc *ejs, struct MprVar *v, struct RemoteLockServer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemoteLockServer(struct ejs_rpc *ejs, struct MprVar *v, const struct RemoteLockServer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemoteLockServer(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassFactory, DCERPC_REMOTELOCKSERVER, (ejs_pull_function_t)ejs_pull_RemoteLockServer, (ejs_push_function_t)ejs_push_RemoteLockServer);
}

static int ejs_IClassFactory_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IClassFactory", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "CreateInstance", ejs_CreateInstance);
	mprSetCFunction(obj, "RemoteCreateInstance", ejs_RemoteCreateInstance);
	mprSetCFunction(obj, "LockServer", ejs_LockServer);
	mprSetCFunction(obj, "RemoteLockServer", ejs_RemoteLockServer);
	return ejs_rpc_init(obj, "IClassFactory");
}

NTSTATUS ejs_init_IClassFactory(void)
{
	ejsDefineCFunction(-1, "IClassFactory_init", ejs_IClassFactory_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_REMQIRESULT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct REMQIRESULT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "hResult", &r->hResult));
	NDR_CHECK(ejs_push_STDOBJREF(ejs, v, "std", &r->std));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_REMQIRESULT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct REMQIRESULT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_WERROR(ejs, v, "hResult", &r->hResult));
	NDR_CHECK(ejs_pull_STDOBJREF(ejs, v, "std", &r->std));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_REMINTERFACEREF(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct REMINTERFACEREF *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "ipid", &r->ipid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cPublicRefs", &r->cPublicRefs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cPrivateRefs", &r->cPrivateRefs));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_RemQueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct RemQueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "ripid")) {
		r->in.ripid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.ripid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "ripid", r->in.ripid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cRefs", &r->in.cRefs));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cIids", &r->in.cIids));
	if (ejs_pull_null(ejs, v, "iids")) {
		r->in.iids = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->in.iids, r->in.cIids);
			for (i=0;i<r->in.cIids;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "iids", i);
				NDR_CHECK(ejs_pull_GUID(ejs, v, id, &r->in.iids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "iids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemQueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct RemQueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.ip) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.cIids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "ip", i);
				if (NULL == r->out.ip[i]) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, id, r->out.ip[i]));
				}
			}
			ejs_push_uint32(ejs, v, "ip" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemQueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown, DCERPC_REMQUERYINTERFACE, (ejs_pull_function_t)ejs_pull_RemQueryInterface, (ejs_push_function_t)ejs_push_RemQueryInterface);
}


static NTSTATUS ejs_pull_RemAddRef(struct ejs_rpc *ejs, struct MprVar *v, struct RemAddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cInterfaceRefs", &r->in.cInterfaceRefs));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.InterfaceRefs, r->in.cInterfaceRefs);
		for (i=0;i<r->in.cInterfaceRefs;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "InterfaceRefs", i);
			NDR_CHECK(ejs_pull_REMINTERFACEREF(ejs, v, id, &r->in.InterfaceRefs[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "InterfaceRefs" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemAddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct RemAddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.pResults) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.cInterfaceRefs;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "pResults", i);
				if (NULL == r->out.pResults[i]) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					NDR_CHECK(ejs_push_WERROR(ejs, v, id, r->out.pResults[i]));
				}
			}
			ejs_push_uint32(ejs, v, "pResults" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemAddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown, DCERPC_REMADDREF, (ejs_pull_function_t)ejs_pull_RemAddRef, (ejs_push_function_t)ejs_push_RemAddRef);
}


static NTSTATUS ejs_pull_RemRelease(struct ejs_rpc *ejs, struct MprVar *v, struct RemRelease *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cInterfaceRefs", &r->in.cInterfaceRefs));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.InterfaceRefs, r->in.cInterfaceRefs);
		for (i=0;i<r->in.cInterfaceRefs;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "InterfaceRefs", i);
			NDR_CHECK(ejs_pull_REMINTERFACEREF(ejs, v, id, &r->in.InterfaceRefs[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "InterfaceRefs" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemRelease(struct ejs_rpc *ejs, struct MprVar *v, const struct RemRelease *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemRelease(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown, DCERPC_REMRELEASE, (ejs_pull_function_t)ejs_pull_RemRelease, (ejs_push_function_t)ejs_push_RemRelease);
}

static int ejs_IRemUnknown_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IRemUnknown", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "RemQueryInterface", ejs_RemQueryInterface);
	mprSetCFunction(obj, "RemAddRef", ejs_RemAddRef);
	mprSetCFunction(obj, "RemRelease", ejs_RemRelease);
	return ejs_rpc_init(obj, "IRemUnknown");
}

NTSTATUS ejs_init_IRemUnknown(void)
{
	ejsDefineCFunction(-1, "IRemUnknown_init", ejs_IRemUnknown_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassActivator, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassActivator, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassActivator, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_GetClassObject(struct ejs_rpc *ejs, struct MprVar *v, struct GetClassObject *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "clsid", &r->in.clsid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "context", &r->in.context));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "locale", &r->in.locale));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", &r->in.iid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_GetClassObject(struct ejs_rpc *ejs, struct MprVar *v, const struct GetClassObject *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", r->out.data));
	}
	return NT_STATUS_OK;
}

static int ejs_GetClassObject(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IClassActivator, DCERPC_GETCLASSOBJECT, (ejs_pull_function_t)ejs_pull_GetClassObject, (ejs_push_function_t)ejs_push_GetClassObject);
}

static int ejs_IClassActivator_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IClassActivator", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "GetClassObject", ejs_GetClassObject);
	return ejs_rpc_init(obj, "IClassActivator");
}

NTSTATUS ejs_init_IClassActivator(void)
{
	ejsDefineCFunction(-1, "IClassActivator_init", ejs_IClassActivator_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISCMLocalActivator, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISCMLocalActivator, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISCMLocalActivator, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_GetClassObject(struct ejs_rpc *ejs, struct MprVar *v, struct GetClassObject *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "clsid", &r->in.clsid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "context", &r->in.context));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "locale", &r->in.locale));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", &r->in.iid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_GetClassObject(struct ejs_rpc *ejs, struct MprVar *v, const struct GetClassObject *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", r->out.data));
	}
	return NT_STATUS_OK;
}

static int ejs_GetClassObject(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISCMLocalActivator, DCERPC_GETCLASSOBJECT, (ejs_pull_function_t)ejs_pull_GetClassObject, (ejs_push_function_t)ejs_push_GetClassObject);
}


static NTSTATUS ejs_pull_ISCMLocalActivator_CreateInstance(struct ejs_rpc *ejs, struct MprVar *v, struct ISCMLocalActivator_CreateInstance *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ISCMLocalActivator_CreateInstance(struct ejs_rpc *ejs, struct MprVar *v, const struct ISCMLocalActivator_CreateInstance *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ISCMLocalActivator_CreateInstance(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISCMLocalActivator, DCERPC_ISCMLOCALACTIVATOR_CREATEINSTANCE, (ejs_pull_function_t)ejs_pull_ISCMLocalActivator_CreateInstance, (ejs_push_function_t)ejs_push_ISCMLocalActivator_CreateInstance);
}

static int ejs_ISCMLocalActivator_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "ISCMLocalActivator", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "GetClassObject", ejs_GetClassObject);
	mprSetCFunction(obj, "ISCMLocalActivator_CreateInstance", ejs_ISCMLocalActivator_CreateInstance);
	return ejs_rpc_init(obj, "ISCMLocalActivator");
}

NTSTATUS ejs_init_ISCMLocalActivator(void)
{
	ejsDefineCFunction(-1, "ISCMLocalActivator_init", ejs_ISCMLocalActivator_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_IMachineLocalActivator_foo(struct ejs_rpc *ejs, struct MprVar *v, struct IMachineLocalActivator_foo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_IMachineLocalActivator_foo(struct ejs_rpc *ejs, struct MprVar *v, const struct IMachineLocalActivator_foo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_IMachineLocalActivator_foo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IMachineLocalActivator, DCERPC_IMACHINELOCALACTIVATOR_FOO, (ejs_pull_function_t)ejs_pull_IMachineLocalActivator_foo, (ejs_push_function_t)ejs_push_IMachineLocalActivator_foo);
}

static int ejs_IMachineLocalActivator_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IMachineLocalActivator", argc, argv);
	mprSetCFunction(obj, "IMachineLocalActivator_foo", ejs_IMachineLocalActivator_foo);
	return ejs_rpc_init(obj, "IMachineLocalActivator");
}

NTSTATUS ejs_init_IMachineLocalActivator(void)
{
	ejsDefineCFunction(-1, "IMachineLocalActivator_init", ejs_IMachineLocalActivator_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_ILocalObjectExporter_Foo(struct ejs_rpc *ejs, struct MprVar *v, struct ILocalObjectExporter_Foo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ILocalObjectExporter_Foo(struct ejs_rpc *ejs, struct MprVar *v, const struct ILocalObjectExporter_Foo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ILocalObjectExporter_Foo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ILocalObjectExporter, DCERPC_ILOCALOBJECTEXPORTER_FOO, (ejs_pull_function_t)ejs_pull_ILocalObjectExporter_Foo, (ejs_push_function_t)ejs_push_ILocalObjectExporter_Foo);
}

static int ejs_ILocalObjectExporter_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "ILocalObjectExporter", argc, argv);
	mprSetCFunction(obj, "ILocalObjectExporter_Foo", ejs_ILocalObjectExporter_Foo);
	return ejs_rpc_init(obj, "ILocalObjectExporter");
}

NTSTATUS ejs_init_ILocalObjectExporter(void)
{
	ejsDefineCFunction(-1, "ILocalObjectExporter_init", ejs_ILocalObjectExporter_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISystemActivator, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISystemActivator, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISystemActivator, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_GetClassObject(struct ejs_rpc *ejs, struct MprVar *v, struct GetClassObject *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "clsid", &r->in.clsid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "context", &r->in.context));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "locale", &r->in.locale));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", &r->in.iid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_GetClassObject(struct ejs_rpc *ejs, struct MprVar *v, const struct GetClassObject *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", r->out.data));
	}
	return NT_STATUS_OK;
}

static int ejs_GetClassObject(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISystemActivator, DCERPC_GETCLASSOBJECT, (ejs_pull_function_t)ejs_pull_GetClassObject, (ejs_push_function_t)ejs_push_GetClassObject);
}


static NTSTATUS ejs_pull_ISystemActivatorRemoteCreateInstance(struct ejs_rpc *ejs, struct MprVar *v, struct ISystemActivatorRemoteCreateInstance *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "iface1", &r->in.iface1));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "unknown2", &r->in.unknown2));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ISystemActivatorRemoteCreateInstance(struct ejs_rpc *ejs, struct MprVar *v, const struct ISystemActivatorRemoteCreateInstance *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.unknown3) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", r->out.unknown3));
	}
	if (NULL == r->out.iface2) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "iface2", r->out.iface2));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ISystemActivatorRemoteCreateInstance(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ISystemActivator, DCERPC_ISYSTEMACTIVATORREMOTECREATEINSTANCE, (ejs_pull_function_t)ejs_pull_ISystemActivatorRemoteCreateInstance, (ejs_push_function_t)ejs_push_ISystemActivatorRemoteCreateInstance);
}

static int ejs_ISystemActivator_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "ISystemActivator", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "GetClassObject", ejs_GetClassObject);
	mprSetCFunction(obj, "ISystemActivatorRemoteCreateInstance", ejs_ISystemActivatorRemoteCreateInstance);
	return ejs_rpc_init(obj, "ISystemActivator");
}

NTSTATUS ejs_init_ISystemActivator(void)
{
	ejsDefineCFunction(-1, "ISystemActivator_init", ejs_ISystemActivator_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown2, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown2, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown2, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_RemQueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct RemQueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "ripid")) {
		r->in.ripid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.ripid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "ripid", r->in.ripid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cRefs", &r->in.cRefs));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cIids", &r->in.cIids));
	if (ejs_pull_null(ejs, v, "iids")) {
		r->in.iids = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->in.iids, r->in.cIids);
			for (i=0;i<r->in.cIids;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "iids", i);
				NDR_CHECK(ejs_pull_GUID(ejs, v, id, &r->in.iids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "iids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemQueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct RemQueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.ip) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.cIids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "ip", i);
				if (NULL == r->out.ip[i]) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, id, r->out.ip[i]));
				}
			}
			ejs_push_uint32(ejs, v, "ip" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemQueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown2, DCERPC_REMQUERYINTERFACE, (ejs_pull_function_t)ejs_pull_RemQueryInterface, (ejs_push_function_t)ejs_push_RemQueryInterface);
}


static NTSTATUS ejs_pull_RemAddRef(struct ejs_rpc *ejs, struct MprVar *v, struct RemAddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cInterfaceRefs", &r->in.cInterfaceRefs));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.InterfaceRefs, r->in.cInterfaceRefs);
		for (i=0;i<r->in.cInterfaceRefs;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "InterfaceRefs", i);
			NDR_CHECK(ejs_pull_REMINTERFACEREF(ejs, v, id, &r->in.InterfaceRefs[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "InterfaceRefs" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemAddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct RemAddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.pResults) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.cInterfaceRefs;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "pResults", i);
				if (NULL == r->out.pResults[i]) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					NDR_CHECK(ejs_push_WERROR(ejs, v, id, r->out.pResults[i]));
				}
			}
			ejs_push_uint32(ejs, v, "pResults" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemAddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown2, DCERPC_REMADDREF, (ejs_pull_function_t)ejs_pull_RemAddRef, (ejs_push_function_t)ejs_push_RemAddRef);
}


static NTSTATUS ejs_pull_RemRelease(struct ejs_rpc *ejs, struct MprVar *v, struct RemRelease *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cInterfaceRefs", &r->in.cInterfaceRefs));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.InterfaceRefs, r->in.cInterfaceRefs);
		for (i=0;i<r->in.cInterfaceRefs;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "InterfaceRefs", i);
			NDR_CHECK(ejs_pull_REMINTERFACEREF(ejs, v, id, &r->in.InterfaceRefs[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "InterfaceRefs" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemRelease(struct ejs_rpc *ejs, struct MprVar *v, const struct RemRelease *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemRelease(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown2, DCERPC_REMRELEASE, (ejs_pull_function_t)ejs_pull_RemRelease, (ejs_push_function_t)ejs_push_RemRelease);
}


static NTSTATUS ejs_pull_RemQueryInterface2(struct ejs_rpc *ejs, struct MprVar *v, struct RemQueryInterface2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "ripid")) {
		r->in.ripid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.ripid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "ripid", r->in.ripid));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cIids", &r->in.cIids));
	if (ejs_pull_null(ejs, v, "iids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.iids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->in.iids, r->in.cIids);
			for (i=0;i<r->in.cIids;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "iids", i);
				if (ejs_pull_null(ejs, v, id)) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					EJS_ALLOC(ejs, r->in.iids[i]);
					NDR_CHECK(ejs_pull_GUID(ejs, v, id, r->in.iids[i]));
				}
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "iids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemQueryInterface2(struct ejs_rpc *ejs, struct MprVar *v, const struct RemQueryInterface2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.phr) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.cIids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "phr", i);
				if (NULL == r->out.phr[i]) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					NDR_CHECK(ejs_push_WERROR(ejs, v, id, r->out.phr[i]));
				}
			}
			ejs_push_uint32(ejs, v, "phr" ".length", &i);
		}
	}
	if (NULL == r->out.ppMIF) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.cIids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "ppMIF", i);
				if (NULL == r->out.ppMIF[i]) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, id, r->out.ppMIF[i]));
				}
			}
			ejs_push_uint32(ejs, v, "ppMIF" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemQueryInterface2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemUnknown2, DCERPC_REMQUERYINTERFACE2, (ejs_pull_function_t)ejs_pull_RemQueryInterface2, (ejs_push_function_t)ejs_push_RemQueryInterface2);
}

static int ejs_IRemUnknown2_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IRemUnknown2", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "RemQueryInterface", ejs_RemQueryInterface);
	mprSetCFunction(obj, "RemAddRef", ejs_RemAddRef);
	mprSetCFunction(obj, "RemRelease", ejs_RemRelease);
	mprSetCFunction(obj, "RemQueryInterface2", ejs_RemQueryInterface2);
	return ejs_rpc_init(obj, "IRemUnknown2");
}

NTSTATUS ejs_init_IRemUnknown2(void)
{
	ejsDefineCFunction(-1, "IRemUnknown2_init", ejs_IRemUnknown2_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_REF_ITypeInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct REF_ITypeInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_VARIANT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct VARIANT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "vartype", &r->vartype));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_DISPPARAMS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct DISPPARAMS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_DISPPARAMS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct DISPPARAMS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_EXCEPINFO(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct EXCEPINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IDispatch, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IDispatch, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IDispatch, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_GetTypeInfoCount(struct ejs_rpc *ejs, struct MprVar *v, struct GetTypeInfoCount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_GetTypeInfoCount(struct ejs_rpc *ejs, struct MprVar *v, const struct GetTypeInfoCount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.pctinfo) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint16(ejs, v, "pctinfo", r->out.pctinfo));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_GetTypeInfoCount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IDispatch, DCERPC_GETTYPEINFOCOUNT, (ejs_pull_function_t)ejs_pull_GetTypeInfoCount, (ejs_push_function_t)ejs_push_GetTypeInfoCount);
}


static NTSTATUS ejs_pull_GetTypeInfo(struct ejs_rpc *ejs, struct MprVar *v, struct GetTypeInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "iTInfo", &r->in.iTInfo));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lcid", &r->in.lcid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_GetTypeInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct GetTypeInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.ppTInfo) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.ppTInfo) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_REF_ITypeInfo(ejs, v, "ppTInfo", *r->out.ppTInfo));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_GetTypeInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IDispatch, DCERPC_GETTYPEINFO, (ejs_pull_function_t)ejs_pull_GetTypeInfo, (ejs_push_function_t)ejs_push_GetTypeInfo);
}


static NTSTATUS ejs_pull_GetIDsOfNames(struct ejs_rpc *ejs, struct MprVar *v, struct GetIDsOfNames *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "riid")) {
		r->in.riid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.riid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "riid", r->in.riid));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cNames", &r->in.cNames));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lcid", &r->in.lcid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_GetIDsOfNames(struct ejs_rpc *ejs, struct MprVar *v, const struct GetIDsOfNames *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.rgDispId) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.cNames;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "rgDispId", i);
				if (NULL == r->out.rgDispId[i]) {
					return NT_STATUS_INVALID_PARAMETER_MIX;
				} else {
					NDR_CHECK(ejs_push_uint32(ejs, v, id, r->out.rgDispId[i]));
				}
			}
			ejs_push_uint32(ejs, v, "rgDispId" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_GetIDsOfNames(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IDispatch, DCERPC_GETIDSOFNAMES, (ejs_pull_function_t)ejs_pull_GetIDsOfNames, (ejs_push_function_t)ejs_push_GetIDsOfNames);
}


static NTSTATUS ejs_pull_Invoke(struct ejs_rpc *ejs, struct MprVar *v, struct Invoke *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "dispIdMember", &r->in.dispIdMember));
	if (ejs_pull_null(ejs, v, "riid")) {
		r->in.riid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.riid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "riid", r->in.riid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lcid", &r->in.lcid));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "wFlags", &r->in.wFlags));
	if (ejs_pull_null(ejs, v, "pDispParams")) {
		r->in.pDispParams = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.pDispParams);
		NDR_CHECK(ejs_pull_DISPPARAMS(ejs, v, "pDispParams", r->in.pDispParams));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Invoke(struct ejs_rpc *ejs, struct MprVar *v, const struct Invoke *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.pDispParams) {
		NDR_CHECK(ejs_push_null(ejs, v, "pDispParams"));
	} else {
		NDR_CHECK(ejs_push_DISPPARAMS(ejs, v, "pDispParams", r->out.pDispParams));
	}
	if (NULL == r->out.pVarResult) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.pVarResult) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_VARIANT(ejs, v, "pVarResult", *r->out.pVarResult));
		}
	}
	if (NULL == r->out.pExcepInfo) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.pExcepInfo) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_EXCEPINFO(ejs, v, "pExcepInfo", *r->out.pExcepInfo));
		}
	}
	if (NULL == r->out.puArgErr) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.puArgErr) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_uint16(ejs, v, "puArgErr", *r->out.puArgErr));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Invoke(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IDispatch, DCERPC_INVOKE, (ejs_pull_function_t)ejs_pull_Invoke, (ejs_push_function_t)ejs_push_Invoke);
}

static int ejs_IDispatch_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IDispatch", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "GetTypeInfoCount", ejs_GetTypeInfoCount);
	mprSetCFunction(obj, "GetTypeInfo", ejs_GetTypeInfo);
	mprSetCFunction(obj, "GetIDsOfNames", ejs_GetIDsOfNames);
	mprSetCFunction(obj, "Invoke", ejs_Invoke);
	return ejs_rpc_init(obj, "IDispatch");
}

NTSTATUS ejs_init_IDispatch(void)
{
	ejsDefineCFunction(-1, "IDispatch_init", ejs_IDispatch_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IMarshal, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IMarshal, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IMarshal, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_MarshalInterface(struct ejs_rpc *ejs, struct MprVar *v, struct MarshalInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_MarshalInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct MarshalInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_MarshalInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IMarshal, DCERPC_MARSHALINTERFACE, (ejs_pull_function_t)ejs_pull_MarshalInterface, (ejs_push_function_t)ejs_push_MarshalInterface);
}


static NTSTATUS ejs_pull_UnMarshalInterface(struct ejs_rpc *ejs, struct MprVar *v, struct UnMarshalInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_UnMarshalInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct UnMarshalInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_UnMarshalInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IMarshal, DCERPC_UNMARSHALINTERFACE, (ejs_pull_function_t)ejs_pull_UnMarshalInterface, (ejs_push_function_t)ejs_push_UnMarshalInterface);
}

static int ejs_IMarshal_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IMarshal", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "MarshalInterface", ejs_MarshalInterface);
	mprSetCFunction(obj, "UnMarshalInterface", ejs_UnMarshalInterface);
	return ejs_rpc_init(obj, "IMarshal");
}

NTSTATUS ejs_init_IMarshal(void)
{
	ejsDefineCFunction(-1, "IMarshal_init", ejs_IMarshal_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ICoffeeMachine, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ICoffeeMachine, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ICoffeeMachine, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_MakeCoffee(struct ejs_rpc *ejs, struct MprVar *v, struct MakeCoffee *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "flavor")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.flavor);
		NDR_CHECK(ejs_pull_string(ejs, v, "flavor", &r->in.flavor));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_MakeCoffee(struct ejs_rpc *ejs, struct MprVar *v, const struct MakeCoffee *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_MakeCoffee(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_ICoffeeMachine, DCERPC_MAKECOFFEE, (ejs_pull_function_t)ejs_pull_MakeCoffee, (ejs_push_function_t)ejs_push_MakeCoffee);
}

static int ejs_ICoffeeMachine_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "ICoffeeMachine", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "MakeCoffee", ejs_MakeCoffee);
	return ejs_rpc_init(obj, "ICoffeeMachine");
}

NTSTATUS ejs_init_ICoffeeMachine(void)
{
	ejsDefineCFunction(-1, "ICoffeeMachine_init", ejs_ICoffeeMachine_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, struct QueryInterface *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	if (ejs_pull_null(ejs, v, "iid")) {
		r->in.iid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.iid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", r->in.iid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_QueryInterface(struct ejs_rpc *ejs, struct MprVar *v, const struct QueryInterface *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.data) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "data", *r->out.data));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_QueryInterface(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IStream, DCERPC_QUERYINTERFACE, (ejs_pull_function_t)ejs_pull_QueryInterface, (ejs_push_function_t)ejs_push_QueryInterface);
}


static NTSTATUS ejs_pull_AddRef(struct ejs_rpc *ejs, struct MprVar *v, struct AddRef *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_AddRef(struct ejs_rpc *ejs, struct MprVar *v, const struct AddRef *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_AddRef(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IStream, DCERPC_ADDREF, (ejs_pull_function_t)ejs_pull_AddRef, (ejs_push_function_t)ejs_push_AddRef);
}


static NTSTATUS ejs_pull_Release(struct ejs_rpc *ejs, struct MprVar *v, struct Release *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Release(struct ejs_rpc *ejs, struct MprVar *v, const struct Release *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Release(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IStream, DCERPC_RELEASE, (ejs_pull_function_t)ejs_pull_Release, (ejs_push_function_t)ejs_push_Release);
}


static NTSTATUS ejs_pull_Read(struct ejs_rpc *ejs, struct MprVar *v, struct Read *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_requested", &r->in.num_requested));
	if (ejs_pull_null(ejs, v, "num_readx")) {
		r->in.num_readx = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.num_readx);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "num_readx", r->in.num_readx));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Read(struct ejs_rpc *ejs, struct MprVar *v, const struct Read *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (r->out.num_read == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
	ejs_push_array_uint8(ejs, v, "pv", r->out.pv, *r->out.num_read);
	if (NULL == r->out.num_read) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "num_read", r->out.num_read));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Read(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IStream, DCERPC_READ, (ejs_pull_function_t)ejs_pull_Read, (ejs_push_function_t)ejs_push_Read);
}


static NTSTATUS ejs_pull_Write(struct ejs_rpc *ejs, struct MprVar *v, struct Write *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "ORPCthis", &r->in.ORPCthis));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_requested", &r->in.num_requested));
	if (ejs_pull_null(ejs, v, "data")) {
		r->in.data = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.data);
		EJS_ALLOC_N(ejs, r->in.data, r->in.num_requested);
		ejs_pull_array_uint8(ejs, v, "data", r->in.data, r->in.num_requested);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_Write(struct ejs_rpc *ejs, struct MprVar *v, const struct Write *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ORPCthat) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "ORPCthat", r->out.ORPCthat));
	}
	if (NULL == r->out.num_written) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "num_written", r->out.num_written));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_Write(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IStream, DCERPC_WRITE, (ejs_pull_function_t)ejs_pull_Write, (ejs_push_function_t)ejs_push_Write);
}

static int ejs_IStream_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IStream", argc, argv);
	mprSetCFunction(obj, "QueryInterface", ejs_QueryInterface);
	mprSetCFunction(obj, "AddRef", ejs_AddRef);
	mprSetCFunction(obj, "Release", ejs_Release);
	mprSetCFunction(obj, "Read", ejs_Read);
	mprSetCFunction(obj, "Write", ejs_Write);
	return ejs_rpc_init(obj, "IStream");
}

NTSTATUS ejs_init_IStream(void)
{
	ejsDefineCFunction(-1, "IStream_init", ejs_IStream_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
