
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_atsvc.h"
#include "librpc/gen_ndr/ndr_atsvc_ejs.h"


static NTSTATUS ejs_push_atsvc_DaysOfMonth(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_atsvc_DaysOfMonth(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_atsvc_Flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint8_t *r)
{
	return ejs_push_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_pull_atsvc_Flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint8_t *r)
{
	return ejs_pull_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_push_atsvc_DaysOfWeek(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint8_t *r)
{
	return ejs_push_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_pull_atsvc_DaysOfWeek(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint8_t *r)
{
	return ejs_pull_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_push_atsvc_JobInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct atsvc_JobInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "job_time", &r->job_time));
	NDR_CHECK(ejs_push_atsvc_DaysOfMonth(ejs, v, "days_of_month", &r->days_of_month));
	NDR_CHECK(ejs_push_atsvc_DaysOfWeek(ejs, v, "days_of_week", &r->days_of_week));
	NDR_CHECK(ejs_push_atsvc_Flags(ejs, v, "flags", &r->flags));
	if (NULL == r->command) {
		NDR_CHECK(ejs_push_null(ejs, v, "command"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "command", r->command));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_atsvc_JobInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct atsvc_JobInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "job_time", &r->job_time));
	NDR_CHECK(ejs_pull_atsvc_DaysOfMonth(ejs, v, "days_of_month", &r->days_of_month));
	NDR_CHECK(ejs_pull_atsvc_DaysOfWeek(ejs, v, "days_of_week", &r->days_of_week));
	NDR_CHECK(ejs_pull_atsvc_Flags(ejs, v, "flags", &r->flags));
	if (ejs_pull_null(ejs, v, "command")) {
		r->command = NULL;
	} else {
		EJS_ALLOC(ejs, r->command);
		NDR_CHECK(ejs_pull_string(ejs, v, "command", &r->command));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_atsvc_JobEnumInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct atsvc_JobEnumInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "job_id", &r->job_id));
	NDR_CHECK(ejs_push_uint32(ejs, v, "job_time", &r->job_time));
	NDR_CHECK(ejs_push_atsvc_DaysOfMonth(ejs, v, "days_of_month", &r->days_of_month));
	NDR_CHECK(ejs_push_atsvc_DaysOfWeek(ejs, v, "days_of_week", &r->days_of_week));
	NDR_CHECK(ejs_push_atsvc_Flags(ejs, v, "flags", &r->flags));
	if (NULL == r->command) {
		NDR_CHECK(ejs_push_null(ejs, v, "command"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "command", r->command));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_atsvc_JobEnumInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct atsvc_JobEnumInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "job_id", &r->job_id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "job_time", &r->job_time));
	NDR_CHECK(ejs_pull_atsvc_DaysOfMonth(ejs, v, "days_of_month", &r->days_of_month));
	NDR_CHECK(ejs_pull_atsvc_DaysOfWeek(ejs, v, "days_of_week", &r->days_of_week));
	NDR_CHECK(ejs_pull_atsvc_Flags(ejs, v, "flags", &r->flags));
	if (ejs_pull_null(ejs, v, "command")) {
		r->command = NULL;
	} else {
		EJS_ALLOC(ejs, r->command);
		NDR_CHECK(ejs_pull_string(ejs, v, "command", &r->command));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_atsvc_enum_ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct atsvc_enum_ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "entries_read", &r->entries_read));
	if (NULL == r->first_entry) {
		NDR_CHECK(ejs_push_null(ejs, v, "first_entry"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->entries_read;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "first_entry", i);
				NDR_CHECK(ejs_push_atsvc_JobEnumInfo(ejs, v, id, &r->first_entry[i]));
			}
			ejs_push_uint32(ejs, v, "first_entry" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_atsvc_enum_ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct atsvc_enum_ctr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "entries_read", &r->entries_read));
	if (ejs_pull_null(ejs, v, "first_entry")) {
		r->first_entry = NULL;
	} else {
		EJS_ALLOC(ejs, r->first_entry);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->first_entry, r->entries_read);
			for (i=0;i<r->entries_read;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "first_entry", i);
				NDR_CHECK(ejs_pull_atsvc_JobEnumInfo(ejs, v, id, &r->first_entry[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "first_entry" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_atsvc_JobAdd(struct ejs_rpc *ejs, struct MprVar *v, struct atsvc_JobAdd *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	if (ejs_pull_null(ejs, v, "job_info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.job_info);
		NDR_CHECK(ejs_pull_atsvc_JobInfo(ejs, v, "job_info", r->in.job_info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_atsvc_JobAdd(struct ejs_rpc *ejs, struct MprVar *v, const struct atsvc_JobAdd *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.job_id) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "job_id", r->out.job_id));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_atsvc_JobAdd(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_atsvc, DCERPC_ATSVC_JOBADD, (ejs_pull_function_t)ejs_pull_atsvc_JobAdd, (ejs_push_function_t)ejs_push_atsvc_JobAdd);
}


static NTSTATUS ejs_pull_atsvc_JobDel(struct ejs_rpc *ejs, struct MprVar *v, struct atsvc_JobDel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "min_job_id", &r->in.min_job_id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_job_id", &r->in.max_job_id));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_atsvc_JobDel(struct ejs_rpc *ejs, struct MprVar *v, const struct atsvc_JobDel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_atsvc_JobDel(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_atsvc, DCERPC_ATSVC_JOBDEL, (ejs_pull_function_t)ejs_pull_atsvc_JobDel, (ejs_push_function_t)ejs_push_atsvc_JobDel);
}


static NTSTATUS ejs_pull_atsvc_JobEnum(struct ejs_rpc *ejs, struct MprVar *v, struct atsvc_JobEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	if (ejs_pull_null(ejs, v, "ctr")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.ctr);
		NDR_CHECK(ejs_pull_atsvc_enum_ctr(ejs, v, "ctr", r->in.ctr));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "preferred_max_len", &r->in.preferred_max_len));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_atsvc_JobEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct atsvc_JobEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ctr) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_atsvc_enum_ctr(ejs, v, "ctr", r->out.ctr));
	}
	if (NULL == r->out.total_entries) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "total_entries", r->out.total_entries));
	}
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_atsvc_JobEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_atsvc, DCERPC_ATSVC_JOBENUM, (ejs_pull_function_t)ejs_pull_atsvc_JobEnum, (ejs_push_function_t)ejs_push_atsvc_JobEnum);
}


static NTSTATUS ejs_pull_atsvc_JobGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct atsvc_JobGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "job_id", &r->in.job_id));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_atsvc_JobGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct atsvc_JobGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.job_info) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.job_info) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_atsvc_JobInfo(ejs, v, "job_info", *r->out.job_info));
		}
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_atsvc_JobGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_atsvc, DCERPC_ATSVC_JOBGETINFO, (ejs_pull_function_t)ejs_pull_atsvc_JobGetInfo, (ejs_push_function_t)ejs_push_atsvc_JobGetInfo);
}

static int ejs_atsvc_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "atsvc", argc, argv);
	mprSetCFunction(obj, "atsvc_JobAdd", ejs_atsvc_JobAdd);
	mprSetCFunction(obj, "atsvc_JobDel", ejs_atsvc_JobDel);
	mprSetCFunction(obj, "atsvc_JobEnum", ejs_atsvc_JobEnum);
	mprSetCFunction(obj, "atsvc_JobGetInfo", ejs_atsvc_JobGetInfo);
	mprSetVar(obj, "Twentyeighth", mprCreateNumberVar(( 0x08000000 )));
	mprSetVar(obj, "Twentythird", mprCreateNumberVar(( 0x00400000 )));
	mprSetVar(obj, "Fifth", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "Thitteenth", mprCreateNumberVar(( 0x00001000 )));
	mprSetVar(obj, "Fourteenth", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "JOB_EXEC_ERROR", mprCreateNumberVar(( 0x02 )));
	mprSetVar(obj, "Seventh", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "DAYSOFWEEK_WEDNESDAY", mprCreateNumberVar(( 0x04 )));
	mprSetVar(obj, "Twentysecond", mprCreateNumberVar(( 0x00200000 )));
	mprSetVar(obj, "Ninteenth", mprCreateNumberVar(( 0x00040000 )));
	mprSetVar(obj, "DAYSOFWEEK_FRIDAY", mprCreateNumberVar(( 0x10 )));
	mprSetVar(obj, "Twentysixth", mprCreateNumberVar(( 0x02000000 )));
	mprSetVar(obj, "Sixth", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "JOB_RUNS_TODAY", mprCreateNumberVar(( 0x04 )));
	mprSetVar(obj, "Twelfth", mprCreateNumberVar(( 0x00000800 )));
	mprSetVar(obj, "Fifteenth", mprCreateNumberVar(( 0x00004000 )));
	mprSetVar(obj, "JOB_ADD_CURRENT_DATE", mprCreateNumberVar(( 0x08 )));
	mprSetVar(obj, "Thirtyfirst", mprCreateNumberVar(( 0x40000000 )));
	mprSetVar(obj, "Eighteenth", mprCreateNumberVar(( 0x00020000 )));
	mprSetVar(obj, "Eight", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "JOB_RUN_PERIODICALLY", mprCreateNumberVar(( 0x01 )));
	mprSetVar(obj, "Second", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "Ninth", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "Tenth", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "Twentyfirst", mprCreateNumberVar(( 0x00100000 )));
	mprSetVar(obj, "Twentyth", mprCreateNumberVar(( 0x00080000 )));
	mprSetVar(obj, "DAYSOFWEEK_THURSDAY", mprCreateNumberVar(( 0x08 )));
	mprSetVar(obj, "DAYSOFWEEK_MONDAY", mprCreateNumberVar(( 0x01 )));
	mprSetVar(obj, "JOB_NONINTERACTIVE", mprCreateNumberVar(( 0x10 )));
	mprSetVar(obj, "Fourth", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "Twentyfifth", mprCreateNumberVar(( 0x01000000 )));
	mprSetVar(obj, "Sixteenth", mprCreateNumberVar(( 0x00008000 )));
	mprSetVar(obj, "DAYSOFWEEK_SUNDAY", mprCreateNumberVar(( 0x40 )));
	mprSetVar(obj, "DAYSOFWEEK_SATURDAY", mprCreateNumberVar(( 0x20 )));
	mprSetVar(obj, "Eleventh", mprCreateNumberVar(( 0x00000400 )));
	mprSetVar(obj, "Twentyseventh", mprCreateNumberVar(( 0x04000000 )));
	mprSetVar(obj, "Seventeenth", mprCreateNumberVar(( 0x00010000 )));
	mprSetVar(obj, "Twentyfourth", mprCreateNumberVar(( 0x00800000 )));
	mprSetVar(obj, "DAYSOFWEEK_TUESDAY", mprCreateNumberVar(( 0x02 )));
	mprSetVar(obj, "Thirtieth", mprCreateNumberVar(( 0x20000000 )));
	mprSetVar(obj, "First", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "Third", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "Twentyninth", mprCreateNumberVar(( 0x10000000 )));
	return ejs_rpc_init(obj, "atsvc");
}

NTSTATUS ejs_init_atsvc(void)
{
	ejsDefineCFunction(-1, "atsvc_init", ejs_atsvc_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
