/* This file is autogenerated by pidl. DO NOT EDIT */
%module efs

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_efs_c.h"
#include "librpc/gen_ndr/efs.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}



%inline {
struct efs { struct dcerpc_pipe *pipe; };
}

%extend efs {
	efs (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct efs *ret = talloc(mem_ctx, struct efs);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_efs, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~efs() {
		talloc_free(self);
	}
	
	/* EfsRpcOpenFileRaw */
	WERROR EfsRpcOpenFileRaw(struct policy_handle *pvContext, const char *FileName, uint32_t Flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcOpenFileRaw r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.FileName = FileName;
		r.in.Flags = Flags;
		
		status = dcerpc_EfsRpcOpenFileRaw(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*pvContext = *r.out.pvContext;
		return r.out.result;
	}
	
	/* EfsRpcReadFileRaw */
	WERROR EfsRpcReadFileRaw(struct policy_handle *pvContext, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcReadFileRaw r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.pvContext = pvContext;
		
		status = dcerpc_EfsRpcReadFileRaw(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcWriteFileRaw */
	WERROR EfsRpcWriteFileRaw(struct policy_handle *pvContext, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcWriteFileRaw r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.pvContext = pvContext;
		
		status = dcerpc_EfsRpcWriteFileRaw(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcCloseRaw */
	void EfsRpcCloseRaw(struct policy_handle *pvContext, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcCloseRaw r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.pvContext = pvContext;
		
		status = dcerpc_EfsRpcCloseRaw(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		*pvContext = *r.out.pvContext;
	}
	
	/* EfsRpcEncryptFileSrv */
	WERROR EfsRpcEncryptFileSrv(const char *Filename, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcEncryptFileSrv r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.Filename = Filename;
		
		status = dcerpc_EfsRpcEncryptFileSrv(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcDecryptFileSrv */
	WERROR EfsRpcDecryptFileSrv(const char *FileName, uint32_t Reserved, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcDecryptFileSrv r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.FileName = FileName;
		r.in.Reserved = Reserved;
		
		status = dcerpc_EfsRpcDecryptFileSrv(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcQueryUsersOnFile */
	WERROR EfsRpcQueryUsersOnFile(const char *FileName, struct ENCRYPTION_CERTIFICATE_HASH_LIST **pUsers, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcQueryUsersOnFile r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.FileName = FileName;
		
		status = dcerpc_EfsRpcQueryUsersOnFile(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*pUsers = *r.out.pUsers;
		return r.out.result;
	}
	
	/* EfsRpcQueryRecoveryAgents */
	WERROR EfsRpcQueryRecoveryAgents(const char *FileName, struct ENCRYPTION_CERTIFICATE_HASH_LIST **pRecoveryAgents, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcQueryRecoveryAgents r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.FileName = FileName;
		
		status = dcerpc_EfsRpcQueryRecoveryAgents(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*pRecoveryAgents = *r.out.pRecoveryAgents;
		return r.out.result;
	}
	
	/* EfsRpcRemoveUsersFromFile */
	WERROR EfsRpcRemoveUsersFromFile(const char *FileName, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcRemoveUsersFromFile r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.FileName = FileName;
		
		status = dcerpc_EfsRpcRemoveUsersFromFile(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcAddUsersToFile */
	WERROR EfsRpcAddUsersToFile(const char *FileName, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcAddUsersToFile r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.FileName = FileName;
		
		status = dcerpc_EfsRpcAddUsersToFile(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcSetFileEncryptionKey */
	WERROR EfsRpcSetFileEncryptionKey(struct ENCRYPTION_CERTIFICATE *pEncryptionCertificate, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcSetFileEncryptionKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.pEncryptionCertificate = pEncryptionCertificate;
		
		status = dcerpc_EfsRpcSetFileEncryptionKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcNotSupported */
	WERROR EfsRpcNotSupported(TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcNotSupported r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_EfsRpcNotSupported(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcFileKeyInfo */
	WERROR EfsRpcFileKeyInfo(TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcFileKeyInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_EfsRpcFileKeyInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* EfsRpcDuplicateEncryptionInfoFile */
	WERROR EfsRpcDuplicateEncryptionInfoFile(TALLOC_CTX *mem_ctx = NULL)
	{
		struct EfsRpcDuplicateEncryptionInfoFile r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_EfsRpcDuplicateEncryptionInfoFile(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* EFS_HASH_BLOB */
/* ENCRYPTION_CERTIFICATE_HASH */
/* ENCRYPTION_CERTIFICATE_HASH_LIST */
/* EFS_CERTIFICATE_BLOB */
/* ENCRYPTION_CERTIFICATE */

