/* This file is autogenerated by pidl. DO NOT EDIT */
%module drsuapi

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_drsuapi_c.h"
#include "librpc/gen_ndr/drsuapi.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(drsuapi_DsReplicaObjectIdentifier);
%types(drsuapi_DsReplicaSyncOptions);
%types(drsuapi_DsReplicaHighWaterMark);
%types(drsuapi_DsReplicaCursor);
%types(drsuapi_DsReplicaNeighbourFlags);
%types(drsuapi_DsReplicaOIDMapping_Ctr);
%types(drsuapi_DsAttributeId);
%types(drsuapi_DsReplicaCursor2);
%types(drsuapi_DsReplicaObjectIdentifier3);
%types(drsuapi_DsReplicaObjectIdentifier3Binary);
%types(drsuapi_DsReplicaAttribute);
%types(drsuapi_DsReplicaObject);
%types(drsuapi_DsReplicaMetaDataCtr);
%types(drsuapi_DsReplicaObjectListItemEx);
%types(drsuapi_DsGetNCChangesCtr1);
%types(drsuapi_DsLinkedAttributeFlags);
%types(drsuapi_DsReplicaLinkedAttribute);
%types(drsuapi_DsGetNCChangesCtr6);
%types(drsuapi_DsReplicaObjectListItem);


%inline {
struct drsuapi { struct dcerpc_pipe *pipe; };
}

%extend drsuapi {
	drsuapi (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct drsuapi *ret = talloc(mem_ctx, struct drsuapi);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_drsuapi, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~drsuapi() {
		talloc_free(self);
	}
	
	/* drsuapi_DsBind */
	WERROR DsBind(struct GUID *bind_guid, struct drsuapi_DsBindInfoCtr *bind_info, struct policy_handle *bind_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsBind r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_guid = bind_guid;
		r.in.bind_info = bind_info;
		
		status = dcerpc_drsuapi_DsBind(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*bind_info = *r.out.bind_info;
		*bind_handle = *r.out.bind_handle;
		return r.out.result;
	}
	
	/* drsuapi_DsUnbind */
	WERROR DsUnbind(struct policy_handle *bind_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsUnbind r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		
		status = dcerpc_drsuapi_DsUnbind(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*bind_handle = *r.out.bind_handle;
		return r.out.result;
	}
	
	/* drsuapi_DsReplicaSync */
	WERROR DsReplicaSync(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsReplicaSyncRequest req, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsReplicaSync r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsReplicaSync(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* drsuapi_DsGetNCChanges */
	WERROR DsGetNCChanges(struct policy_handle *bind_handle, int32_t *level, union drsuapi_DsGetNCChangesRequest req, union drsuapi_DsGetNCChangesCtr ctr, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsGetNCChanges r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsGetNCChanges(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*level = *r.out.level;
		/* FIXME: ctr [out] argument is not a pointer */
		*ctr = *r.out.ctr;
		return r.out.result;
	}
	
	/* drsuapi_DsReplicaUpdateRefs */
	WERROR DsReplicaUpdateRefs(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsReplicaUpdateRefsRequest req, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsReplicaUpdateRefs r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsReplicaUpdateRefs(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* DRSUAPI_REPLICA_ADD */
	WERROR DRSUAPI_REPLICA_ADD(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_REPLICA_ADD r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_REPLICA_ADD(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* DRSUAPI_REPLICA_DEL */
	WERROR DRSUAPI_REPLICA_DEL(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_REPLICA_DEL r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_REPLICA_DEL(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* DRSUAPI_REPLICA_MODIFY */
	WERROR DRSUAPI_REPLICA_MODIFY(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_REPLICA_MODIFY r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_REPLICA_MODIFY(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* DRSUAPI_VERIFY_NAMES */
	WERROR DRSUAPI_VERIFY_NAMES(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_VERIFY_NAMES r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_VERIFY_NAMES(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* drsuapi_DsGetMemberships */
	WERROR DsGetMemberships(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsGetMembershipsRequest req, union drsuapi_DsGetMembershipsCtr ctr, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsGetMemberships r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsGetMemberships(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		/* FIXME: ctr [out] argument is not a pointer */
		*ctr = *r.out.ctr;
		return r.out.result;
	}
	
	/* DRSUAPI_INTER_DOMAIN_MOVE */
	WERROR DRSUAPI_INTER_DOMAIN_MOVE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_INTER_DOMAIN_MOVE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_INTER_DOMAIN_MOVE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* drsuapi_DsGetNT4ChangeLog */
	WERROR DsGetNT4ChangeLog(struct policy_handle *bind_handle, uint32_t level, union drsuapi_DsGetNT4ChangeLogRequest req, union drsuapi_DsGetNT4ChangeLogInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsGetNT4ChangeLog r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsGetNT4ChangeLog(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* drsuapi_DsCrackNames */
	WERROR DsCrackNames(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsNameRequest req, union drsuapi_DsNameCtr ctr, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsCrackNames r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsCrackNames(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		/* FIXME: ctr [out] argument is not a pointer */
		*ctr = *r.out.ctr;
		return r.out.result;
	}
	
	/* drsuapi_DsWriteAccountSpn */
	WERROR DsWriteAccountSpn(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsWriteAccountSpnRequest req, union drsuapi_DsWriteAccountSpnResult res, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsWriteAccountSpn r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsWriteAccountSpn(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		/* FIXME: res [out] argument is not a pointer */
		*res = *r.out.res;
		return r.out.result;
	}
	
	/* drsuapi_DsRemoveDSServer */
	WERROR DsRemoveDSServer(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsRemoveDSServerRequest req, union drsuapi_DsRemoveDSServerResult res, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsRemoveDSServer r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsRemoveDSServer(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		/* FIXME: res [out] argument is not a pointer */
		*res = *r.out.res;
		return r.out.result;
	}
	
	/* DRSUAPI_REMOVE_DS_DOMAIN */
	WERROR DRSUAPI_REMOVE_DS_DOMAIN(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_REMOVE_DS_DOMAIN r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_REMOVE_DS_DOMAIN(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* drsuapi_DsGetDomainControllerInfo */
	WERROR DsGetDomainControllerInfo(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsGetDCInfoRequest req, int32_t level_out, union drsuapi_DsGetDCInfoCtr ctr, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsGetDomainControllerInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsGetDomainControllerInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level_out [out] argument is not a pointer */
		*level_out = *r.out.level_out;
		/* FIXME: ctr [out] argument is not a pointer */
		*ctr = *r.out.ctr;
		return r.out.result;
	}
	
	/* drsuapi_DsAddEntry */
	WERROR DsAddEntry(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsAddEntryRequest req, union drsuapi_DsAddEntryCtr ctr, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsAddEntry r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsAddEntry(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		/* FIXME: ctr [out] argument is not a pointer */
		*ctr = *r.out.ctr;
		return r.out.result;
	}
	
	/* DRSUAPI_EXECUTE_KCC */
	WERROR DRSUAPI_EXECUTE_KCC(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_EXECUTE_KCC r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_EXECUTE_KCC(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* drsuapi_DsReplicaGetInfo */
	WERROR DsReplicaGetInfo(struct policy_handle *bind_handle, enum drsuapi_DsReplicaGetInfoLevel level, union drsuapi_DsReplicaGetInfoRequest req, enum drsuapi_DsReplicaInfoType info_type, union drsuapi_DsReplicaInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsReplicaGetInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsReplicaGetInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: info_type [out] argument is not a pointer */
		*info_type = *r.out.info_type;
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* DRSUAPI_ADD_SID_HISTORY */
	WERROR DRSUAPI_ADD_SID_HISTORY(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_ADD_SID_HISTORY r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_ADD_SID_HISTORY(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* drsuapi_DsGetMemberships2 */
	WERROR DsGetMemberships2(struct policy_handle *bind_handle, int32_t level, union drsuapi_DsGetMemberships2Request req, union drsuapi_DsGetMemberships2Ctr ctr, TALLOC_CTX *mem_ctx = NULL)
	{
		struct drsuapi_DsGetMemberships2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.bind_handle = bind_handle;
		r.in.level = level;
		r.in.req = req;
		
		status = dcerpc_drsuapi_DsGetMemberships2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		/* FIXME: ctr [out] argument is not a pointer */
		*ctr = *r.out.ctr;
		return r.out.result;
	}
	
	/* DRSUAPI_REPLICA_VERIFY_OBJECTS */
	WERROR DRSUAPI_REPLICA_VERIFY_OBJECTS(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_REPLICA_VERIFY_OBJECTS r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_REPLICA_VERIFY_OBJECTS(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* DRSUAPI_GET_OBJECT_EXISTENCE */
	WERROR DRSUAPI_GET_OBJECT_EXISTENCE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_GET_OBJECT_EXISTENCE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_GET_OBJECT_EXISTENCE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* DRSUAPI_QUERY_SITES_BY_COST */
	WERROR DRSUAPI_QUERY_SITES_BY_COST(TALLOC_CTX *mem_ctx = NULL)
	{
		struct DRSUAPI_QUERY_SITES_BY_COST r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_DRSUAPI_QUERY_SITES_BY_COST(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* drsuapi_SupportedExtensions */
/* drsuapi_DsBindInfo24 */
/* drsuapi_DsBindInfo28 */
/* drsuapi_DsBindInfoFallBack */
/* drsuapi_DsBindInfo */
/* drsuapi_DsBindInfoCtr */
/* drsuapi_DsReplicaObjectIdentifier */
/* drsuapi_DsReplicaSyncOptions */
/* drsuapi_DsReplicaSyncRequest1 */
/* drsuapi_DsReplicaSyncRequest */
/* drsuapi_DsReplicaHighWaterMark */
/* drsuapi_DsReplicaCursor */
/* drsuapi_DsReplicaCursorCtrEx */
/* drsuapi_DsReplicaNeighbourFlags */
/* drsuapi_DsGetNCChangesRequest5 */
/* drsuapi_DsReplicaOID */
/* drsuapi_DsReplicaOIDMapping */
/* drsuapi_DsReplicaOIDMapping_Ctr */
/* drsuapi_DsObjectClassId */
/* drsuapi_DsAttributeId */
/* drsuapi_DsGetNCChangesRequest8 */
/* drsuapi_DsGetNCChangesRequest */
/* drsuapi_DsReplicaCursor2 */
/* drsuapi_DsReplicaCursor2CtrEx */
/* drsuapi_DsAttributeValue */
/* drsuapi_DsAttributeValueCtr */
/* drsuapi_DsReplicaObjectIdentifier3 */
/* drsuapi_DsReplicaObjectIdentifier3Binary */
/* drsuapi_DsReplicaAttribute */
/* drsuapi_DsReplicaAttributeCtr */
/* drsuapi_DsReplicaObject */
/* drsuapi_DsReplicaMetaData */
/* drsuapi_DsReplicaMetaDataCtr */
/* drsuapi_DsReplicaObjectListItemEx */
/* drsuapi_DsGetNCChangesCtr1 */
/* drsuapi_DsLinkedAttributeFlags */
/* drsuapi_DsReplicaLinkedAttribute */
/* drsuapi_DsGetNCChangesCtr6 */
/* drsuapi_DsGetNCChangesMSZIPCtr1 */
/* drsuapi_DsGetNCChangesMSZIPCtr6 */
/* drsuapi_DsGetNCChangesXPRESSCtr1 */
/* drsuapi_DsGetNCChangesXPRESSCtr6 */
/* drsuapi_DsGetNCChangesCompressionType */
/* drsuapi_DsGetNCChangesCompressedCtr */
/* drsuapi_DsGetNCChangesCtr2 */
/* drsuapi_DsGetNCChangesCtr7 */
/* drsuapi_DsGetNCChangesCtr */
/* drsuapi_DsReplicaUpdateRefsOptions */
/* drsuapi_DsReplicaUpdateRefsRequest1 */
/* drsuapi_DsReplicaUpdateRefsRequest */
/* drsuapi_DsReplicaAddOptions */
/* drsuapi_DsReplicaDeleteOptions */
/* drsuapi_DsReplicaModifyOptions */
/* drsuapi_DsMembershipType */
/* drsuapi_DsGetMembershipsCtr1 */
/* drsuapi_DsGetMembershipsCtr */
/* drsuapi_DsGetMembershipsRequest1 */
/* drsuapi_DsGetMembershipsRequest */
/* drsuapi_DsGetNT4ChangeLogRequest1 */
/* drsuapi_DsGetNT4ChangeLogRequest */
/* drsuapi_DsGetNT4ChangeLogInfo1 */
/* drsuapi_DsGetNT4ChangeLogInfo */
/* drsuapi_DsNameStatus */
/* drsuapi_DsNameFlags */
/* drsuapi_DsNameFormat */
/* drsuapi_DsNameString */
/* drsuapi_DsNameRequest1 */
/* drsuapi_DsNameRequest */
/* drsuapi_DsNameInfo1 */
/* drsuapi_DsNameCtr1 */
/* drsuapi_DsNameCtr */
/* drsuapi_DsSpnOperation */
/* drsuapi_DsWriteAccountSpnRequest1 */
/* drsuapi_DsWriteAccountSpnRequest */
/* drsuapi_DsWriteAccountSpnResult1 */
/* drsuapi_DsWriteAccountSpnResult */
/* drsuapi_DsRemoveDSServerRequest1 */
/* drsuapi_DsRemoveDSServerRequest */
/* drsuapi_DsRemoveDSServerResult1 */
/* drsuapi_DsRemoveDSServerResult */
/* drsuapi_DsGetDCInfoRequest1 */
/* drsuapi_DsGetDCInfoRequest */
/* drsuapi_DsGetDCInfo1 */
/* drsuapi_DsGetDCInfoCtr1 */
/* drsuapi_DsGetDCInfo2 */
/* drsuapi_DsGetDCInfoCtr2 */
/* drsuapi_DsGetDCConnection01 */
/* drsuapi_DsGetDCConnectionCtr01 */
/* drsuapi_DsGetDCInfoCtrLevels */
/* drsuapi_DsGetDCInfoCtr */
/* drsuapi_DsReplicaObjectListItem */
/* drsuapi_DsAddEntryRequest2 */
/* drsuapi_DsAddEntryRequest */
/* drsuapi_DsAddEntryErrorInfoX */
/* drsuapi_DsAddEntryExtraErrorBuffer */
/* drsuapi_DsAddEntryExtraError1 */
/* drsuapi_DsAddEntryErrorListItem1 */
/* drsuapi_DsAddEntryErrorInfo1 */
/* drsuapi_DsAddEntryErrorInfo */
/* drsuapi_DsAddEntryError1 */
/* drsuapi_DsAddEntryError */
/* drsuapi_DsReplicaObjectIdentifier2 */
/* drsuapi_DsAddEntryCtr2 */
/* drsuapi_DsAddEntryCtr3 */
/* drsuapi_DsAddEntryCtr */
/* drsuapi_DsReplicaGetInfoLevel */
/* drsuapi_DsReplicaInfoType */
/* drsuapi_DsReplicaGetInfoRequest1 */
/* drsuapi_DsReplicaGetInfoRequest2 */
/* drsuapi_DsReplicaGetInfoRequest */
/* drsuapi_DsReplicaNeighbour */
/* drsuapi_DsReplicaNeighbourCtr */
/* drsuapi_DsReplicaCursorCtr */
/* drsuapi_DsReplicaObjMetaData */
/* drsuapi_DsReplicaObjMetaDataCtr */
/* drsuapi_DsReplicaKccDsaFailure */
/* drsuapi_DsReplicaKccDsaFailuresCtr */
/* drsuapi_DsReplicaOpType */
/* drsuapi_DsRplicaOpOptions */
/* drsuapi_DsReplicaOp */
/* drsuapi_DsReplicaOpCtr */
/* drsuapi_DsReplicaAttrValMetaData */
/* drsuapi_DsReplicaAttrValMetaDataCtr */
/* drsuapi_DsReplicaCursor2Ctr */
/* drsuapi_DsReplicaCursor3 */
/* drsuapi_DsReplicaCursor3Ctr */
/* drsuapi_DsReplicaObjMetaData2 */
/* drsuapi_DsReplicaObjMetaData2Ctr */
/* drsuapi_DsReplicaAttrValMetaData2 */
/* drsuapi_DsReplicaAttrValMetaData2Ctr */
/* drsuapi_DsReplicaConnection04 */
/* drsuapi_DsReplicaConnection04Ctr */
/* drsuapi_DsReplica06 */
/* drsuapi_DsReplica06Ctr */
/* drsuapi_DsReplicaInfo */
/* drsuapi_DsGetMemberships2Ctr1 */
/* drsuapi_DsGetMemberships2Ctr */
/* drsuapi_DsGetMemberships2Request1 */
/* drsuapi_DsGetMemberships2Request */

