/* This file is autogenerated by pidl. DO NOT EDIT */
%module dcom

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_dcom_c.h"
#include "librpc/gen_ndr/dcom.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(REMQIRESULT);


%inline {
struct dcom_Unknown { struct dcerpc_pipe *pipe; };
}

%extend dcom_Unknown {
	dcom_Unknown (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct dcom_Unknown *ret = talloc(mem_ctx, struct dcom_Unknown);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_dcom_Unknown, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~dcom_Unknown() {
		talloc_free(self);
	}
	
	/* UseProtSeq */
	void UseProtSeq(TALLOC_CTX *mem_ctx = NULL)
	{
		struct UseProtSeq r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_UseProtSeq(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
	}
	
	/* GetCustomProtseqInfo */
	void GetCustomProtseqInfo(TALLOC_CTX *mem_ctx = NULL)
	{
		struct GetCustomProtseqInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_GetCustomProtseqInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
	}
	
	/* UpdateResolverBindings */
	void UpdateResolverBindings(TALLOC_CTX *mem_ctx = NULL)
	{
		struct UpdateResolverBindings r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_UpdateResolverBindings(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
	}
	
};


%inline {
struct IUnknown { struct dcerpc_pipe *pipe; };
}

%extend IUnknown {
	IUnknown (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IUnknown *ret = talloc(mem_ctx, struct IUnknown);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IUnknown, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IUnknown() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
};


%inline {
struct IClassFactory { struct dcerpc_pipe *pipe; };
}

%extend IClassFactory {
	IClassFactory (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IClassFactory *ret = talloc(mem_ctx, struct IClassFactory);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IClassFactory, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IClassFactory() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* CreateInstance */
	WERROR CreateInstance(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct MInterfacePointer *pUnknown, struct GUID *iid, struct MInterfacePointer **ppv, TALLOC_CTX *mem_ctx = NULL)
	{
		struct CreateInstance r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.pUnknown = pUnknown;
		r.in.iid = iid;
		
		status = dcerpc_CreateInstance(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*ppv = *r.out.ppv;
		return r.out.result;
	}
	
	/* RemoteCreateInstance */
	WERROR RemoteCreateInstance(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemoteCreateInstance r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_RemoteCreateInstance(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* LockServer */
	WERROR LockServer(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint8_t lock, TALLOC_CTX *mem_ctx = NULL)
	{
		struct LockServer r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.lock = lock;
		
		status = dcerpc_LockServer(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* RemoteLockServer */
	WERROR RemoteLockServer(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemoteLockServer r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_RemoteLockServer(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
};


%inline {
struct IRemUnknown { struct dcerpc_pipe *pipe; };
}

%extend IRemUnknown {
	IRemUnknown (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IRemUnknown *ret = talloc(mem_ctx, struct IRemUnknown);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IRemUnknown, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IRemUnknown() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* RemQueryInterface */
	WERROR RemQueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *ripid, uint32_t cRefs, uint16_t cIids, struct GUID *iids, struct MInterfacePointer **ip, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemQueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.ripid = ripid;
		r.in.cRefs = cRefs;
		r.in.cIids = cIids;
		r.in.iids = iids;
		
		status = dcerpc_RemQueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*ip = *r.out.ip;
		return r.out.result;
	}
	
	/* RemAddRef */
	WERROR RemAddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint16_t cInterfaceRefs, struct REMINTERFACEREF *InterfaceRefs, WERROR **pResults, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemAddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.cInterfaceRefs = cInterfaceRefs;
		r.in.InterfaceRefs = InterfaceRefs;
		
		status = dcerpc_RemAddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*pResults = *r.out.pResults;
		return r.out.result;
	}
	
	/* RemRelease */
	WERROR RemRelease(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint16_t cInterfaceRefs, struct REMINTERFACEREF *InterfaceRefs, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemRelease r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.cInterfaceRefs = cInterfaceRefs;
		r.in.InterfaceRefs = InterfaceRefs;
		
		status = dcerpc_RemRelease(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
};

/* REMQIRESULT */
/* REMINTERFACEREF */

%inline {
struct IClassActivator { struct dcerpc_pipe *pipe; };
}

%extend IClassActivator {
	IClassActivator (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IClassActivator *ret = talloc(mem_ctx, struct IClassActivator);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IClassActivator, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IClassActivator() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* GetClassObject */
	void GetClassObject(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID clsid, uint32_t context, uint32_t locale, struct GUID iid, struct MInterfacePointer *data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct GetClassObject r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.clsid = clsid;
		r.in.context = context;
		r.in.locale = locale;
		r.in.iid = iid;
		
		status = dcerpc_GetClassObject(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
	}
	
};


%inline {
struct ISCMLocalActivator { struct dcerpc_pipe *pipe; };
}

%extend ISCMLocalActivator {
	ISCMLocalActivator (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct ISCMLocalActivator *ret = talloc(mem_ctx, struct ISCMLocalActivator);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_ISCMLocalActivator, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~ISCMLocalActivator() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* GetClassObject */
	void GetClassObject(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID clsid, uint32_t context, uint32_t locale, struct GUID iid, struct MInterfacePointer *data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct GetClassObject r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.clsid = clsid;
		r.in.context = context;
		r.in.locale = locale;
		r.in.iid = iid;
		
		status = dcerpc_GetClassObject(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
	}
	
	/* ISCMLocalActivator_CreateInstance */
	WERROR CreateInstance(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct ISCMLocalActivator_CreateInstance r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_ISCMLocalActivator_CreateInstance(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
};


%inline {
struct IMachineLocalActivator { struct dcerpc_pipe *pipe; };
}

%extend IMachineLocalActivator {
	IMachineLocalActivator (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IMachineLocalActivator *ret = talloc(mem_ctx, struct IMachineLocalActivator);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IMachineLocalActivator, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IMachineLocalActivator() {
		talloc_free(self);
	}
	
	/* IMachineLocalActivator_foo */
	WERROR foo(TALLOC_CTX *mem_ctx = NULL)
	{
		struct IMachineLocalActivator_foo r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_IMachineLocalActivator_foo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};


%inline {
struct ILocalObjectExporter { struct dcerpc_pipe *pipe; };
}

%extend ILocalObjectExporter {
	ILocalObjectExporter (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct ILocalObjectExporter *ret = talloc(mem_ctx, struct ILocalObjectExporter);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_ILocalObjectExporter, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~ILocalObjectExporter() {
		talloc_free(self);
	}
	
	/* ILocalObjectExporter_Foo */
	WERROR Foo(TALLOC_CTX *mem_ctx = NULL)
	{
		struct ILocalObjectExporter_Foo r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_ILocalObjectExporter_Foo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};


%inline {
struct ISystemActivator { struct dcerpc_pipe *pipe; };
}

%extend ISystemActivator {
	ISystemActivator (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct ISystemActivator *ret = talloc(mem_ctx, struct ISystemActivator);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_ISystemActivator, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~ISystemActivator() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* GetClassObject */
	void GetClassObject(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID clsid, uint32_t context, uint32_t locale, struct GUID iid, struct MInterfacePointer *data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct GetClassObject r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.clsid = clsid;
		r.in.context = context;
		r.in.locale = locale;
		r.in.iid = iid;
		
		status = dcerpc_GetClassObject(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
	}
	
	/* ISystemActivatorRemoteCreateInstance */
	WERROR ISystemActivatorRemoteCreateInstance(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint64_t unknown1, struct MInterfacePointer iface1, uint64_t unknown2, uint32_t *unknown3, struct MInterfacePointer *iface2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct ISystemActivatorRemoteCreateInstance r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.unknown1 = unknown1;
		r.in.iface1 = iface1;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_ISystemActivatorRemoteCreateInstance(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*unknown3 = *r.out.unknown3;
		*iface2 = *r.out.iface2;
		return r.out.result;
	}
	
};


%inline {
struct IRemUnknown2 { struct dcerpc_pipe *pipe; };
}

%extend IRemUnknown2 {
	IRemUnknown2 (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IRemUnknown2 *ret = talloc(mem_ctx, struct IRemUnknown2);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IRemUnknown2, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IRemUnknown2() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* RemQueryInterface */
	WERROR RemQueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *ripid, uint32_t cRefs, uint16_t cIids, struct GUID *iids, struct MInterfacePointer **ip, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemQueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.ripid = ripid;
		r.in.cRefs = cRefs;
		r.in.cIids = cIids;
		r.in.iids = iids;
		
		status = dcerpc_RemQueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*ip = *r.out.ip;
		return r.out.result;
	}
	
	/* RemAddRef */
	WERROR RemAddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint16_t cInterfaceRefs, struct REMINTERFACEREF *InterfaceRefs, WERROR **pResults, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemAddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.cInterfaceRefs = cInterfaceRefs;
		r.in.InterfaceRefs = InterfaceRefs;
		
		status = dcerpc_RemAddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*pResults = *r.out.pResults;
		return r.out.result;
	}
	
	/* RemRelease */
	WERROR RemRelease(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint16_t cInterfaceRefs, struct REMINTERFACEREF *InterfaceRefs, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemRelease r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.cInterfaceRefs = cInterfaceRefs;
		r.in.InterfaceRefs = InterfaceRefs;
		
		status = dcerpc_RemRelease(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* RemQueryInterface2 */
	WERROR RemQueryInterface2(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *ripid, uint16_t cIids, struct GUID **iids, WERROR **phr, struct MInterfacePointer **ppMIF, TALLOC_CTX *mem_ctx = NULL)
	{
		struct RemQueryInterface2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.ripid = ripid;
		r.in.cIids = cIids;
		r.in.iids = iids;
		
		status = dcerpc_RemQueryInterface2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*phr = *r.out.phr;
		*ppMIF = *r.out.ppMIF;
		return r.out.result;
	}
	
};


%inline {
struct IDispatch { struct dcerpc_pipe *pipe; };
}

%extend IDispatch {
	IDispatch (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IDispatch *ret = talloc(mem_ctx, struct IDispatch);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IDispatch, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IDispatch() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* GetTypeInfoCount */
	WERROR GetTypeInfoCount(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint16_t *pctinfo, TALLOC_CTX *mem_ctx = NULL)
	{
		struct GetTypeInfoCount r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_GetTypeInfoCount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*pctinfo = *r.out.pctinfo;
		return r.out.result;
	}
	
	/* GetTypeInfo */
	WERROR GetTypeInfo(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint16_t iTInfo, uint32_t lcid, struct REF_ITypeInfo **ppTInfo, TALLOC_CTX *mem_ctx = NULL)
	{
		struct GetTypeInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iTInfo = iTInfo;
		r.in.lcid = lcid;
		
		status = dcerpc_GetTypeInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*ppTInfo = *r.out.ppTInfo;
		return r.out.result;
	}
	
	/* GetIDsOfNames */
	WERROR GetIDsOfNames(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *riid, uint16_t cNames, uint32_t lcid, uint32_t **rgDispId, TALLOC_CTX *mem_ctx = NULL)
	{
		struct GetIDsOfNames r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.riid = riid;
		r.in.cNames = cNames;
		r.in.lcid = lcid;
		
		status = dcerpc_GetIDsOfNames(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*rgDispId = *r.out.rgDispId;
		return r.out.result;
	}
	
	/* Invoke */
	WERROR Invoke(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint32_t dispIdMember, struct GUID *riid, uint32_t lcid, uint16_t wFlags, struct DISPPARAMS *pDispParams, struct VARIANT **pVarResult, struct EXCEPINFO **pExcepInfo, uint16_t **puArgErr, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Invoke r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.dispIdMember = dispIdMember;
		r.in.riid = riid;
		r.in.lcid = lcid;
		r.in.wFlags = wFlags;
		r.in.pDispParams = pDispParams;
		
		status = dcerpc_Invoke(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*pDispParams = *r.out.pDispParams;
		*pVarResult = *r.out.pVarResult;
		*pExcepInfo = *r.out.pExcepInfo;
		*puArgErr = *r.out.puArgErr;
		return r.out.result;
	}
	
};

/* REF_ITypeInfo */
/* VARIANT */
/* DISPPARAMS */
/* EXCEPINFO */

%inline {
struct IMarshal { struct dcerpc_pipe *pipe; };
}

%extend IMarshal {
	IMarshal (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IMarshal *ret = talloc(mem_ctx, struct IMarshal);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IMarshal, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IMarshal() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* MarshalInterface */
	WERROR MarshalInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct MarshalInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_MarshalInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* UnMarshalInterface */
	WERROR UnMarshalInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct UnMarshalInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_UnMarshalInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
};


%inline {
struct ICoffeeMachine { struct dcerpc_pipe *pipe; };
}

%extend ICoffeeMachine {
	ICoffeeMachine (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct ICoffeeMachine *ret = talloc(mem_ctx, struct ICoffeeMachine);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_ICoffeeMachine, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~ICoffeeMachine() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* MakeCoffee */
	WERROR MakeCoffee(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, const char *flavor, TALLOC_CTX *mem_ctx = NULL)
	{
		struct MakeCoffee r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.flavor = flavor;
		
		status = dcerpc_MakeCoffee(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
};


%inline {
struct IStream { struct dcerpc_pipe *pipe; };
}

%extend IStream {
	IStream (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct IStream *ret = talloc(mem_ctx, struct IStream);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_IStream, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~IStream() {
		talloc_free(self);
	}
	
	/* QueryInterface */
	WERROR QueryInterface(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, struct GUID *iid, struct MInterfacePointer **data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct QueryInterface r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.iid = iid;
		
		status = dcerpc_QueryInterface(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*data = *r.out.data;
		return r.out.result;
	}
	
	/* AddRef */
	uint32_t AddRef(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct AddRef r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_AddRef(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Release */
	uint32_t Release(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Release r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		
		status = dcerpc_Release(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		return r.out.result;
	}
	
	/* Read */
	WERROR Read(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint8_t *pv, uint32_t num_requested, uint32_t *num_readx, uint32_t *num_read, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Read r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.num_requested = num_requested;
		r.in.num_readx = num_readx;
		
		status = dcerpc_Read(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		/* FIXME: pv [out] argument is not a pointer */
		*pv = *r.out.pv;
		*num_read = *r.out.num_read;
		return r.out.result;
	}
	
	/* Write */
	WERROR Write(struct ORPCTHAT *ORPCthat, struct ORPCTHIS ORPCthis, uint8_t *data, uint32_t num_requested, uint32_t *num_written, TALLOC_CTX *mem_ctx = NULL)
	{
		struct Write r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.ORPCthis = ORPCthis;
		r.in.data = data;
		r.in.num_requested = num_requested;
		
		status = dcerpc_Write(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ORPCthat = *r.out.ORPCthat;
		*num_written = *r.out.num_written;
		return r.out.result;
	}
	
};


