/* -*- C -*- */
/*
 * Copyright (c) 1995-2005 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: roken.h.in,v 1.178 2005/09/28 03:04:54 lha Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#include <string.h>
#include <signal.h>

#ifdef _AIX
struct ether_addr;
struct sockaddr_dl;
#endif
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_BITYPES_H
#include <sys/bitypes.h>
#endif
#ifdef HAVE_BIND_BITYPES_H
#include <bind/bitypes.h>
#endif
#ifdef HAVE_NETINET_IN6_MACHTYPES_H
#include <netinet/in6_machtypes.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_SYS_UIO_H
#include <sys/uio.h>
#endif
#ifdef HAVE_GRP_H
#include <grp.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_NETINET_IN6_H
#include <netinet/in6.h>
#endif
#ifdef HAVE_NETINET6_IN6_H
#include <netinet6/in6.h>
#endif
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_ARPA_NAMESER_H
#include <arpa/nameser.h>
#endif
#ifdef HAVE_RESOLV_H
#include <resolv.h>
#endif
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include <err.h>
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif
#if defined(HAVE_SYS_IOCTL_H) && SunOS != 40
#include <sys/ioctl.h>
#endif
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#elif defined(HAVE_SYS_TIME_H)
#include <sys/time.h>
#else
#include <time.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_PATHS_H
#include <paths.h>
#endif

#ifndef HAVE_SSIZE_T
typedef int ssize_t;
#endif

#include <roken-common.h>

ROKEN_CPP_START

#ifdef HAVE_UINTPTR_T
#define rk_UNCONST(x) ((void *)(uintptr_t)(const void *)(x))
#else
#define rk_UNCONST(x) ((void *)(unsigned long)(const void *)(x))
#endif

#if !defined(HAVE_SETSID) && defined(HAVE__SETSID)
#define setsid _setsid
#endif

#ifndef HAVE_PUTENV
int ROKEN_LIB_FUNCTION putenv(const char *);
#endif

#if !defined(HAVE_SETENV) || defined(NEED_SETENV_PROTO)
int ROKEN_LIB_FUNCTION setenv(const char *, const char *, int);
#endif

#if !defined(HAVE_UNSETENV) || defined(NEED_UNSETENV_PROTO)
void ROKEN_LIB_FUNCTION unsetenv(const char *);
#endif

#if !defined(HAVE_GETUSERSHELL) || defined(NEED_GETUSERSHELL_PROTO)
char * ROKEN_LIB_FUNCTION getusershell(void);
void ROKEN_LIB_FUNCTION endusershell(void);
#endif

#if !defined(HAVE_SNPRINTF) || defined(NEED_SNPRINTF_PROTO)
int ROKEN_LIB_FUNCTION snprintf (char *, size_t, const char *, ...)
     __attribute__ ((format (printf, 3, 4)));
#endif

#if !defined(HAVE_VSNPRINTF) || defined(NEED_VSNPRINTF_PROTO)
int ROKEN_LIB_FUNCTION 
     vsnprintf (char *, size_t, const char *, va_list)
     __attribute__((format (printf, 3, 0)));
#endif

#if !defined(HAVE_ASPRINTF) || defined(NEED_ASPRINTF_PROTO)
int ROKEN_LIB_FUNCTION
     asprintf (char **, const char *, ...)
     __attribute__ ((format (printf, 2, 3)));
#endif

#if !defined(HAVE_VASPRINTF) || defined(NEED_VASPRINTF_PROTO)
int ROKEN_LIB_FUNCTION
    vasprintf (char **, const char *, va_list)
     __attribute__((format (printf, 2, 0)));
#endif

#if !defined(HAVE_ASNPRINTF) || defined(NEED_ASNPRINTF_PROTO)
int ROKEN_LIB_FUNCTION
    asnprintf (char **, size_t, const char *, ...)
     __attribute__ ((format (printf, 3, 4)));
#endif

#if !defined(HAVE_VASNPRINTF) || defined(NEED_VASNPRINTF_PROTO)
int ROKEN_LIB_FUNCTION
    vasnprintf (char **, size_t, const char *, va_list)
     __attribute__((format (printf, 3, 0)));
#endif

#ifndef HAVE_STRDUP
char * ROKEN_LIB_FUNCTION strdup(const char *);
#endif

#if !defined(HAVE_STRNDUP) || defined(NEED_STRNDUP_PROTO)
char * ROKEN_LIB_FUNCTION strndup(const char *, size_t);
#endif

#ifndef HAVE_STRLWR
char * ROKEN_LIB_FUNCTION strlwr(char *);
#endif

#ifndef HAVE_STRNLEN
size_t ROKEN_LIB_FUNCTION strnlen(const char*, size_t);
#endif

#if !defined(HAVE_STRSEP) || defined(NEED_STRSEP_PROTO)
char * ROKEN_LIB_FUNCTION strsep(char**, const char*);
#endif

#if !defined(HAVE_STRSEP_COPY) || defined(NEED_STRSEP_COPY_PROTO)
ssize_t ROKEN_LIB_FUNCTION strsep_copy(const char**, const char*, char*, size_t);
#endif

#ifndef HAVE_STRCASECMP
int ROKEN_LIB_FUNCTION strcasecmp(const char *, const char *);
#endif

#ifdef NEED_FCLOSE_PROTO
int ROKEN_LIB_FUNCTION fclose(FILE *);
#endif

#ifdef NEED_STRTOK_R_PROTO
char * ROKEN_LIB_FUNCTION strtok_r(char *, const char *, char **);
#endif

#ifndef HAVE_STRUPR
char * ROKEN_LIB_FUNCTION strupr(char *);
#endif

#ifndef HAVE_STRLCPY
size_t ROKEN_LIB_FUNCTION strlcpy (char *, const char *, size_t);
#endif

#ifndef HAVE_STRLCAT
size_t ROKEN_LIB_FUNCTION strlcat (char *, const char *, size_t);
#endif

#ifndef HAVE_GETDTABLESIZE
int ROKEN_LIB_FUNCTION getdtablesize(void);
#endif

#if !defined(HAVE_STRERROR) && !defined(strerror)
char * ROKEN_LIB_FUNCTION strerror(int);
#endif

#if !defined(HAVE_HSTRERROR) || defined(NEED_HSTRERROR_PROTO)
/* This causes a fatal error under Psoriasis */
#if !(defined(SunOS) && (SunOS >= 50))
const char * ROKEN_LIB_FUNCTION hstrerror(int);
#endif
#endif

#if !HAVE_DECL_H_ERRNO
extern int h_errno;
#endif

#if !defined(HAVE_INET_ATON) || defined(NEED_INET_ATON_PROTO)
int ROKEN_LIB_FUNCTION inet_aton(const char *, struct in_addr *);
#endif

#ifndef HAVE_INET_NTOP
const char * ROKEN_LIB_FUNCTION
inet_ntop(int af, const void *src, char *dst, size_t size);
#endif

#ifndef HAVE_INET_PTON
int ROKEN_LIB_FUNCTION
inet_pton(int, const char *, void *);
#endif

#if !defined(HAVE_GETCWD)
char* ROKEN_LIB_FUNCTION getcwd(char *, size_t);
#endif

#ifdef HAVE_PWD_H
#include <pwd.h>
struct passwd * ROKEN_LIB_FUNCTION k_getpwnam (const char *);
struct passwd * ROKEN_LIB_FUNCTION k_getpwuid (uid_t);
#endif

const char * ROKEN_LIB_FUNCTION get_default_username (void);

#ifndef HAVE_SETEUID
int ROKEN_LIB_FUNCTION seteuid(uid_t);
#endif

#ifndef HAVE_SETEGID
int ROKEN_LIB_FUNCTION setegid(gid_t);
#endif

#ifndef HAVE_LSTAT
int ROKEN_LIB_FUNCTION lstat(const char *, struct stat *);
#endif

#if !defined(HAVE_MKSTEMP) || defined(NEED_MKSTEMP_PROTO)
int ROKEN_LIB_FUNCTION mkstemp(char *);
#endif

#ifndef HAVE_CGETENT
int ROKEN_LIB_FUNCTION cgetent(char **, char **, const char *);
int ROKEN_LIB_FUNCTION cgetstr(char *, const char *, char **);
#endif

#ifndef HAVE_INITGROUPS
int ROKEN_LIB_FUNCTION initgroups(const char *, gid_t);
#endif

#ifndef HAVE_FCHOWN
int ROKEN_LIB_FUNCTION fchown(int, uid_t, gid_t);
#endif

#if !defined(HAVE_DAEMON) || defined(NEED_DAEMON_PROTO)
int ROKEN_LIB_FUNCTION daemon(int, int);
#endif

#ifndef HAVE_INNETGR
int ROKEN_LIB_FUNCTION innetgr(const char *, const char *, 
	    const char *, const char *);
#endif

#ifndef HAVE_CHOWN
int ROKEN_LIB_FUNCTION chown(const char *, uid_t, gid_t);
#endif

#ifndef HAVE_RCMD
int ROKEN_LIB_FUNCTION
    rcmd(char **, unsigned short, const char *,
	 const char *, const char *, int *);
#endif

#if !defined(HAVE_INNETGR) || defined(NEED_INNETGR_PROTO)
int ROKEN_LIB_FUNCTION innetgr(const char*, const char*,
    const char*, const char*);
#endif

#ifndef HAVE_IRUSEROK
int ROKEN_LIB_FUNCTION iruserok(unsigned, int, 
    const char *, const char *);
#endif

#if !defined(HAVE_GETHOSTNAME) || defined(NEED_GETHOSTNAME_PROTO)
int ROKEN_LIB_FUNCTION gethostname(char *, int);
#endif

#ifndef HAVE_WRITEV
ssize_t ROKEN_LIB_FUNCTION
writev(int, const struct iovec *, int);
#endif

#ifndef HAVE_READV
ssize_t ROKEN_LIB_FUNCTION
readv(int, const struct iovec *, int);
#endif

#ifndef HAVE_MKSTEMP
int ROKEN_LIB_FUNCTION
mkstemp(char *);
#endif

#ifndef HAVE_PIDFILE
void ROKEN_LIB_FUNCTION pidfile (const char*);
#endif

#ifndef HAVE_BSWAP32
unsigned int ROKEN_LIB_FUNCTION bswap32(unsigned int);
#endif

#ifndef HAVE_BSWAP16
unsigned short ROKEN_LIB_FUNCTION bswap16(unsigned short);
#endif

#ifndef HAVE_FLOCK
#ifndef LOCK_SH
#define LOCK_SH   1		/* Shared lock */
#endif
#ifndef	LOCK_EX
#define LOCK_EX   2		/* Exclusive lock */
#endif
#ifndef LOCK_NB
#define LOCK_NB   4		/* Don't block when locking */
#endif
#ifndef LOCK_UN
#define LOCK_UN   8		/* Unlock */
#endif

int flock(int fd, int operation);
#endif /* HAVE_FLOCK */

time_t ROKEN_LIB_FUNCTION tm2time (struct tm, int);

int ROKEN_LIB_FUNCTION unix_verify_user(char *, char *);

int ROKEN_LIB_FUNCTION roken_concat (char *, size_t, ...);

size_t ROKEN_LIB_FUNCTION roken_mconcat (char **, size_t, ...);

int ROKEN_LIB_FUNCTION roken_vconcat (char *, size_t, va_list);

size_t ROKEN_LIB_FUNCTION
    roken_vmconcat (char **, size_t, va_list);

ssize_t ROKEN_LIB_FUNCTION net_write (int, const void *, size_t);

ssize_t ROKEN_LIB_FUNCTION net_read (int, void *, size_t);

int ROKEN_LIB_FUNCTION issuid(void);

#ifndef HAVE_STRUCT_WINSIZE
struct winsize {
	unsigned short ws_row, ws_col;
	unsigned short ws_xpixel, ws_ypixel;
};
#endif

int ROKEN_LIB_FUNCTION get_window_size(int fd, struct winsize *);

#ifndef HAVE_VSYSLOG
void ROKEN_LIB_FUNCTION vsyslog(int, const char *, va_list);
#endif

#if !HAVE_DECL_OPTARG
extern char *optarg;
#endif
#if !HAVE_DECL_OPTIND
extern int optind;
#endif
#if !HAVE_DECL_OPTERR
extern int opterr;
#endif

#if !HAVE_DECL_ENVIRON
extern char **environ;
#endif

#ifndef HAVE_GETIPNODEBYNAME
struct hostent * ROKEN_LIB_FUNCTION
getipnodebyname (const char *, int, int, int *);
#endif

#ifndef HAVE_GETIPNODEBYADDR
struct hostent * ROKEN_LIB_FUNCTION
getipnodebyaddr (const void *, size_t, int, int *);
#endif

#ifndef HAVE_FREEHOSTENT
void ROKEN_LIB_FUNCTION
freehostent (struct hostent *);
#endif

#ifndef HAVE_COPYHOSTENT
struct hostent * ROKEN_LIB_FUNCTION
copyhostent (const struct hostent *);
#endif

#ifndef HAVE_SOCKLEN_T
typedef int socklen_t;
#endif

#ifndef HAVE_STRUCT_SOCKADDR_STORAGE

#ifndef HAVE_SA_FAMILY_T
typedef unsigned short sa_family_t;
#endif

#ifdef HAVE_IPV6
#define _SS_MAXSIZE sizeof(struct sockaddr_in6)
#else
#define _SS_MAXSIZE sizeof(struct sockaddr_in)
#endif

#define _SS_ALIGNSIZE	sizeof(unsigned long)

#if HAVE_STRUCT_SOCKADDR_SA_LEN

typedef unsigned char roken_sa_family_t;

#define _SS_PAD1SIZE   ((2 * _SS_ALIGNSIZE - sizeof (roken_sa_family_t) - sizeof(unsigned char)) % _SS_ALIGNSIZE)
#define _SS_PAD2SIZE   (_SS_MAXSIZE - (sizeof (roken_sa_family_t) + sizeof(unsigned char) + _SS_PAD1SIZE + _SS_ALIGNSIZE))

struct sockaddr_storage {
    unsigned char	ss_len;
    roken_sa_family_t	ss_family;
    char		__ss_pad1[_SS_PAD1SIZE];
    unsigned long	__ss_align[_SS_PAD2SIZE / sizeof(unsigned long) + 1];
};

#else /* !HAVE_STRUCT_SOCKADDR_SA_LEN */

typedef unsigned short roken_sa_family_t;

#define _SS_PAD1SIZE   ((2 * _SS_ALIGNSIZE - sizeof (roken_sa_family_t)) % _SS_ALIGNSIZE)
#define _SS_PAD2SIZE   (_SS_MAXSIZE - (sizeof (roken_sa_family_t) + _SS_PAD1SIZE + _SS_ALIGNSIZE))

struct sockaddr_storage {
    roken_sa_family_t	ss_family;
    char		__ss_pad1[_SS_PAD1SIZE];
    unsigned long	__ss_align[_SS_PAD2SIZE / sizeof(unsigned long) + 1];
};

#endif /* HAVE_STRUCT_SOCKADDR_SA_LEN */

#endif /* HAVE_STRUCT_SOCKADDR_STORAGE */

#ifndef HAVE_STRUCT_ADDRINFO
struct addrinfo {
    int    ai_flags;
    int    ai_family;
    int    ai_socktype;
    int    ai_protocol;
    size_t ai_addrlen;
    char  *ai_canonname;
    struct sockaddr *ai_addr;
    struct addrinfo *ai_next;
};
#endif

#ifndef HAVE_GETADDRINFO
int ROKEN_LIB_FUNCTION
getaddrinfo(const char *,
	    const char *,
	    const struct addrinfo *,
	    struct addrinfo **);
#endif

#ifndef HAVE_GETNAMEINFO
int ROKEN_LIB_FUNCTION
getnameinfo(const struct sockaddr *, socklen_t,
		char *, size_t,
		char *, size_t,
		int);
#endif

#ifndef HAVE_FREEADDRINFO
void ROKEN_LIB_FUNCTION
freeaddrinfo(struct addrinfo *);
#endif

#ifndef HAVE_GAI_STRERROR
const char * ROKEN_LIB_FUNCTION
gai_strerror(int);
#endif

int ROKEN_LIB_FUNCTION
getnameinfo_verified(const struct sockaddr *, socklen_t,
		     char *, size_t,
		     char *, size_t,
		     int);

int ROKEN_LIB_FUNCTION
roken_getaddrinfo_hostspec(const char *, int, struct addrinfo **); 
int ROKEN_LIB_FUNCTION
roken_getaddrinfo_hostspec2(const char *, int, int, struct addrinfo **);

#ifndef HAVE_STRFTIME
size_t ROKEN_LIB_FUNCTION
strftime (char *, size_t, const char *, const struct tm *);
#endif

#ifndef HAVE_STRPTIME
char * ROKEN_LIB_FUNCTION
strptime (const char *, const char *, struct tm *);
#endif

#ifndef HAVE_EMALLOC
void * ROKEN_LIB_FUNCTION emalloc (size_t);
#endif
#ifndef HAVE_ECALLOC
void * ROKEN_LIB_FUNCTION ecalloc(size_t, size_t);
#endif
#ifndef HAVE_EREALLOC
void * ROKEN_LIB_FUNCTION erealloc (void *, size_t);
#endif
#ifndef HAVE_ESTRDUP
char * ROKEN_LIB_FUNCTION estrdup (const char *);
#endif

/*
 * kludges and such
 */

#if 1
int ROKEN_LIB_FUNCTION
roken_gethostby_setup(const char*, const char*);
struct hostent* ROKEN_LIB_FUNCTION
roken_gethostbyname(const char*);
struct hostent* ROKEN_LIB_FUNCTION 
roken_gethostbyaddr(const void*, size_t, int);
#else
#ifdef GETHOSTBYNAME_PROTO_COMPATIBLE
#define roken_gethostbyname(x) gethostbyname(x)
#else
#define roken_gethostbyname(x) gethostbyname((char *)x)
#endif

#ifdef GETHOSTBYADDR_PROTO_COMPATIBLE
#define roken_gethostbyaddr(a, l, t) gethostbyaddr(a, l, t)
#else
#define roken_gethostbyaddr(a, l, t) gethostbyaddr((char *)a, l, t)
#endif
#endif

#ifdef GETSERVBYNAME_PROTO_COMPATIBLE
#define roken_getservbyname(x,y) getservbyname(x,y)
#else
#define roken_getservbyname(x,y) getservbyname((char *)x, (char *)y)
#endif

#ifdef OPENLOG_PROTO_COMPATIBLE
#define roken_openlog(a,b,c) openlog(a,b,c)
#else
#define roken_openlog(a,b,c) openlog((char *)a,b,c)
#endif

#ifdef GETSOCKNAME_PROTO_COMPATIBLE
#define roken_getsockname(a,b,c) getsockname(a,b,c)
#else
#define roken_getsockname(a,b,c) getsockname(a, b, (void*)c)
#endif

#ifndef HAVE_SETPROGNAME
void ROKEN_LIB_FUNCTION setprogname(const char *);
#endif

#ifndef HAVE_GETPROGNAME
const char * ROKEN_LIB_FUNCTION getprogname(void);
#endif

#if !defined(HAVE_SETPROGNAME) && !defined(HAVE_GETPROGNAME) && !HAVE_DECL___PROGNAME
extern const char *__progname;
#endif

void ROKEN_LIB_FUNCTION mini_inetd_addrinfo (struct addrinfo*);
void ROKEN_LIB_FUNCTION mini_inetd (int);

#ifndef HAVE_LOCALTIME_R
struct tm * ROKEN_LIB_FUNCTION
localtime_r(const time_t *, struct tm *);
#endif

#if !defined(HAVE_STRSVIS) || defined(NEED_STRSVIS_PROTO)
int ROKEN_LIB_FUNCTION
strsvis(char *, const char *, int, const char *);
#endif

#if !defined(HAVE_STRUNVIS) || defined(NEED_STRUNVIS_PROTO)
int ROKEN_LIB_FUNCTION
strunvis(char *, const char *);
#endif

#if !defined(HAVE_STRVIS) || defined(NEED_STRVIS_PROTO)
int ROKEN_LIB_FUNCTION
strvis(char *, const char *, int);
#endif

#if !defined(HAVE_STRVISX) || defined(NEED_STRVISX_PROTO)
int ROKEN_LIB_FUNCTION
strvisx(char *, const char *, size_t, int);
#endif

#if !defined(HAVE_SVIS) || defined(NEED_SVIS_PROTO)
char * ROKEN_LIB_FUNCTION
svis(char *, int, int, int, const char *);
#endif

#if !defined(HAVE_UNVIS) || defined(NEED_UNVIS_PROTO)
int ROKEN_LIB_FUNCTION
unvis(char *, int, int *, int);
#endif

#if !defined(HAVE_VIS) || defined(NEED_VIS_PROTO)
char * ROKEN_LIB_FUNCTION
vis(char *, int, int, int);
#endif

#if !defined(HAVE_CLOSEFROM)
int ROKEN_LIB_FUNCTION
closefrom(int);
#endif

ROKEN_CPP_END
