/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_wmi.h"

static bool api_Delete(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Delete *r;

	call = &ndr_table_IWbemClassObject.calls[NDR_DELETE];

	r = talloc(talloc_tos(), struct Delete);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Delete, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Delete(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Delete, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemClassObject_cmds[] = 
{
	{"DELETE", NDR_DELETE, api_Delete},
};

void IWbemClassObject_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemClassObject_cmds;
	*n_fns = sizeof(api_IWbemClassObject_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemClassObject_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_DELETE: {
			struct Delete *r = (struct Delete *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Delete(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemClassObject_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemClassObject", "IWbemClassObject", &ndr_table_IWbemClassObject, api_IWbemClassObject_cmds, sizeof(api_IWbemClassObject_cmds) / sizeof(struct api_struct));
}
static bool api_OpenNamespace(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct OpenNamespace *r;

	call = &ndr_table_IWbemServices.calls[NDR_OPENNAMESPACE];

	r = talloc(talloc_tos(), struct OpenNamespace);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(OpenNamespace, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppWorkingNamespace = r->in.ppWorkingNamespace;
	r->out.ppResult = r->in.ppResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _OpenNamespace(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(OpenNamespace, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_CancelAsyncCall(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct CancelAsyncCall *r;

	call = &ndr_table_IWbemServices.calls[NDR_CANCELASYNCCALL];

	r = talloc(talloc_tos(), struct CancelAsyncCall);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CancelAsyncCall, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CancelAsyncCall(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CancelAsyncCall, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_QueryObjectSink(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct QueryObjectSink *r;

	call = &ndr_table_IWbemServices.calls[NDR_QUERYOBJECTSINK];

	r = talloc(talloc_tos(), struct QueryObjectSink);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(QueryObjectSink, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppResponseHandler = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppResponseHandler == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _QueryObjectSink(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(QueryObjectSink, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetObject(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetObject *r;

	call = &ndr_table_IWbemServices.calls[NDR_GETOBJECT];

	r = talloc(talloc_tos(), struct GetObject);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetObject, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppObject = r->in.ppObject;
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetObject(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetObject, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetObjectAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetObjectAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_GETOBJECTASYNC];

	r = talloc(talloc_tos(), struct GetObjectAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetObjectAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetObjectAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetObjectAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_PutClass(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct PutClass *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTCLASS];

	r = talloc(talloc_tos(), struct PutClass);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutClass, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutClass(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutClass, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_PutClassAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct PutClassAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTCLASSASYNC];

	r = talloc(talloc_tos(), struct PutClassAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutClassAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutClassAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutClassAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_DeleteClass(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct DeleteClass *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETECLASS];

	r = talloc(talloc_tos(), struct DeleteClass);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteClass, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteClass(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteClass, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_DeleteClassAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct DeleteClassAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETECLASSASYNC];

	r = talloc(talloc_tos(), struct DeleteClassAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteClassAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteClassAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteClassAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_CreateClassEnum(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct CreateClassEnum *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATECLASSENUM];

	r = talloc(talloc_tos(), struct CreateClassEnum);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateClassEnum, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateClassEnum(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateClassEnum, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_CreateClassEnumAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct CreateClassEnumAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATECLASSENUMASYNC];

	r = talloc(talloc_tos(), struct CreateClassEnumAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateClassEnumAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateClassEnumAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateClassEnumAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_PutInstance(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct PutInstance *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTINSTANCE];

	r = talloc(talloc_tos(), struct PutInstance);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutInstance, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutInstance, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_PutInstanceAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct PutInstanceAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTINSTANCEASYNC];

	r = talloc(talloc_tos(), struct PutInstanceAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutInstanceAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutInstanceAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutInstanceAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_DeleteInstance(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct DeleteInstance *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETEINSTANCE];

	r = talloc(talloc_tos(), struct DeleteInstance);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteInstance, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteInstance, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_DeleteInstanceAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct DeleteInstanceAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETEINSTANCEASYNC];

	r = talloc(talloc_tos(), struct DeleteInstanceAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteInstanceAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteInstanceAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteInstanceAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_CreateInstanceEnum(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct CreateInstanceEnum *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATEINSTANCEENUM];

	r = talloc(talloc_tos(), struct CreateInstanceEnum);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateInstanceEnum, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateInstanceEnum(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateInstanceEnum, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_CreateInstanceEnumAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct CreateInstanceEnumAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATEINSTANCEENUMASYNC];

	r = talloc(talloc_tos(), struct CreateInstanceEnumAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateInstanceEnumAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateInstanceEnumAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateInstanceEnumAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ExecQuery(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ExecQuery *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECQUERY];

	r = talloc(talloc_tos(), struct ExecQuery);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecQuery, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecQuery(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecQuery, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ExecQueryAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ExecQueryAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECQUERYASYNC];

	r = talloc(talloc_tos(), struct ExecQueryAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecQueryAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecQueryAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecQueryAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ExecNotificationQuery(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ExecNotificationQuery *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECNOTIFICATIONQUERY];

	r = talloc(talloc_tos(), struct ExecNotificationQuery);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecNotificationQuery, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecNotificationQuery(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecNotificationQuery, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ExecNotificationQueryAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ExecNotificationQueryAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECNOTIFICATIONQUERYASYNC];

	r = talloc(talloc_tos(), struct ExecNotificationQueryAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecNotificationQueryAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecNotificationQueryAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecNotificationQueryAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ExecMethod(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ExecMethod *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECMETHOD];

	r = talloc(talloc_tos(), struct ExecMethod);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecMethod, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppOutParams = r->in.ppOutParams;
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecMethod(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecMethod, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ExecMethodAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ExecMethodAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECMETHODASYNC];

	r = talloc(talloc_tos(), struct ExecMethodAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecMethodAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecMethodAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecMethodAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemServices_cmds[] = 
{
	{"OPENNAMESPACE", NDR_OPENNAMESPACE, api_OpenNamespace},
	{"CANCELASYNCCALL", NDR_CANCELASYNCCALL, api_CancelAsyncCall},
	{"QUERYOBJECTSINK", NDR_QUERYOBJECTSINK, api_QueryObjectSink},
	{"GETOBJECT", NDR_GETOBJECT, api_GetObject},
	{"GETOBJECTASYNC", NDR_GETOBJECTASYNC, api_GetObjectAsync},
	{"PUTCLASS", NDR_PUTCLASS, api_PutClass},
	{"PUTCLASSASYNC", NDR_PUTCLASSASYNC, api_PutClassAsync},
	{"DELETECLASS", NDR_DELETECLASS, api_DeleteClass},
	{"DELETECLASSASYNC", NDR_DELETECLASSASYNC, api_DeleteClassAsync},
	{"CREATECLASSENUM", NDR_CREATECLASSENUM, api_CreateClassEnum},
	{"CREATECLASSENUMASYNC", NDR_CREATECLASSENUMASYNC, api_CreateClassEnumAsync},
	{"PUTINSTANCE", NDR_PUTINSTANCE, api_PutInstance},
	{"PUTINSTANCEASYNC", NDR_PUTINSTANCEASYNC, api_PutInstanceAsync},
	{"DELETEINSTANCE", NDR_DELETEINSTANCE, api_DeleteInstance},
	{"DELETEINSTANCEASYNC", NDR_DELETEINSTANCEASYNC, api_DeleteInstanceAsync},
	{"CREATEINSTANCEENUM", NDR_CREATEINSTANCEENUM, api_CreateInstanceEnum},
	{"CREATEINSTANCEENUMASYNC", NDR_CREATEINSTANCEENUMASYNC, api_CreateInstanceEnumAsync},
	{"EXECQUERY", NDR_EXECQUERY, api_ExecQuery},
	{"EXECQUERYASYNC", NDR_EXECQUERYASYNC, api_ExecQueryAsync},
	{"EXECNOTIFICATIONQUERY", NDR_EXECNOTIFICATIONQUERY, api_ExecNotificationQuery},
	{"EXECNOTIFICATIONQUERYASYNC", NDR_EXECNOTIFICATIONQUERYASYNC, api_ExecNotificationQueryAsync},
	{"EXECMETHOD", NDR_EXECMETHOD, api_ExecMethod},
	{"EXECMETHODASYNC", NDR_EXECMETHODASYNC, api_ExecMethodAsync},
};

void IWbemServices_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemServices_cmds;
	*n_fns = sizeof(api_IWbemServices_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemServices_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_OPENNAMESPACE: {
			struct OpenNamespace *r = (struct OpenNamespace *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppWorkingNamespace = r->in.ppWorkingNamespace;
			r->out.ppResult = r->in.ppResult;
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _OpenNamespace(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_CANCELASYNCCALL: {
			struct CancelAsyncCall *r = (struct CancelAsyncCall *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _CancelAsyncCall(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_QUERYOBJECTSINK: {
			struct QueryObjectSink *r = (struct QueryObjectSink *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppResponseHandler = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppResponseHandler == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _QueryObjectSink(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_GETOBJECT: {
			struct GetObject *r = (struct GetObject *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppObject = r->in.ppObject;
			r->out.ppCallResult = r->in.ppCallResult;
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetObject(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_GETOBJECTASYNC: {
			struct GetObjectAsync *r = (struct GetObjectAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetObjectAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_PUTCLASS: {
			struct PutClass *r = (struct PutClass *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppCallResult = r->in.ppCallResult;
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _PutClass(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_PUTCLASSASYNC: {
			struct PutClassAsync *r = (struct PutClassAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _PutClassAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DELETECLASS: {
			struct DeleteClass *r = (struct DeleteClass *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppCallResult = r->in.ppCallResult;
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _DeleteClass(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DELETECLASSASYNC: {
			struct DeleteClassAsync *r = (struct DeleteClassAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _DeleteClassAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_CREATECLASSENUM: {
			struct CreateClassEnum *r = (struct CreateClassEnum *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppEnum = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppEnum == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _CreateClassEnum(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_CREATECLASSENUMASYNC: {
			struct CreateClassEnumAsync *r = (struct CreateClassEnumAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _CreateClassEnumAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_PUTINSTANCE: {
			struct PutInstance *r = (struct PutInstance *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppCallResult = r->in.ppCallResult;
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _PutInstance(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_PUTINSTANCEASYNC: {
			struct PutInstanceAsync *r = (struct PutInstanceAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _PutInstanceAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DELETEINSTANCE: {
			struct DeleteInstance *r = (struct DeleteInstance *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppCallResult = r->in.ppCallResult;
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _DeleteInstance(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DELETEINSTANCEASYNC: {
			struct DeleteInstanceAsync *r = (struct DeleteInstanceAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _DeleteInstanceAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_CREATEINSTANCEENUM: {
			struct CreateInstanceEnum *r = (struct CreateInstanceEnum *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppEnum = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppEnum == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _CreateInstanceEnum(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_CREATEINSTANCEENUMASYNC: {
			struct CreateInstanceEnumAsync *r = (struct CreateInstanceEnumAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _CreateInstanceEnumAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EXECQUERY: {
			struct ExecQuery *r = (struct ExecQuery *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppEnum = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppEnum == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ExecQuery(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EXECQUERYASYNC: {
			struct ExecQueryAsync *r = (struct ExecQueryAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ExecQueryAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EXECNOTIFICATIONQUERY: {
			struct ExecNotificationQuery *r = (struct ExecNotificationQuery *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppEnum = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppEnum == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ExecNotificationQuery(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EXECNOTIFICATIONQUERYASYNC: {
			struct ExecNotificationQueryAsync *r = (struct ExecNotificationQueryAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ExecNotificationQueryAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EXECMETHOD: {
			struct ExecMethod *r = (struct ExecMethod *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppOutParams = r->in.ppOutParams;
			r->out.ppCallResult = r->in.ppCallResult;
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ExecMethod(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EXECMETHODASYNC: {
			struct ExecMethodAsync *r = (struct ExecMethodAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ExecMethodAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemServices_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemServices", "IWbemServices", &ndr_table_IWbemServices, api_IWbemServices_cmds, sizeof(api_IWbemServices_cmds) / sizeof(struct api_struct));
}
static bool api_Reset(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Reset *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_RESET];

	r = talloc(talloc_tos(), struct Reset);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Reset, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Reset(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Reset, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_IEnumWbemClassObject_Next(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct IEnumWbemClassObject_Next *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_IENUMWBEMCLASSOBJECT_NEXT];

	r = talloc(talloc_tos(), struct IEnumWbemClassObject_Next);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IEnumWbemClassObject_Next, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.apObjects = talloc_zero_array(r, struct MInterfacePointer *, r->in.uCount);
	if (r->out.apObjects == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.puReturned = talloc_zero(r, uint32_t);
	if (r->out.puReturned == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _IEnumWbemClassObject_Next(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IEnumWbemClassObject_Next, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_NextAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct NextAsync *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_NEXTASYNC];

	r = talloc(talloc_tos(), struct NextAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NextAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _NextAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NextAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_IEnumWbemClassObject_Clone(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct IEnumWbemClassObject_Clone *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_IENUMWBEMCLASSOBJECT_CLONE];

	r = talloc(talloc_tos(), struct IEnumWbemClassObject_Clone);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IEnumWbemClassObject_Clone, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _IEnumWbemClassObject_Clone(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IEnumWbemClassObject_Clone, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_Skip(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Skip *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_SKIP];

	r = talloc(talloc_tos(), struct Skip);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Skip, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Skip(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Skip, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IEnumWbemClassObject_cmds[] = 
{
	{"RESET", NDR_RESET, api_Reset},
	{"IENUMWBEMCLASSOBJECT_NEXT", NDR_IENUMWBEMCLASSOBJECT_NEXT, api_IEnumWbemClassObject_Next},
	{"NEXTASYNC", NDR_NEXTASYNC, api_NextAsync},
	{"IENUMWBEMCLASSOBJECT_CLONE", NDR_IENUMWBEMCLASSOBJECT_CLONE, api_IEnumWbemClassObject_Clone},
	{"SKIP", NDR_SKIP, api_Skip},
};

void IEnumWbemClassObject_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IEnumWbemClassObject_cmds;
	*n_fns = sizeof(api_IEnumWbemClassObject_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IEnumWbemClassObject_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_RESET: {
			struct Reset *r = (struct Reset *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Reset(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_IENUMWBEMCLASSOBJECT_NEXT: {
			struct IEnumWbemClassObject_Next *r = (struct IEnumWbemClassObject_Next *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.apObjects = talloc_zero_array(mem_ctx, struct MInterfacePointer *, r->in.uCount);
			if (r->out.apObjects == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.puReturned = talloc_zero(mem_ctx, uint32_t);
			if (r->out.puReturned == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _IEnumWbemClassObject_Next(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_NEXTASYNC: {
			struct NextAsync *r = (struct NextAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _NextAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_IENUMWBEMCLASSOBJECT_CLONE: {
			struct IEnumWbemClassObject_Clone *r = (struct IEnumWbemClassObject_Clone *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppEnum = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppEnum == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _IEnumWbemClassObject_Clone(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SKIP: {
			struct Skip *r = (struct Skip *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Skip(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IEnumWbemClassObject_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IEnumWbemClassObject", "IEnumWbemClassObject", &ndr_table_IEnumWbemClassObject, api_IEnumWbemClassObject_cmds, sizeof(api_IEnumWbemClassObject_cmds) / sizeof(struct api_struct));
}
static bool api_Clone(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Clone *r;

	call = &ndr_table_IWbemContext.calls[NDR_CLONE];

	r = talloc(talloc_tos(), struct Clone);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Clone, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppNewCopy = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppNewCopy == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Clone(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Clone, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetNames(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetNames *r;

	call = &ndr_table_IWbemContext.calls[NDR_GETNAMES];

	r = talloc(talloc_tos(), struct GetNames);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetNames, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetNames(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetNames, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_BeginEnumeration(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct BeginEnumeration *r;

	call = &ndr_table_IWbemContext.calls[NDR_BEGINENUMERATION];

	r = talloc(talloc_tos(), struct BeginEnumeration);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(BeginEnumeration, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _BeginEnumeration(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(BeginEnumeration, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_Next(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Next *r;

	call = &ndr_table_IWbemContext.calls[NDR_NEXT];

	r = talloc(talloc_tos(), struct Next);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Next, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Next(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Next, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EndEnumeration(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EndEnumeration *r;

	call = &ndr_table_IWbemContext.calls[NDR_ENDENUMERATION];

	r = talloc(talloc_tos(), struct EndEnumeration);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EndEnumeration, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _EndEnumeration(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EndEnumeration, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_SetValue(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct SetValue *r;

	call = &ndr_table_IWbemContext.calls[NDR_SETVALUE];

	r = talloc(talloc_tos(), struct SetValue);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(SetValue, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _SetValue(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(SetValue, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetValue(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetValue *r;

	call = &ndr_table_IWbemContext.calls[NDR_GETVALUE];

	r = talloc(talloc_tos(), struct GetValue);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetValue, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetValue(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetValue, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_DeleteValue(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct DeleteValue *r;

	call = &ndr_table_IWbemContext.calls[NDR_DELETEVALUE];

	r = talloc(talloc_tos(), struct DeleteValue);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteValue, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteValue(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteValue, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_DeleteAll(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct DeleteAll *r;

	call = &ndr_table_IWbemContext.calls[NDR_DELETEALL];

	r = talloc(talloc_tos(), struct DeleteAll);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteAll, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteAll(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteAll, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemContext_cmds[] = 
{
	{"CLONE", NDR_CLONE, api_Clone},
	{"GETNAMES", NDR_GETNAMES, api_GetNames},
	{"BEGINENUMERATION", NDR_BEGINENUMERATION, api_BeginEnumeration},
	{"NEXT", NDR_NEXT, api_Next},
	{"ENDENUMERATION", NDR_ENDENUMERATION, api_EndEnumeration},
	{"SETVALUE", NDR_SETVALUE, api_SetValue},
	{"GETVALUE", NDR_GETVALUE, api_GetValue},
	{"DELETEVALUE", NDR_DELETEVALUE, api_DeleteValue},
	{"DELETEALL", NDR_DELETEALL, api_DeleteAll},
};

void IWbemContext_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemContext_cmds;
	*n_fns = sizeof(api_IWbemContext_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemContext_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_CLONE: {
			struct Clone *r = (struct Clone *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppNewCopy = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppNewCopy == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Clone(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_GETNAMES: {
			struct GetNames *r = (struct GetNames *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetNames(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_BEGINENUMERATION: {
			struct BeginEnumeration *r = (struct BeginEnumeration *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _BeginEnumeration(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_NEXT: {
			struct Next *r = (struct Next *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Next(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ENDENUMERATION: {
			struct EndEnumeration *r = (struct EndEnumeration *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _EndEnumeration(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SETVALUE: {
			struct SetValue *r = (struct SetValue *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _SetValue(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_GETVALUE: {
			struct GetValue *r = (struct GetValue *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetValue(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DELETEVALUE: {
			struct DeleteValue *r = (struct DeleteValue *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _DeleteValue(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DELETEALL: {
			struct DeleteAll *r = (struct DeleteAll *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _DeleteAll(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemContext_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemContext", "IWbemContext", &ndr_table_IWbemContext, api_IWbemContext_cmds, sizeof(api_IWbemContext_cmds) / sizeof(struct api_struct));
}
static bool api_EstablishPosition(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EstablishPosition *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_ESTABLISHPOSITION];

	r = talloc(talloc_tos(), struct EstablishPosition);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EstablishPosition, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.reserved = talloc_zero(r, uint32_t);
	if (r->out.reserved == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _EstablishPosition(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EstablishPosition, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_RequestChallenge(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RequestChallenge *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_REQUESTCHALLENGE];

	r = talloc(talloc_tos(), struct RequestChallenge);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RequestChallenge, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.Nonce = talloc_zero_array(r, uint8_t, 16);
	if (r->out.Nonce == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RequestChallenge(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RequestChallenge, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_WBEMLogin(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct WBEMLogin *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_WBEMLOGIN];

	r = talloc(talloc_tos(), struct WBEMLogin);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(WBEMLogin, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppNamespace = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppNamespace == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _WBEMLogin(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(WBEMLogin, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_NTLMLogin(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct NTLMLogin *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_NTLMLOGIN];

	r = talloc(talloc_tos(), struct NTLMLogin);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NTLMLogin, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppNamespace = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppNamespace == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _NTLMLogin(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NTLMLogin, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemLevel1Login_cmds[] = 
{
	{"ESTABLISHPOSITION", NDR_ESTABLISHPOSITION, api_EstablishPosition},
	{"REQUESTCHALLENGE", NDR_REQUESTCHALLENGE, api_RequestChallenge},
	{"WBEMLOGIN", NDR_WBEMLOGIN, api_WBEMLogin},
	{"NTLMLOGIN", NDR_NTLMLOGIN, api_NTLMLogin},
};

void IWbemLevel1Login_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemLevel1Login_cmds;
	*n_fns = sizeof(api_IWbemLevel1Login_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemLevel1Login_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_ESTABLISHPOSITION: {
			struct EstablishPosition *r = (struct EstablishPosition *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.reserved = talloc_zero(mem_ctx, uint32_t);
			if (r->out.reserved == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _EstablishPosition(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_REQUESTCHALLENGE: {
			struct RequestChallenge *r = (struct RequestChallenge *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.Nonce = talloc_zero_array(mem_ctx, uint8_t, 16);
			if (r->out.Nonce == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _RequestChallenge(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBEMLOGIN: {
			struct WBEMLogin *r = (struct WBEMLogin *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppNamespace = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppNamespace == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _WBEMLogin(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_NTLMLOGIN: {
			struct NTLMLogin *r = (struct NTLMLogin *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppNamespace = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppNamespace == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _NTLMLogin(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemLevel1Login_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemLevel1Login", "IWbemLevel1Login", &ndr_table_IWbemLevel1Login, api_IWbemLevel1Login_cmds, sizeof(api_IWbemLevel1Login_cmds) / sizeof(struct api_struct));
}
static bool api_IWbemWCOSmartEnum_Next(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct IWbemWCOSmartEnum_Next *r;

	call = &ndr_table_IWbemWCOSmartEnum.calls[NDR_IWBEMWCOSMARTENUM_NEXT];

	r = talloc(talloc_tos(), struct IWbemWCOSmartEnum_Next);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IWbemWCOSmartEnum_Next, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.puReturned = talloc_zero(r, uint32_t);
	if (r->out.puReturned == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pSize = talloc_zero(r, uint32_t);
	if (r->out.pSize == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pData = talloc_zero(r, uint8_t *);
	if (r->out.pData == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _IWbemWCOSmartEnum_Next(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IWbemWCOSmartEnum_Next, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemWCOSmartEnum_cmds[] = 
{
	{"IWBEMWCOSMARTENUM_NEXT", NDR_IWBEMWCOSMARTENUM_NEXT, api_IWbemWCOSmartEnum_Next},
};

void IWbemWCOSmartEnum_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemWCOSmartEnum_cmds;
	*n_fns = sizeof(api_IWbemWCOSmartEnum_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemWCOSmartEnum_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_IWBEMWCOSMARTENUM_NEXT: {
			struct IWbemWCOSmartEnum_Next *r = (struct IWbemWCOSmartEnum_Next *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.puReturned = talloc_zero(mem_ctx, uint32_t);
			if (r->out.puReturned == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.pSize = talloc_zero(mem_ctx, uint32_t);
			if (r->out.pSize == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.pData = talloc_zero(mem_ctx, uint8_t *);
			if (r->out.pData == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _IWbemWCOSmartEnum_Next(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemWCOSmartEnum_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemWCOSmartEnum", "IWbemWCOSmartEnum", &ndr_table_IWbemWCOSmartEnum, api_IWbemWCOSmartEnum_cmds, sizeof(api_IWbemWCOSmartEnum_cmds) / sizeof(struct api_struct));
}
static bool api_Fetch(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Fetch *r;

	call = &ndr_table_IWbemFetchSmartEnum.calls[NDR_FETCH];

	r = talloc(talloc_tos(), struct Fetch);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Fetch, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Fetch(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Fetch, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_Test(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Test *r;

	call = &ndr_table_IWbemFetchSmartEnum.calls[NDR_TEST];

	r = talloc(talloc_tos(), struct Test);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Test, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Test(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Test, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemFetchSmartEnum_cmds[] = 
{
	{"FETCH", NDR_FETCH, api_Fetch},
	{"TEST", NDR_TEST, api_Test},
};

void IWbemFetchSmartEnum_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemFetchSmartEnum_cmds;
	*n_fns = sizeof(api_IWbemFetchSmartEnum_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemFetchSmartEnum_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_FETCH: {
			struct Fetch *r = (struct Fetch *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppEnum = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppEnum == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Fetch(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_TEST: {
			struct Test *r = (struct Test *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppEnum = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppEnum == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Test(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemFetchSmartEnum_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemFetchSmartEnum", "IWbemFetchSmartEnum", &ndr_table_IWbemFetchSmartEnum, api_IWbemFetchSmartEnum_cmds, sizeof(api_IWbemFetchSmartEnum_cmds) / sizeof(struct api_struct));
}
static bool api_GetResultObject(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetResultObject *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETRESULTOBJECT];

	r = talloc(talloc_tos(), struct GetResultObject);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetResultObject, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppResultObject = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppResultObject == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetResultObject(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetResultObject, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetResultString(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetResultString *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETRESULTSTRING];

	r = talloc(talloc_tos(), struct GetResultString);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetResultString, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pstrResultString = talloc_zero(r, struct BSTR);
	if (r->out.pstrResultString == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetResultString(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetResultString, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetResultServices(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetResultServices *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETRESULTSERVICES];

	r = talloc(talloc_tos(), struct GetResultServices);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetResultServices, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppServices = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppServices == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetResultServices(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetResultServices, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetCallStatus(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetCallStatus *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETCALLSTATUS];

	r = talloc(talloc_tos(), struct GetCallStatus);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetCallStatus, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.plStatus = talloc_zero(r, int32_t);
	if (r->out.plStatus == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetCallStatus(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetCallStatus, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemCallResult_cmds[] = 
{
	{"GETRESULTOBJECT", NDR_GETRESULTOBJECT, api_GetResultObject},
	{"GETRESULTSTRING", NDR_GETRESULTSTRING, api_GetResultString},
	{"GETRESULTSERVICES", NDR_GETRESULTSERVICES, api_GetResultServices},
	{"GETCALLSTATUS", NDR_GETCALLSTATUS, api_GetCallStatus},
};

void IWbemCallResult_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemCallResult_cmds;
	*n_fns = sizeof(api_IWbemCallResult_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemCallResult_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_GETRESULTOBJECT: {
			struct GetResultObject *r = (struct GetResultObject *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppResultObject = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppResultObject == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetResultObject(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_GETRESULTSTRING: {
			struct GetResultString *r = (struct GetResultString *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.pstrResultString = talloc_zero(mem_ctx, struct BSTR);
			if (r->out.pstrResultString == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetResultString(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_GETRESULTSERVICES: {
			struct GetResultServices *r = (struct GetResultServices *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ppServices = talloc_zero(mem_ctx, struct MInterfacePointer *);
			if (r->out.ppServices == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetResultServices(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_GETCALLSTATUS: {
			struct GetCallStatus *r = (struct GetCallStatus *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.plStatus = talloc_zero(mem_ctx, int32_t);
			if (r->out.plStatus == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _GetCallStatus(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemCallResult_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemCallResult", "IWbemCallResult", &ndr_table_IWbemCallResult, api_IWbemCallResult_cmds, sizeof(api_IWbemCallResult_cmds) / sizeof(struct api_struct));
}
static bool api_SetStatus(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct SetStatus *r;

	call = &ndr_table_IWbemObjectSink.calls[NDR_SETSTATUS];

	r = talloc(talloc_tos(), struct SetStatus);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(SetStatus, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _SetStatus(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(SetStatus, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_Indicate(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Indicate *r;

	call = &ndr_table_IWbemObjectSink.calls[NDR_INDICATE];

	r = talloc(talloc_tos(), struct Indicate);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Indicate, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Indicate(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Indicate, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemObjectSink_cmds[] = 
{
	{"SETSTATUS", NDR_SETSTATUS, api_SetStatus},
	{"INDICATE", NDR_INDICATE, api_Indicate},
};

void IWbemObjectSink_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemObjectSink_cmds;
	*n_fns = sizeof(api_IWbemObjectSink_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemObjectSink_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_SETSTATUS: {
			struct SetStatus *r = (struct SetStatus *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _SetStatus(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_INDICATE: {
			struct Indicate *r = (struct Indicate *)_r;
			ZERO_STRUCT(r->out);
			r->out.ORPCthat = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.ORPCthat == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _Indicate(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IWbemObjectSink_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemObjectSink", "IWbemObjectSink", &ndr_table_IWbemObjectSink, api_IWbemObjectSink_cmds, sizeof(api_IWbemObjectSink_cmds) / sizeof(struct api_struct));
}
