/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_unixinfo.h"

static bool api_unixinfo_SidToUid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct unixinfo_SidToUid *r;

	call = &ndr_table_unixinfo.calls[NDR_UNIXINFO_SIDTOUID];

	r = talloc(talloc_tos(), struct unixinfo_SidToUid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(unixinfo_SidToUid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.uid = talloc_zero(r, uint64_t);
	if (r->out.uid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _unixinfo_SidToUid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(unixinfo_SidToUid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_unixinfo_UidToSid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct unixinfo_UidToSid *r;

	call = &ndr_table_unixinfo.calls[NDR_UNIXINFO_UIDTOSID];

	r = talloc(talloc_tos(), struct unixinfo_UidToSid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(unixinfo_UidToSid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sid = talloc_zero(r, struct dom_sid);
	if (r->out.sid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _unixinfo_UidToSid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(unixinfo_UidToSid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_unixinfo_SidToGid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct unixinfo_SidToGid *r;

	call = &ndr_table_unixinfo.calls[NDR_UNIXINFO_SIDTOGID];

	r = talloc(talloc_tos(), struct unixinfo_SidToGid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(unixinfo_SidToGid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.gid = talloc_zero(r, uint64_t);
	if (r->out.gid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _unixinfo_SidToGid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(unixinfo_SidToGid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_unixinfo_GidToSid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct unixinfo_GidToSid *r;

	call = &ndr_table_unixinfo.calls[NDR_UNIXINFO_GIDTOSID];

	r = talloc(talloc_tos(), struct unixinfo_GidToSid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(unixinfo_GidToSid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sid = talloc_zero(r, struct dom_sid);
	if (r->out.sid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _unixinfo_GidToSid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(unixinfo_GidToSid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_unixinfo_GetPWUid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct unixinfo_GetPWUid *r;

	call = &ndr_table_unixinfo.calls[NDR_UNIXINFO_GETPWUID];

	r = talloc(talloc_tos(), struct unixinfo_GetPWUid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(unixinfo_GetPWUid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.count = r->in.count;
	r->out.infos = talloc_zero_array(r, struct unixinfo_GetPWUidInfo, *r->out.count);
	if (r->out.infos == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _unixinfo_GetPWUid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(unixinfo_GetPWUid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_unixinfo_cmds[] = 
{
	{"UNIXINFO_SIDTOUID", NDR_UNIXINFO_SIDTOUID, api_unixinfo_SidToUid},
	{"UNIXINFO_UIDTOSID", NDR_UNIXINFO_UIDTOSID, api_unixinfo_UidToSid},
	{"UNIXINFO_SIDTOGID", NDR_UNIXINFO_SIDTOGID, api_unixinfo_SidToGid},
	{"UNIXINFO_GIDTOSID", NDR_UNIXINFO_GIDTOSID, api_unixinfo_GidToSid},
	{"UNIXINFO_GETPWUID", NDR_UNIXINFO_GETPWUID, api_unixinfo_GetPWUid},
};

void unixinfo_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_unixinfo_cmds;
	*n_fns = sizeof(api_unixinfo_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_unixinfo_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_UNIXINFO_SIDTOUID: {
			struct unixinfo_SidToUid *r = (struct unixinfo_SidToUid *)_r;
			ZERO_STRUCT(r->out);
			r->out.uid = talloc_zero(mem_ctx, uint64_t);
			if (r->out.uid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _unixinfo_SidToUid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_UNIXINFO_UIDTOSID: {
			struct unixinfo_UidToSid *r = (struct unixinfo_UidToSid *)_r;
			ZERO_STRUCT(r->out);
			r->out.sid = talloc_zero(mem_ctx, struct dom_sid);
			if (r->out.sid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _unixinfo_UidToSid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_UNIXINFO_SIDTOGID: {
			struct unixinfo_SidToGid *r = (struct unixinfo_SidToGid *)_r;
			ZERO_STRUCT(r->out);
			r->out.gid = talloc_zero(mem_ctx, uint64_t);
			if (r->out.gid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _unixinfo_SidToGid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_UNIXINFO_GIDTOSID: {
			struct unixinfo_GidToSid *r = (struct unixinfo_GidToSid *)_r;
			ZERO_STRUCT(r->out);
			r->out.sid = talloc_zero(mem_ctx, struct dom_sid);
			if (r->out.sid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _unixinfo_GidToSid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_UNIXINFO_GETPWUID: {
			struct unixinfo_GetPWUid *r = (struct unixinfo_GetPWUid *)_r;
			ZERO_STRUCT(r->out);
			r->out.count = r->in.count;
			r->out.infos = talloc_zero_array(mem_ctx, struct unixinfo_GetPWUidInfo, *r->out.count);
			if (r->out.infos == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _unixinfo_GetPWUid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_unixinfo_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "unixinfo", "unixinfo", &ndr_table_unixinfo, api_unixinfo_cmds, sizeof(api_unixinfo_cmds) / sizeof(struct api_struct));
}
