/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_rot.h"

static bool api_rot_add(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct rot_add *r;

	call = &ndr_table_rot.calls[NDR_ROT_ADD];

	r = talloc(talloc_tos(), struct rot_add);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(rot_add, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rotid = talloc_zero(r, uint32_t);
	if (r->out.rotid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _rot_add(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(rot_add, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_rot_remove(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct rot_remove *r;

	call = &ndr_table_rot.calls[NDR_ROT_REMOVE];

	r = talloc(talloc_tos(), struct rot_remove);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(rot_remove, r);
	}

	r->out.result = _rot_remove(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(rot_remove, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_rot_is_listed(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct rot_is_listed *r;

	call = &ndr_table_rot.calls[NDR_ROT_IS_LISTED];

	r = talloc(talloc_tos(), struct rot_is_listed);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(rot_is_listed, r);
	}

	r->out.result = _rot_is_listed(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(rot_is_listed, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_rot_get_interface_pointer(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct rot_get_interface_pointer *r;

	call = &ndr_table_rot.calls[NDR_ROT_GET_INTERFACE_POINTER];

	r = talloc(talloc_tos(), struct rot_get_interface_pointer);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(rot_get_interface_pointer, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ip = talloc_zero(r, struct MInterfacePointer);
	if (r->out.ip == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _rot_get_interface_pointer(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(rot_get_interface_pointer, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_rot_set_modification_time(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct rot_set_modification_time *r;

	call = &ndr_table_rot.calls[NDR_ROT_SET_MODIFICATION_TIME];

	r = talloc(talloc_tos(), struct rot_set_modification_time);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(rot_set_modification_time, r);
	}

	r->out.result = _rot_set_modification_time(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(rot_set_modification_time, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_rot_get_modification_time(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct rot_get_modification_time *r;

	call = &ndr_table_rot.calls[NDR_ROT_GET_MODIFICATION_TIME];

	r = talloc(talloc_tos(), struct rot_get_modification_time);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(rot_get_modification_time, r);
	}

	ZERO_STRUCT(r->out);
	r->out.t = talloc_zero(r, NTTIME);
	if (r->out.t == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _rot_get_modification_time(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(rot_get_modification_time, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_rot_enum(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct rot_enum *r;

	call = &ndr_table_rot.calls[NDR_ROT_ENUM];

	r = talloc(talloc_tos(), struct rot_enum);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(rot_enum, r);
	}

	ZERO_STRUCT(r->out);
	r->out.EnumMoniker = talloc_zero(r, struct MInterfacePointer);
	if (r->out.EnumMoniker == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _rot_enum(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(rot_enum, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_rot_cmds[] = 
{
	{"ROT_ADD", NDR_ROT_ADD, api_rot_add},
	{"ROT_REMOVE", NDR_ROT_REMOVE, api_rot_remove},
	{"ROT_IS_LISTED", NDR_ROT_IS_LISTED, api_rot_is_listed},
	{"ROT_GET_INTERFACE_POINTER", NDR_ROT_GET_INTERFACE_POINTER, api_rot_get_interface_pointer},
	{"ROT_SET_MODIFICATION_TIME", NDR_ROT_SET_MODIFICATION_TIME, api_rot_set_modification_time},
	{"ROT_GET_MODIFICATION_TIME", NDR_ROT_GET_MODIFICATION_TIME, api_rot_get_modification_time},
	{"ROT_ENUM", NDR_ROT_ENUM, api_rot_enum},
};

void rot_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_rot_cmds;
	*n_fns = sizeof(api_rot_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_rot_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_ROT_ADD: {
			struct rot_add *r = (struct rot_add *)_r;
			ZERO_STRUCT(r->out);
			r->out.rotid = talloc_zero(mem_ctx, uint32_t);
			if (r->out.rotid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _rot_add(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ROT_REMOVE: {
			struct rot_remove *r = (struct rot_remove *)_r;
			r->out.result = _rot_remove(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ROT_IS_LISTED: {
			struct rot_is_listed *r = (struct rot_is_listed *)_r;
			r->out.result = _rot_is_listed(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ROT_GET_INTERFACE_POINTER: {
			struct rot_get_interface_pointer *r = (struct rot_get_interface_pointer *)_r;
			ZERO_STRUCT(r->out);
			r->out.ip = talloc_zero(mem_ctx, struct MInterfacePointer);
			if (r->out.ip == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _rot_get_interface_pointer(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ROT_SET_MODIFICATION_TIME: {
			struct rot_set_modification_time *r = (struct rot_set_modification_time *)_r;
			r->out.result = _rot_set_modification_time(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ROT_GET_MODIFICATION_TIME: {
			struct rot_get_modification_time *r = (struct rot_get_modification_time *)_r;
			ZERO_STRUCT(r->out);
			r->out.t = talloc_zero(mem_ctx, NTTIME);
			if (r->out.t == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _rot_get_modification_time(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ROT_ENUM: {
			struct rot_enum *r = (struct rot_enum *)_r;
			ZERO_STRUCT(r->out);
			r->out.EnumMoniker = talloc_zero(mem_ctx, struct MInterfacePointer);
			if (r->out.EnumMoniker == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _rot_enum(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_rot_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "rot", "rot", &ndr_table_rot, api_rot_cmds, sizeof(api_rot_cmds) / sizeof(struct api_struct));
}
