/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_remact.h"

static bool api_RemoteActivation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemoteActivation *r;

	call = &ndr_table_IRemoteActivation.calls[NDR_REMOTEACTIVATION];

	r = talloc(talloc_tos(), struct RemoteActivation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemoteActivation, r);
	}

	ZERO_STRUCT(r->out);
	r->out.that = talloc_zero(r, struct ORPCTHAT);
	if (r->out.that == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pOxid = talloc_zero(r, uint64_t);
	if (r->out.pOxid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pdsaOxidBindings = talloc_zero(r, struct DUALSTRINGARRAY);
	if (r->out.pdsaOxidBindings == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ipidRemUnknown = talloc_zero(r, struct GUID);
	if (r->out.ipidRemUnknown == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.AuthnHint = talloc_zero(r, uint32_t);
	if (r->out.AuthnHint == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ServerVersion = talloc_zero(r, struct COMVERSION);
	if (r->out.ServerVersion == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.hr = talloc_zero(r, WERROR);
	if (r->out.hr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ifaces = talloc_zero_array(r, struct MInterfacePointer *, r->in.Interfaces);
	if (r->out.ifaces == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.results = talloc_zero_array(r, WERROR, r->in.Interfaces);
	if (r->out.results == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemoteActivation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemoteActivation, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IRemoteActivation_cmds[] = 
{
	{"REMOTEACTIVATION", NDR_REMOTEACTIVATION, api_RemoteActivation},
};

void IRemoteActivation_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IRemoteActivation_cmds;
	*n_fns = sizeof(api_IRemoteActivation_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IRemoteActivation_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_REMOTEACTIVATION: {
			struct RemoteActivation *r = (struct RemoteActivation *)_r;
			ZERO_STRUCT(r->out);
			r->out.that = talloc_zero(mem_ctx, struct ORPCTHAT);
			if (r->out.that == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.pOxid = talloc_zero(mem_ctx, uint64_t);
			if (r->out.pOxid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.pdsaOxidBindings = talloc_zero(mem_ctx, struct DUALSTRINGARRAY);
			if (r->out.pdsaOxidBindings == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ipidRemUnknown = talloc_zero(mem_ctx, struct GUID);
			if (r->out.ipidRemUnknown == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.AuthnHint = talloc_zero(mem_ctx, uint32_t);
			if (r->out.AuthnHint == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ServerVersion = talloc_zero(mem_ctx, struct COMVERSION);
			if (r->out.ServerVersion == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.hr = talloc_zero(mem_ctx, WERROR);
			if (r->out.hr == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ifaces = talloc_zero_array(mem_ctx, struct MInterfacePointer *, r->in.Interfaces);
			if (r->out.ifaces == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.results = talloc_zero_array(mem_ctx, WERROR, r->in.Interfaces);
			if (r->out.results == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _RemoteActivation(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IRemoteActivation_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IRemoteActivation", "IRemoteActivation", &ndr_table_IRemoteActivation, api_IRemoteActivation_cmds, sizeof(api_IRemoteActivation_cmds) / sizeof(struct api_struct));
}
