/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_ntlmssp.h"

static bool api_decode_NEGOTIATE_MESSAGE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct decode_NEGOTIATE_MESSAGE *r;

	call = &ndr_table_ntlmssp.calls[NDR_DECODE_NEGOTIATE_MESSAGE];

	r = talloc(talloc_tos(), struct decode_NEGOTIATE_MESSAGE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(decode_NEGOTIATE_MESSAGE, r);
	}

	_decode_NEGOTIATE_MESSAGE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(decode_NEGOTIATE_MESSAGE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_decode_CHALLENGE_MESSAGE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct decode_CHALLENGE_MESSAGE *r;

	call = &ndr_table_ntlmssp.calls[NDR_DECODE_CHALLENGE_MESSAGE];

	r = talloc(talloc_tos(), struct decode_CHALLENGE_MESSAGE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(decode_CHALLENGE_MESSAGE, r);
	}

	_decode_CHALLENGE_MESSAGE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(decode_CHALLENGE_MESSAGE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_decode_AUTHENTICATE_MESSAGE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct decode_AUTHENTICATE_MESSAGE *r;

	call = &ndr_table_ntlmssp.calls[NDR_DECODE_AUTHENTICATE_MESSAGE];

	r = talloc(talloc_tos(), struct decode_AUTHENTICATE_MESSAGE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(decode_AUTHENTICATE_MESSAGE, r);
	}

	_decode_AUTHENTICATE_MESSAGE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(decode_AUTHENTICATE_MESSAGE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_decode_NTLMv2_CLIENT_CHALLENGE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct decode_NTLMv2_CLIENT_CHALLENGE *r;

	call = &ndr_table_ntlmssp.calls[NDR_DECODE_NTLMV2_CLIENT_CHALLENGE];

	r = talloc(talloc_tos(), struct decode_NTLMv2_CLIENT_CHALLENGE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(decode_NTLMv2_CLIENT_CHALLENGE, r);
	}

	_decode_NTLMv2_CLIENT_CHALLENGE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(decode_NTLMv2_CLIENT_CHALLENGE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ntlmssp_cmds[] = 
{
	{"DECODE_NEGOTIATE_MESSAGE", NDR_DECODE_NEGOTIATE_MESSAGE, api_decode_NEGOTIATE_MESSAGE},
	{"DECODE_CHALLENGE_MESSAGE", NDR_DECODE_CHALLENGE_MESSAGE, api_decode_CHALLENGE_MESSAGE},
	{"DECODE_AUTHENTICATE_MESSAGE", NDR_DECODE_AUTHENTICATE_MESSAGE, api_decode_AUTHENTICATE_MESSAGE},
	{"DECODE_NTLMV2_CLIENT_CHALLENGE", NDR_DECODE_NTLMV2_CLIENT_CHALLENGE, api_decode_NTLMv2_CLIENT_CHALLENGE},
};

void ntlmssp_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ntlmssp_cmds;
	*n_fns = sizeof(api_ntlmssp_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ntlmssp_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_DECODE_NEGOTIATE_MESSAGE: {
			struct decode_NEGOTIATE_MESSAGE *r = (struct decode_NEGOTIATE_MESSAGE *)_r;
			_decode_NEGOTIATE_MESSAGE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DECODE_CHALLENGE_MESSAGE: {
			struct decode_CHALLENGE_MESSAGE *r = (struct decode_CHALLENGE_MESSAGE *)_r;
			_decode_CHALLENGE_MESSAGE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DECODE_AUTHENTICATE_MESSAGE: {
			struct decode_AUTHENTICATE_MESSAGE *r = (struct decode_AUTHENTICATE_MESSAGE *)_r;
			_decode_AUTHENTICATE_MESSAGE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_DECODE_NTLMV2_CLIENT_CHALLENGE: {
			struct decode_NTLMv2_CLIENT_CHALLENGE *r = (struct decode_NTLMv2_CLIENT_CHALLENGE *)_r;
			_decode_NTLMv2_CLIENT_CHALLENGE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_ntlmssp_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ntlmssp", "ntlmssp", &ndr_table_ntlmssp, api_ntlmssp_cmds, sizeof(api_ntlmssp_cmds) / sizeof(struct api_struct));
}
