/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_wmi.h"

struct rpccli_Delete_state {
	struct Delete orig;
	struct Delete tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Delete_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Delete_send(TALLOC_CTX *mem_ctx,
				      struct tevent_context *ev,
				      struct rpc_pipe_client *cli,
				      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS _ORPCthis /* [in]  */,
				      const char *_wszName /* [in] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_Delete_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Delete_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszName = _wszName;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Delete_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemClassObject,
				    NDR_DELETE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Delete_done, req);
	return req;
}

static void rpccli_Delete_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Delete_state *state = tevent_req_data(
		req, struct rpccli_Delete_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Delete_recv(struct tevent_req *req,
			    TALLOC_CTX *mem_ctx,
			    WERROR *result)
{
	struct rpccli_Delete_state *state = tevent_req_data(
		req, struct rpccli_Delete_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Delete(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */,
		       const char *wszName /* [in] [ref,charset(UTF16)] */,
		       WERROR *werror)
{
	struct Delete r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszName = wszName;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemClassObject,
				NDR_DELETE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_OpenNamespace_state {
	struct OpenNamespace orig;
	struct OpenNamespace tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_OpenNamespace_done(struct tevent_req *subreq);

struct tevent_req *rpccli_OpenNamespace_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     struct BSTR _strNamespace /* [in]  */,
					     int32_t _lFlags /* [in]  */,
					     struct MInterfacePointer *_pCtx /* [in] [ref] */,
					     struct MInterfacePointer **_ppWorkingNamespace /* [in,out] [unique] */,
					     struct MInterfacePointer **_ppResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_OpenNamespace_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_OpenNamespace_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strNamespace = _strNamespace;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppWorkingNamespace = _ppWorkingNamespace;
	state->orig.in.ppResult = _ppResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppWorkingNamespace = _ppWorkingNamespace;
	state->orig.out.ppResult = _ppResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_OpenNamespace_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_OPENNAMESPACE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_OpenNamespace_done, req);
	return req;
}

static void rpccli_OpenNamespace_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_OpenNamespace_state *state = tevent_req_data(
		req, struct rpccli_OpenNamespace_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppWorkingNamespace && state->tmp.out.ppWorkingNamespace) {
		*state->orig.out.ppWorkingNamespace = *state->tmp.out.ppWorkingNamespace;
	}
	if (state->orig.out.ppResult && state->tmp.out.ppResult) {
		*state->orig.out.ppResult = *state->tmp.out.ppResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_OpenNamespace_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct rpccli_OpenNamespace_state *state = tevent_req_data(
		req, struct rpccli_OpenNamespace_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_OpenNamespace(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct BSTR strNamespace /* [in]  */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer **ppWorkingNamespace /* [in,out] [unique] */,
			      struct MInterfacePointer **ppResult /* [in,out] [unique] */,
			      WERROR *werror)
{
	struct OpenNamespace r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strNamespace = strNamespace;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppWorkingNamespace = ppWorkingNamespace;
	r.in.ppResult = ppResult;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_OPENNAMESPACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppWorkingNamespace && r.out.ppWorkingNamespace) {
		*ppWorkingNamespace = *r.out.ppWorkingNamespace;
	}
	if (ppResult && r.out.ppResult) {
		*ppResult = *r.out.ppResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_CancelAsyncCall_state {
	struct CancelAsyncCall orig;
	struct CancelAsyncCall tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_CancelAsyncCall_done(struct tevent_req *subreq);

struct tevent_req *rpccli_CancelAsyncCall_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct MInterfacePointer *_pSink /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_CancelAsyncCall_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_CancelAsyncCall_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pSink = _pSink;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_CancelAsyncCall_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_CANCELASYNCCALL,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_CancelAsyncCall_done, req);
	return req;
}

static void rpccli_CancelAsyncCall_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_CancelAsyncCall_state *state = tevent_req_data(
		req, struct rpccli_CancelAsyncCall_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_CancelAsyncCall_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct rpccli_CancelAsyncCall_state *state = tevent_req_data(
		req, struct rpccli_CancelAsyncCall_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_CancelAsyncCall(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct MInterfacePointer *pSink /* [in] [ref] */,
				WERROR *werror)
{
	struct CancelAsyncCall r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pSink = pSink;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CANCELASYNCCALL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_QueryObjectSink_state {
	struct QueryObjectSink orig;
	struct QueryObjectSink tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_QueryObjectSink_done(struct tevent_req *subreq);

struct tevent_req *rpccli_QueryObjectSink_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lFlags /* [in]  */,
					       struct MInterfacePointer **_ppResponseHandler /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_QueryObjectSink_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_QueryObjectSink_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lFlags = _lFlags;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppResponseHandler = _ppResponseHandler;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_QueryObjectSink_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_QUERYOBJECTSINK,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_QueryObjectSink_done, req);
	return req;
}

static void rpccli_QueryObjectSink_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_QueryObjectSink_state *state = tevent_req_data(
		req, struct rpccli_QueryObjectSink_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppResponseHandler = *state->tmp.out.ppResponseHandler;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_QueryObjectSink_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct rpccli_QueryObjectSink_state *state = tevent_req_data(
		req, struct rpccli_QueryObjectSink_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_QueryObjectSink(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer **ppResponseHandler /* [out] [ref] */,
				WERROR *werror)
{
	struct QueryObjectSink r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lFlags = lFlags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_QUERYOBJECTSINK,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppResponseHandler = *r.out.ppResponseHandler;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetObject_state {
	struct GetObject orig;
	struct GetObject tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetObject_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetObject_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 struct BSTR _strObjectPath /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [ref] */,
					 struct MInterfacePointer **_ppObject /* [in,out] [unique] */,
					 struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_GetObject_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetObject_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppObject = _ppObject;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppObject = _ppObject;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetObject_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_GETOBJECT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetObject_done, req);
	return req;
}

static void rpccli_GetObject_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetObject_state *state = tevent_req_data(
		req, struct rpccli_GetObject_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppObject && state->tmp.out.ppObject) {
		*state->orig.out.ppObject = *state->tmp.out.ppObject;
	}
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetObject_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_GetObject_state *state = tevent_req_data(
		req, struct rpccli_GetObject_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetObject(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strObjectPath /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppObject /* [in,out] [unique] */,
			  struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			  WERROR *werror)
{
	struct GetObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppObject = ppObject;
	r.in.ppCallResult = ppCallResult;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_GETOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppObject && r.out.ppObject) {
		*ppObject = *r.out.ppObject;
	}
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetObjectAsync_state {
	struct GetObjectAsync orig;
	struct GetObjectAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetObjectAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetObjectAsync_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strObjectPath /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_GetObjectAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetObjectAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetObjectAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_GETOBJECTASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetObjectAsync_done, req);
	return req;
}

static void rpccli_GetObjectAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetObjectAsync_state *state = tevent_req_data(
		req, struct rpccli_GetObjectAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetObjectAsync_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_GetObjectAsync_state *state = tevent_req_data(
		req, struct rpccli_GetObjectAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetObjectAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror)
{
	struct GetObjectAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_GETOBJECTASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_PutClass_state {
	struct PutClass orig;
	struct PutClass tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_PutClass_done(struct tevent_req *subreq);

struct tevent_req *rpccli_PutClass_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */,
					struct MInterfacePointer *_pObject /* [in] [ref] */,
					int32_t _lFlags /* [in]  */,
					struct MInterfacePointer *_pCtx /* [in] [ref] */,
					struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_PutClass_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_PutClass_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pObject = _pObject;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_PutClass_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_PUTCLASS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_PutClass_done, req);
	return req;
}

static void rpccli_PutClass_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_PutClass_state *state = tevent_req_data(
		req, struct rpccli_PutClass_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_PutClass_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_PutClass_state *state = tevent_req_data(
		req, struct rpccli_PutClass_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_PutClass(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 struct MInterfacePointer *pObject /* [in] [ref] */,
			 int32_t lFlags /* [in]  */,
			 struct MInterfacePointer *pCtx /* [in] [ref] */,
			 struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			 WERROR *werror)
{
	struct PutClass r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pObject = pObject;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTCLASS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_PutClassAsync_state {
	struct PutClassAsync orig;
	struct PutClassAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_PutClassAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_PutClassAsync_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     struct MInterfacePointer *_pObject /* [in] [ref] */,
					     int32_t _lFlags /* [in]  */,
					     struct MInterfacePointer *_pCtx /* [in] [ref] */,
					     struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_PutClassAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_PutClassAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pObject = _pObject;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_PutClassAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_PUTCLASSASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_PutClassAsync_done, req);
	return req;
}

static void rpccli_PutClassAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_PutClassAsync_state *state = tevent_req_data(
		req, struct rpccli_PutClassAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_PutClassAsync_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct rpccli_PutClassAsync_state *state = tevent_req_data(
		req, struct rpccli_PutClassAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_PutClassAsync(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct MInterfacePointer *pObject /* [in] [ref] */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			      WERROR *werror)
{
	struct PutClassAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pObject = pObject;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTCLASSASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_DeleteClass_state {
	struct DeleteClass orig;
	struct DeleteClass tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_DeleteClass_done(struct tevent_req *subreq);

struct tevent_req *rpccli_DeleteClass_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct BSTR _strClass /* [in]  */,
					   int32_t _lFlags /* [in]  */,
					   struct MInterfacePointer *_pCtx /* [in] [ref] */,
					   struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_DeleteClass_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_DeleteClass_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strClass = _strClass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_DeleteClass_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_DELETECLASS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_DeleteClass_done, req);
	return req;
}

static void rpccli_DeleteClass_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_DeleteClass_state *state = tevent_req_data(
		req, struct rpccli_DeleteClass_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_DeleteClass_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct rpccli_DeleteClass_state *state = tevent_req_data(
		req, struct rpccli_DeleteClass_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_DeleteClass(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct BSTR strClass /* [in]  */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror)
{
	struct DeleteClass r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strClass = strClass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETECLASS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_DeleteClassAsync_state {
	struct DeleteClassAsync orig;
	struct DeleteClassAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_DeleteClassAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_DeleteClassAsync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						struct BSTR _strClass /* [in]  */,
						int32_t _lFlags /* [in]  */,
						struct MInterfacePointer *_pCtx /* [in] [ref] */,
						struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_DeleteClassAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_DeleteClassAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strClass = _strClass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_DeleteClassAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_DELETECLASSASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_DeleteClassAsync_done, req);
	return req;
}

static void rpccli_DeleteClassAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_DeleteClassAsync_state *state = tevent_req_data(
		req, struct rpccli_DeleteClassAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_DeleteClassAsync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_DeleteClassAsync_state *state = tevent_req_data(
		req, struct rpccli_DeleteClassAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_DeleteClassAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct BSTR strClass /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror)
{
	struct DeleteClassAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strClass = strClass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETECLASSASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_CreateClassEnum_state {
	struct CreateClassEnum orig;
	struct CreateClassEnum tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_CreateClassEnum_done(struct tevent_req *subreq);

struct tevent_req *rpccli_CreateClassEnum_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct BSTR _strSuperclass /* [in]  */,
					       int32_t _lFlags /* [in]  */,
					       struct MInterfacePointer *_pCtx /* [in] [ref] */,
					       struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_CreateClassEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_CreateClassEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strSuperclass = _strSuperclass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_CreateClassEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_CREATECLASSENUM,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_CreateClassEnum_done, req);
	return req;
}

static void rpccli_CreateClassEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_CreateClassEnum_state *state = tevent_req_data(
		req, struct rpccli_CreateClassEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_CreateClassEnum_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct rpccli_CreateClassEnum_state *state = tevent_req_data(
		req, struct rpccli_CreateClassEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_CreateClassEnum(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strSuperclass /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer **ppEnum /* [out] [ref] */,
				WERROR *werror)
{
	struct CreateClassEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strSuperclass = strSuperclass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATECLASSENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_CreateClassEnumAsync_state {
	struct CreateClassEnumAsync orig;
	struct CreateClassEnumAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_CreateClassEnumAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_CreateClassEnumAsync_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						    struct ORPCTHIS _ORPCthis /* [in]  */,
						    struct BSTR _strSuperclass /* [in]  */,
						    int32_t _lFlags /* [in]  */,
						    struct MInterfacePointer *_pCtx /* [in] [ref] */,
						    struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_CreateClassEnumAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_CreateClassEnumAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strSuperclass = _strSuperclass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_CreateClassEnumAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_CREATECLASSENUMASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_CreateClassEnumAsync_done, req);
	return req;
}

static void rpccli_CreateClassEnumAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_CreateClassEnumAsync_state *state = tevent_req_data(
		req, struct rpccli_CreateClassEnumAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_CreateClassEnumAsync_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_CreateClassEnumAsync_state *state = tevent_req_data(
		req, struct rpccli_CreateClassEnumAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_CreateClassEnumAsync(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS ORPCthis /* [in]  */,
				     struct BSTR strSuperclass /* [in]  */,
				     int32_t lFlags /* [in]  */,
				     struct MInterfacePointer *pCtx /* [in] [ref] */,
				     struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				     WERROR *werror)
{
	struct CreateClassEnumAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strSuperclass = strSuperclass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATECLASSENUMASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_PutInstance_state {
	struct PutInstance orig;
	struct PutInstance tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_PutInstance_done(struct tevent_req *subreq);

struct tevent_req *rpccli_PutInstance_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct MInterfacePointer *_pInst /* [in] [ref] */,
					   int32_t _lFlags /* [in]  */,
					   struct MInterfacePointer *_pCtx /* [in] [ref] */,
					   struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_PutInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_PutInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pInst = _pInst;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_PutInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_PUTINSTANCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_PutInstance_done, req);
	return req;
}

static void rpccli_PutInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_PutInstance_state *state = tevent_req_data(
		req, struct rpccli_PutInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_PutInstance_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct rpccli_PutInstance_state *state = tevent_req_data(
		req, struct rpccli_PutInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_PutInstance(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct MInterfacePointer *pInst /* [in] [ref] */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror)
{
	struct PutInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pInst = pInst;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_PutInstanceAsync_state {
	struct PutInstanceAsync orig;
	struct PutInstanceAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_PutInstanceAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_PutInstanceAsync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						struct MInterfacePointer *_pInst /* [in] [ref] */,
						int32_t _lFlags /* [in]  */,
						struct MInterfacePointer *_pCtx /* [in] [ref] */,
						struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_PutInstanceAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_PutInstanceAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pInst = _pInst;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_PutInstanceAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_PUTINSTANCEASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_PutInstanceAsync_done, req);
	return req;
}

static void rpccli_PutInstanceAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_PutInstanceAsync_state *state = tevent_req_data(
		req, struct rpccli_PutInstanceAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_PutInstanceAsync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_PutInstanceAsync_state *state = tevent_req_data(
		req, struct rpccli_PutInstanceAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_PutInstanceAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct MInterfacePointer *pInst /* [in] [ref] */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror)
{
	struct PutInstanceAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pInst = pInst;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTINSTANCEASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_DeleteInstance_state {
	struct DeleteInstance orig;
	struct DeleteInstance tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_DeleteInstance_done(struct tevent_req *subreq);

struct tevent_req *rpccli_DeleteInstance_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strObjectPath /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_DeleteInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_DeleteInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_DeleteInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_DELETEINSTANCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_DeleteInstance_done, req);
	return req;
}

static void rpccli_DeleteInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_DeleteInstance_state *state = tevent_req_data(
		req, struct rpccli_DeleteInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_DeleteInstance_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_DeleteInstance_state *state = tevent_req_data(
		req, struct rpccli_DeleteInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_DeleteInstance(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			       WERROR *werror)
{
	struct DeleteInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_DeleteInstanceAsync_state {
	struct DeleteInstanceAsync orig;
	struct DeleteInstanceAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_DeleteInstanceAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_DeleteInstanceAsync_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						   struct ORPCTHIS _ORPCthis /* [in]  */,
						   struct BSTR _strObjectPath /* [in]  */,
						   int32_t _lFlags /* [in]  */,
						   struct MInterfacePointer *_pCtx /* [in] [ref] */,
						   struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_DeleteInstanceAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_DeleteInstanceAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_DeleteInstanceAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_DELETEINSTANCEASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_DeleteInstanceAsync_done, req);
	return req;
}

static void rpccli_DeleteInstanceAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_DeleteInstanceAsync_state *state = tevent_req_data(
		req, struct rpccli_DeleteInstanceAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_DeleteInstanceAsync_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct rpccli_DeleteInstanceAsync_state *state = tevent_req_data(
		req, struct rpccli_DeleteInstanceAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_DeleteInstanceAsync(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS ORPCthis /* [in]  */,
				    struct BSTR strObjectPath /* [in]  */,
				    int32_t lFlags /* [in]  */,
				    struct MInterfacePointer *pCtx /* [in] [ref] */,
				    struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				    WERROR *werror)
{
	struct DeleteInstanceAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETEINSTANCEASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_CreateInstanceEnum_state {
	struct CreateInstanceEnum orig;
	struct CreateInstanceEnum tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_CreateInstanceEnum_done(struct tevent_req *subreq);

struct tevent_req *rpccli_CreateInstanceEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						  struct ORPCTHIS _ORPCthis /* [in]  */,
						  struct BSTR _strFilter /* [in]  */,
						  int32_t _lFlags /* [in]  */,
						  struct MInterfacePointer *_pCtx /* [in] [unique] */,
						  struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_CreateInstanceEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_CreateInstanceEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strFilter = _strFilter;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_CreateInstanceEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_CREATEINSTANCEENUM,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_CreateInstanceEnum_done, req);
	return req;
}

static void rpccli_CreateInstanceEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_CreateInstanceEnum_state *state = tevent_req_data(
		req, struct rpccli_CreateInstanceEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_CreateInstanceEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_CreateInstanceEnum_state *state = tevent_req_data(
		req, struct rpccli_CreateInstanceEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_CreateInstanceEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   struct BSTR strFilter /* [in]  */,
				   int32_t lFlags /* [in]  */,
				   struct MInterfacePointer *pCtx /* [in] [unique] */,
				   struct MInterfacePointer **ppEnum /* [out] [ref] */,
				   WERROR *werror)
{
	struct CreateInstanceEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strFilter = strFilter;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATEINSTANCEENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_CreateInstanceEnumAsync_state {
	struct CreateInstanceEnumAsync orig;
	struct CreateInstanceEnumAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_CreateInstanceEnumAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_CreateInstanceEnumAsync_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						       struct ORPCTHIS _ORPCthis /* [in]  */,
						       struct BSTR _strSuperClass /* [in]  */,
						       int32_t _lFlags /* [in]  */,
						       struct MInterfacePointer *_pCtx /* [in] [ref] */,
						       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_CreateInstanceEnumAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_CreateInstanceEnumAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strSuperClass = _strSuperClass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_CreateInstanceEnumAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_CREATEINSTANCEENUMASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_CreateInstanceEnumAsync_done, req);
	return req;
}

static void rpccli_CreateInstanceEnumAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_CreateInstanceEnumAsync_state *state = tevent_req_data(
		req, struct rpccli_CreateInstanceEnumAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_CreateInstanceEnumAsync_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct rpccli_CreateInstanceEnumAsync_state *state = tevent_req_data(
		req, struct rpccli_CreateInstanceEnumAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_CreateInstanceEnumAsync(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					struct ORPCTHIS ORPCthis /* [in]  */,
					struct BSTR strSuperClass /* [in]  */,
					int32_t lFlags /* [in]  */,
					struct MInterfacePointer *pCtx /* [in] [ref] */,
					struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					WERROR *werror)
{
	struct CreateInstanceEnumAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strSuperClass = strSuperClass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATEINSTANCEENUMASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ExecQuery_state {
	struct ExecQuery orig;
	struct ExecQuery tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ExecQuery_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ExecQuery_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 struct BSTR _strQueryLanguage /* [in]  */,
					 struct BSTR _strQuery /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [unique] */,
					 struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_ExecQuery_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ExecQuery_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ExecQuery_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_EXECQUERY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ExecQuery_done, req);
	return req;
}

static void rpccli_ExecQuery_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ExecQuery_state *state = tevent_req_data(
		req, struct rpccli_ExecQuery_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ExecQuery_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_ExecQuery_state *state = tevent_req_data(
		req, struct rpccli_ExecQuery_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ExecQuery(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strQueryLanguage /* [in]  */,
			  struct BSTR strQuery /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppEnum /* [out] [ref] */,
			  WERROR *werror)
{
	struct ExecQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECQUERY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ExecQueryAsync_state {
	struct ExecQueryAsync orig;
	struct ExecQueryAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ExecQueryAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ExecQueryAsync_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strQueryLanguage /* [in]  */,
					      struct BSTR _strQuery /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_ExecQueryAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ExecQueryAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ExecQueryAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_EXECQUERYASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ExecQueryAsync_done, req);
	return req;
}

static void rpccli_ExecQueryAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ExecQueryAsync_state *state = tevent_req_data(
		req, struct rpccli_ExecQueryAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ExecQueryAsync_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_ExecQueryAsync_state *state = tevent_req_data(
		req, struct rpccli_ExecQueryAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ExecQueryAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strQueryLanguage /* [in]  */,
			       struct BSTR strQuery /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror)
{
	struct ExecQueryAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECQUERYASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ExecNotificationQuery_state {
	struct ExecNotificationQuery orig;
	struct ExecNotificationQuery tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ExecNotificationQuery_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ExecNotificationQuery_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						     struct ORPCTHIS _ORPCthis /* [in]  */,
						     struct BSTR _strQueryLanguage /* [in]  */,
						     struct BSTR _strQuery /* [in]  */,
						     int32_t _lFlags /* [in]  */,
						     struct MInterfacePointer *_pCtx /* [in] [unique] */,
						     struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_ExecNotificationQuery_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ExecNotificationQuery_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ExecNotificationQuery_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_EXECNOTIFICATIONQUERY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ExecNotificationQuery_done, req);
	return req;
}

static void rpccli_ExecNotificationQuery_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ExecNotificationQuery_state *state = tevent_req_data(
		req, struct rpccli_ExecNotificationQuery_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ExecNotificationQuery_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct rpccli_ExecNotificationQuery_state *state = tevent_req_data(
		req, struct rpccli_ExecNotificationQuery_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ExecNotificationQuery(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS ORPCthis /* [in]  */,
				      struct BSTR strQueryLanguage /* [in]  */,
				      struct BSTR strQuery /* [in]  */,
				      int32_t lFlags /* [in]  */,
				      struct MInterfacePointer *pCtx /* [in] [unique] */,
				      struct MInterfacePointer **ppEnum /* [out] [ref] */,
				      WERROR *werror)
{
	struct ExecNotificationQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECNOTIFICATIONQUERY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ExecNotificationQueryAsync_state {
	struct ExecNotificationQueryAsync orig;
	struct ExecNotificationQueryAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ExecNotificationQueryAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ExecNotificationQueryAsync_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							  struct ORPCTHIS _ORPCthis /* [in]  */,
							  struct BSTR _strQueryLanguage /* [in]  */,
							  struct BSTR _strQuery /* [in]  */,
							  int32_t _lFlags /* [in]  */,
							  struct MInterfacePointer *_pCtx /* [in] [ref] */,
							  struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_ExecNotificationQueryAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ExecNotificationQueryAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ExecNotificationQueryAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_EXECNOTIFICATIONQUERYASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ExecNotificationQueryAsync_done, req);
	return req;
}

static void rpccli_ExecNotificationQueryAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ExecNotificationQueryAsync_state *state = tevent_req_data(
		req, struct rpccli_ExecNotificationQueryAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ExecNotificationQueryAsync_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct rpccli_ExecNotificationQueryAsync_state *state = tevent_req_data(
		req, struct rpccli_ExecNotificationQueryAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ExecNotificationQueryAsync(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct BSTR strQueryLanguage /* [in]  */,
					   struct BSTR strQuery /* [in]  */,
					   int32_t lFlags /* [in]  */,
					   struct MInterfacePointer *pCtx /* [in] [ref] */,
					   struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					   WERROR *werror)
{
	struct ExecNotificationQueryAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECNOTIFICATIONQUERYASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ExecMethod_state {
	struct ExecMethod orig;
	struct ExecMethod tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ExecMethod_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ExecMethod_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS _ORPCthis /* [in]  */,
					  struct BSTR _strObjectPath /* [in]  */,
					  struct BSTR _strMethodName /* [in]  */,
					  int32_t _lFlags /* [in]  */,
					  struct MInterfacePointer *_pCtx /* [in] [unique] */,
					  struct MInterfacePointer *_pInParams /* [in] [unique] */,
					  struct MInterfacePointer **_ppOutParams /* [in,out] [unique] */,
					  struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_ExecMethod_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ExecMethod_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.strMethodName = _strMethodName;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pInParams = _pInParams;
	state->orig.in.ppOutParams = _ppOutParams;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppOutParams = _ppOutParams;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ExecMethod_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_EXECMETHOD,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ExecMethod_done, req);
	return req;
}

static void rpccli_ExecMethod_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ExecMethod_state *state = tevent_req_data(
		req, struct rpccli_ExecMethod_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppOutParams && state->tmp.out.ppOutParams) {
		*state->orig.out.ppOutParams = *state->tmp.out.ppOutParams;
	}
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ExecMethod_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct rpccli_ExecMethod_state *state = tevent_req_data(
		req, struct rpccli_ExecMethod_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ExecMethod(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   struct BSTR strObjectPath /* [in]  */,
			   struct BSTR strMethodName /* [in]  */,
			   int32_t lFlags /* [in]  */,
			   struct MInterfacePointer *pCtx /* [in] [unique] */,
			   struct MInterfacePointer *pInParams /* [in] [unique] */,
			   struct MInterfacePointer **ppOutParams /* [in,out] [unique] */,
			   struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			   WERROR *werror)
{
	struct ExecMethod r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.strMethodName = strMethodName;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pInParams = pInParams;
	r.in.ppOutParams = ppOutParams;
	r.in.ppCallResult = ppCallResult;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECMETHOD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppOutParams && r.out.ppOutParams) {
		*ppOutParams = *r.out.ppOutParams;
	}
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ExecMethodAsync_state {
	struct ExecMethodAsync orig;
	struct ExecMethodAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ExecMethodAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ExecMethodAsync_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct BSTR _strObjectPath /* [in]  */,
					       struct BSTR _strMethodName /* [in]  */,
					       uint32_t _lFlags /* [in]  */,
					       struct MInterfacePointer *_pCtx /* [in] [ref] */,
					       struct MInterfacePointer *_pInParams /* [in] [ref] */,
					       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_ExecMethodAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ExecMethodAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.strMethodName = _strMethodName;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pInParams = _pInParams;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ExecMethodAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemServices,
				    NDR_EXECMETHODASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ExecMethodAsync_done, req);
	return req;
}

static void rpccli_ExecMethodAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ExecMethodAsync_state *state = tevent_req_data(
		req, struct rpccli_ExecMethodAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ExecMethodAsync_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct rpccli_ExecMethodAsync_state *state = tevent_req_data(
		req, struct rpccli_ExecMethodAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ExecMethodAsync(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strObjectPath /* [in]  */,
				struct BSTR strMethodName /* [in]  */,
				uint32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer *pInParams /* [in] [ref] */,
				struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				WERROR *werror)
{
	struct ExecMethodAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.strMethodName = strMethodName;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pInParams = pInParams;
	r.in.pResponseHandler = pResponseHandler;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECMETHODASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Reset_state {
	struct Reset orig;
	struct Reset tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Reset_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Reset_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct rpc_pipe_client *cli,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_Reset_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Reset_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Reset_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IEnumWbemClassObject,
				    NDR_RESET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Reset_done, req);
	return req;
}

static void rpccli_Reset_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Reset_state *state = tevent_req_data(
		req, struct rpccli_Reset_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Reset_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result)
{
	struct rpccli_Reset_state *state = tevent_req_data(
		req, struct rpccli_Reset_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Reset(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      WERROR *werror)
{
	struct Reset r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_RESET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_IEnumWbemClassObject_Next_state {
	struct IEnumWbemClassObject_Next orig;
	struct IEnumWbemClassObject_Next tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_IEnumWbemClassObject_Next_done(struct tevent_req *subreq);

struct tevent_req *rpccli_IEnumWbemClassObject_Next_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							 struct ORPCTHIS _ORPCthis /* [in]  */,
							 int32_t _lTimeout /* [in]  */,
							 uint32_t _uCount /* [in]  */,
							 struct MInterfacePointer **_apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
							 uint32_t *_puReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_IEnumWbemClassObject_Next_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_IEnumWbemClassObject_Next_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;
	state->orig.in.uCount = _uCount;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.apObjects = _apObjects;
	state->orig.out.puReturned = _puReturned;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_IEnumWbemClassObject_Next_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IEnumWbemClassObject,
				    NDR_IENUMWBEMCLASSOBJECT_NEXT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_IEnumWbemClassObject_Next_done, req);
	return req;
}

static void rpccli_IEnumWbemClassObject_Next_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_IEnumWbemClassObject_Next_state *state = tevent_req_data(
		req, struct rpccli_IEnumWbemClassObject_Next_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	memcpy(state->orig.out.apObjects, state->tmp.out.apObjects, (state->tmp.in.uCount) * sizeof(*state->orig.out.apObjects));
	*state->orig.out.puReturned = *state->tmp.out.puReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_IEnumWbemClassObject_Next_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct rpccli_IEnumWbemClassObject_Next_state *state = tevent_req_data(
		req, struct rpccli_IEnumWbemClassObject_Next_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_IEnumWbemClassObject_Next(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS ORPCthis /* [in]  */,
					  int32_t lTimeout /* [in]  */,
					  uint32_t uCount /* [in]  */,
					  struct MInterfacePointer **apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
					  uint32_t *puReturned /* [out] [ref] */,
					  WERROR *werror)
{
	struct IEnumWbemClassObject_Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;
	r.in.uCount = uCount;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_IENUMWBEMCLASSOBJECT_NEXT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	memcpy(apObjects, r.out.apObjects, (r.in.uCount) * sizeof(*apObjects));
	*puReturned = *r.out.puReturned;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_NextAsync_state {
	struct NextAsync orig;
	struct NextAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_NextAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_NextAsync_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 uint32_t _uCount /* [in]  */,
					 struct MInterfacePointer *_pSink /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_NextAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_NextAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.uCount = _uCount;
	state->orig.in.pSink = _pSink;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_NextAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IEnumWbemClassObject,
				    NDR_NEXTASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_NextAsync_done, req);
	return req;
}

static void rpccli_NextAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_NextAsync_state *state = tevent_req_data(
		req, struct rpccli_NextAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_NextAsync_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_NextAsync_state *state = tevent_req_data(
		req, struct rpccli_NextAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_NextAsync(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  uint32_t uCount /* [in]  */,
			  struct MInterfacePointer *pSink /* [in] [ref] */,
			  WERROR *werror)
{
	struct NextAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.uCount = uCount;
	r.in.pSink = pSink;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_NEXTASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_IEnumWbemClassObject_Clone_state {
	struct IEnumWbemClassObject_Clone orig;
	struct IEnumWbemClassObject_Clone tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_IEnumWbemClassObject_Clone_done(struct tevent_req *subreq);

struct tevent_req *rpccli_IEnumWbemClassObject_Clone_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							  struct ORPCTHIS _ORPCthis /* [in]  */,
							  struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_IEnumWbemClassObject_Clone_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_IEnumWbemClassObject_Clone_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_IEnumWbemClassObject_Clone_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IEnumWbemClassObject,
				    NDR_IENUMWBEMCLASSOBJECT_CLONE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_IEnumWbemClassObject_Clone_done, req);
	return req;
}

static void rpccli_IEnumWbemClassObject_Clone_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_IEnumWbemClassObject_Clone_state *state = tevent_req_data(
		req, struct rpccli_IEnumWbemClassObject_Clone_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_IEnumWbemClassObject_Clone_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct rpccli_IEnumWbemClassObject_Clone_state *state = tevent_req_data(
		req, struct rpccli_IEnumWbemClassObject_Clone_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_IEnumWbemClassObject_Clone(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct MInterfacePointer **ppEnum /* [out] [ref] */,
					   WERROR *werror)
{
	struct IEnumWbemClassObject_Clone r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_IENUMWBEMCLASSOBJECT_CLONE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Skip_state {
	struct Skip orig;
	struct Skip tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Skip_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Skip_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct rpc_pipe_client *cli,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    int32_t _lTimeout /* [in]  */,
				    uint32_t _nCount /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_Skip_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Skip_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;
	state->orig.in.nCount = _nCount;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Skip_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IEnumWbemClassObject,
				    NDR_SKIP,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Skip_done, req);
	return req;
}

static void rpccli_Skip_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Skip_state *state = tevent_req_data(
		req, struct rpccli_Skip_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Skip_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result)
{
	struct rpccli_Skip_state *state = tevent_req_data(
		req, struct rpccli_Skip_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Skip(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     int32_t lTimeout /* [in]  */,
		     uint32_t nCount /* [in]  */,
		     WERROR *werror)
{
	struct Skip r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;
	r.in.nCount = nCount;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_SKIP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Clone_state {
	struct Clone orig;
	struct Clone tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Clone_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Clone_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct rpc_pipe_client *cli,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     struct MInterfacePointer **_ppNewCopy /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_Clone_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Clone_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppNewCopy = _ppNewCopy;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Clone_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_CLONE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Clone_done, req);
	return req;
}

static void rpccli_Clone_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Clone_state *state = tevent_req_data(
		req, struct rpccli_Clone_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppNewCopy = *state->tmp.out.ppNewCopy;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Clone_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result)
{
	struct rpccli_Clone_state *state = tevent_req_data(
		req, struct rpccli_Clone_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Clone(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppNewCopy /* [out] [ref] */,
		      WERROR *werror)
{
	struct Clone r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_CLONE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppNewCopy = *r.out.ppNewCopy;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetNames_state {
	struct GetNames orig;
	struct GetNames tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetNames_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetNames_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_GetNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_GETNAMES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetNames_done, req);
	return req;
}

static void rpccli_GetNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetNames_state *state = tevent_req_data(
		req, struct rpccli_GetNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetNames_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_GetNames_state *state = tevent_req_data(
		req, struct rpccli_GetNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetNames(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror)
{
	struct GetNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_GETNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_BeginEnumeration_state {
	struct BeginEnumeration orig;
	struct BeginEnumeration tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_BeginEnumeration_done(struct tevent_req *subreq);

struct tevent_req *rpccli_BeginEnumeration_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						int32_t _lFlags /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_BeginEnumeration_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_BeginEnumeration_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lFlags = _lFlags;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_BeginEnumeration_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_BEGINENUMERATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_BeginEnumeration_done, req);
	return req;
}

static void rpccli_BeginEnumeration_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_BeginEnumeration_state *state = tevent_req_data(
		req, struct rpccli_BeginEnumeration_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_BeginEnumeration_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_BeginEnumeration_state *state = tevent_req_data(
		req, struct rpccli_BeginEnumeration_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_BeginEnumeration(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 WERROR *werror)
{
	struct BeginEnumeration r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lFlags = lFlags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_BEGINENUMERATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Next_state {
	struct Next orig;
	struct Next tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Next_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Next_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct rpc_pipe_client *cli,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_Next_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Next_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Next_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_NEXT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Next_done, req);
	return req;
}

static void rpccli_Next_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Next_state *state = tevent_req_data(
		req, struct rpccli_Next_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Next_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result)
{
	struct rpccli_Next_state *state = tevent_req_data(
		req, struct rpccli_Next_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Next(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     WERROR *werror)
{
	struct Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_NEXT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EndEnumeration_state {
	struct EndEnumeration orig;
	struct EndEnumeration tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EndEnumeration_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EndEnumeration_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_EndEnumeration_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EndEnumeration_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_EndEnumeration_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_ENDENUMERATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EndEnumeration_done, req);
	return req;
}

static void rpccli_EndEnumeration_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EndEnumeration_state *state = tevent_req_data(
		req, struct rpccli_EndEnumeration_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EndEnumeration_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_EndEnumeration_state *state = tevent_req_data(
		req, struct rpccli_EndEnumeration_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EndEnumeration(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       WERROR *werror)
{
	struct EndEnumeration r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_ENDENUMERATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_SetValue_state {
	struct SetValue orig;
	struct SetValue tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_SetValue_done(struct tevent_req *subreq);

struct tevent_req *rpccli_SetValue_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_SetValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_SetValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_SetValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_SETVALUE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_SetValue_done, req);
	return req;
}

static void rpccli_SetValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_SetValue_state *state = tevent_req_data(
		req, struct rpccli_SetValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_SetValue_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_SetValue_state *state = tevent_req_data(
		req, struct rpccli_SetValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_SetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror)
{
	struct SetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_SETVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetValue_state {
	struct GetValue orig;
	struct GetValue tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetValue_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetValue_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_GetValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_GETVALUE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetValue_done, req);
	return req;
}

static void rpccli_GetValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetValue_state *state = tevent_req_data(
		req, struct rpccli_GetValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetValue_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_GetValue_state *state = tevent_req_data(
		req, struct rpccli_GetValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror)
{
	struct GetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_GETVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_DeleteValue_state {
	struct DeleteValue orig;
	struct DeleteValue tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_DeleteValue_done(struct tevent_req *subreq);

struct tevent_req *rpccli_DeleteValue_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_DeleteValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_DeleteValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_DeleteValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_DELETEVALUE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_DeleteValue_done, req);
	return req;
}

static void rpccli_DeleteValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_DeleteValue_state *state = tevent_req_data(
		req, struct rpccli_DeleteValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_DeleteValue_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct rpccli_DeleteValue_state *state = tevent_req_data(
		req, struct rpccli_DeleteValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_DeleteValue(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    WERROR *werror)
{
	struct DeleteValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_DELETEVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_DeleteAll_state {
	struct DeleteAll orig;
	struct DeleteAll tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_DeleteAll_done(struct tevent_req *subreq);

struct tevent_req *rpccli_DeleteAll_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_DeleteAll_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_DeleteAll_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_DeleteAll_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemContext,
				    NDR_DELETEALL,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_DeleteAll_done, req);
	return req;
}

static void rpccli_DeleteAll_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_DeleteAll_state *state = tevent_req_data(
		req, struct rpccli_DeleteAll_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_DeleteAll_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_DeleteAll_state *state = tevent_req_data(
		req, struct rpccli_DeleteAll_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_DeleteAll(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  WERROR *werror)
{
	struct DeleteAll r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_DELETEALL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EstablishPosition_state {
	struct EstablishPosition orig;
	struct EstablishPosition tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EstablishPosition_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EstablishPosition_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						 struct ORPCTHIS _ORPCthis /* [in]  */,
						 const char *_wszLocaleList /* [in] [unique,charset(UTF16)] */,
						 uint32_t _dwNumLocales /* [in]  */,
						 uint32_t *_reserved /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_EstablishPosition_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EstablishPosition_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszLocaleList = _wszLocaleList;
	state->orig.in.dwNumLocales = _dwNumLocales;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.reserved = _reserved;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_EstablishPosition_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemLevel1Login,
				    NDR_ESTABLISHPOSITION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EstablishPosition_done, req);
	return req;
}

static void rpccli_EstablishPosition_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EstablishPosition_state *state = tevent_req_data(
		req, struct rpccli_EstablishPosition_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.reserved = *state->tmp.out.reserved;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EstablishPosition_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_EstablishPosition_state *state = tevent_req_data(
		req, struct rpccli_EstablishPosition_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EstablishPosition(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  const char *wszLocaleList /* [in] [unique,charset(UTF16)] */,
				  uint32_t dwNumLocales /* [in]  */,
				  uint32_t *reserved /* [out] [ref] */,
				  WERROR *werror)
{
	struct EstablishPosition r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszLocaleList = wszLocaleList;
	r.in.dwNumLocales = dwNumLocales;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_ESTABLISHPOSITION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*reserved = *r.out.reserved;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_RequestChallenge_state {
	struct RequestChallenge orig;
	struct RequestChallenge tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_RequestChallenge_done(struct tevent_req *subreq);

struct tevent_req *rpccli_RequestChallenge_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						const char *_wszNetworkResource /* [in] [unique,charset(UTF16)] */,
						const char *_wszUser /* [in] [unique,charset(UTF16)] */,
						uint8_t *_Nonce /* [out] [ref,length_is(16),size_is(16)] */)
{
	struct tevent_req *req;
	struct rpccli_RequestChallenge_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_RequestChallenge_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszNetworkResource = _wszNetworkResource;
	state->orig.in.wszUser = _wszUser;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.Nonce = _Nonce;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_RequestChallenge_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemLevel1Login,
				    NDR_REQUESTCHALLENGE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_RequestChallenge_done, req);
	return req;
}

static void rpccli_RequestChallenge_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_RequestChallenge_state *state = tevent_req_data(
		req, struct rpccli_RequestChallenge_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	memcpy(state->orig.out.Nonce, state->tmp.out.Nonce, (16) * sizeof(*state->orig.out.Nonce));

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_RequestChallenge_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_RequestChallenge_state *state = tevent_req_data(
		req, struct rpccli_RequestChallenge_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_RequestChallenge(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
				 const char *wszUser /* [in] [unique,charset(UTF16)] */,
				 uint8_t *Nonce /* [out] [ref,length_is(16),size_is(16)] */,
				 WERROR *werror)
{
	struct RequestChallenge r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszNetworkResource = wszNetworkResource;
	r.in.wszUser = wszUser;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_REQUESTCHALLENGE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	memcpy(Nonce, r.out.Nonce, (16) * sizeof(*Nonce));

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_WBEMLogin_state {
	struct WBEMLogin orig;
	struct WBEMLogin tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_WBEMLogin_done(struct tevent_req *subreq);

struct tevent_req *rpccli_WBEMLogin_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 const char *_wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
					 uint8_t *_AccessToken /* [in] [unique,length_is(16),size_is(16)] */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [ref] */,
					 struct MInterfacePointer **_ppNamespace /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_WBEMLogin_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_WBEMLogin_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszPreferredLocale = _wszPreferredLocale;
	state->orig.in.AccessToken = _AccessToken;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppNamespace = _ppNamespace;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_WBEMLogin_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemLevel1Login,
				    NDR_WBEMLOGIN,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_WBEMLogin_done, req);
	return req;
}

static void rpccli_WBEMLogin_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_WBEMLogin_state *state = tevent_req_data(
		req, struct rpccli_WBEMLogin_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppNamespace = *state->tmp.out.ppNamespace;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_WBEMLogin_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_WBEMLogin_state *state = tevent_req_data(
		req, struct rpccli_WBEMLogin_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_WBEMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  uint8_t *AccessToken /* [in] [unique,length_is(16),size_is(16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror)
{
	struct WBEMLogin r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszPreferredLocale = wszPreferredLocale;
	r.in.AccessToken = AccessToken;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_WBEMLOGIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppNamespace = *r.out.ppNamespace;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_NTLMLogin_state {
	struct NTLMLogin orig;
	struct NTLMLogin tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_NTLMLogin_done(struct tevent_req *subreq);

struct tevent_req *rpccli_NTLMLogin_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 const char *_wszNetworkResource /* [in] [unique,charset(UTF16)] */,
					 const char *_wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [unique] */,
					 struct MInterfacePointer **_ppNamespace /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_NTLMLogin_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_NTLMLogin_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszNetworkResource = _wszNetworkResource;
	state->orig.in.wszPreferredLocale = _wszPreferredLocale;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppNamespace = _ppNamespace;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_NTLMLogin_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemLevel1Login,
				    NDR_NTLMLOGIN,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_NTLMLogin_done, req);
	return req;
}

static void rpccli_NTLMLogin_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_NTLMLogin_state *state = tevent_req_data(
		req, struct rpccli_NTLMLogin_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppNamespace = *state->tmp.out.ppNamespace;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_NTLMLogin_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_NTLMLogin_state *state = tevent_req_data(
		req, struct rpccli_NTLMLogin_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_NTLMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror)
{
	struct NTLMLogin r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszNetworkResource = wszNetworkResource;
	r.in.wszPreferredLocale = wszPreferredLocale;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_NTLMLOGIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppNamespace = *r.out.ppNamespace;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_IWbemWCOSmartEnum_Next_state {
	struct IWbemWCOSmartEnum_Next orig;
	struct IWbemWCOSmartEnum_Next tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_IWbemWCOSmartEnum_Next_done(struct tevent_req *subreq);

struct tevent_req *rpccli_IWbemWCOSmartEnum_Next_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						      struct ORPCTHIS _ORPCthis /* [in]  */,
						      struct GUID *_gEWCO /* [in] [ref] */,
						      uint32_t _lTimeOut /* [in]  */,
						      uint32_t _uCount /* [in]  */,
						      uint32_t _unknown /* [in]  */,
						      struct GUID *_gWCO /* [in] [ref] */,
						      uint32_t *_puReturned /* [out] [ref] */,
						      uint32_t *_pSize /* [out] [ref] */,
						      uint8_t **_pData /* [out] [noprint,ref,size_is(,*pSize)] */)
{
	struct tevent_req *req;
	struct rpccli_IWbemWCOSmartEnum_Next_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_IWbemWCOSmartEnum_Next_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.gEWCO = _gEWCO;
	state->orig.in.lTimeOut = _lTimeOut;
	state->orig.in.uCount = _uCount;
	state->orig.in.unknown = _unknown;
	state->orig.in.gWCO = _gWCO;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.puReturned = _puReturned;
	state->orig.out.pSize = _pSize;
	state->orig.out.pData = _pData;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_IWbemWCOSmartEnum_Next_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemWCOSmartEnum,
				    NDR_IWBEMWCOSMARTENUM_NEXT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_IWbemWCOSmartEnum_Next_done, req);
	return req;
}

static void rpccli_IWbemWCOSmartEnum_Next_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_IWbemWCOSmartEnum_Next_state *state = tevent_req_data(
		req, struct rpccli_IWbemWCOSmartEnum_Next_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.puReturned = *state->tmp.out.puReturned;
	*state->orig.out.pSize = *state->tmp.out.pSize;
	*state->orig.out.pData = *state->tmp.out.pData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_IWbemWCOSmartEnum_Next_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct rpccli_IWbemWCOSmartEnum_Next_state *state = tevent_req_data(
		req, struct rpccli_IWbemWCOSmartEnum_Next_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_IWbemWCOSmartEnum_Next(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				       struct ORPCTHIS ORPCthis /* [in]  */,
				       struct GUID *gEWCO /* [in] [ref] */,
				       uint32_t lTimeOut /* [in]  */,
				       uint32_t uCount /* [in]  */,
				       uint32_t unknown /* [in]  */,
				       struct GUID *gWCO /* [in] [ref] */,
				       uint32_t *puReturned /* [out] [ref] */,
				       uint32_t *pSize /* [out] [ref] */,
				       uint8_t **pData /* [out] [noprint,ref,size_is(,*pSize)] */,
				       WERROR *werror)
{
	struct IWbemWCOSmartEnum_Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.gEWCO = gEWCO;
	r.in.lTimeOut = lTimeOut;
	r.in.uCount = uCount;
	r.in.unknown = unknown;
	r.in.gWCO = gWCO;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemWCOSmartEnum,
				NDR_IWBEMWCOSMARTENUM_NEXT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*puReturned = *r.out.puReturned;
	*pSize = *r.out.pSize;
	*pData = *r.out.pData;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Fetch_state {
	struct Fetch orig;
	struct Fetch tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Fetch_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Fetch_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct rpc_pipe_client *cli,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_Fetch_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Fetch_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Fetch_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemFetchSmartEnum,
				    NDR_FETCH,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Fetch_done, req);
	return req;
}

static void rpccli_Fetch_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Fetch_state *state = tevent_req_data(
		req, struct rpccli_Fetch_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Fetch_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result)
{
	struct rpccli_Fetch_state *state = tevent_req_data(
		req, struct rpccli_Fetch_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Fetch(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppEnum /* [out] [ref] */,
		      WERROR *werror)
{
	struct Fetch r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemFetchSmartEnum,
				NDR_FETCH,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Test_state {
	struct Test orig;
	struct Test tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Test_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Test_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct rpc_pipe_client *cli,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_Test_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Test_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Test_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemFetchSmartEnum,
				    NDR_TEST,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Test_done, req);
	return req;
}

static void rpccli_Test_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Test_state *state = tevent_req_data(
		req, struct rpccli_Test_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Test_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result)
{
	struct rpccli_Test_state *state = tevent_req_data(
		req, struct rpccli_Test_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Test(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     struct MInterfacePointer **ppEnum /* [out] [ref] */,
		     WERROR *werror)
{
	struct Test r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemFetchSmartEnum,
				NDR_TEST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetResultObject_state {
	struct GetResultObject orig;
	struct GetResultObject tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetResultObject_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetResultObject_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lTimeout /* [in]  */,
					       struct MInterfacePointer **_ppResultObject /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_GetResultObject_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetResultObject_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppResultObject = _ppResultObject;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetResultObject_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemCallResult,
				    NDR_GETRESULTOBJECT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetResultObject_done, req);
	return req;
}

static void rpccli_GetResultObject_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetResultObject_state *state = tevent_req_data(
		req, struct rpccli_GetResultObject_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppResultObject = *state->tmp.out.ppResultObject;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetResultObject_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct rpccli_GetResultObject_state *state = tevent_req_data(
		req, struct rpccli_GetResultObject_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetResultObject(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct MInterfacePointer **ppResultObject /* [out] [ref] */,
				WERROR *werror)
{
	struct GetResultObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETRESULTOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppResultObject = *r.out.ppResultObject;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetResultString_state {
	struct GetResultString orig;
	struct GetResultString tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetResultString_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetResultString_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lTimeout /* [in]  */,
					       struct BSTR *_pstrResultString /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_GetResultString_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetResultString_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.pstrResultString = _pstrResultString;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetResultString_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemCallResult,
				    NDR_GETRESULTSTRING,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetResultString_done, req);
	return req;
}

static void rpccli_GetResultString_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetResultString_state *state = tevent_req_data(
		req, struct rpccli_GetResultString_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.pstrResultString = *state->tmp.out.pstrResultString;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetResultString_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct rpccli_GetResultString_state *state = tevent_req_data(
		req, struct rpccli_GetResultString_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetResultString(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct BSTR *pstrResultString /* [out] [ref] */,
				WERROR *werror)
{
	struct GetResultString r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETRESULTSTRING,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*pstrResultString = *r.out.pstrResultString;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetResultServices_state {
	struct GetResultServices orig;
	struct GetResultServices tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetResultServices_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetResultServices_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						 struct ORPCTHIS _ORPCthis /* [in]  */,
						 int32_t _lTimeout /* [in]  */,
						 struct MInterfacePointer **_ppServices /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_GetResultServices_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetResultServices_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppServices = _ppServices;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetResultServices_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemCallResult,
				    NDR_GETRESULTSERVICES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetResultServices_done, req);
	return req;
}

static void rpccli_GetResultServices_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetResultServices_state *state = tevent_req_data(
		req, struct rpccli_GetResultServices_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppServices = *state->tmp.out.ppServices;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetResultServices_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_GetResultServices_state *state = tevent_req_data(
		req, struct rpccli_GetResultServices_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetResultServices(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  int32_t lTimeout /* [in]  */,
				  struct MInterfacePointer **ppServices /* [out] [ref] */,
				  WERROR *werror)
{
	struct GetResultServices r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETRESULTSERVICES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppServices = *r.out.ppServices;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetCallStatus_state {
	struct GetCallStatus orig;
	struct GetCallStatus tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetCallStatus_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetCallStatus_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     int32_t _lTimeout /* [in]  */,
					     int32_t *_plStatus /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_GetCallStatus_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetCallStatus_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.plStatus = _plStatus;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetCallStatus_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemCallResult,
				    NDR_GETCALLSTATUS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetCallStatus_done, req);
	return req;
}

static void rpccli_GetCallStatus_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetCallStatus_state *state = tevent_req_data(
		req, struct rpccli_GetCallStatus_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.plStatus = *state->tmp.out.plStatus;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetCallStatus_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct rpccli_GetCallStatus_state *state = tevent_req_data(
		req, struct rpccli_GetCallStatus_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetCallStatus(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      int32_t lTimeout /* [in]  */,
			      int32_t *plStatus /* [out] [ref] */,
			      WERROR *werror)
{
	struct GetCallStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETCALLSTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*plStatus = *r.out.plStatus;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_SetStatus_state {
	struct SetStatus orig;
	struct SetStatus tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_SetStatus_done(struct tevent_req *subreq);

struct tevent_req *rpccli_SetStatus_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 WERROR _hResult /* [in]  */,
					 struct BSTR _strParam /* [in]  */,
					 struct MInterfacePointer *_pObjParam /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_SetStatus_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_SetStatus_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.hResult = _hResult;
	state->orig.in.strParam = _strParam;
	state->orig.in.pObjParam = _pObjParam;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_SetStatus_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemObjectSink,
				    NDR_SETSTATUS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_SetStatus_done, req);
	return req;
}

static void rpccli_SetStatus_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_SetStatus_state *state = tevent_req_data(
		req, struct rpccli_SetStatus_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_SetStatus_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_SetStatus_state *state = tevent_req_data(
		req, struct rpccli_SetStatus_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_SetStatus(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  WERROR hResult /* [in]  */,
			  struct BSTR strParam /* [in]  */,
			  struct MInterfacePointer *pObjParam /* [in] [ref] */,
			  WERROR *werror)
{
	struct SetStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lFlags = lFlags;
	r.in.hResult = hResult;
	r.in.strParam = strParam;
	r.in.pObjParam = pObjParam;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemObjectSink,
				NDR_SETSTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Indicate_state {
	struct Indicate orig;
	struct Indicate tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Indicate_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Indicate_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */,
					int32_t _lObjectCount /* [in]  */,
					struct MInterfacePointer **_apObjArray /* [in] [ref,size_is(lObjectCount)] */)
{
	struct tevent_req *req;
	struct rpccli_Indicate_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Indicate_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lObjectCount = _lObjectCount;
	state->orig.in.apObjArray = _apObjArray;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Indicate_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IWbemObjectSink,
				    NDR_INDICATE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Indicate_done, req);
	return req;
}

static void rpccli_Indicate_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Indicate_state *state = tevent_req_data(
		req, struct rpccli_Indicate_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Indicate_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_Indicate_state *state = tevent_req_data(
		req, struct rpccli_Indicate_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Indicate(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 int32_t lObjectCount /* [in]  */,
			 struct MInterfacePointer **apObjArray /* [in] [ref,size_is(lObjectCount)] */,
			 WERROR *werror)
{
	struct Indicate r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lObjectCount = lObjectCount;
	r.in.apObjArray = apObjArray;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemObjectSink,
				NDR_INDICATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

