/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_frstrans.h"

struct rpccli_frstrans_CheckConnectivity_state {
	struct frstrans_CheckConnectivity orig;
	struct frstrans_CheckConnectivity tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frstrans_CheckConnectivity_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frstrans_CheckConnectivity_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct GUID _replica_set_guid /* [in]  */,
							  struct GUID _connection_guid /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_frstrans_CheckConnectivity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frstrans_CheckConnectivity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.replica_set_guid = _replica_set_guid;
	state->orig.in.connection_guid = _connection_guid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_CHECKCONNECTIVITY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frstrans_CheckConnectivity_done, req);
	return req;
}

static void rpccli_frstrans_CheckConnectivity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frstrans_CheckConnectivity_state *state = tevent_req_data(
		req, struct rpccli_frstrans_CheckConnectivity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frstrans_CheckConnectivity_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct rpccli_frstrans_CheckConnectivity_state *state = tevent_req_data(
		req, struct rpccli_frstrans_CheckConnectivity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frstrans_CheckConnectivity(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct GUID replica_set_guid /* [in]  */,
					   struct GUID connection_guid /* [in]  */,
					   WERROR *werror)
{
	struct frstrans_CheckConnectivity r;
	NTSTATUS status;

	/* In parameters */
	r.in.replica_set_guid = replica_set_guid;
	r.in.connection_guid = connection_guid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_CHECKCONNECTIVITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frstrans_EstablishConnection_state {
	struct frstrans_EstablishConnection orig;
	struct frstrans_EstablishConnection tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frstrans_EstablishConnection_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frstrans_EstablishConnection_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    struct GUID _replica_set_guid /* [in]  */,
							    struct GUID _connection_guid /* [in]  */,
							    enum frstrans_ProtocolVersion _downstream_protocol_version /* [in]  */,
							    uint32_t _downstream_flags /* [in]  */,
							    enum frstrans_ProtocolVersion *_upstream_protocol_version /* [out] [ref] */,
							    uint32_t *_upstream_flags /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_frstrans_EstablishConnection_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frstrans_EstablishConnection_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.replica_set_guid = _replica_set_guid;
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.downstream_protocol_version = _downstream_protocol_version;
	state->orig.in.downstream_flags = _downstream_flags;

	/* Out parameters */
	state->orig.out.upstream_protocol_version = _upstream_protocol_version;
	state->orig.out.upstream_flags = _upstream_flags;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_frstrans_EstablishConnection_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_ESTABLISHCONNECTION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frstrans_EstablishConnection_done, req);
	return req;
}

static void rpccli_frstrans_EstablishConnection_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frstrans_EstablishConnection_state *state = tevent_req_data(
		req, struct rpccli_frstrans_EstablishConnection_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.upstream_protocol_version = *state->tmp.out.upstream_protocol_version;
	*state->orig.out.upstream_flags = *state->tmp.out.upstream_flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frstrans_EstablishConnection_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct rpccli_frstrans_EstablishConnection_state *state = tevent_req_data(
		req, struct rpccli_frstrans_EstablishConnection_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frstrans_EstablishConnection(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct GUID replica_set_guid /* [in]  */,
					     struct GUID connection_guid /* [in]  */,
					     enum frstrans_ProtocolVersion downstream_protocol_version /* [in]  */,
					     uint32_t downstream_flags /* [in]  */,
					     enum frstrans_ProtocolVersion *upstream_protocol_version /* [out] [ref] */,
					     uint32_t *upstream_flags /* [out] [ref] */,
					     WERROR *werror)
{
	struct frstrans_EstablishConnection r;
	NTSTATUS status;

	/* In parameters */
	r.in.replica_set_guid = replica_set_guid;
	r.in.connection_guid = connection_guid;
	r.in.downstream_protocol_version = downstream_protocol_version;
	r.in.downstream_flags = downstream_flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_ESTABLISHCONNECTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*upstream_protocol_version = *r.out.upstream_protocol_version;
	*upstream_flags = *r.out.upstream_flags;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frstrans_EstablishSession_state {
	struct frstrans_EstablishSession orig;
	struct frstrans_EstablishSession tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frstrans_EstablishSession_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frstrans_EstablishSession_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct GUID _connection_guid /* [in]  */,
							 struct GUID _content_set_guid /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_frstrans_EstablishSession_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frstrans_EstablishSession_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.content_set_guid = _content_set_guid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_ESTABLISHSESSION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frstrans_EstablishSession_done, req);
	return req;
}

static void rpccli_frstrans_EstablishSession_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frstrans_EstablishSession_state *state = tevent_req_data(
		req, struct rpccli_frstrans_EstablishSession_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frstrans_EstablishSession_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct rpccli_frstrans_EstablishSession_state *state = tevent_req_data(
		req, struct rpccli_frstrans_EstablishSession_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frstrans_EstablishSession(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct GUID connection_guid /* [in]  */,
					  struct GUID content_set_guid /* [in]  */,
					  WERROR *werror)
{
	struct frstrans_EstablishSession r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = connection_guid;
	r.in.content_set_guid = content_set_guid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_ESTABLISHSESSION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frstrans_RequestUpdates_state {
	struct frstrans_RequestUpdates orig;
	struct frstrans_RequestUpdates tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frstrans_RequestUpdates_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frstrans_RequestUpdates_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct GUID _connection_guid /* [in]  */,
						       struct GUID _content_set_guid /* [in]  */,
						       uint32_t _credits_available /* [in] [range(0,256)] */,
						       uint32_t _hash_requested /* [in] [range(0,1)] */,
						       enum frstrans_UpdateRequestType _update_request_type /* [in] [range(0,2)] */,
						       uint32_t _version_vector_diff_count /* [in]  */,
						       struct frstrans_VersionVector *_version_vector_diff /* [in] [ref,size_is(version_vector_diff_count)] */,
						       struct frstrans_Update *_frs_update /* [out] [ref,length_is(*update_count),size_is(credits_available)] */,
						       uint32_t *_update_count /* [out] [ref] */,
						       enum frstrans_UpdateStatus *_update_status /* [out] [ref] */,
						       struct GUID *_gvsn_db_guid /* [out] [ref] */,
						       uint64_t *_gvsn_version /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_frstrans_RequestUpdates_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frstrans_RequestUpdates_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.content_set_guid = _content_set_guid;
	state->orig.in.credits_available = _credits_available;
	state->orig.in.hash_requested = _hash_requested;
	state->orig.in.update_request_type = _update_request_type;
	state->orig.in.version_vector_diff_count = _version_vector_diff_count;
	state->orig.in.version_vector_diff = _version_vector_diff;

	/* Out parameters */
	state->orig.out.frs_update = _frs_update;
	state->orig.out.update_count = _update_count;
	state->orig.out.update_status = _update_status;
	state->orig.out.gvsn_db_guid = _gvsn_db_guid;
	state->orig.out.gvsn_version = _gvsn_version;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_frstrans_RequestUpdates_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_REQUESTUPDATES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frstrans_RequestUpdates_done, req);
	return req;
}

static void rpccli_frstrans_RequestUpdates_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frstrans_RequestUpdates_state *state = tevent_req_data(
		req, struct rpccli_frstrans_RequestUpdates_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	memcpy(state->orig.out.frs_update, state->tmp.out.frs_update, (state->tmp.in.credits_available) * sizeof(*state->orig.out.frs_update));
	*state->orig.out.update_count = *state->tmp.out.update_count;
	*state->orig.out.update_status = *state->tmp.out.update_status;
	*state->orig.out.gvsn_db_guid = *state->tmp.out.gvsn_db_guid;
	*state->orig.out.gvsn_version = *state->tmp.out.gvsn_version;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frstrans_RequestUpdates_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct rpccli_frstrans_RequestUpdates_state *state = tevent_req_data(
		req, struct rpccli_frstrans_RequestUpdates_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frstrans_RequestUpdates(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct GUID connection_guid /* [in]  */,
					struct GUID content_set_guid /* [in]  */,
					uint32_t credits_available /* [in] [range(0,256)] */,
					uint32_t hash_requested /* [in] [range(0,1)] */,
					enum frstrans_UpdateRequestType update_request_type /* [in] [range(0,2)] */,
					uint32_t version_vector_diff_count /* [in]  */,
					struct frstrans_VersionVector *version_vector_diff /* [in] [ref,size_is(version_vector_diff_count)] */,
					struct frstrans_Update *frs_update /* [out] [ref,length_is(*update_count),size_is(credits_available)] */,
					uint32_t *update_count /* [out] [ref] */,
					enum frstrans_UpdateStatus *update_status /* [out] [ref] */,
					struct GUID *gvsn_db_guid /* [out] [ref] */,
					uint64_t *gvsn_version /* [out] [ref] */,
					WERROR *werror)
{
	struct frstrans_RequestUpdates r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = connection_guid;
	r.in.content_set_guid = content_set_guid;
	r.in.credits_available = credits_available;
	r.in.hash_requested = hash_requested;
	r.in.update_request_type = update_request_type;
	r.in.version_vector_diff_count = version_vector_diff_count;
	r.in.version_vector_diff = version_vector_diff;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_REQUESTUPDATES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(frs_update, r.out.frs_update, (r.in.credits_available) * sizeof(*frs_update));
	*update_count = *r.out.update_count;
	*update_status = *r.out.update_status;
	*gvsn_db_guid = *r.out.gvsn_db_guid;
	*gvsn_version = *r.out.gvsn_version;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frstrans_RequestVersionVector_state {
	struct frstrans_RequestVersionVector orig;
	struct frstrans_RequestVersionVector tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frstrans_RequestVersionVector_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frstrans_RequestVersionVector_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     uint32_t _sequence_number /* [in]  */,
							     struct GUID _connection_guid /* [in]  */,
							     struct GUID _content_set_guid /* [in]  */,
							     enum frstrans_VersionRequestType _request_type /* [in] [range(0,2)] */,
							     enum frstrans_VersionChangeType _change_type /* [in] [range(0,2)] */,
							     uint64_t _vv_generation /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_frstrans_RequestVersionVector_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frstrans_RequestVersionVector_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sequence_number = _sequence_number;
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.content_set_guid = _content_set_guid;
	state->orig.in.request_type = _request_type;
	state->orig.in.change_type = _change_type;
	state->orig.in.vv_generation = _vv_generation;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_REQUESTVERSIONVECTOR,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frstrans_RequestVersionVector_done, req);
	return req;
}

static void rpccli_frstrans_RequestVersionVector_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frstrans_RequestVersionVector_state *state = tevent_req_data(
		req, struct rpccli_frstrans_RequestVersionVector_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frstrans_RequestVersionVector_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct rpccli_frstrans_RequestVersionVector_state *state = tevent_req_data(
		req, struct rpccli_frstrans_RequestVersionVector_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frstrans_RequestVersionVector(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      uint32_t sequence_number /* [in]  */,
					      struct GUID connection_guid /* [in]  */,
					      struct GUID content_set_guid /* [in]  */,
					      enum frstrans_VersionRequestType request_type /* [in] [range(0,2)] */,
					      enum frstrans_VersionChangeType change_type /* [in] [range(0,2)] */,
					      uint64_t vv_generation /* [in]  */,
					      WERROR *werror)
{
	struct frstrans_RequestVersionVector r;
	NTSTATUS status;

	/* In parameters */
	r.in.sequence_number = sequence_number;
	r.in.connection_guid = connection_guid;
	r.in.content_set_guid = content_set_guid;
	r.in.request_type = request_type;
	r.in.change_type = change_type;
	r.in.vv_generation = vv_generation;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_REQUESTVERSIONVECTOR,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frstrans_AsyncPoll_state {
	struct frstrans_AsyncPoll orig;
	struct frstrans_AsyncPoll tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frstrans_AsyncPoll_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frstrans_AsyncPoll_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct GUID _connection_guid /* [in]  */,
						  struct frstrans_AsyncResponseContext *_response /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_frstrans_AsyncPoll_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frstrans_AsyncPoll_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;

	/* Out parameters */
	state->orig.out.response = _response;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_frstrans_AsyncPoll_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_ASYNCPOLL,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frstrans_AsyncPoll_done, req);
	return req;
}

static void rpccli_frstrans_AsyncPoll_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frstrans_AsyncPoll_state *state = tevent_req_data(
		req, struct rpccli_frstrans_AsyncPoll_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.response = *state->tmp.out.response;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frstrans_AsyncPoll_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_frstrans_AsyncPoll_state *state = tevent_req_data(
		req, struct rpccli_frstrans_AsyncPoll_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frstrans_AsyncPoll(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct GUID connection_guid /* [in]  */,
				   struct frstrans_AsyncResponseContext *response /* [out] [ref] */,
				   WERROR *werror)
{
	struct frstrans_AsyncPoll r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = connection_guid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_ASYNCPOLL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*response = *r.out.response;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_FRSTRANS_REQUEST_RECORDS_state {
	struct FRSTRANS_REQUEST_RECORDS orig;
	struct FRSTRANS_REQUEST_RECORDS tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_REQUEST_RECORDS_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_REQUEST_RECORDS_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_REQUEST_RECORDS_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_REQUEST_RECORDS_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_REQUEST_RECORDS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_REQUEST_RECORDS_done, req);
	return req;
}

static void rpccli_FRSTRANS_REQUEST_RECORDS_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_REQUEST_RECORDS_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_REQUEST_RECORDS_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_REQUEST_RECORDS_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_REQUEST_RECORDS_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_REQUEST_RECORDS_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_REQUEST_RECORDS(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_REQUEST_RECORDS r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_REQUEST_RECORDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_UPDATE_CANCEL_state {
	struct FRSTRANS_UPDATE_CANCEL orig;
	struct FRSTRANS_UPDATE_CANCEL tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_UPDATE_CANCEL_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_UPDATE_CANCEL_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_UPDATE_CANCEL_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_UPDATE_CANCEL_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_UPDATE_CANCEL,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_UPDATE_CANCEL_done, req);
	return req;
}

static void rpccli_FRSTRANS_UPDATE_CANCEL_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_UPDATE_CANCEL_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_UPDATE_CANCEL_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_UPDATE_CANCEL_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_UPDATE_CANCEL_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_UPDATE_CANCEL_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_UPDATE_CANCEL(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_UPDATE_CANCEL r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_UPDATE_CANCEL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_state {
	struct FRSTRANS_RAW_GET_FILE_DATA orig;
	struct FRSTRANS_RAW_GET_FILE_DATA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_RAW_GET_FILE_DATA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_RAW_GET_FILE_DATA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_RAW_GET_FILE_DATA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_RAW_GET_FILE_DATA_done, req);
	return req;
}

static void rpccli_FRSTRANS_RAW_GET_FILE_DATA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_RAW_GET_FILE_DATA r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_RAW_GET_FILE_DATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_RDC_GET_SIGNATURES_state {
	struct FRSTRANS_RDC_GET_SIGNATURES orig;
	struct FRSTRANS_RDC_GET_SIGNATURES tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_RDC_GET_SIGNATURES_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_RDC_GET_SIGNATURES_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_RDC_GET_SIGNATURES_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_RDC_GET_SIGNATURES_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_RDC_GET_SIGNATURES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_RDC_GET_SIGNATURES_done, req);
	return req;
}

static void rpccli_FRSTRANS_RDC_GET_SIGNATURES_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_RDC_GET_SIGNATURES_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_GET_SIGNATURES_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_RDC_GET_SIGNATURES_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_RDC_GET_SIGNATURES_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_GET_SIGNATURES_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_RDC_GET_SIGNATURES(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_RDC_GET_SIGNATURES r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_RDC_GET_SIGNATURES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_state {
	struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS orig;
	struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_RDC_PUSH_SOURCE_NEEDS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_done, req);
	return req;
}

static void rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_RDC_PUSH_SOURCE_NEEDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_state {
	struct FRSTRANS_RDC_GET_FILE_DATA orig;
	struct FRSTRANS_RDC_GET_FILE_DATA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_RDC_GET_FILE_DATA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_RDC_GET_FILE_DATA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_RDC_GET_FILE_DATA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_RDC_GET_FILE_DATA_done, req);
	return req;
}

static void rpccli_FRSTRANS_RDC_GET_FILE_DATA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_RDC_GET_FILE_DATA r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_RDC_GET_FILE_DATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_RDC_CLOSE_state {
	struct FRSTRANS_RDC_CLOSE orig;
	struct FRSTRANS_RDC_CLOSE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_RDC_CLOSE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_RDC_CLOSE_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_RDC_CLOSE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_RDC_CLOSE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_RDC_CLOSE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_RDC_CLOSE_done, req);
	return req;
}

static void rpccli_FRSTRANS_RDC_CLOSE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_RDC_CLOSE_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_CLOSE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_RDC_CLOSE_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_RDC_CLOSE_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_CLOSE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_RDC_CLOSE(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_RDC_CLOSE r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_RDC_CLOSE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_frstrans_InitializeFileTransferAsync_state {
	struct frstrans_InitializeFileTransferAsync orig;
	struct frstrans_InitializeFileTransferAsync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frstrans_InitializeFileTransferAsync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frstrans_InitializeFileTransferAsync_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct rpc_pipe_client *cli,
								    struct GUID _connection_guid /* [in]  */,
								    struct frstrans_Update *_frs_update /* [in,out] [ref] */,
								    uint32_t _rdc_desired /* [in] [range(0,1)] */,
								    enum frstrans_RequestedStagingPolicy *_staging_policy /* [in,out] [ref] */,
								    struct policy_handle *_server_context /* [out] [ref] */,
								    struct frstrans_RdcFileInfo **_rdc_file_info /* [out] [ref] */,
								    uint8_t *_data_buffer /* [out] [ref,length_is(*size_read),size_is(buffer_size)] */,
								    uint32_t _buffer_size /* [in] [range(0,262144)] */,
								    uint32_t *_size_read /* [out] [ref] */,
								    uint32_t *_is_end_of_file /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_frstrans_InitializeFileTransferAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frstrans_InitializeFileTransferAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.frs_update = _frs_update;
	state->orig.in.rdc_desired = _rdc_desired;
	state->orig.in.staging_policy = _staging_policy;
	state->orig.in.buffer_size = _buffer_size;

	/* Out parameters */
	state->orig.out.frs_update = _frs_update;
	state->orig.out.staging_policy = _staging_policy;
	state->orig.out.server_context = _server_context;
	state->orig.out.rdc_file_info = _rdc_file_info;
	state->orig.out.data_buffer = _data_buffer;
	state->orig.out.size_read = _size_read;
	state->orig.out.is_end_of_file = _is_end_of_file;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_frstrans_InitializeFileTransferAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frstrans_InitializeFileTransferAsync_done, req);
	return req;
}

static void rpccli_frstrans_InitializeFileTransferAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frstrans_InitializeFileTransferAsync_state *state = tevent_req_data(
		req, struct rpccli_frstrans_InitializeFileTransferAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.frs_update = *state->tmp.out.frs_update;
	*state->orig.out.staging_policy = *state->tmp.out.staging_policy;
	*state->orig.out.server_context = *state->tmp.out.server_context;
	*state->orig.out.rdc_file_info = *state->tmp.out.rdc_file_info;
	memcpy(state->orig.out.data_buffer, state->tmp.out.data_buffer, (state->tmp.in.buffer_size) * sizeof(*state->orig.out.data_buffer));
	*state->orig.out.size_read = *state->tmp.out.size_read;
	*state->orig.out.is_end_of_file = *state->tmp.out.is_end_of_file;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frstrans_InitializeFileTransferAsync_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct rpccli_frstrans_InitializeFileTransferAsync_state *state = tevent_req_data(
		req, struct rpccli_frstrans_InitializeFileTransferAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frstrans_InitializeFileTransferAsync(struct rpc_pipe_client *cli,
						     TALLOC_CTX *mem_ctx,
						     struct GUID connection_guid /* [in]  */,
						     struct frstrans_Update *frs_update /* [in,out] [ref] */,
						     uint32_t rdc_desired /* [in] [range(0,1)] */,
						     enum frstrans_RequestedStagingPolicy *staging_policy /* [in,out] [ref] */,
						     struct policy_handle *server_context /* [out] [ref] */,
						     struct frstrans_RdcFileInfo **rdc_file_info /* [out] [ref] */,
						     uint8_t *data_buffer /* [out] [ref,length_is(*size_read),size_is(buffer_size)] */,
						     uint32_t buffer_size /* [in] [range(0,262144)] */,
						     uint32_t *size_read /* [out] [ref] */,
						     uint32_t *is_end_of_file /* [out] [ref] */,
						     WERROR *werror)
{
	struct frstrans_InitializeFileTransferAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = connection_guid;
	r.in.frs_update = frs_update;
	r.in.rdc_desired = rdc_desired;
	r.in.staging_policy = staging_policy;
	r.in.buffer_size = buffer_size;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*frs_update = *r.out.frs_update;
	*staging_policy = *r.out.staging_policy;
	*server_context = *r.out.server_context;
	*rdc_file_info = *r.out.rdc_file_info;
	memcpy(data_buffer, r.out.data_buffer, (r.in.buffer_size) * sizeof(*data_buffer));
	*size_read = *r.out.size_read;
	*is_end_of_file = *r.out.is_end_of_file;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_state {
	struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE orig;
	struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_done, req);
	return req;
}

static void rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(struct rpc_pipe_client *cli,
						       TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_state {
	struct FRSTRANS_RAW_GET_FILE_DATA_ASYNC orig;
	struct FRSTRANS_RAW_GET_FILE_DATA_ASYNC tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_RAW_GET_FILE_DATA_ASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_done, req);
	return req;
}

static void rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_RAW_GET_FILE_DATA_ASYNC r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_RAW_GET_FILE_DATA_ASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_state {
	struct FRSTRANS_RDC_GET_FILE_DATA_ASYNC orig;
	struct FRSTRANS_RDC_GET_FILE_DATA_ASYNC tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frstrans,
				    NDR_FRSTRANS_RDC_GET_FILE_DATA_ASYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_done, req);
	return req;
}

static void rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_state *state = tevent_req_data(
		req, struct rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx)
{
	struct FRSTRANS_RDC_GET_FILE_DATA_ASYNC r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frstrans,
				NDR_FRSTRANS_RDC_GET_FILE_DATA_ASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

