/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_efs.h"

struct rpccli_EfsRpcOpenFileRaw_state {
	struct EfsRpcOpenFileRaw orig;
	struct EfsRpcOpenFileRaw tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcOpenFileRaw_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcOpenFileRaw_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_pvContext /* [out] [ref] */,
						 const char *_FileName /* [in] [charset(UTF16)] */,
						 uint32_t _Flags /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcOpenFileRaw_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcOpenFileRaw_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.FileName = _FileName;
	state->orig.in.Flags = _Flags;

	/* Out parameters */
	state->orig.out.pvContext = _pvContext;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_EfsRpcOpenFileRaw_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCOPENFILERAW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcOpenFileRaw_done, req);
	return req;
}

static void rpccli_EfsRpcOpenFileRaw_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcOpenFileRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcOpenFileRaw_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pvContext = *state->tmp.out.pvContext;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcOpenFileRaw_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_EfsRpcOpenFileRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcOpenFileRaw_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcOpenFileRaw(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *pvContext /* [out] [ref] */,
				  const char *FileName /* [in] [charset(UTF16)] */,
				  uint32_t Flags /* [in]  */,
				  WERROR *werror)
{
	struct EfsRpcOpenFileRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;
	r.in.Flags = Flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCOPENFILERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pvContext = *r.out.pvContext;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcReadFileRaw_state {
	struct EfsRpcReadFileRaw orig;
	struct EfsRpcReadFileRaw tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcReadFileRaw_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcReadFileRaw_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_pvContext /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcReadFileRaw_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcReadFileRaw_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.pvContext = _pvContext;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCREADFILERAW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcReadFileRaw_done, req);
	return req;
}

static void rpccli_EfsRpcReadFileRaw_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcReadFileRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcReadFileRaw_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcReadFileRaw_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_EfsRpcReadFileRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcReadFileRaw_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcReadFileRaw(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *pvContext /* [in] [ref] */,
				  WERROR *werror)
{
	struct EfsRpcReadFileRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.pvContext = pvContext;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCREADFILERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcWriteFileRaw_state {
	struct EfsRpcWriteFileRaw orig;
	struct EfsRpcWriteFileRaw tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcWriteFileRaw_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcWriteFileRaw_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct policy_handle *_pvContext /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcWriteFileRaw_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcWriteFileRaw_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.pvContext = _pvContext;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCWRITEFILERAW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcWriteFileRaw_done, req);
	return req;
}

static void rpccli_EfsRpcWriteFileRaw_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcWriteFileRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcWriteFileRaw_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcWriteFileRaw_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_EfsRpcWriteFileRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcWriteFileRaw_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcWriteFileRaw(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *pvContext /* [in] [ref] */,
				   WERROR *werror)
{
	struct EfsRpcWriteFileRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.pvContext = pvContext;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCWRITEFILERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcCloseRaw_state {
	struct EfsRpcCloseRaw orig;
	struct EfsRpcCloseRaw tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcCloseRaw_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcCloseRaw_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct policy_handle *_pvContext /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcCloseRaw_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcCloseRaw_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.pvContext = _pvContext;

	/* Out parameters */
	state->orig.out.pvContext = _pvContext;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_EfsRpcCloseRaw_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCCLOSERAW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcCloseRaw_done, req);
	return req;
}

static void rpccli_EfsRpcCloseRaw_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcCloseRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcCloseRaw_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pvContext = *state->tmp.out.pvContext;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcCloseRaw_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx)
{
	struct rpccli_EfsRpcCloseRaw_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcCloseRaw_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcCloseRaw(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *pvContext /* [in,out] [ref] */)
{
	struct EfsRpcCloseRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.pvContext = pvContext;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCCLOSERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pvContext = *r.out.pvContext;

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_EfsRpcEncryptFileSrv_state {
	struct EfsRpcEncryptFileSrv orig;
	struct EfsRpcEncryptFileSrv tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcEncryptFileSrv_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcEncryptFileSrv_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_Filename /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcEncryptFileSrv_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcEncryptFileSrv_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.Filename = _Filename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCENCRYPTFILESRV,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcEncryptFileSrv_done, req);
	return req;
}

static void rpccli_EfsRpcEncryptFileSrv_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcEncryptFileSrv_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcEncryptFileSrv_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcEncryptFileSrv_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_EfsRpcEncryptFileSrv_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcEncryptFileSrv_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcEncryptFileSrv(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *Filename /* [in] [charset(UTF16)] */,
				     WERROR *werror)
{
	struct EfsRpcEncryptFileSrv r;
	NTSTATUS status;

	/* In parameters */
	r.in.Filename = Filename;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCENCRYPTFILESRV,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcDecryptFileSrv_state {
	struct EfsRpcDecryptFileSrv orig;
	struct EfsRpcDecryptFileSrv tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcDecryptFileSrv_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcDecryptFileSrv_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_FileName /* [in] [charset(UTF16)] */,
						    uint32_t _Reserved /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcDecryptFileSrv_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcDecryptFileSrv_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.FileName = _FileName;
	state->orig.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCDECRYPTFILESRV,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcDecryptFileSrv_done, req);
	return req;
}

static void rpccli_EfsRpcDecryptFileSrv_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcDecryptFileSrv_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcDecryptFileSrv_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcDecryptFileSrv_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_EfsRpcDecryptFileSrv_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcDecryptFileSrv_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcDecryptFileSrv(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *FileName /* [in] [charset(UTF16)] */,
				     uint32_t Reserved /* [in]  */,
				     WERROR *werror)
{
	struct EfsRpcDecryptFileSrv r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;
	r.in.Reserved = Reserved;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCDECRYPTFILESRV,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcQueryUsersOnFile_state {
	struct EfsRpcQueryUsersOnFile orig;
	struct EfsRpcQueryUsersOnFile tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcQueryUsersOnFile_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcQueryUsersOnFile_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      const char *_FileName /* [in] [charset(UTF16)] */,
						      struct ENCRYPTION_CERTIFICATE_HASH_LIST **_pUsers /* [out] [unique,ref] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcQueryUsersOnFile_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcQueryUsersOnFile_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.FileName = _FileName;

	/* Out parameters */
	state->orig.out.pUsers = _pUsers;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_EfsRpcQueryUsersOnFile_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCQUERYUSERSONFILE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcQueryUsersOnFile_done, req);
	return req;
}

static void rpccli_EfsRpcQueryUsersOnFile_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcQueryUsersOnFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcQueryUsersOnFile_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pUsers = *state->tmp.out.pUsers;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcQueryUsersOnFile_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct rpccli_EfsRpcQueryUsersOnFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcQueryUsersOnFile_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcQueryUsersOnFile(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *FileName /* [in] [charset(UTF16)] */,
				       struct ENCRYPTION_CERTIFICATE_HASH_LIST **pUsers /* [out] [unique,ref] */,
				       WERROR *werror)
{
	struct EfsRpcQueryUsersOnFile r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCQUERYUSERSONFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pUsers = *r.out.pUsers;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcQueryRecoveryAgents_state {
	struct EfsRpcQueryRecoveryAgents orig;
	struct EfsRpcQueryRecoveryAgents tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcQueryRecoveryAgents_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcQueryRecoveryAgents_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 const char *_FileName /* [in] [charset(UTF16)] */,
							 struct ENCRYPTION_CERTIFICATE_HASH_LIST **_pRecoveryAgents /* [out] [unique,ref] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcQueryRecoveryAgents_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcQueryRecoveryAgents_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.FileName = _FileName;

	/* Out parameters */
	state->orig.out.pRecoveryAgents = _pRecoveryAgents;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_EfsRpcQueryRecoveryAgents_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCQUERYRECOVERYAGENTS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcQueryRecoveryAgents_done, req);
	return req;
}

static void rpccli_EfsRpcQueryRecoveryAgents_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcQueryRecoveryAgents_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcQueryRecoveryAgents_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pRecoveryAgents = *state->tmp.out.pRecoveryAgents;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcQueryRecoveryAgents_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct rpccli_EfsRpcQueryRecoveryAgents_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcQueryRecoveryAgents_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcQueryRecoveryAgents(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *FileName /* [in] [charset(UTF16)] */,
					  struct ENCRYPTION_CERTIFICATE_HASH_LIST **pRecoveryAgents /* [out] [unique,ref] */,
					  WERROR *werror)
{
	struct EfsRpcQueryRecoveryAgents r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCQUERYRECOVERYAGENTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pRecoveryAgents = *r.out.pRecoveryAgents;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcRemoveUsersFromFile_state {
	struct EfsRpcRemoveUsersFromFile orig;
	struct EfsRpcRemoveUsersFromFile tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcRemoveUsersFromFile_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcRemoveUsersFromFile_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 const char *_FileName /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcRemoveUsersFromFile_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcRemoveUsersFromFile_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.FileName = _FileName;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCREMOVEUSERSFROMFILE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcRemoveUsersFromFile_done, req);
	return req;
}

static void rpccli_EfsRpcRemoveUsersFromFile_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcRemoveUsersFromFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcRemoveUsersFromFile_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcRemoveUsersFromFile_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct rpccli_EfsRpcRemoveUsersFromFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcRemoveUsersFromFile_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcRemoveUsersFromFile(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *FileName /* [in] [charset(UTF16)] */,
					  WERROR *werror)
{
	struct EfsRpcRemoveUsersFromFile r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCREMOVEUSERSFROMFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcAddUsersToFile_state {
	struct EfsRpcAddUsersToFile orig;
	struct EfsRpcAddUsersToFile tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcAddUsersToFile_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcAddUsersToFile_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_FileName /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcAddUsersToFile_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcAddUsersToFile_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.FileName = _FileName;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCADDUSERSTOFILE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcAddUsersToFile_done, req);
	return req;
}

static void rpccli_EfsRpcAddUsersToFile_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcAddUsersToFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcAddUsersToFile_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcAddUsersToFile_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_EfsRpcAddUsersToFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcAddUsersToFile_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcAddUsersToFile(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *FileName /* [in] [charset(UTF16)] */,
				     WERROR *werror)
{
	struct EfsRpcAddUsersToFile r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCADDUSERSTOFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcSetFileEncryptionKey_state {
	struct EfsRpcSetFileEncryptionKey orig;
	struct EfsRpcSetFileEncryptionKey tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcSetFileEncryptionKey_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcSetFileEncryptionKey_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct ENCRYPTION_CERTIFICATE *_pEncryptionCertificate /* [in] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcSetFileEncryptionKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcSetFileEncryptionKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.pEncryptionCertificate = _pEncryptionCertificate;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCSETFILEENCRYPTIONKEY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcSetFileEncryptionKey_done, req);
	return req;
}

static void rpccli_EfsRpcSetFileEncryptionKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcSetFileEncryptionKey_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcSetFileEncryptionKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcSetFileEncryptionKey_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct rpccli_EfsRpcSetFileEncryptionKey_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcSetFileEncryptionKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcSetFileEncryptionKey(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ENCRYPTION_CERTIFICATE *pEncryptionCertificate /* [in] [unique] */,
					   WERROR *werror)
{
	struct EfsRpcSetFileEncryptionKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.pEncryptionCertificate = pEncryptionCertificate;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCSETFILEENCRYPTIONKEY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcNotSupported_state {
	struct EfsRpcNotSupported orig;
	struct EfsRpcNotSupported tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcNotSupported_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcNotSupported_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcNotSupported_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcNotSupported_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCNOTSUPPORTED,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcNotSupported_done, req);
	return req;
}

static void rpccli_EfsRpcNotSupported_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcNotSupported_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcNotSupported_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcNotSupported_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_EfsRpcNotSupported_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcNotSupported_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcNotSupported(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct EfsRpcNotSupported r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCNOTSUPPORTED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcFileKeyInfo_state {
	struct EfsRpcFileKeyInfo orig;
	struct EfsRpcFileKeyInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcFileKeyInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcFileKeyInfo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcFileKeyInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcFileKeyInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCFILEKEYINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcFileKeyInfo_done, req);
	return req;
}

static void rpccli_EfsRpcFileKeyInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcFileKeyInfo_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcFileKeyInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcFileKeyInfo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_EfsRpcFileKeyInfo_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcFileKeyInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcFileKeyInfo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct EfsRpcFileKeyInfo r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCFILEKEYINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_EfsRpcDuplicateEncryptionInfoFile_state {
	struct EfsRpcDuplicateEncryptionInfoFile orig;
	struct EfsRpcDuplicateEncryptionInfoFile tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_EfsRpcDuplicateEncryptionInfoFile_done(struct tevent_req *subreq);

struct tevent_req *rpccli_EfsRpcDuplicateEncryptionInfoFile_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_EfsRpcDuplicateEncryptionInfoFile_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_EfsRpcDuplicateEncryptionInfoFile_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_efs,
				    NDR_EFSRPCDUPLICATEENCRYPTIONINFOFILE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_EfsRpcDuplicateEncryptionInfoFile_done, req);
	return req;
}

static void rpccli_EfsRpcDuplicateEncryptionInfoFile_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_EfsRpcDuplicateEncryptionInfoFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcDuplicateEncryptionInfoFile_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_EfsRpcDuplicateEncryptionInfoFile_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct rpccli_EfsRpcDuplicateEncryptionInfoFile_state *state = tevent_req_data(
		req, struct rpccli_EfsRpcDuplicateEncryptionInfoFile_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcDuplicateEncryptionInfoFile(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct EfsRpcDuplicateEncryptionInfoFile r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCDUPLICATEENCRYPTIONINFOFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

