/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_atsvc.h"

struct rpccli_atsvc_JobAdd_state {
	struct atsvc_JobAdd orig;
	struct atsvc_JobAdd tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_atsvc_JobAdd_done(struct tevent_req *subreq);

struct tevent_req *rpccli_atsvc_JobAdd_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli,
					    const char *_servername /* [in] [unique,charset(UTF16)] */,
					    struct atsvc_JobInfo *_job_info /* [in] [ref] */,
					    uint32_t *_job_id /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_atsvc_JobAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_atsvc_JobAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.job_info = _job_info;

	/* Out parameters */
	state->orig.out.job_id = _job_id;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_atsvc_JobAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_atsvc,
				    NDR_ATSVC_JOBADD,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_atsvc_JobAdd_done, req);
	return req;
}

static void rpccli_atsvc_JobAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_atsvc_JobAdd_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.job_id = *state->tmp.out.job_id;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_atsvc_JobAdd_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct rpccli_atsvc_JobAdd_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_atsvc_JobAdd(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     struct atsvc_JobInfo *job_info /* [in] [ref] */,
			     uint32_t *job_id /* [out] [ref] */)
{
	struct atsvc_JobAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.job_info = job_info;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBADD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*job_id = *r.out.job_id;

	/* Return result */
	return r.out.result;
}

struct rpccli_atsvc_JobDel_state {
	struct atsvc_JobDel orig;
	struct atsvc_JobDel tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_atsvc_JobDel_done(struct tevent_req *subreq);

struct tevent_req *rpccli_atsvc_JobDel_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli,
					    const char *_servername /* [in] [unique,charset(UTF16)] */,
					    uint32_t _min_job_id /* [in]  */,
					    uint32_t _max_job_id /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_atsvc_JobDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_atsvc_JobDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.min_job_id = _min_job_id;
	state->orig.in.max_job_id = _max_job_id;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_atsvc,
				    NDR_ATSVC_JOBDEL,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_atsvc_JobDel_done, req);
	return req;
}

static void rpccli_atsvc_JobDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_atsvc_JobDel_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_atsvc_JobDel_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct rpccli_atsvc_JobDel_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_atsvc_JobDel(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     uint32_t min_job_id /* [in]  */,
			     uint32_t max_job_id /* [in]  */)
{
	struct atsvc_JobDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.min_job_id = min_job_id;
	r.in.max_job_id = max_job_id;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBDEL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_atsvc_JobEnum_state {
	struct atsvc_JobEnum orig;
	struct atsvc_JobEnum tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_atsvc_JobEnum_done(struct tevent_req *subreq);

struct tevent_req *rpccli_atsvc_JobEnum_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     const char *_servername /* [in] [unique,charset(UTF16)] */,
					     struct atsvc_enum_ctr *_ctr /* [in,out] [ref] */,
					     uint32_t _preferred_max_len /* [in]  */,
					     uint32_t *_total_entries /* [out] [ref] */,
					     uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_atsvc_JobEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_atsvc_JobEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.ctr = _ctr;
	state->orig.in.preferred_max_len = _preferred_max_len;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.ctr = _ctr;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_atsvc_JobEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_atsvc,
				    NDR_ATSVC_JOBENUM,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_atsvc_JobEnum_done, req);
	return req;
}

static void rpccli_atsvc_JobEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_atsvc_JobEnum_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_atsvc_JobEnum_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_atsvc_JobEnum_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_atsvc_JobEnum(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *servername /* [in] [unique,charset(UTF16)] */,
			      struct atsvc_enum_ctr *ctr /* [in,out] [ref] */,
			      uint32_t preferred_max_len /* [in]  */,
			      uint32_t *total_entries /* [out] [ref] */,
			      uint32_t *resume_handle /* [in,out] [unique] */)
{
	struct atsvc_JobEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.ctr = ctr;
	r.in.preferred_max_len = preferred_max_len;
	r.in.resume_handle = resume_handle;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;
	*total_entries = *r.out.total_entries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	return r.out.result;
}

struct rpccli_atsvc_JobGetInfo_state {
	struct atsvc_JobGetInfo orig;
	struct atsvc_JobGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_atsvc_JobGetInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_atsvc_JobGetInfo_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_servername /* [in] [unique,charset(UTF16)] */,
						uint32_t _job_id /* [in]  */,
						struct atsvc_JobInfo **_job_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_atsvc_JobGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_atsvc_JobGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.job_id = _job_id;

	/* Out parameters */
	state->orig.out.job_info = _job_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_atsvc_JobGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_atsvc,
				    NDR_ATSVC_JOBGETINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_atsvc_JobGetInfo_done, req);
	return req;
}

static void rpccli_atsvc_JobGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_atsvc_JobGetInfo_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.job_info = *state->tmp.out.job_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_atsvc_JobGetInfo_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_atsvc_JobGetInfo_state *state = tevent_req_data(
		req, struct rpccli_atsvc_JobGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_atsvc_JobGetInfo(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [unique,charset(UTF16)] */,
				 uint32_t job_id /* [in]  */,
				 struct atsvc_JobInfo **job_info /* [out] [ref] */)
{
	struct atsvc_JobGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.job_id = job_id;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*job_info = *r.out.job_info;

	/* Return result */
	return r.out.result;
}

