
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_winreg.h"
#include "../librpc/gen_ndr/ndr_winreg_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject winreg_String_Type;
staticforward PyTypeObject KeySecurityData_Type;
staticforward PyTypeObject winreg_SecBuf_Type;
staticforward PyTypeObject winreg_StringBuf_Type;
staticforward PyTypeObject winreg_ValNameBuf_Type;
staticforward PyTypeObject KeySecurityAttribute_Type;
staticforward PyTypeObject QueryMultipleValue_Type;
staticforward PyTypeObject winreg_InterfaceType;

static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *policy_handle_Type;

static PyObject *py_winreg_String_get_name_len(PyObject *obj, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(obj);
	PyObject *py_name_len;
	py_name_len = PyInt_FromLong(object->name_len);
	return py_name_len;
}

static int py_winreg_String_set_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->name_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_String_get_name_size(PyObject *obj, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(obj);
	PyObject *py_name_size;
	py_name_size = PyInt_FromLong(object->name_size);
	return py_name_size;
}

static int py_winreg_String_set_name_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->name_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_String_get_name(PyObject *obj, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
	} else {
		py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_winreg_String_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyGetSetDef py_winreg_String_getsetters[] = {
	{ discard_const_p(char, "name_len"), py_winreg_String_get_name_len, py_winreg_String_set_name_len },
	{ discard_const_p(char, "name_size"), py_winreg_String_get_name_size, py_winreg_String_set_name_size },
	{ discard_const_p(char, "name"), py_winreg_String_get_name, py_winreg_String_set_name },
	{ NULL }
};

static PyObject *py_winreg_String_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_String, type);
}

static PyObject *py_winreg_String_ndr_pack(PyObject *py_obj)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_winreg_String);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_winreg_String_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_winreg_String);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_winreg_String_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_winreg_String_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_winreg_String_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_String_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.String",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_winreg_String_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_winreg_String_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_String_new,
};


static PyObject *py_KeySecurityData_get_data(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
	} else {
		py_data = PyList_New(object->len);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->len; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_KeySecurityData_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(py_obj);
	talloc_free(object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_Size(value));
			for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_KeySecurityData_get_size(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_KeySecurityData_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_KeySecurityData_get_len(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_KeySecurityData_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_KeySecurityData_getsetters[] = {
	{ discard_const_p(char, "data"), py_KeySecurityData_get_data, py_KeySecurityData_set_data },
	{ discard_const_p(char, "size"), py_KeySecurityData_get_size, py_KeySecurityData_set_size },
	{ discard_const_p(char, "len"), py_KeySecurityData_get_len, py_KeySecurityData_set_len },
	{ NULL }
};

static PyObject *py_KeySecurityData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct KeySecurityData, type);
}


static PyTypeObject KeySecurityData_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.KeySecurityData",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_KeySecurityData_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KeySecurityData_new,
};


static PyObject *py_winreg_SecBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_winreg_SecBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_SecBuf_get_sd(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(obj);
	PyObject *py_sd;
	py_sd = py_talloc_import_ex(&KeySecurityData_Type, py_talloc_get_mem_ctx(obj), &object->sd);
	return py_sd;
}

static int py_winreg_SecBuf_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	memcpy(&object->sd, talloc_ptrtype(py_talloc_get_ptr(value), &object->sd), sizeof(object->sd));
	return 0;
}

static PyObject *py_winreg_SecBuf_get_inherit(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(obj);
	PyObject *py_inherit;
	py_inherit = PyInt_FromLong(object->inherit);
	return py_inherit;
}

static int py_winreg_SecBuf_set_inherit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->inherit = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_winreg_SecBuf_getsetters[] = {
	{ discard_const_p(char, "length"), py_winreg_SecBuf_get_length, py_winreg_SecBuf_set_length },
	{ discard_const_p(char, "sd"), py_winreg_SecBuf_get_sd, py_winreg_SecBuf_set_sd },
	{ discard_const_p(char, "inherit"), py_winreg_SecBuf_get_inherit, py_winreg_SecBuf_set_inherit },
	{ NULL }
};

static PyObject *py_winreg_SecBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_SecBuf, type);
}


static PyTypeObject winreg_SecBuf_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.SecBuf",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_winreg_SecBuf_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_SecBuf_new,
};


static PyObject *py_winreg_StringBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_winreg_StringBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_StringBuf_get_size(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_winreg_StringBuf_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_StringBuf_get_name(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
	} else {
		py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_winreg_StringBuf_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyGetSetDef py_winreg_StringBuf_getsetters[] = {
	{ discard_const_p(char, "length"), py_winreg_StringBuf_get_length, py_winreg_StringBuf_set_length },
	{ discard_const_p(char, "size"), py_winreg_StringBuf_get_size, py_winreg_StringBuf_set_size },
	{ discard_const_p(char, "name"), py_winreg_StringBuf_get_name, py_winreg_StringBuf_set_name },
	{ NULL }
};

static PyObject *py_winreg_StringBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_StringBuf, type);
}


static PyTypeObject winreg_StringBuf_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.StringBuf",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_winreg_StringBuf_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_StringBuf_new,
};


static PyObject *py_winreg_ValNameBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_winreg_ValNameBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_ValNameBuf_get_size(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_winreg_ValNameBuf_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_ValNameBuf_get_name(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
	} else {
		py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_winreg_ValNameBuf_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyGetSetDef py_winreg_ValNameBuf_getsetters[] = {
	{ discard_const_p(char, "length"), py_winreg_ValNameBuf_get_length, py_winreg_ValNameBuf_set_length },
	{ discard_const_p(char, "size"), py_winreg_ValNameBuf_get_size, py_winreg_ValNameBuf_set_size },
	{ discard_const_p(char, "name"), py_winreg_ValNameBuf_get_name, py_winreg_ValNameBuf_set_name },
	{ NULL }
};

static PyObject *py_winreg_ValNameBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_ValNameBuf, type);
}


static PyTypeObject winreg_ValNameBuf_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.ValNameBuf",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_winreg_ValNameBuf_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_ValNameBuf_new,
};


static PyObject *py_KeySecurityAttribute_get_data_size(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyInt_FromLong(object->data_size);
	return py_data_size;
}

static int py_KeySecurityAttribute_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_KeySecurityAttribute_get_sec_data(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(obj);
	PyObject *py_sec_data;
	py_sec_data = py_talloc_import_ex(&KeySecurityData_Type, py_talloc_get_mem_ctx(obj), &object->sec_data);
	return py_sec_data;
}

static int py_KeySecurityAttribute_set_sec_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	memcpy(&object->sec_data, talloc_ptrtype(py_talloc_get_ptr(value), &object->sec_data), sizeof(object->sec_data));
	return 0;
}

static PyObject *py_KeySecurityAttribute_get_inherit(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(obj);
	PyObject *py_inherit;
	py_inherit = PyInt_FromLong(object->inherit);
	return py_inherit;
}

static int py_KeySecurityAttribute_set_inherit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->inherit = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_KeySecurityAttribute_getsetters[] = {
	{ discard_const_p(char, "data_size"), py_KeySecurityAttribute_get_data_size, py_KeySecurityAttribute_set_data_size },
	{ discard_const_p(char, "sec_data"), py_KeySecurityAttribute_get_sec_data, py_KeySecurityAttribute_set_sec_data },
	{ discard_const_p(char, "inherit"), py_KeySecurityAttribute_get_inherit, py_KeySecurityAttribute_set_inherit },
	{ NULL }
};

static PyObject *py_KeySecurityAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct KeySecurityAttribute, type);
}


static PyTypeObject KeySecurityAttribute_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.KeySecurityAttribute",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_KeySecurityAttribute_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KeySecurityAttribute_new,
};


static PyObject *py_QueryMultipleValue_get_name(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
	} else {
		py_name = py_talloc_import_ex(&winreg_String_Type, object->name, object->name);
	}
	return py_name;
}

static int py_QueryMultipleValue_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	talloc_free(object->name);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->name);
		PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
		object->name = talloc_ptrtype(py_talloc_get_ptr(value), object->name);
	}
	return 0;
}

static PyObject *py_QueryMultipleValue_get_type(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_QueryMultipleValue_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QueryMultipleValue_get_offset(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_offset;
	py_offset = PyInt_FromLong(object->offset);
	return py_offset;
}

static int py_QueryMultipleValue_set_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QueryMultipleValue_get_length(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_QueryMultipleValue_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_QueryMultipleValue_getsetters[] = {
	{ discard_const_p(char, "name"), py_QueryMultipleValue_get_name, py_QueryMultipleValue_set_name },
	{ discard_const_p(char, "type"), py_QueryMultipleValue_get_type, py_QueryMultipleValue_set_type },
	{ discard_const_p(char, "offset"), py_QueryMultipleValue_get_offset, py_QueryMultipleValue_set_offset },
	{ discard_const_p(char, "length"), py_QueryMultipleValue_get_length, py_QueryMultipleValue_set_length },
	{ NULL }
};

static PyObject *py_QueryMultipleValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct QueryMultipleValue, type);
}


static PyTypeObject QueryMultipleValue_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.QueryMultipleValue",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_QueryMultipleValue_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_QueryMultipleValue_new,
};


static bool pack_py_winreg_OpenHKCR_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCR *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCR", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCR_args_out(struct winreg_OpenHKCR *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKCU_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCU *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCU", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCU_args_out(struct winreg_OpenHKCU *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKLM_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKLM *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKLM", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKLM_args_out(struct winreg_OpenHKLM *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKPD_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPD *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPD", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPD_args_out(struct winreg_OpenHKPD *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKU_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKU *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKU", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKU_args_out(struct winreg_OpenHKU *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_CloseKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_CloseKey *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_CloseKey", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	return true;
}

static PyObject *unpack_py_winreg_CloseKey_args_out(struct winreg_CloseKey *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_CreateKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_CreateKey *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_options;
	PyObject *py_access_mask;
	PyObject *py_secdesc;
	PyObject *py_action_taken;
	const char *kwnames[] = {
		"handle", "name", "keyclass", "options", "access_mask", "secdesc", "action_taken", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_CreateKey", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_keyclass, &py_options, &py_access_mask, &py_secdesc, &py_action_taken)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_name, return false;);
	memcpy(&r->in.name, talloc_ptrtype(py_talloc_get_ptr(py_name), &r->in.name), sizeof(r->in.name));
	PY_CHECK_TYPE(&winreg_String_Type, py_keyclass, return false;);
	memcpy(&r->in.keyclass, talloc_ptrtype(py_talloc_get_ptr(py_keyclass), &r->in.keyclass), sizeof(r->in.keyclass));
	PY_CHECK_TYPE(&PyInt_Type, py_options, return false;);
	r->in.options = PyInt_AsLong(py_options);
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	if (py_secdesc == Py_None) {
		r->in.secdesc = NULL;
	} else {
		r->in.secdesc = talloc_ptrtype(r, r->in.secdesc);
		PY_CHECK_TYPE(&winreg_SecBuf_Type, py_secdesc, return false;);
		r->in.secdesc = talloc_ptrtype(py_talloc_get_ptr(py_secdesc), r->in.secdesc);
	}
	if (py_action_taken == Py_None) {
		r->in.action_taken = NULL;
	} else {
		r->in.action_taken = talloc_ptrtype(r, r->in.action_taken);
		PY_CHECK_TYPE(&PyInt_Type, py_action_taken, return false;);
		*r->in.action_taken = PyInt_AsLong(py_action_taken);
	}
	return true;
}

static PyObject *unpack_py_winreg_CreateKey_args_out(struct winreg_CreateKey *r)
{
	PyObject *result = Py_None;
	PyObject *py_new_handle;
	PyObject *py_action_taken;
	result = PyTuple_New(2);
	py_new_handle = py_talloc_import_ex(policy_handle_Type, r->out.new_handle, r->out.new_handle);
	PyTuple_SetItem(result, 0, py_new_handle);
	if (r->out.action_taken == NULL) {
		py_action_taken = Py_None;
	} else {
		py_action_taken = PyInt_FromLong(*r->out.action_taken);
	}
	PyTuple_SetItem(result, 1, py_action_taken);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_DeleteKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteKey *r)
{
	PyObject *py_handle;
	PyObject *py_key;
	const char *kwnames[] = {
		"handle", "key", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_DeleteKey", discard_const_p(char *, kwnames), &py_handle, &py_key)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_key, return false;);
	memcpy(&r->in.key, talloc_ptrtype(py_talloc_get_ptr(py_key), &r->in.key), sizeof(r->in.key));
	return true;
}

static PyObject *unpack_py_winreg_DeleteKey_args_out(struct winreg_DeleteKey *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_DeleteValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteValue *r)
{
	PyObject *py_handle;
	PyObject *py_value;
	const char *kwnames[] = {
		"handle", "value", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_DeleteValue", discard_const_p(char *, kwnames), &py_handle, &py_value)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_value, return false;);
	memcpy(&r->in.value, talloc_ptrtype(py_talloc_get_ptr(py_value), &r->in.value), sizeof(r->in.value));
	return true;
}

static PyObject *unpack_py_winreg_DeleteValue_args_out(struct winreg_DeleteValue *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_EnumKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_EnumKey *r)
{
	PyObject *py_handle;
	PyObject *py_enum_index;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_last_changed_time;
	const char *kwnames[] = {
		"handle", "enum_index", "name", "keyclass", "last_changed_time", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winreg_EnumKey", discard_const_p(char *, kwnames), &py_handle, &py_enum_index, &py_name, &py_keyclass, &py_last_changed_time)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&PyInt_Type, py_enum_index, return false;);
	r->in.enum_index = PyInt_AsLong(py_enum_index);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&winreg_StringBuf_Type, py_name, return false;);
	r->in.name = talloc_ptrtype(py_talloc_get_ptr(py_name), r->in.name);
	if (py_keyclass == Py_None) {
		r->in.keyclass = NULL;
	} else {
		r->in.keyclass = talloc_ptrtype(r, r->in.keyclass);
		PY_CHECK_TYPE(&winreg_StringBuf_Type, py_keyclass, return false;);
		r->in.keyclass = talloc_ptrtype(py_talloc_get_ptr(py_keyclass), r->in.keyclass);
	}
	if (py_last_changed_time == Py_None) {
		r->in.last_changed_time = NULL;
	} else {
		r->in.last_changed_time = talloc_ptrtype(r, r->in.last_changed_time);
		PY_CHECK_TYPE(&PyInt_Type, py_last_changed_time, return false;);
		*r->in.last_changed_time = PyInt_AsLong(py_last_changed_time);
	}
	return true;
}

static PyObject *unpack_py_winreg_EnumKey_args_out(struct winreg_EnumKey *r)
{
	PyObject *result = Py_None;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_last_changed_time;
	result = PyTuple_New(3);
	py_name = py_talloc_import_ex(&winreg_StringBuf_Type, r->out.name, r->out.name);
	PyTuple_SetItem(result, 0, py_name);
	if (r->out.keyclass == NULL) {
		py_keyclass = Py_None;
	} else {
		py_keyclass = py_talloc_import_ex(&winreg_StringBuf_Type, r->out.keyclass, r->out.keyclass);
	}
	PyTuple_SetItem(result, 1, py_keyclass);
	if (r->out.last_changed_time == NULL) {
		py_last_changed_time = Py_None;
	} else {
		py_last_changed_time = PyInt_FromLong(*r->out.last_changed_time);
	}
	PyTuple_SetItem(result, 2, py_last_changed_time);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_EnumValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_EnumValue *r)
{
	PyObject *py_handle;
	PyObject *py_enum_index;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_value;
	PyObject *py_size;
	const char *kwnames[] = {
		"handle", "enum_index", "name", "type", "value", "size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:winreg_EnumValue", discard_const_p(char *, kwnames), &py_handle, &py_enum_index, &py_name, &py_type, &py_value, &py_size)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&PyInt_Type, py_enum_index, return false;);
	r->in.enum_index = PyInt_AsLong(py_enum_index);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&winreg_ValNameBuf_Type, py_name, return false;);
	r->in.name = talloc_ptrtype(py_talloc_get_ptr(py_name), r->in.name);
	if (py_type == Py_None) {
		r->in.type = NULL;
	} else {
		r->in.type = talloc_ptrtype(r, r->in.type);
		PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
		*r->in.type = PyInt_AsLong(py_type);
	}
	if (py_value == Py_None) {
		r->in.value = NULL;
	} else {
		r->in.value = talloc_ptrtype(r, r->in.value);
		PY_CHECK_TYPE(&PyList_Type, py_value, return false;);
		{
			int value_cntr_1;
			r->in.value = talloc_array_ptrtype(r, r->in.value, PyList_Size(py_value));
			for (value_cntr_1 = 0; value_cntr_1 < PyList_Size(py_value); value_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_value, value_cntr_1), return false;);
				r->in.value[value_cntr_1] = PyInt_AsLong(PyList_GetItem(py_value, value_cntr_1));
			}
		}
	}
	if (py_size == Py_None) {
		r->in.size = NULL;
	} else {
		r->in.size = talloc_ptrtype(r, r->in.size);
		PY_CHECK_TYPE(&PyInt_Type, py_size, return false;);
		*r->in.size = PyInt_AsLong(py_size);
	}
	PY_CHECK_TYPE(&PyList_Type, py_value, return false;);
	r->in.length = talloc_ptrtype(r, r->in.length);
	*r->in.length = PyList_Size(py_value);
	return true;
}

static PyObject *unpack_py_winreg_EnumValue_args_out(struct winreg_EnumValue *r)
{
	PyObject *result = Py_None;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_value;
	PyObject *py_size;
	result = PyTuple_New(4);
	py_name = py_talloc_import_ex(&winreg_ValNameBuf_Type, r->out.name, r->out.name);
	PyTuple_SetItem(result, 0, py_name);
	if (r->out.type == NULL) {
		py_type = Py_None;
	} else {
		py_type = PyInt_FromLong(*r->out.type);
	}
	PyTuple_SetItem(result, 1, py_type);
	if (r->out.value == NULL) {
		py_value = Py_None;
	} else {
		py_value = PyList_New(*r->out.length);
		if (py_value == NULL) {
			return NULL;
		}
		{
			int value_cntr_1;
			for (value_cntr_1 = 0; value_cntr_1 < *r->out.length; value_cntr_1++) {
				PyObject *py_value_1;
				py_value_1 = PyInt_FromLong(r->out.value[value_cntr_1]);
				PyList_SetItem(py_value, value_cntr_1, py_value_1);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_value);
	if (r->out.size == NULL) {
		py_size = Py_None;
	} else {
		py_size = PyInt_FromLong(*r->out.size);
	}
	PyTuple_SetItem(result, 3, py_size);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_FlushKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_FlushKey *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_FlushKey", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	return true;
}

static PyObject *unpack_py_winreg_FlushKey_args_out(struct winreg_FlushKey *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_GetKeySecurity_args_in(PyObject *args, PyObject *kwargs, struct winreg_GetKeySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sd;
	const char *kwnames[] = {
		"handle", "sec_info", "sd", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_GetKeySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sd)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&PyInt_Type, py_sec_info, return false;);
	r->in.sec_info = PyInt_AsLong(py_sec_info);
	r->in.sd = talloc_ptrtype(r, r->in.sd);
	PY_CHECK_TYPE(&KeySecurityData_Type, py_sd, return false;);
	r->in.sd = talloc_ptrtype(py_talloc_get_ptr(py_sd), r->in.sd);
	return true;
}

static PyObject *unpack_py_winreg_GetKeySecurity_args_out(struct winreg_GetKeySecurity *r)
{
	PyObject *result = Py_None;
	PyObject *py_sd;
	py_sd = py_talloc_import_ex(&KeySecurityData_Type, r->out.sd, r->out.sd);
	result = py_sd;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_LoadKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_LoadKey *r)
{
	PyObject *py_handle;
	PyObject *py_keyname;
	PyObject *py_filename;
	const char *kwnames[] = {
		"handle", "keyname", "filename", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_LoadKey", discard_const_p(char *, kwnames), &py_handle, &py_keyname, &py_filename)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	if (py_keyname == Py_None) {
		r->in.keyname = NULL;
	} else {
		r->in.keyname = talloc_ptrtype(r, r->in.keyname);
		PY_CHECK_TYPE(&winreg_String_Type, py_keyname, return false;);
		r->in.keyname = talloc_ptrtype(py_talloc_get_ptr(py_keyname), r->in.keyname);
	}
	if (py_filename == Py_None) {
		r->in.filename = NULL;
	} else {
		r->in.filename = talloc_ptrtype(r, r->in.filename);
		PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
		r->in.filename = talloc_ptrtype(py_talloc_get_ptr(py_filename), r->in.filename);
	}
	return true;
}

static PyObject *unpack_py_winreg_LoadKey_args_out(struct winreg_LoadKey *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_NotifyChangeKeyValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_NotifyChangeKeyValue *r)
{
	PyObject *py_handle;
	PyObject *py_watch_subtree;
	PyObject *py_notify_filter;
	PyObject *py_unknown;
	PyObject *py_string1;
	PyObject *py_string2;
	PyObject *py_unknown2;
	const char *kwnames[] = {
		"handle", "watch_subtree", "notify_filter", "unknown", "string1", "string2", "unknown2", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_NotifyChangeKeyValue", discard_const_p(char *, kwnames), &py_handle, &py_watch_subtree, &py_notify_filter, &py_unknown, &py_string1, &py_string2, &py_unknown2)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&PyInt_Type, py_watch_subtree, return false;);
	r->in.watch_subtree = PyInt_AsLong(py_watch_subtree);
	PY_CHECK_TYPE(&PyInt_Type, py_notify_filter, return false;);
	r->in.notify_filter = PyInt_AsLong(py_notify_filter);
	PY_CHECK_TYPE(&PyInt_Type, py_unknown, return false;);
	r->in.unknown = PyInt_AsLong(py_unknown);
	PY_CHECK_TYPE(&winreg_String_Type, py_string1, return false;);
	memcpy(&r->in.string1, talloc_ptrtype(py_talloc_get_ptr(py_string1), &r->in.string1), sizeof(r->in.string1));
	PY_CHECK_TYPE(&winreg_String_Type, py_string2, return false;);
	memcpy(&r->in.string2, talloc_ptrtype(py_talloc_get_ptr(py_string2), &r->in.string2), sizeof(r->in.string2));
	PY_CHECK_TYPE(&PyInt_Type, py_unknown2, return false;);
	r->in.unknown2 = PyInt_AsLong(py_unknown2);
	return true;
}

static PyObject *unpack_py_winreg_NotifyChangeKeyValue_args_out(struct winreg_NotifyChangeKeyValue *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenKey *r)
{
	PyObject *py_parent_handle;
	PyObject *py_keyname;
	PyObject *py_unknown;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"parent_handle", "keyname", "unknown", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_OpenKey", discard_const_p(char *, kwnames), &py_parent_handle, &py_keyname, &py_unknown, &py_access_mask)) {
		return false;
	}

	r->in.parent_handle = talloc_ptrtype(r, r->in.parent_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_parent_handle, return false;);
	r->in.parent_handle = talloc_ptrtype(py_talloc_get_ptr(py_parent_handle), r->in.parent_handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_keyname, return false;);
	memcpy(&r->in.keyname, talloc_ptrtype(py_talloc_get_ptr(py_keyname), &r->in.keyname), sizeof(r->in.keyname));
	PY_CHECK_TYPE(&PyInt_Type, py_unknown, return false;);
	r->in.unknown = PyInt_AsLong(py_unknown);
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenKey_args_out(struct winreg_OpenKey *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_QueryInfoKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryInfoKey *r)
{
	PyObject *py_handle;
	PyObject *py_classname;
	const char *kwnames[] = {
		"handle", "classname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_QueryInfoKey", discard_const_p(char *, kwnames), &py_handle, &py_classname)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	r->in.classname = talloc_ptrtype(r, r->in.classname);
	PY_CHECK_TYPE(&winreg_String_Type, py_classname, return false;);
	r->in.classname = talloc_ptrtype(py_talloc_get_ptr(py_classname), r->in.classname);
	return true;
}

static PyObject *unpack_py_winreg_QueryInfoKey_args_out(struct winreg_QueryInfoKey *r)
{
	PyObject *result = Py_None;
	PyObject *py_classname;
	PyObject *py_num_subkeys;
	PyObject *py_max_subkeylen;
	PyObject *py_max_classlen;
	PyObject *py_num_values;
	PyObject *py_max_valnamelen;
	PyObject *py_max_valbufsize;
	PyObject *py_secdescsize;
	PyObject *py_last_changed_time;
	result = PyTuple_New(9);
	py_classname = py_talloc_import_ex(&winreg_String_Type, r->out.classname, r->out.classname);
	PyTuple_SetItem(result, 0, py_classname);
	py_num_subkeys = PyInt_FromLong(*r->out.num_subkeys);
	PyTuple_SetItem(result, 1, py_num_subkeys);
	py_max_subkeylen = PyInt_FromLong(*r->out.max_subkeylen);
	PyTuple_SetItem(result, 2, py_max_subkeylen);
	py_max_classlen = PyInt_FromLong(*r->out.max_classlen);
	PyTuple_SetItem(result, 3, py_max_classlen);
	py_num_values = PyInt_FromLong(*r->out.num_values);
	PyTuple_SetItem(result, 4, py_num_values);
	py_max_valnamelen = PyInt_FromLong(*r->out.max_valnamelen);
	PyTuple_SetItem(result, 5, py_max_valnamelen);
	py_max_valbufsize = PyInt_FromLong(*r->out.max_valbufsize);
	PyTuple_SetItem(result, 6, py_max_valbufsize);
	py_secdescsize = PyInt_FromLong(*r->out.secdescsize);
	PyTuple_SetItem(result, 7, py_secdescsize);
	py_last_changed_time = PyInt_FromLong(*r->out.last_changed_time);
	PyTuple_SetItem(result, 8, py_last_changed_time);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_QueryValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryValue *r)
{
	PyObject *py_handle;
	PyObject *py_value_name;
	PyObject *py_type;
	PyObject *py_data;
	PyObject *py_data_size;
	const char *kwnames[] = {
		"handle", "value_name", "type", "data", "data_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winreg_QueryValue", discard_const_p(char *, kwnames), &py_handle, &py_value_name, &py_type, &py_data, &py_data_size)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	r->in.value_name = talloc_ptrtype(r, r->in.value_name);
	PY_CHECK_TYPE(&winreg_String_Type, py_value_name, return false;);
	r->in.value_name = talloc_ptrtype(py_talloc_get_ptr(py_value_name), r->in.value_name);
	if (py_type == Py_None) {
		r->in.type = NULL;
	} else {
		r->in.type = talloc_ptrtype(r, r->in.type);
		PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
		*r->in.type = PyInt_AsLong(py_type);
	}
	if (py_data == Py_None) {
		r->in.data = NULL;
	} else {
		r->in.data = talloc_ptrtype(r, r->in.data);
		PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
		{
			int data_cntr_1;
			r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_Size(py_data));
			for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(py_data); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_data, data_cntr_1), return false;);
				r->in.data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(py_data, data_cntr_1));
			}
		}
	}
	if (py_data_size == Py_None) {
		r->in.data_size = NULL;
	} else {
		r->in.data_size = talloc_ptrtype(r, r->in.data_size);
		PY_CHECK_TYPE(&PyInt_Type, py_data_size, return false;);
		*r->in.data_size = PyInt_AsLong(py_data_size);
	}
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.data_length = talloc_ptrtype(r, r->in.data_length);
	*r->in.data_length = PyList_Size(py_data);
	return true;
}

static PyObject *unpack_py_winreg_QueryValue_args_out(struct winreg_QueryValue *r)
{
	PyObject *result = Py_None;
	PyObject *py_type;
	PyObject *py_data;
	PyObject *py_data_size;
	result = PyTuple_New(3);
	if (r->out.type == NULL) {
		py_type = Py_None;
	} else {
		py_type = PyInt_FromLong(*r->out.type);
	}
	PyTuple_SetItem(result, 0, py_type);
	if (r->out.data == NULL) {
		py_data = Py_None;
	} else {
		py_data = PyList_New(*r->out.data_length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < *r->out.data_length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(r->out.data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_data);
	if (r->out.data_size == NULL) {
		py_data_size = Py_None;
	} else {
		py_data_size = PyInt_FromLong(*r->out.data_size);
	}
	PyTuple_SetItem(result, 2, py_data_size);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_RestoreKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_RestoreKey *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "filename", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_RestoreKey", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_flags)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	r->in.filename = talloc_ptrtype(py_talloc_get_ptr(py_filename), r->in.filename);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_winreg_RestoreKey_args_out(struct winreg_RestoreKey *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_SaveKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_SaveKey *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_sec_attrib;
	const char *kwnames[] = {
		"handle", "filename", "sec_attrib", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_SaveKey", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_sec_attrib)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	r->in.filename = talloc_ptrtype(py_talloc_get_ptr(py_filename), r->in.filename);
	if (py_sec_attrib == Py_None) {
		r->in.sec_attrib = NULL;
	} else {
		r->in.sec_attrib = talloc_ptrtype(r, r->in.sec_attrib);
		PY_CHECK_TYPE(&KeySecurityAttribute_Type, py_sec_attrib, return false;);
		r->in.sec_attrib = talloc_ptrtype(py_talloc_get_ptr(py_sec_attrib), r->in.sec_attrib);
	}
	return true;
}

static PyObject *unpack_py_winreg_SaveKey_args_out(struct winreg_SaveKey *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_SetKeySecurity_args_in(PyObject *args, PyObject *kwargs, struct winreg_SetKeySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sd;
	const char *kwnames[] = {
		"handle", "sec_info", "sd", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_SetKeySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sd)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&PyInt_Type, py_sec_info, return false;);
	r->in.sec_info = PyInt_AsLong(py_sec_info);
	r->in.sd = talloc_ptrtype(r, r->in.sd);
	PY_CHECK_TYPE(&KeySecurityData_Type, py_sd, return false;);
	r->in.sd = talloc_ptrtype(py_talloc_get_ptr(py_sd), r->in.sd);
	return true;
}

static PyObject *unpack_py_winreg_SetKeySecurity_args_out(struct winreg_SetKeySecurity *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_SetValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_SetValue *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_data;
	const char *kwnames[] = {
		"handle", "name", "type", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_SetValue", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_type, &py_data)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_name, return false;);
	memcpy(&r->in.name, talloc_ptrtype(py_talloc_get_ptr(py_name), &r->in.name), sizeof(r->in.name));
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	r->in.data = talloc_ptrtype(r, r->in.data);
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	{
		int data_cntr_1;
		r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_Size(py_data));
		for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(py_data); data_cntr_1++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_data, data_cntr_1), return false;);
			r->in.data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(py_data, data_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.size = PyList_Size(py_data);
	return true;
}

static PyObject *unpack_py_winreg_SetValue_args_out(struct winreg_SetValue *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_InitiateSystemShutdown_args_in(PyObject *args, PyObject *kwargs, struct winreg_InitiateSystemShutdown *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winreg_InitiateSystemShutdown", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot)) {
		return false;
	}

	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		PY_CHECK_TYPE(&PyInt_Type, py_hostname, return false;);
		*r->in.hostname = PyInt_AsLong(py_hostname);
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = talloc_ptrtype(r, r->in.message);
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		r->in.message = talloc_ptrtype(py_talloc_get_ptr(py_message), r->in.message);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_timeout, return false;);
	r->in.timeout = PyInt_AsLong(py_timeout);
	PY_CHECK_TYPE(&PyInt_Type, py_force_apps, return false;);
	r->in.force_apps = PyInt_AsLong(py_force_apps);
	PY_CHECK_TYPE(&PyInt_Type, py_do_reboot, return false;);
	r->in.do_reboot = PyInt_AsLong(py_do_reboot);
	return true;
}

static PyObject *unpack_py_winreg_InitiateSystemShutdown_args_out(struct winreg_InitiateSystemShutdown *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_AbortSystemShutdown_args_in(PyObject *args, PyObject *kwargs, struct winreg_AbortSystemShutdown *r)
{
	PyObject *py_server;
	const char *kwnames[] = {
		"server", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_AbortSystemShutdown", discard_const_p(char *, kwnames), &py_server)) {
		return false;
	}

	if (py_server == Py_None) {
		r->in.server = NULL;
	} else {
		r->in.server = talloc_ptrtype(r, r->in.server);
		PY_CHECK_TYPE(&PyInt_Type, py_server, return false;);
		*r->in.server = PyInt_AsLong(py_server);
	}
	return true;
}

static PyObject *unpack_py_winreg_AbortSystemShutdown_args_out(struct winreg_AbortSystemShutdown *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_GetVersion_args_in(PyObject *args, PyObject *kwargs, struct winreg_GetVersion *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_GetVersion", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = talloc_ptrtype(py_talloc_get_ptr(py_handle), r->in.handle);
	return true;
}

static PyObject *unpack_py_winreg_GetVersion_args_out(struct winreg_GetVersion *r)
{
	PyObject *result = Py_None;
	PyObject *py_version;
	py_version = PyInt_FromLong(*r->out.version);
	result = py_version;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKCC_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCC *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCC", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCC_args_out(struct winreg_OpenHKCC *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKDD_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKDD *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKDD", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKDD_args_out(struct winreg_OpenHKDD *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_QueryMultipleValues_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryMultipleValues *r)
{
	PyObject *py_key_handle;
	PyObject *py_values;
	PyObject *py_buffer;
	const char *kwnames[] = {
		"key_handle", "values", "buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_QueryMultipleValues", discard_const_p(char *, kwnames), &py_key_handle, &py_values, &py_buffer)) {
		return false;
	}

	r->in.key_handle = talloc_ptrtype(r, r->in.key_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_key_handle, return false;);
	r->in.key_handle = talloc_ptrtype(py_talloc_get_ptr(py_key_handle), r->in.key_handle);
	r->in.values = talloc_ptrtype(r, r->in.values);
	PY_CHECK_TYPE(&PyList_Type, py_values, return false;);
	{
		int values_cntr_1;
		r->in.values = talloc_array_ptrtype(r, r->in.values, PyList_Size(py_values));
		for (values_cntr_1 = 0; values_cntr_1 < PyList_Size(py_values); values_cntr_1++) {
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GetItem(py_values, values_cntr_1), return false;);
			memcpy(&r->in.values[values_cntr_1], talloc_ptrtype(py_talloc_get_ptr(PyList_GetItem(py_values, values_cntr_1)), &r->in.values[values_cntr_1]), sizeof(r->in.values[values_cntr_1]));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_values, return false;);
	r->in.num_values = PyList_Size(py_values);
	if (py_buffer == Py_None) {
		r->in.buffer = NULL;
	} else {
		r->in.buffer = talloc_ptrtype(r, r->in.buffer);
		PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
		{
			int buffer_cntr_1;
			r->in.buffer = talloc_array_ptrtype(r, r->in.buffer, PyList_Size(py_buffer));
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_Size(py_buffer); buffer_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_buffer, buffer_cntr_1), return false;);
				r->in.buffer[buffer_cntr_1] = PyInt_AsLong(PyList_GetItem(py_buffer, buffer_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	r->in.buffer_size = talloc_ptrtype(r, r->in.buffer_size);
	*r->in.buffer_size = PyList_Size(py_buffer);
	return true;
}

static PyObject *unpack_py_winreg_QueryMultipleValues_args_out(struct winreg_QueryMultipleValues *r)
{
	PyObject *result = Py_None;
	PyObject *py_values;
	PyObject *py_buffer;
	result = PyTuple_New(2);
	py_values = PyList_New(r->in.num_values);
	if (py_values == NULL) {
		return NULL;
	}
	{
		int values_cntr_1;
		for (values_cntr_1 = 0; values_cntr_1 < r->in.num_values; values_cntr_1++) {
			PyObject *py_values_1;
			py_values_1 = py_talloc_import_ex(&QueryMultipleValue_Type, r->out.values, &r->out.values[values_cntr_1]);
			PyList_SetItem(py_values, values_cntr_1, py_values_1);
		}
	}
	PyTuple_SetItem(result, 0, py_values);
	if (r->out.buffer == NULL) {
		py_buffer = Py_None;
	} else {
		py_buffer = PyList_New(*r->out.buffer_size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < *r->out.buffer_size; buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_buffer);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_InitiateSystemShutdownEx_args_in(PyObject *args, PyObject *kwargs, struct winreg_InitiateSystemShutdownEx *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	PyObject *py_reason;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", "reason", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:winreg_InitiateSystemShutdownEx", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot, &py_reason)) {
		return false;
	}

	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		PY_CHECK_TYPE(&PyInt_Type, py_hostname, return false;);
		*r->in.hostname = PyInt_AsLong(py_hostname);
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = talloc_ptrtype(r, r->in.message);
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		r->in.message = talloc_ptrtype(py_talloc_get_ptr(py_message), r->in.message);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_timeout, return false;);
	r->in.timeout = PyInt_AsLong(py_timeout);
	PY_CHECK_TYPE(&PyInt_Type, py_force_apps, return false;);
	r->in.force_apps = PyInt_AsLong(py_force_apps);
	PY_CHECK_TYPE(&PyInt_Type, py_do_reboot, return false;);
	r->in.do_reboot = PyInt_AsLong(py_do_reboot);
	PY_CHECK_TYPE(&PyInt_Type, py_reason, return false;);
	r->in.reason = PyInt_AsLong(py_reason);
	return true;
}

static PyObject *unpack_py_winreg_InitiateSystemShutdownEx_args_out(struct winreg_InitiateSystemShutdownEx *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKPT_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPT *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPT", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPT_args_out(struct winreg_OpenHKPT *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKPN_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPN *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPN", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPN_args_out(struct winreg_OpenHKPN *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_winreg_methods[] = {
	{ "OpenHKCR", "S.OpenHKCR(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKCR, (py_data_pack_fn)pack_py_winreg_OpenHKCR_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKCR_args_out, 0, &ndr_table_winreg },
	{ "OpenHKCU", "S.OpenHKCU(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKCU, (py_data_pack_fn)pack_py_winreg_OpenHKCU_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKCU_args_out, 1, &ndr_table_winreg },
	{ "OpenHKLM", "S.OpenHKLM(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKLM, (py_data_pack_fn)pack_py_winreg_OpenHKLM_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKLM_args_out, 2, &ndr_table_winreg },
	{ "OpenHKPD", "S.OpenHKPD(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKPD, (py_data_pack_fn)pack_py_winreg_OpenHKPD_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKPD_args_out, 3, &ndr_table_winreg },
	{ "OpenHKU", "S.OpenHKU(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKU, (py_data_pack_fn)pack_py_winreg_OpenHKU_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKU_args_out, 4, &ndr_table_winreg },
	{ "CloseKey", "S.CloseKey(handle) -> handle", (dcerpc_call_fn)dcerpc_winreg_CloseKey, (py_data_pack_fn)pack_py_winreg_CloseKey_args_in, (py_data_unpack_fn)unpack_py_winreg_CloseKey_args_out, 5, &ndr_table_winreg },
	{ "CreateKey", "S.CreateKey(handle, name, keyclass, options, access_mask, secdesc, action_taken) -> (new_handle, action_taken)", (dcerpc_call_fn)dcerpc_winreg_CreateKey, (py_data_pack_fn)pack_py_winreg_CreateKey_args_in, (py_data_unpack_fn)unpack_py_winreg_CreateKey_args_out, 6, &ndr_table_winreg },
	{ "DeleteKey", "S.DeleteKey(handle, key) -> None", (dcerpc_call_fn)dcerpc_winreg_DeleteKey, (py_data_pack_fn)pack_py_winreg_DeleteKey_args_in, (py_data_unpack_fn)unpack_py_winreg_DeleteKey_args_out, 7, &ndr_table_winreg },
	{ "DeleteValue", "S.DeleteValue(handle, value) -> None", (dcerpc_call_fn)dcerpc_winreg_DeleteValue, (py_data_pack_fn)pack_py_winreg_DeleteValue_args_in, (py_data_unpack_fn)unpack_py_winreg_DeleteValue_args_out, 8, &ndr_table_winreg },
	{ "EnumKey", "S.EnumKey(handle, enum_index, name, keyclass, last_changed_time) -> (name, keyclass, last_changed_time)", (dcerpc_call_fn)dcerpc_winreg_EnumKey, (py_data_pack_fn)pack_py_winreg_EnumKey_args_in, (py_data_unpack_fn)unpack_py_winreg_EnumKey_args_out, 9, &ndr_table_winreg },
	{ "EnumValue", "S.EnumValue(handle, enum_index, name, type, value, size) -> (name, type, value, size)", (dcerpc_call_fn)dcerpc_winreg_EnumValue, (py_data_pack_fn)pack_py_winreg_EnumValue_args_in, (py_data_unpack_fn)unpack_py_winreg_EnumValue_args_out, 10, &ndr_table_winreg },
	{ "FlushKey", "S.FlushKey(handle) -> None", (dcerpc_call_fn)dcerpc_winreg_FlushKey, (py_data_pack_fn)pack_py_winreg_FlushKey_args_in, (py_data_unpack_fn)unpack_py_winreg_FlushKey_args_out, 11, &ndr_table_winreg },
	{ "GetKeySecurity", "S.GetKeySecurity(handle, sec_info, sd) -> sd", (dcerpc_call_fn)dcerpc_winreg_GetKeySecurity, (py_data_pack_fn)pack_py_winreg_GetKeySecurity_args_in, (py_data_unpack_fn)unpack_py_winreg_GetKeySecurity_args_out, 12, &ndr_table_winreg },
	{ "LoadKey", "S.LoadKey(handle, keyname, filename) -> None", (dcerpc_call_fn)dcerpc_winreg_LoadKey, (py_data_pack_fn)pack_py_winreg_LoadKey_args_in, (py_data_unpack_fn)unpack_py_winreg_LoadKey_args_out, 13, &ndr_table_winreg },
	{ "NotifyChangeKeyValue", "S.NotifyChangeKeyValue(handle, watch_subtree, notify_filter, unknown, string1, string2, unknown2) -> None", (dcerpc_call_fn)dcerpc_winreg_NotifyChangeKeyValue, (py_data_pack_fn)pack_py_winreg_NotifyChangeKeyValue_args_in, (py_data_unpack_fn)unpack_py_winreg_NotifyChangeKeyValue_args_out, 14, &ndr_table_winreg },
	{ "OpenKey", "S.OpenKey(parent_handle, keyname, unknown, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenKey, (py_data_pack_fn)pack_py_winreg_OpenKey_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenKey_args_out, 15, &ndr_table_winreg },
	{ "QueryInfoKey", "S.QueryInfoKey(handle, classname) -> (classname, num_subkeys, max_subkeylen, max_classlen, num_values, max_valnamelen, max_valbufsize, secdescsize, last_changed_time)", (dcerpc_call_fn)dcerpc_winreg_QueryInfoKey, (py_data_pack_fn)pack_py_winreg_QueryInfoKey_args_in, (py_data_unpack_fn)unpack_py_winreg_QueryInfoKey_args_out, 16, &ndr_table_winreg },
	{ "QueryValue", "S.QueryValue(handle, value_name, type, data, data_size) -> (type, data, data_size)", (dcerpc_call_fn)dcerpc_winreg_QueryValue, (py_data_pack_fn)pack_py_winreg_QueryValue_args_in, (py_data_unpack_fn)unpack_py_winreg_QueryValue_args_out, 17, &ndr_table_winreg },
	{ "ReplaceKey", NULL, (dcerpc_call_fn)dcerpc_winreg_ReplaceKey, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 18, &ndr_table_winreg },
	{ "RestoreKey", "S.RestoreKey(handle, filename, flags) -> None", (dcerpc_call_fn)dcerpc_winreg_RestoreKey, (py_data_pack_fn)pack_py_winreg_RestoreKey_args_in, (py_data_unpack_fn)unpack_py_winreg_RestoreKey_args_out, 19, &ndr_table_winreg },
	{ "SaveKey", "S.SaveKey(handle, filename, sec_attrib) -> None", (dcerpc_call_fn)dcerpc_winreg_SaveKey, (py_data_pack_fn)pack_py_winreg_SaveKey_args_in, (py_data_unpack_fn)unpack_py_winreg_SaveKey_args_out, 20, &ndr_table_winreg },
	{ "SetKeySecurity", "S.SetKeySecurity(handle, sec_info, sd) -> None", (dcerpc_call_fn)dcerpc_winreg_SetKeySecurity, (py_data_pack_fn)pack_py_winreg_SetKeySecurity_args_in, (py_data_unpack_fn)unpack_py_winreg_SetKeySecurity_args_out, 21, &ndr_table_winreg },
	{ "SetValue", "S.SetValue(handle, name, type, data) -> None", (dcerpc_call_fn)dcerpc_winreg_SetValue, (py_data_pack_fn)pack_py_winreg_SetValue_args_in, (py_data_unpack_fn)unpack_py_winreg_SetValue_args_out, 22, &ndr_table_winreg },
	{ "UnLoadKey", NULL, (dcerpc_call_fn)dcerpc_winreg_UnLoadKey, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 23, &ndr_table_winreg },
	{ "InitiateSystemShutdown", "S.InitiateSystemShutdown(hostname, message, timeout, force_apps, do_reboot) -> None", (dcerpc_call_fn)dcerpc_winreg_InitiateSystemShutdown, (py_data_pack_fn)pack_py_winreg_InitiateSystemShutdown_args_in, (py_data_unpack_fn)unpack_py_winreg_InitiateSystemShutdown_args_out, 24, &ndr_table_winreg },
	{ "AbortSystemShutdown", "S.AbortSystemShutdown(server) -> None", (dcerpc_call_fn)dcerpc_winreg_AbortSystemShutdown, (py_data_pack_fn)pack_py_winreg_AbortSystemShutdown_args_in, (py_data_unpack_fn)unpack_py_winreg_AbortSystemShutdown_args_out, 25, &ndr_table_winreg },
	{ "GetVersion", "S.GetVersion(handle) -> version", (dcerpc_call_fn)dcerpc_winreg_GetVersion, (py_data_pack_fn)pack_py_winreg_GetVersion_args_in, (py_data_unpack_fn)unpack_py_winreg_GetVersion_args_out, 26, &ndr_table_winreg },
	{ "OpenHKCC", "S.OpenHKCC(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKCC, (py_data_pack_fn)pack_py_winreg_OpenHKCC_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKCC_args_out, 27, &ndr_table_winreg },
	{ "OpenHKDD", "S.OpenHKDD(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKDD, (py_data_pack_fn)pack_py_winreg_OpenHKDD_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKDD_args_out, 28, &ndr_table_winreg },
	{ "QueryMultipleValues", "S.QueryMultipleValues(key_handle, values, buffer) -> (values, buffer)", (dcerpc_call_fn)dcerpc_winreg_QueryMultipleValues, (py_data_pack_fn)pack_py_winreg_QueryMultipleValues_args_in, (py_data_unpack_fn)unpack_py_winreg_QueryMultipleValues_args_out, 29, &ndr_table_winreg },
	{ "InitiateSystemShutdownEx", "S.InitiateSystemShutdownEx(hostname, message, timeout, force_apps, do_reboot, reason) -> None", (dcerpc_call_fn)dcerpc_winreg_InitiateSystemShutdownEx, (py_data_pack_fn)pack_py_winreg_InitiateSystemShutdownEx_args_in, (py_data_unpack_fn)unpack_py_winreg_InitiateSystemShutdownEx_args_out, 30, &ndr_table_winreg },
	{ "SaveKeyEx", NULL, (dcerpc_call_fn)dcerpc_winreg_SaveKeyEx, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 31, &ndr_table_winreg },
	{ "OpenHKPT", "S.OpenHKPT(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKPT, (py_data_pack_fn)pack_py_winreg_OpenHKPT_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKPT_args_out, 32, &ndr_table_winreg },
	{ "OpenHKPN", "S.OpenHKPN(system_name, access_mask) -> handle", (dcerpc_call_fn)dcerpc_winreg_OpenHKPN, (py_data_pack_fn)pack_py_winreg_OpenHKPN_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKPN_args_out, 33, &ndr_table_winreg },
	{ "QueryMultipleValues2", NULL, (dcerpc_call_fn)dcerpc_winreg_QueryMultipleValues2, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 34, &ndr_table_winreg },
	{ NULL }
};

static PyObject *interface_winreg_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_winreg);
}

#define PY_DOC_WINREG "Remote Registry Service"
static PyTypeObject winreg_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.winreg",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "winreg(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_WINREG,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_winreg_new,
};

static PyMethodDef winreg_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initwinreg(void)
{
	PyObject *m;
	PyObject *dep_lsa;
	PyObject *dep_security;
	PyObject *dep_misc;

	dep_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_lsa == NULL)
		return;

	dep_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_security == NULL)
		return;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	lsa_StringLarge_Type = (PyTypeObject *)PyObject_GetAttrString(dep_lsa, "StringLarge");
	if (lsa_StringLarge_Type == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	if (PyType_Ready(&winreg_String_Type) < 0)
		return;
	if (PyType_Ready(&KeySecurityData_Type) < 0)
		return;
	if (PyType_Ready(&winreg_SecBuf_Type) < 0)
		return;
	if (PyType_Ready(&winreg_StringBuf_Type) < 0)
		return;
	if (PyType_Ready(&winreg_ValNameBuf_Type) < 0)
		return;
	if (PyType_Ready(&KeySecurityAttribute_Type) < 0)
		return;
	if (PyType_Ready(&QueryMultipleValue_Type) < 0)
		return;
	if (PyType_Ready(&winreg_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&winreg_InterfaceType, py_ndr_winreg_methods))
		return;

#ifdef PY_STRING_PATCH
	PY_STRING_PATCH(&winreg_String_Type);
#endif
#ifdef PY_KEYSECURITYDATA_PATCH
	PY_KEYSECURITYDATA_PATCH(&KeySecurityData_Type);
#endif
#ifdef PY_SECBUF_PATCH
	PY_SECBUF_PATCH(&winreg_SecBuf_Type);
#endif
#ifdef PY_STRINGBUF_PATCH
	PY_STRINGBUF_PATCH(&winreg_StringBuf_Type);
#endif
#ifdef PY_VALNAMEBUF_PATCH
	PY_VALNAMEBUF_PATCH(&winreg_ValNameBuf_Type);
#endif
#ifdef PY_KEYSECURITYATTRIBUTE_PATCH
	PY_KEYSECURITYATTRIBUTE_PATCH(&KeySecurityAttribute_Type);
#endif
#ifdef PY_QUERYMULTIPLEVALUE_PATCH
	PY_QUERYMULTIPLEVALUE_PATCH(&QueryMultipleValue_Type);
#endif
#ifdef PY_WINREG_PATCH
	PY_WINREG_PATCH(&winreg_InterfaceType);
#endif

	m = Py_InitModule3("winreg", winreg_methods, "winreg DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "KEY_QUERY_VALUE", PyInt_FromLong(KEY_QUERY_VALUE));
	PyModule_AddObject(m, "KEY_WOW64_32KEY", PyInt_FromLong(KEY_WOW64_32KEY));
	PyModule_AddObject(m, "KEY_NOTIFY", PyInt_FromLong(KEY_NOTIFY));
	PyModule_AddObject(m, "REG_ACTION_NONE", PyInt_FromLong(REG_ACTION_NONE));
	PyModule_AddObject(m, "REG_SZ", PyInt_FromLong(REG_SZ));
	PyModule_AddObject(m, "KEY_ENUMERATE_SUB_KEYS", PyInt_FromLong(KEY_ENUMERATE_SUB_KEYS));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_ATTRIBUTES", PyInt_FromLong(REG_NOTIFY_CHANGE_ATTRIBUTES));
	PyModule_AddObject(m, "REG_OPENED_EXISTING_KEY", PyInt_FromLong(REG_OPENED_EXISTING_KEY));
	PyModule_AddObject(m, "REG_EXPAND_SZ", PyInt_FromLong(REG_EXPAND_SZ));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_SECURITY", PyInt_FromLong(REG_NOTIFY_CHANGE_SECURITY));
	PyModule_AddObject(m, "KEY_CREATE_LINK", PyInt_FromLong(KEY_CREATE_LINK));
	PyModule_AddObject(m, "REG_RESOURCE_REQUIREMENTS_LIST", PyInt_FromLong(REG_RESOURCE_REQUIREMENTS_LIST));
	PyModule_AddObject(m, "REG_FULL_RESOURCE_DESCRIPTOR", PyInt_FromLong(REG_FULL_RESOURCE_DESCRIPTOR));
	PyModule_AddObject(m, "REG_BINARY", PyInt_FromLong(REG_BINARY));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_LAST_SET", PyInt_FromLong(REG_NOTIFY_CHANGE_LAST_SET));
	PyModule_AddObject(m, "KEY_CREATE_SUB_KEY", PyInt_FromLong(KEY_CREATE_SUB_KEY));
	PyModule_AddObject(m, "KEY_SET_VALUE", PyInt_FromLong(KEY_SET_VALUE));
	PyModule_AddObject(m, "REG_CREATED_NEW_KEY", PyInt_FromLong(REG_CREATED_NEW_KEY));
	PyModule_AddObject(m, "REG_RESOURCE_LIST", PyInt_FromLong(REG_RESOURCE_LIST));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_NAME", PyInt_FromLong(REG_NOTIFY_CHANGE_NAME));
	PyModule_AddObject(m, "KEY_WOW64_64KEY", PyInt_FromLong(KEY_WOW64_64KEY));
	PyModule_AddObject(m, "REG_DWORD", PyInt_FromLong(REG_DWORD));
	PyModule_AddObject(m, "REG_MULTI_SZ", PyInt_FromLong(REG_MULTI_SZ));
	PyModule_AddObject(m, "REG_DWORD_BIG_ENDIAN", PyInt_FromLong(REG_DWORD_BIG_ENDIAN));
	PyModule_AddObject(m, "REG_QWORD", PyInt_FromLong(REG_QWORD));
	PyModule_AddObject(m, "REG_LINK", PyInt_FromLong(REG_LINK));
	PyModule_AddObject(m, "REG_NONE", PyInt_FromLong(REG_NONE));
	Py_INCREF((PyObject *)&winreg_String_Type);
	PyModule_AddObject(m, "String", (PyObject *)&winreg_String_Type);
	Py_INCREF((PyObject *)&KeySecurityData_Type);
	PyModule_AddObject(m, "KeySecurityData", (PyObject *)&KeySecurityData_Type);
	Py_INCREF((PyObject *)&winreg_SecBuf_Type);
	PyModule_AddObject(m, "SecBuf", (PyObject *)&winreg_SecBuf_Type);
	Py_INCREF((PyObject *)&winreg_StringBuf_Type);
	PyModule_AddObject(m, "StringBuf", (PyObject *)&winreg_StringBuf_Type);
	Py_INCREF((PyObject *)&winreg_ValNameBuf_Type);
	PyModule_AddObject(m, "ValNameBuf", (PyObject *)&winreg_ValNameBuf_Type);
	Py_INCREF((PyObject *)&KeySecurityAttribute_Type);
	PyModule_AddObject(m, "KeySecurityAttribute", (PyObject *)&KeySecurityAttribute_Type);
	Py_INCREF((PyObject *)&QueryMultipleValue_Type);
	PyModule_AddObject(m, "QueryMultipleValue", (PyObject *)&QueryMultipleValue_Type);
	Py_INCREF((PyObject *)&winreg_InterfaceType);
	PyModule_AddObject(m, "winreg", (PyObject *)&winreg_InterfaceType);
#ifdef PY_MOD_WINREG_PATCH
	PY_MOD_WINREG_PATCH(m);
#endif

}
