
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_unixinfo.h"
#include "../librpc/gen_ndr/ndr_unixinfo_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject unixinfo_GetPWUidInfo_Type;
staticforward PyTypeObject unixinfo_InterfaceType;

static PyTypeObject *dom_sid_Type;

static PyObject *py_unixinfo_GetPWUidInfo_get_status(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = (struct unixinfo_GetPWUidInfo *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_unixinfo_GetPWUidInfo_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = (struct unixinfo_GetPWUidInfo *)py_talloc_get_ptr(py_obj);
	object->status = NT_STATUS(PyInt_AsLong(value));
	return 0;
}

static PyObject *py_unixinfo_GetPWUidInfo_get_homedir(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = (struct unixinfo_GetPWUidInfo *)py_talloc_get_ptr(obj);
	PyObject *py_homedir;
	py_homedir = PyUnicode_Decode(object->homedir, strlen(object->homedir), "utf-8", "ignore");
	return py_homedir;
}

static int py_unixinfo_GetPWUidInfo_set_homedir(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = (struct unixinfo_GetPWUidInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->homedir = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_unixinfo_GetPWUidInfo_get_shell(PyObject *obj, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = (struct unixinfo_GetPWUidInfo *)py_talloc_get_ptr(obj);
	PyObject *py_shell;
	py_shell = PyUnicode_Decode(object->shell, strlen(object->shell), "utf-8", "ignore");
	return py_shell;
}

static int py_unixinfo_GetPWUidInfo_set_shell(PyObject *py_obj, PyObject *value, void *closure)
{
	struct unixinfo_GetPWUidInfo *object = (struct unixinfo_GetPWUidInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->shell = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyGetSetDef py_unixinfo_GetPWUidInfo_getsetters[] = {
	{ discard_const_p(char, "status"), py_unixinfo_GetPWUidInfo_get_status, py_unixinfo_GetPWUidInfo_set_status },
	{ discard_const_p(char, "homedir"), py_unixinfo_GetPWUidInfo_get_homedir, py_unixinfo_GetPWUidInfo_set_homedir },
	{ discard_const_p(char, "shell"), py_unixinfo_GetPWUidInfo_get_shell, py_unixinfo_GetPWUidInfo_set_shell },
	{ NULL }
};

static PyObject *py_unixinfo_GetPWUidInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct unixinfo_GetPWUidInfo, type);
}


static PyTypeObject unixinfo_GetPWUidInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "unixinfo.GetPWUidInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_unixinfo_GetPWUidInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_unixinfo_GetPWUidInfo_new,
};


static bool pack_py_unixinfo_SidToUid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_SidToUid *r)
{
	PyObject *py_sid;
	const char *kwnames[] = {
		"sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_SidToUid", discard_const_p(char *, kwnames), &py_sid)) {
		return false;
	}

	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	memcpy(&r->in.sid, talloc_ptrtype(py_talloc_get_ptr(py_sid), &r->in.sid), sizeof(r->in.sid));
	return true;
}

static PyObject *unpack_py_unixinfo_SidToUid_args_out(struct unixinfo_SidToUid *r)
{
	PyObject *result = Py_None;
	PyObject *py_uid;
	py_uid = PyInt_FromLong(*r->out.uid);
	result = py_uid;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_unixinfo_UidToSid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_UidToSid *r)
{
	PyObject *py_uid;
	const char *kwnames[] = {
		"uid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_UidToSid", discard_const_p(char *, kwnames), &py_uid)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_uid, return false;);
	r->in.uid = PyInt_AsLong(py_uid);
	return true;
}

static PyObject *unpack_py_unixinfo_UidToSid_args_out(struct unixinfo_UidToSid *r)
{
	PyObject *result = Py_None;
	PyObject *py_sid;
	py_sid = py_talloc_import_ex(dom_sid_Type, r->out.sid, r->out.sid);
	result = py_sid;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_unixinfo_SidToGid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_SidToGid *r)
{
	PyObject *py_sid;
	const char *kwnames[] = {
		"sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_SidToGid", discard_const_p(char *, kwnames), &py_sid)) {
		return false;
	}

	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	memcpy(&r->in.sid, talloc_ptrtype(py_talloc_get_ptr(py_sid), &r->in.sid), sizeof(r->in.sid));
	return true;
}

static PyObject *unpack_py_unixinfo_SidToGid_args_out(struct unixinfo_SidToGid *r)
{
	PyObject *result = Py_None;
	PyObject *py_gid;
	py_gid = PyInt_FromLong(*r->out.gid);
	result = py_gid;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_unixinfo_GidToSid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_GidToSid *r)
{
	PyObject *py_gid;
	const char *kwnames[] = {
		"gid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_GidToSid", discard_const_p(char *, kwnames), &py_gid)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_gid, return false;);
	r->in.gid = PyInt_AsLong(py_gid);
	return true;
}

static PyObject *unpack_py_unixinfo_GidToSid_args_out(struct unixinfo_GidToSid *r)
{
	PyObject *result = Py_None;
	PyObject *py_sid;
	py_sid = py_talloc_import_ex(dom_sid_Type, r->out.sid, r->out.sid);
	result = py_sid;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_unixinfo_GetPWUid_args_in(PyObject *args, PyObject *kwargs, struct unixinfo_GetPWUid *r)
{
	PyObject *py_uids;
	const char *kwnames[] = {
		"uids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:unixinfo_GetPWUid", discard_const_p(char *, kwnames), &py_uids)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_uids, return false;);
	r->in.count = talloc_ptrtype(r, r->in.count);
	*r->in.count = PyList_Size(py_uids);
	PY_CHECK_TYPE(&PyList_Type, py_uids, return false;);
	{
		int uids_cntr_0;
		r->in.uids = talloc_array_ptrtype(r, r->in.uids, PyList_Size(py_uids));
		for (uids_cntr_0 = 0; uids_cntr_0 < PyList_Size(py_uids); uids_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_uids, uids_cntr_0), return false;);
			r->in.uids[uids_cntr_0] = PyInt_AsLong(PyList_GetItem(py_uids, uids_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_unixinfo_GetPWUid_args_out(struct unixinfo_GetPWUid *r)
{
	PyObject *result = Py_None;
	PyObject *py_infos;
	py_infos = PyList_New(*r->out.count);
	if (py_infos == NULL) {
		return NULL;
	}
	{
		int infos_cntr_0;
		for (infos_cntr_0 = 0; infos_cntr_0 < *r->out.count; infos_cntr_0++) {
			PyObject *py_infos_0;
			py_infos_0 = py_talloc_import_ex(&unixinfo_GetPWUidInfo_Type, r->out.infos, &r->out.infos[infos_cntr_0]);
			PyList_SetItem(py_infos, infos_cntr_0, py_infos_0);
		}
	}
	result = py_infos;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_unixinfo_methods[] = {
	{ "SidToUid", "S.SidToUid(sid) -> uid", (dcerpc_call_fn)dcerpc_unixinfo_SidToUid, (py_data_pack_fn)pack_py_unixinfo_SidToUid_args_in, (py_data_unpack_fn)unpack_py_unixinfo_SidToUid_args_out, 0, &ndr_table_unixinfo },
	{ "UidToSid", "S.UidToSid(uid) -> sid", (dcerpc_call_fn)dcerpc_unixinfo_UidToSid, (py_data_pack_fn)pack_py_unixinfo_UidToSid_args_in, (py_data_unpack_fn)unpack_py_unixinfo_UidToSid_args_out, 1, &ndr_table_unixinfo },
	{ "SidToGid", "S.SidToGid(sid) -> gid", (dcerpc_call_fn)dcerpc_unixinfo_SidToGid, (py_data_pack_fn)pack_py_unixinfo_SidToGid_args_in, (py_data_unpack_fn)unpack_py_unixinfo_SidToGid_args_out, 2, &ndr_table_unixinfo },
	{ "GidToSid", "S.GidToSid(gid) -> sid", (dcerpc_call_fn)dcerpc_unixinfo_GidToSid, (py_data_pack_fn)pack_py_unixinfo_GidToSid_args_in, (py_data_unpack_fn)unpack_py_unixinfo_GidToSid_args_out, 3, &ndr_table_unixinfo },
	{ "GetPWUid", "S.GetPWUid(uids) -> infos", (dcerpc_call_fn)dcerpc_unixinfo_GetPWUid, (py_data_pack_fn)pack_py_unixinfo_GetPWUid_args_in, (py_data_unpack_fn)unpack_py_unixinfo_GetPWUid_args_out, 4, &ndr_table_unixinfo },
	{ NULL }
};

static PyObject *interface_unixinfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_unixinfo);
}

#define PY_DOC_UNIXINFO "Unixinfo specific stuff"
static PyTypeObject unixinfo_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "unixinfo.unixinfo",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "unixinfo(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_UNIXINFO,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_unixinfo_new,
};

static PyMethodDef unixinfo_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initunixinfo(void)
{
	PyObject *m;
	PyObject *dep_security;

	dep_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_security == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	if (PyType_Ready(&unixinfo_GetPWUidInfo_Type) < 0)
		return;
	if (PyType_Ready(&unixinfo_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&unixinfo_InterfaceType, py_ndr_unixinfo_methods))
		return;

#ifdef PY_GETPWUIDINFO_PATCH
	PY_GETPWUIDINFO_PATCH(&unixinfo_GetPWUidInfo_Type);
#endif
#ifdef PY_UNIXINFO_PATCH
	PY_UNIXINFO_PATCH(&unixinfo_InterfaceType);
#endif

	m = Py_InitModule3("unixinfo", unixinfo_methods, "unixinfo DCE/RPC");
	if (m == NULL)
		return;

	Py_INCREF((PyObject *)&unixinfo_GetPWUidInfo_Type);
	PyModule_AddObject(m, "GetPWUidInfo", (PyObject *)&unixinfo_GetPWUidInfo_Type);
	Py_INCREF((PyObject *)&unixinfo_InterfaceType);
	PyModule_AddObject(m, "unixinfo", (PyObject *)&unixinfo_InterfaceType);
#ifdef PY_MOD_UNIXINFO_PATCH
	PY_MOD_UNIXINFO_PATCH(m);
#endif

}
