
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_oxidresolver.h"
#include "../librpc/gen_ndr/ndr_oxidresolver_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/orpc.h"
staticforward PyTypeObject COMINFO_Type;
staticforward PyTypeObject IOXIDResolver_InterfaceType;

static PyTypeObject *DUALSTRINGARRAY_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *COMVERSION_Type;

static PyObject *py_COMINFO_get_version(PyObject *obj, void *closure)
{
	struct COMINFO *object = (struct COMINFO *)py_talloc_get_ptr(obj);
	PyObject *py_version;
	py_version = py_talloc_import_ex(COMVERSION_Type, py_talloc_get_mem_ctx(obj), &object->version);
	return py_version;
}

static int py_COMINFO_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct COMINFO *object = (struct COMINFO *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(COMVERSION_Type, value, return -1;);
	memcpy(&object->version, talloc_ptrtype(py_talloc_get_ptr(value), &object->version), sizeof(object->version));
	return 0;
}

static PyObject *py_COMINFO_get_unknown1(PyObject *obj, void *closure)
{
	struct COMINFO *object = (struct COMINFO *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_COMINFO_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct COMINFO *object = (struct COMINFO *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_COMINFO_getsetters[] = {
	{ discard_const_p(char, "version"), py_COMINFO_get_version, py_COMINFO_set_version },
	{ discard_const_p(char, "unknown1"), py_COMINFO_get_unknown1, py_COMINFO_set_unknown1 },
	{ NULL }
};

static PyObject *py_COMINFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct COMINFO, type);
}


static PyTypeObject COMINFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "oxidresolver.COMINFO",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_COMINFO_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_COMINFO_new,
};


static bool pack_py_ResolveOxid_args_in(PyObject *args, PyObject *kwargs, struct ResolveOxid *r)
{
	PyObject *py_pOxid;
	PyObject *py_arRequestedProtseqs;
	const char *kwnames[] = {
		"pOxid", "arRequestedProtseqs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:ResolveOxid", discard_const_p(char *, kwnames), &py_pOxid, &py_arRequestedProtseqs)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_pOxid, return false;);
	r->in.pOxid = PyInt_AsLong(py_pOxid);
	PY_CHECK_TYPE(&PyList_Type, py_arRequestedProtseqs, return false;);
	r->in.cRequestedProtseqs = PyList_Size(py_arRequestedProtseqs);
	PY_CHECK_TYPE(&PyList_Type, py_arRequestedProtseqs, return false;);
	{
		int arRequestedProtseqs_cntr_0;
		r->in.arRequestedProtseqs = talloc_array_ptrtype(r, r->in.arRequestedProtseqs, PyList_Size(py_arRequestedProtseqs));
		for (arRequestedProtseqs_cntr_0 = 0; arRequestedProtseqs_cntr_0 < PyList_Size(py_arRequestedProtseqs); arRequestedProtseqs_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_arRequestedProtseqs, arRequestedProtseqs_cntr_0), return false;);
			r->in.arRequestedProtseqs[arRequestedProtseqs_cntr_0] = PyInt_AsLong(PyList_GetItem(py_arRequestedProtseqs, arRequestedProtseqs_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_ResolveOxid_args_out(struct ResolveOxid *r)
{
	PyObject *result = Py_None;
	PyObject *py_ppdsaOxidBindings;
	PyObject *py_pipidRemUnknown;
	PyObject *py_pAuthnHint;
	result = PyTuple_New(3);
	if (*r->out.ppdsaOxidBindings == NULL) {
		py_ppdsaOxidBindings = Py_None;
	} else {
		py_ppdsaOxidBindings = py_talloc_import_ex(DUALSTRINGARRAY_Type, *r->out.ppdsaOxidBindings, *r->out.ppdsaOxidBindings);
	}
	PyTuple_SetItem(result, 0, py_ppdsaOxidBindings);
	py_pipidRemUnknown = py_talloc_import_ex(GUID_Type, r->out.pipidRemUnknown, r->out.pipidRemUnknown);
	PyTuple_SetItem(result, 1, py_pipidRemUnknown);
	py_pAuthnHint = PyInt_FromLong(*r->out.pAuthnHint);
	PyTuple_SetItem(result, 2, py_pAuthnHint);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_SimplePing_args_in(PyObject *args, PyObject *kwargs, struct SimplePing *r)
{
	PyObject *py_SetId;
	const char *kwnames[] = {
		"SetId", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:SimplePing", discard_const_p(char *, kwnames), &py_SetId)) {
		return false;
	}

	r->in.SetId = talloc_ptrtype(r, r->in.SetId);
	PY_CHECK_TYPE(&PyInt_Type, py_SetId, return false;);
	*r->in.SetId = PyInt_AsLong(py_SetId);
	return true;
}

static PyObject *unpack_py_SimplePing_args_out(struct SimplePing *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ComplexPing_args_in(PyObject *args, PyObject *kwargs, struct ComplexPing *r)
{
	PyObject *py_SetId;
	PyObject *py_SequenceNum;
	PyObject *py_AddToSet;
	PyObject *py_DelFromSet;
	const char *kwnames[] = {
		"SetId", "SequenceNum", "AddToSet", "DelFromSet", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:ComplexPing", discard_const_p(char *, kwnames), &py_SetId, &py_SequenceNum, &py_AddToSet, &py_DelFromSet)) {
		return false;
	}

	r->in.SetId = talloc_ptrtype(r, r->in.SetId);
	PY_CHECK_TYPE(&PyInt_Type, py_SetId, return false;);
	*r->in.SetId = PyInt_AsLong(py_SetId);
	PY_CHECK_TYPE(&PyInt_Type, py_SequenceNum, return false;);
	r->in.SequenceNum = PyInt_AsLong(py_SequenceNum);
	PY_CHECK_TYPE(&PyList_Type, py_AddToSet, return false;);
	r->in.cAddToSet = PyList_Size(py_AddToSet);
	PY_CHECK_TYPE(&PyList_Type, py_DelFromSet, return false;);
	r->in.cDelFromSet = PyList_Size(py_DelFromSet);
	PY_CHECK_TYPE(&PyList_Type, py_AddToSet, return false;);
	{
		int AddToSet_cntr_0;
		r->in.AddToSet = talloc_array_ptrtype(r, r->in.AddToSet, PyList_Size(py_AddToSet));
		for (AddToSet_cntr_0 = 0; AddToSet_cntr_0 < PyList_Size(py_AddToSet); AddToSet_cntr_0++) {
			PY_CHECK_TYPE(GUID_Type, PyList_GetItem(py_AddToSet, AddToSet_cntr_0), return false;);
			memcpy(&r->in.AddToSet[AddToSet_cntr_0], talloc_ptrtype(py_talloc_get_ptr(PyList_GetItem(py_AddToSet, AddToSet_cntr_0)), &r->in.AddToSet[AddToSet_cntr_0]), sizeof(r->in.AddToSet[AddToSet_cntr_0]));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_DelFromSet, return false;);
	{
		int DelFromSet_cntr_0;
		r->in.DelFromSet = talloc_array_ptrtype(r, r->in.DelFromSet, PyList_Size(py_DelFromSet));
		for (DelFromSet_cntr_0 = 0; DelFromSet_cntr_0 < PyList_Size(py_DelFromSet); DelFromSet_cntr_0++) {
			PY_CHECK_TYPE(GUID_Type, PyList_GetItem(py_DelFromSet, DelFromSet_cntr_0), return false;);
			memcpy(&r->in.DelFromSet[DelFromSet_cntr_0], talloc_ptrtype(py_talloc_get_ptr(PyList_GetItem(py_DelFromSet, DelFromSet_cntr_0)), &r->in.DelFromSet[DelFromSet_cntr_0]), sizeof(r->in.DelFromSet[DelFromSet_cntr_0]));
		}
	}
	return true;
}

static PyObject *unpack_py_ComplexPing_args_out(struct ComplexPing *r)
{
	PyObject *result = Py_None;
	PyObject *py_SetId;
	PyObject *py_PingBackoffFactor;
	result = PyTuple_New(2);
	py_SetId = PyInt_FromLong(*r->out.SetId);
	PyTuple_SetItem(result, 0, py_SetId);
	py_PingBackoffFactor = PyInt_FromLong(*r->out.PingBackoffFactor);
	PyTuple_SetItem(result, 1, py_PingBackoffFactor);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ServerAlive_args_in(PyObject *args, PyObject *kwargs, struct ServerAlive *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":ServerAlive", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_ServerAlive_args_out(struct ServerAlive *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ResolveOxid2_args_in(PyObject *args, PyObject *kwargs, struct ResolveOxid2 *r)
{
	PyObject *py_pOxid;
	PyObject *py_arRequestedProtseqs;
	const char *kwnames[] = {
		"pOxid", "arRequestedProtseqs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:ResolveOxid2", discard_const_p(char *, kwnames), &py_pOxid, &py_arRequestedProtseqs)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_pOxid, return false;);
	r->in.pOxid = PyInt_AsLong(py_pOxid);
	PY_CHECK_TYPE(&PyList_Type, py_arRequestedProtseqs, return false;);
	r->in.cRequestedProtseqs = PyList_Size(py_arRequestedProtseqs);
	PY_CHECK_TYPE(&PyList_Type, py_arRequestedProtseqs, return false;);
	{
		int arRequestedProtseqs_cntr_0;
		r->in.arRequestedProtseqs = talloc_array_ptrtype(r, r->in.arRequestedProtseqs, PyList_Size(py_arRequestedProtseqs));
		for (arRequestedProtseqs_cntr_0 = 0; arRequestedProtseqs_cntr_0 < PyList_Size(py_arRequestedProtseqs); arRequestedProtseqs_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_arRequestedProtseqs, arRequestedProtseqs_cntr_0), return false;);
			r->in.arRequestedProtseqs[arRequestedProtseqs_cntr_0] = PyInt_AsLong(PyList_GetItem(py_arRequestedProtseqs, arRequestedProtseqs_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_ResolveOxid2_args_out(struct ResolveOxid2 *r)
{
	PyObject *result = Py_None;
	PyObject *py_pdsaOxidBindings;
	PyObject *py_ipidRemUnknown;
	PyObject *py_AuthnHint;
	PyObject *py_ComVersion;
	result = PyTuple_New(4);
	if (*r->out.pdsaOxidBindings == NULL) {
		py_pdsaOxidBindings = Py_None;
	} else {
		py_pdsaOxidBindings = py_talloc_import_ex(DUALSTRINGARRAY_Type, *r->out.pdsaOxidBindings, *r->out.pdsaOxidBindings);
	}
	PyTuple_SetItem(result, 0, py_pdsaOxidBindings);
	py_ipidRemUnknown = py_talloc_import_ex(GUID_Type, r->out.ipidRemUnknown, r->out.ipidRemUnknown);
	PyTuple_SetItem(result, 1, py_ipidRemUnknown);
	py_AuthnHint = PyInt_FromLong(*r->out.AuthnHint);
	PyTuple_SetItem(result, 2, py_AuthnHint);
	py_ComVersion = py_talloc_import_ex(COMVERSION_Type, r->out.ComVersion, r->out.ComVersion);
	PyTuple_SetItem(result, 3, py_ComVersion);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ServerAlive2_args_in(PyObject *args, PyObject *kwargs, struct ServerAlive2 *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":ServerAlive2", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_ServerAlive2_args_out(struct ServerAlive2 *r)
{
	PyObject *result = Py_None;
	PyObject *py_info;
	PyObject *py_dualstring;
	PyObject *py_unknown2;
	PyObject *py_unknown3;
	PyObject *py_unknown4;
	result = PyTuple_New(5);
	py_info = py_talloc_import_ex(&COMINFO_Type, r->out.info, r->out.info);
	PyTuple_SetItem(result, 0, py_info);
	py_dualstring = py_talloc_import_ex(DUALSTRINGARRAY_Type, r->out.dualstring, r->out.dualstring);
	PyTuple_SetItem(result, 1, py_dualstring);
	py_unknown2 = PyInt_FromLong(*r->out.unknown2);
	PyTuple_SetItem(result, 2, py_unknown2);
	py_unknown3 = PyInt_FromLong(*r->out.unknown3);
	PyTuple_SetItem(result, 3, py_unknown3);
	py_unknown4 = PyInt_FromLong(*r->out.unknown4);
	PyTuple_SetItem(result, 4, py_unknown4);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IOXIDResolver_methods[] = {
	{ "ResolveOxid", "S.ResolveOxid(pOxid, arRequestedProtseqs) -> (ppdsaOxidBindings, pipidRemUnknown, pAuthnHint)", (dcerpc_call_fn)dcerpc_ResolveOxid, (py_data_pack_fn)pack_py_ResolveOxid_args_in, (py_data_unpack_fn)unpack_py_ResolveOxid_args_out, 0, &ndr_table_IOXIDResolver },
	{ "SimplePing", "S.SimplePing(SetId) -> None", (dcerpc_call_fn)dcerpc_SimplePing, (py_data_pack_fn)pack_py_SimplePing_args_in, (py_data_unpack_fn)unpack_py_SimplePing_args_out, 1, &ndr_table_IOXIDResolver },
	{ "ComplexPing", "S.ComplexPing(SetId, SequenceNum, AddToSet, DelFromSet) -> (SetId, PingBackoffFactor)", (dcerpc_call_fn)dcerpc_ComplexPing, (py_data_pack_fn)pack_py_ComplexPing_args_in, (py_data_unpack_fn)unpack_py_ComplexPing_args_out, 2, &ndr_table_IOXIDResolver },
	{ "ServerAlive", "S.ServerAlive() -> None", (dcerpc_call_fn)dcerpc_ServerAlive, (py_data_pack_fn)pack_py_ServerAlive_args_in, (py_data_unpack_fn)unpack_py_ServerAlive_args_out, 3, &ndr_table_IOXIDResolver },
	{ "ResolveOxid2", "S.ResolveOxid2(pOxid, arRequestedProtseqs) -> (pdsaOxidBindings, ipidRemUnknown, AuthnHint, ComVersion)", (dcerpc_call_fn)dcerpc_ResolveOxid2, (py_data_pack_fn)pack_py_ResolveOxid2_args_in, (py_data_unpack_fn)unpack_py_ResolveOxid2_args_out, 4, &ndr_table_IOXIDResolver },
	{ "ServerAlive2", "S.ServerAlive2() -> (info, dualstring, unknown2, unknown3, unknown4)", (dcerpc_call_fn)dcerpc_ServerAlive2, (py_data_pack_fn)pack_py_ServerAlive2_args_in, (py_data_unpack_fn)unpack_py_ServerAlive2_args_out, 5, &ndr_table_IOXIDResolver },
	{ NULL }
};

static PyObject *interface_IOXIDResolver_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IOXIDResolver);
}

#define PY_DOC_IOXIDRESOLVER "Object Exporter ID Resolver"
static PyTypeObject IOXIDResolver_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "oxidresolver.IOXIDResolver",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "IOXIDResolver(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_IOXIDRESOLVER,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IOXIDResolver_new,
};

static PyMethodDef oxidresolver_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initoxidresolver(void)
{
	PyObject *m;
	PyObject *dep_misc;
	PyObject *dep_orpc;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	dep_orpc = PyImport_ImportModule("samba.dcerpc.orpc");
	if (dep_orpc == NULL)
		return;

	DUALSTRINGARRAY_Type = (PyTypeObject *)PyObject_GetAttrString(dep_orpc, "DUALSTRINGARRAY");
	if (DUALSTRINGARRAY_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	COMVERSION_Type = (PyTypeObject *)PyObject_GetAttrString(dep_orpc, "COMVERSION");
	if (COMVERSION_Type == NULL)
		return;

	if (PyType_Ready(&COMINFO_Type) < 0)
		return;
	if (PyType_Ready(&IOXIDResolver_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&IOXIDResolver_InterfaceType, py_ndr_IOXIDResolver_methods))
		return;

#ifdef PY_COMINFO_PATCH
	PY_COMINFO_PATCH(&COMINFO_Type);
#endif
#ifdef PY_IOXIDRESOLVER_PATCH
	PY_IOXIDRESOLVER_PATCH(&IOXIDResolver_InterfaceType);
#endif

	m = Py_InitModule3("oxidresolver", oxidresolver_methods, "oxidresolver DCE/RPC");
	if (m == NULL)
		return;

	Py_INCREF((PyObject *)&COMINFO_Type);
	PyModule_AddObject(m, "COMINFO", (PyObject *)&COMINFO_Type);
	Py_INCREF((PyObject *)&IOXIDResolver_InterfaceType);
	PyModule_AddObject(m, "IOXIDResolver", (PyObject *)&IOXIDResolver_InterfaceType);
#ifdef PY_MOD_OXIDRESOLVER_PATCH
	PY_MOD_OXIDRESOLVER_PATCH(m);
#endif

}
