
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_ntsvcs.h"
#include "../librpc/gen_ndr/ndr_ntsvcs_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/winreg.h"
staticforward PyTypeObject PNP_HwProfInfo_Type;
staticforward PyTypeObject ntsvcs_InterfaceType;


static PyObject *py_PNP_HwProfInfo_get_profile_handle(PyObject *obj, void *closure)
{
	struct PNP_HwProfInfo *object = (struct PNP_HwProfInfo *)py_talloc_get_ptr(obj);
	PyObject *py_profile_handle;
	py_profile_handle = PyInt_FromLong(object->profile_handle);
	return py_profile_handle;
}

static int py_PNP_HwProfInfo_set_profile_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PNP_HwProfInfo *object = (struct PNP_HwProfInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->profile_handle = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PNP_HwProfInfo_get_friendly_name(PyObject *obj, void *closure)
{
	struct PNP_HwProfInfo *object = (struct PNP_HwProfInfo *)py_talloc_get_ptr(obj);
	PyObject *py_friendly_name;
	py_friendly_name = PyList_New(80);
	if (py_friendly_name == NULL) {
		return NULL;
	}
	{
		int friendly_name_cntr_0;
		for (friendly_name_cntr_0 = 0; friendly_name_cntr_0 < 80; friendly_name_cntr_0++) {
			PyObject *py_friendly_name_0;
			py_friendly_name_0 = PyInt_FromLong(object->friendly_name[friendly_name_cntr_0]);
			PyList_SetItem(py_friendly_name, friendly_name_cntr_0, py_friendly_name_0);
		}
	}
	return py_friendly_name;
}

static int py_PNP_HwProfInfo_set_friendly_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PNP_HwProfInfo *object = (struct PNP_HwProfInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int friendly_name_cntr_0;
		for (friendly_name_cntr_0 = 0; friendly_name_cntr_0 < PyList_Size(value); friendly_name_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, friendly_name_cntr_0), return -1;);
			object->friendly_name[friendly_name_cntr_0] = PyInt_AsLong(PyList_GetItem(value, friendly_name_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_PNP_HwProfInfo_get_flags(PyObject *obj, void *closure)
{
	struct PNP_HwProfInfo *object = (struct PNP_HwProfInfo *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_PNP_HwProfInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PNP_HwProfInfo *object = (struct PNP_HwProfInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_PNP_HwProfInfo_getsetters[] = {
	{ discard_const_p(char, "profile_handle"), py_PNP_HwProfInfo_get_profile_handle, py_PNP_HwProfInfo_set_profile_handle },
	{ discard_const_p(char, "friendly_name"), py_PNP_HwProfInfo_get_friendly_name, py_PNP_HwProfInfo_set_friendly_name },
	{ discard_const_p(char, "flags"), py_PNP_HwProfInfo_get_flags, py_PNP_HwProfInfo_set_flags },
	{ NULL }
};

static PyObject *py_PNP_HwProfInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct PNP_HwProfInfo, type);
}


static PyTypeObject PNP_HwProfInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntsvcs.PNP_HwProfInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_PNP_HwProfInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PNP_HwProfInfo_new,
};


static bool pack_py_PNP_GetVersion_args_in(PyObject *args, PyObject *kwargs, struct PNP_GetVersion *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":PNP_GetVersion", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_PNP_GetVersion_args_out(struct PNP_GetVersion *r)
{
	PyObject *result = Py_None;
	PyObject *py_version;
	py_version = PyInt_FromLong(*r->out.version);
	result = py_version;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PNP_ValidateDeviceInstance_args_in(PyObject *args, PyObject *kwargs, struct PNP_ValidateDeviceInstance *r)
{
	PyObject *py_devicepath;
	PyObject *py_flags;
	const char *kwnames[] = {
		"devicepath", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:PNP_ValidateDeviceInstance", discard_const_p(char *, kwnames), &py_devicepath, &py_flags)) {
		return false;
	}

	r->in.devicepath = talloc_ptrtype(r, r->in.devicepath);
	PY_CHECK_TYPE(&PyUnicode_Type, py_devicepath, return false;);
	r->in.devicepath = PyString_AsString(PyUnicode_AsEncodedString(py_devicepath, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_PNP_ValidateDeviceInstance_args_out(struct PNP_ValidateDeviceInstance *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PNP_GetDeviceList_args_in(PyObject *args, PyObject *kwargs, struct PNP_GetDeviceList *r)
{
	PyObject *py_filter;
	PyObject *py_flags;
	const char *kwnames[] = {
		"filter", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:PNP_GetDeviceList", discard_const_p(char *, kwnames), &py_filter, &py_flags)) {
		return false;
	}

	if (py_filter == Py_None) {
		r->in.filter = NULL;
	} else {
		r->in.filter = talloc_ptrtype(r, r->in.filter);
		PY_CHECK_TYPE(&PyUnicode_Type, py_filter, return false;);
		r->in.filter = PyString_AsString(PyUnicode_AsEncodedString(py_filter, "utf-8", "ignore"));
	}
	r->in.length = talloc_ptrtype(r, r->in.length);
	PY_CHECK_TYPE(&PyInt_Type, py_length, return false;);
	*r->in.length = PyInt_AsLong(py_length);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_PNP_GetDeviceList_args_out(struct PNP_GetDeviceList *r)
{
	PyObject *result = Py_None;
	PyObject *py_buffer;
	py_buffer = PyList_New(*r->out.length);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < *r->out.length; buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	result = py_buffer;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PNP_GetDeviceListSize_args_in(PyObject *args, PyObject *kwargs, struct PNP_GetDeviceListSize *r)
{
	PyObject *py_devicename;
	PyObject *py_flags;
	const char *kwnames[] = {
		"devicename", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:PNP_GetDeviceListSize", discard_const_p(char *, kwnames), &py_devicename, &py_flags)) {
		return false;
	}

	if (py_devicename == Py_None) {
		r->in.devicename = NULL;
	} else {
		r->in.devicename = talloc_ptrtype(r, r->in.devicename);
		PY_CHECK_TYPE(&PyUnicode_Type, py_devicename, return false;);
		r->in.devicename = PyString_AsString(PyUnicode_AsEncodedString(py_devicename, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_PNP_GetDeviceListSize_args_out(struct PNP_GetDeviceListSize *r)
{
	PyObject *result = Py_None;
	PyObject *py_size;
	py_size = PyInt_FromLong(*r->out.size);
	result = py_size;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PNP_GetDeviceRegProp_args_in(PyObject *args, PyObject *kwargs, struct PNP_GetDeviceRegProp *r)
{
	PyObject *py_devicepath;
	PyObject *py_property;
	PyObject *py_reg_data_type;
	PyObject *py_needed;
	PyObject *py_flags;
	const char *kwnames[] = {
		"devicepath", "property", "reg_data_type", "needed", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:PNP_GetDeviceRegProp", discard_const_p(char *, kwnames), &py_devicepath, &py_property, &py_reg_data_type, &py_needed, &py_flags)) {
		return false;
	}

	r->in.devicepath = talloc_ptrtype(r, r->in.devicepath);
	PY_CHECK_TYPE(&PyUnicode_Type, py_devicepath, return false;);
	r->in.devicepath = PyString_AsString(PyUnicode_AsEncodedString(py_devicepath, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_property, return false;);
	r->in.property = PyInt_AsLong(py_property);
	r->in.reg_data_type = talloc_ptrtype(r, r->in.reg_data_type);
	PY_CHECK_TYPE(&PyInt_Type, py_reg_data_type, return false;);
	*r->in.reg_data_type = PyInt_AsLong(py_reg_data_type);
	r->in.buffer_size = talloc_ptrtype(r, r->in.buffer_size);
	PY_CHECK_TYPE(&PyInt_Type, py_buffer_size, return false;);
	*r->in.buffer_size = PyInt_AsLong(py_buffer_size);
	r->in.needed = talloc_ptrtype(r, r->in.needed);
	PY_CHECK_TYPE(&PyInt_Type, py_needed, return false;);
	*r->in.needed = PyInt_AsLong(py_needed);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_PNP_GetDeviceRegProp_args_out(struct PNP_GetDeviceRegProp *r)
{
	PyObject *result = Py_None;
	PyObject *py_reg_data_type;
	PyObject *py_buffer;
	PyObject *py_needed;
	result = PyTuple_New(3);
	py_reg_data_type = PyInt_FromLong(*r->out.reg_data_type);
	PyTuple_SetItem(result, 0, py_reg_data_type);
	py_buffer = PyList_New(*r->out.buffer_size);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < *r->out.buffer_size; buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	PyTuple_SetItem(result, 1, py_buffer);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 2, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PNP_HwProfFlags_args_in(PyObject *args, PyObject *kwargs, struct PNP_HwProfFlags *r)
{
	PyObject *py_action;
	PyObject *py_devicepath;
	PyObject *py_config;
	PyObject *py_profile_flags;
	PyObject *py_veto_type;
	PyObject *py_unknown5;
	PyObject *py_name_length;
	PyObject *py_flags;
	const char *kwnames[] = {
		"action", "devicepath", "config", "profile_flags", "veto_type", "unknown5", "name_length", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:PNP_HwProfFlags", discard_const_p(char *, kwnames), &py_action, &py_devicepath, &py_config, &py_profile_flags, &py_veto_type, &py_unknown5, &py_name_length, &py_flags)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_action, return false;);
	r->in.action = PyInt_AsLong(py_action);
	r->in.devicepath = talloc_ptrtype(r, r->in.devicepath);
	PY_CHECK_TYPE(&PyUnicode_Type, py_devicepath, return false;);
	r->in.devicepath = PyString_AsString(PyUnicode_AsEncodedString(py_devicepath, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_config, return false;);
	r->in.config = PyInt_AsLong(py_config);
	r->in.profile_flags = talloc_ptrtype(r, r->in.profile_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_profile_flags, return false;);
	*r->in.profile_flags = PyInt_AsLong(py_profile_flags);
	if (py_veto_type == Py_None) {
		r->in.veto_type = NULL;
	} else {
		r->in.veto_type = talloc_ptrtype(r, r->in.veto_type);
		PY_CHECK_TYPE(&PyInt_Type, py_veto_type, return false;);
		*r->in.veto_type = PyInt_AsLong(py_veto_type);
	}
	if (py_unknown5 == Py_None) {
		r->in.unknown5 = NULL;
	} else {
		r->in.unknown5 = talloc_ptrtype(r, r->in.unknown5);
		PY_CHECK_TYPE(&PyUnicode_Type, py_unknown5, return false;);
		r->in.unknown5 = PyString_AsString(PyUnicode_AsEncodedString(py_unknown5, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_name_length, return false;);
	r->in.name_length = PyInt_AsLong(py_name_length);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_PNP_HwProfFlags_args_out(struct PNP_HwProfFlags *r)
{
	PyObject *result = Py_None;
	PyObject *py_profile_flags;
	PyObject *py_veto_type;
	PyObject *py_unknown5a;
	result = PyTuple_New(3);
	py_profile_flags = PyInt_FromLong(*r->out.profile_flags);
	PyTuple_SetItem(result, 0, py_profile_flags);
	if (r->out.veto_type == NULL) {
		py_veto_type = Py_None;
	} else {
		py_veto_type = PyInt_FromLong(*r->out.veto_type);
	}
	PyTuple_SetItem(result, 1, py_veto_type);
	if (r->out.unknown5a == NULL) {
		py_unknown5a = Py_None;
	} else {
		if (*r->out.unknown5a == NULL) {
			py_unknown5a = Py_None;
		} else {
			py_unknown5a = PyUnicode_Decode(*r->out.unknown5a, strlen(*r->out.unknown5a), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 2, py_unknown5a);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PNP_GetHwProfInfo_args_in(PyObject *args, PyObject *kwargs, struct PNP_GetHwProfInfo *r)
{
	PyObject *py_idx;
	PyObject *py_info;
	PyObject *py_size;
	PyObject *py_flags;
	const char *kwnames[] = {
		"idx", "info", "size", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:PNP_GetHwProfInfo", discard_const_p(char *, kwnames), &py_idx, &py_info, &py_size, &py_flags)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_idx, return false;);
	r->in.idx = PyInt_AsLong(py_idx);
	r->in.info = talloc_ptrtype(r, r->in.info);
	PY_CHECK_TYPE(&PNP_HwProfInfo_Type, py_info, return false;);
	r->in.info = talloc_ptrtype(py_talloc_get_ptr(py_info), r->in.info);
	PY_CHECK_TYPE(&PyInt_Type, py_size, return false;);
	r->in.size = PyInt_AsLong(py_size);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_PNP_GetHwProfInfo_args_out(struct PNP_GetHwProfInfo *r)
{
	PyObject *result = Py_None;
	PyObject *py_info;
	py_info = py_talloc_import_ex(&PNP_HwProfInfo_Type, r->out.info, r->out.info);
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_ntsvcs_methods[] = {
	{ "PNP_Disconnect", NULL, (dcerpc_call_fn)dcerpc_PNP_Disconnect, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 0, &ndr_table_ntsvcs },
	{ "PNP_Connect", NULL, (dcerpc_call_fn)dcerpc_PNP_Connect, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 1, &ndr_table_ntsvcs },
	{ "PNP_GetVersion", "S.PNP_GetVersion() -> version", (dcerpc_call_fn)dcerpc_PNP_GetVersion, (py_data_pack_fn)pack_py_PNP_GetVersion_args_in, (py_data_unpack_fn)unpack_py_PNP_GetVersion_args_out, 2, &ndr_table_ntsvcs },
	{ "PNP_GetGlobalState", NULL, (dcerpc_call_fn)dcerpc_PNP_GetGlobalState, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 3, &ndr_table_ntsvcs },
	{ "PNP_InitDetection", NULL, (dcerpc_call_fn)dcerpc_PNP_InitDetection, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 4, &ndr_table_ntsvcs },
	{ "PNP_ReportLogOn", NULL, (dcerpc_call_fn)dcerpc_PNP_ReportLogOn, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 5, &ndr_table_ntsvcs },
	{ "PNP_ValidateDeviceInstance", "S.PNP_ValidateDeviceInstance(devicepath, flags) -> None", (dcerpc_call_fn)dcerpc_PNP_ValidateDeviceInstance, (py_data_pack_fn)pack_py_PNP_ValidateDeviceInstance_args_in, (py_data_unpack_fn)unpack_py_PNP_ValidateDeviceInstance_args_out, 6, &ndr_table_ntsvcs },
	{ "PNP_GetRootDeviceInstance", NULL, (dcerpc_call_fn)dcerpc_PNP_GetRootDeviceInstance, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 7, &ndr_table_ntsvcs },
	{ "PNP_GetRelatedDeviceInstance", NULL, (dcerpc_call_fn)dcerpc_PNP_GetRelatedDeviceInstance, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 8, &ndr_table_ntsvcs },
	{ "PNP_EnumerateSubKeys", NULL, (dcerpc_call_fn)dcerpc_PNP_EnumerateSubKeys, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 9, &ndr_table_ntsvcs },
	{ "PNP_GetDeviceList", "S.PNP_GetDeviceList(filter, flags) -> buffer", (dcerpc_call_fn)dcerpc_PNP_GetDeviceList, (py_data_pack_fn)pack_py_PNP_GetDeviceList_args_in, (py_data_unpack_fn)unpack_py_PNP_GetDeviceList_args_out, 10, &ndr_table_ntsvcs },
	{ "PNP_GetDeviceListSize", "S.PNP_GetDeviceListSize(devicename, flags) -> size", (dcerpc_call_fn)dcerpc_PNP_GetDeviceListSize, (py_data_pack_fn)pack_py_PNP_GetDeviceListSize_args_in, (py_data_unpack_fn)unpack_py_PNP_GetDeviceListSize_args_out, 11, &ndr_table_ntsvcs },
	{ "PNP_GetDepth", NULL, (dcerpc_call_fn)dcerpc_PNP_GetDepth, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 12, &ndr_table_ntsvcs },
	{ "PNP_GetDeviceRegProp", "S.PNP_GetDeviceRegProp(devicepath, property, reg_data_type, needed, flags) -> (reg_data_type, buffer, needed)", (dcerpc_call_fn)dcerpc_PNP_GetDeviceRegProp, (py_data_pack_fn)pack_py_PNP_GetDeviceRegProp_args_in, (py_data_unpack_fn)unpack_py_PNP_GetDeviceRegProp_args_out, 13, &ndr_table_ntsvcs },
	{ "PNP_SetDeviceRegProp", NULL, (dcerpc_call_fn)dcerpc_PNP_SetDeviceRegProp, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 14, &ndr_table_ntsvcs },
	{ "PNP_GetClassInstance", NULL, (dcerpc_call_fn)dcerpc_PNP_GetClassInstance, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 15, &ndr_table_ntsvcs },
	{ "PNP_CreateKey", NULL, (dcerpc_call_fn)dcerpc_PNP_CreateKey, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 16, &ndr_table_ntsvcs },
	{ "PNP_DeleteRegistryKey", NULL, (dcerpc_call_fn)dcerpc_PNP_DeleteRegistryKey, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 17, &ndr_table_ntsvcs },
	{ "PNP_GetClassCount", NULL, (dcerpc_call_fn)dcerpc_PNP_GetClassCount, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 18, &ndr_table_ntsvcs },
	{ "PNP_GetClassName", NULL, (dcerpc_call_fn)dcerpc_PNP_GetClassName, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 19, &ndr_table_ntsvcs },
	{ "PNP_DeleteClassKey", NULL, (dcerpc_call_fn)dcerpc_PNP_DeleteClassKey, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 20, &ndr_table_ntsvcs },
	{ "PNP_GetInterfaceDeviceAlias", NULL, (dcerpc_call_fn)dcerpc_PNP_GetInterfaceDeviceAlias, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 21, &ndr_table_ntsvcs },
	{ "PNP_GetInterfaceDeviceList", NULL, (dcerpc_call_fn)dcerpc_PNP_GetInterfaceDeviceList, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 22, &ndr_table_ntsvcs },
	{ "PNP_GetInterfaceDeviceListSize", NULL, (dcerpc_call_fn)dcerpc_PNP_GetInterfaceDeviceListSize, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 23, &ndr_table_ntsvcs },
	{ "PNP_RegisterDeviceClassAssociation", NULL, (dcerpc_call_fn)dcerpc_PNP_RegisterDeviceClassAssociation, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 24, &ndr_table_ntsvcs },
	{ "PNP_UnregisterDeviceClassAssociation", NULL, (dcerpc_call_fn)dcerpc_PNP_UnregisterDeviceClassAssociation, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 25, &ndr_table_ntsvcs },
	{ "PNP_GetClassRegProp", NULL, (dcerpc_call_fn)dcerpc_PNP_GetClassRegProp, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 26, &ndr_table_ntsvcs },
	{ "PNP_SetClassRegProp", NULL, (dcerpc_call_fn)dcerpc_PNP_SetClassRegProp, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 27, &ndr_table_ntsvcs },
	{ "PNP_CreateDevInst", NULL, (dcerpc_call_fn)dcerpc_PNP_CreateDevInst, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 28, &ndr_table_ntsvcs },
	{ "PNP_DeviceInstanceAction", NULL, (dcerpc_call_fn)dcerpc_PNP_DeviceInstanceAction, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 29, &ndr_table_ntsvcs },
	{ "PNP_GetDeviceStatus", NULL, (dcerpc_call_fn)dcerpc_PNP_GetDeviceStatus, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 30, &ndr_table_ntsvcs },
	{ "PNP_SetDeviceProblem", NULL, (dcerpc_call_fn)dcerpc_PNP_SetDeviceProblem, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 31, &ndr_table_ntsvcs },
	{ "PNP_DisableDevInst", NULL, (dcerpc_call_fn)dcerpc_PNP_DisableDevInst, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 32, &ndr_table_ntsvcs },
	{ "PNP_UninstallDevInst", NULL, (dcerpc_call_fn)dcerpc_PNP_UninstallDevInst, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 33, &ndr_table_ntsvcs },
	{ "PNP_AddID", NULL, (dcerpc_call_fn)dcerpc_PNP_AddID, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 34, &ndr_table_ntsvcs },
	{ "PNP_RegisterDriver", NULL, (dcerpc_call_fn)dcerpc_PNP_RegisterDriver, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 35, &ndr_table_ntsvcs },
	{ "PNP_QueryRemove", NULL, (dcerpc_call_fn)dcerpc_PNP_QueryRemove, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 36, &ndr_table_ntsvcs },
	{ "PNP_RequestDeviceEject", NULL, (dcerpc_call_fn)dcerpc_PNP_RequestDeviceEject, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 37, &ndr_table_ntsvcs },
	{ "PNP_IsDockStationPresent", NULL, (dcerpc_call_fn)dcerpc_PNP_IsDockStationPresent, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 38, &ndr_table_ntsvcs },
	{ "PNP_RequestEjectPC", NULL, (dcerpc_call_fn)dcerpc_PNP_RequestEjectPC, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 39, &ndr_table_ntsvcs },
	{ "PNP_HwProfFlags", "S.PNP_HwProfFlags(action, devicepath, config, profile_flags, veto_type, unknown5, name_length, flags) -> (profile_flags, veto_type, unknown5a)", (dcerpc_call_fn)dcerpc_PNP_HwProfFlags, (py_data_pack_fn)pack_py_PNP_HwProfFlags_args_in, (py_data_unpack_fn)unpack_py_PNP_HwProfFlags_args_out, 40, &ndr_table_ntsvcs },
	{ "PNP_GetHwProfInfo", "S.PNP_GetHwProfInfo(idx, info, size, flags) -> info", (dcerpc_call_fn)dcerpc_PNP_GetHwProfInfo, (py_data_pack_fn)pack_py_PNP_GetHwProfInfo_args_in, (py_data_unpack_fn)unpack_py_PNP_GetHwProfInfo_args_out, 41, &ndr_table_ntsvcs },
	{ "PNP_AddEmptyLogConf", NULL, (dcerpc_call_fn)dcerpc_PNP_AddEmptyLogConf, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 42, &ndr_table_ntsvcs },
	{ "PNP_FreeLogConf", NULL, (dcerpc_call_fn)dcerpc_PNP_FreeLogConf, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 43, &ndr_table_ntsvcs },
	{ "PNP_GetFirstLogConf", NULL, (dcerpc_call_fn)dcerpc_PNP_GetFirstLogConf, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 44, &ndr_table_ntsvcs },
	{ "PNP_GetNextLogConf", NULL, (dcerpc_call_fn)dcerpc_PNP_GetNextLogConf, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 45, &ndr_table_ntsvcs },
	{ "PNP_GetLogConfPriority", NULL, (dcerpc_call_fn)dcerpc_PNP_GetLogConfPriority, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 46, &ndr_table_ntsvcs },
	{ "PNP_AddResDes", NULL, (dcerpc_call_fn)dcerpc_PNP_AddResDes, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 47, &ndr_table_ntsvcs },
	{ "PNP_FreeResDes", NULL, (dcerpc_call_fn)dcerpc_PNP_FreeResDes, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 48, &ndr_table_ntsvcs },
	{ "PNP_GetNextResDes", NULL, (dcerpc_call_fn)dcerpc_PNP_GetNextResDes, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 49, &ndr_table_ntsvcs },
	{ "PNP_GetResDesData", NULL, (dcerpc_call_fn)dcerpc_PNP_GetResDesData, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 50, &ndr_table_ntsvcs },
	{ "PNP_GetResDesDataSize", NULL, (dcerpc_call_fn)dcerpc_PNP_GetResDesDataSize, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 51, &ndr_table_ntsvcs },
	{ "PNP_ModifyResDes", NULL, (dcerpc_call_fn)dcerpc_PNP_ModifyResDes, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 52, &ndr_table_ntsvcs },
	{ "PNP_DetectResourceLimit", NULL, (dcerpc_call_fn)dcerpc_PNP_DetectResourceLimit, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 53, &ndr_table_ntsvcs },
	{ "PNP_QueryResConfList", NULL, (dcerpc_call_fn)dcerpc_PNP_QueryResConfList, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 54, &ndr_table_ntsvcs },
	{ "PNP_SetHwProf", NULL, (dcerpc_call_fn)dcerpc_PNP_SetHwProf, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 55, &ndr_table_ntsvcs },
	{ "PNP_QueryArbitratorFreeData", NULL, (dcerpc_call_fn)dcerpc_PNP_QueryArbitratorFreeData, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 56, &ndr_table_ntsvcs },
	{ "PNP_QueryArbitratorFreeSize", NULL, (dcerpc_call_fn)dcerpc_PNP_QueryArbitratorFreeSize, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 57, &ndr_table_ntsvcs },
	{ "PNP_RunDetection", NULL, (dcerpc_call_fn)dcerpc_PNP_RunDetection, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 58, &ndr_table_ntsvcs },
	{ "PNP_RegisterNotification", NULL, (dcerpc_call_fn)dcerpc_PNP_RegisterNotification, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 59, &ndr_table_ntsvcs },
	{ "PNP_UnregisterNotification", NULL, (dcerpc_call_fn)dcerpc_PNP_UnregisterNotification, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 60, &ndr_table_ntsvcs },
	{ "PNP_GetCustomDevProp", NULL, (dcerpc_call_fn)dcerpc_PNP_GetCustomDevProp, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 61, &ndr_table_ntsvcs },
	{ "PNP_GetVersionInternal", NULL, (dcerpc_call_fn)dcerpc_PNP_GetVersionInternal, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 62, &ndr_table_ntsvcs },
	{ "PNP_GetBlockedDriverInfo", NULL, (dcerpc_call_fn)dcerpc_PNP_GetBlockedDriverInfo, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 63, &ndr_table_ntsvcs },
	{ "PNP_GetServerSideDeviceInstallFlags", NULL, (dcerpc_call_fn)dcerpc_PNP_GetServerSideDeviceInstallFlags, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 64, &ndr_table_ntsvcs },
	{ NULL }
};

static PyObject *interface_ntsvcs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_ntsvcs);
}

#define PY_DOC_NTSVCS "Plug and Play services"
static PyTypeObject ntsvcs_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntsvcs.ntsvcs",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "ntsvcs(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_NTSVCS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_ntsvcs_new,
};

static PyMethodDef ntsvcs_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initntsvcs(void)
{
	PyObject *m;
	PyObject *dep_winreg;

	dep_winreg = PyImport_ImportModule("samba.dcerpc.winreg");
	if (dep_winreg == NULL)
		return;

	if (PyType_Ready(&PNP_HwProfInfo_Type) < 0)
		return;
	if (PyType_Ready(&ntsvcs_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&ntsvcs_InterfaceType, py_ndr_ntsvcs_methods))
		return;

#ifdef PY_PNP_HWPROFINFO_PATCH
	PY_PNP_HWPROFINFO_PATCH(&PNP_HwProfInfo_Type);
#endif
#ifdef PY_NTSVCS_PATCH
	PY_NTSVCS_PATCH(&ntsvcs_InterfaceType);
#endif

	m = Py_InitModule3("ntsvcs", ntsvcs_methods, "ntsvcs DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DEV_REGPROP_DESC", PyInt_FromLong(1));
	Py_INCREF((PyObject *)&PNP_HwProfInfo_Type);
	PyModule_AddObject(m, "PNP_HwProfInfo", (PyObject *)&PNP_HwProfInfo_Type);
	Py_INCREF((PyObject *)&ntsvcs_InterfaceType);
	PyModule_AddObject(m, "ntsvcs", (PyObject *)&ntsvcs_InterfaceType);
#ifdef PY_MOD_NTSVCS_PATCH
	PY_MOD_NTSVCS_PATCH(m);
#endif

}
