
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_named_pipe_auth.h"
#include "../librpc/gen_ndr/ndr_named_pipe_auth_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/netlogon.h"
staticforward PyTypeObject named_pipe_auth_req_Type;
staticforward PyTypeObject named_pipe_auth_rep_Type;

static PyTypeObject *netr_SamInfo3_Type;
PyObject *py_import_named_pipe_auth_req_info(TALLOC_CTX *mem_ctx, int level, union named_pipe_auth_req_info *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = Py_None;
			return ret;

		case 1:
			ret = py_talloc_import_ex(netr_SamInfo3_Type, mem_ctx, &in->info1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union named_pipe_auth_req_info *py_export_named_pipe_auth_req_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union named_pipe_auth_req_info *ret = talloc_zero(mem_ctx, union named_pipe_auth_req_info);
	switch (level) {
		case 0:
			break;

		case 1:
			PY_CHECK_TYPE(netr_SamInfo3_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->info1, talloc_ptrtype(py_talloc_get_ptr(in), &ret->info1), sizeof(ret->info1));
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_named_pipe_auth_req_get_length(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_named_pipe_auth_req_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_get_magic(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyUnicode_Decode(object->magic, strlen(object->magic), "utf-8", "ignore");
	return py_magic;
}

static int py_named_pipe_auth_req_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->magic = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_named_pipe_auth_req_get_level(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyInt_FromLong(object->level);
	return py_level;
}

static int py_named_pipe_auth_req_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->level = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_get_info(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_info;
	py_info = py_import_named_pipe_auth_req_info(py_talloc_get_mem_ctx(obj), object->level, &object->info);
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_named_pipe_auth_req_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	memcpy(&object->info, py_export_named_pipe_auth_req_info(py_talloc_get_mem_ctx(py_obj), object->level, value), sizeof(object->info));
	return 0;
}

static PyGetSetDef py_named_pipe_auth_req_getsetters[] = {
	{ discard_const_p(char, "length"), py_named_pipe_auth_req_get_length, py_named_pipe_auth_req_set_length },
	{ discard_const_p(char, "magic"), py_named_pipe_auth_req_get_magic, py_named_pipe_auth_req_set_magic },
	{ discard_const_p(char, "level"), py_named_pipe_auth_req_get_level, py_named_pipe_auth_req_set_level },
	{ discard_const_p(char, "info"), py_named_pipe_auth_req_get_info, py_named_pipe_auth_req_set_info },
	{ NULL }
};

static PyObject *py_named_pipe_auth_req_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_req, type);
}

static PyObject *py_named_pipe_auth_req_ndr_pack(PyObject *py_obj)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_named_pipe_auth_req);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_named_pipe_auth_req_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_named_pipe_auth_req);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_named_pipe_auth_req_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_named_pipe_auth_req_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_named_pipe_auth_req_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject named_pipe_auth_req_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.req",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_req_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_named_pipe_auth_req_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_req_new,
};

PyObject *py_import_named_pipe_auth_rep_info(TALLOC_CTX *mem_ctx, int level, union named_pipe_auth_rep_info *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = Py_None;
			return ret;

		case 1:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union named_pipe_auth_rep_info *py_export_named_pipe_auth_rep_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union named_pipe_auth_rep_info *ret = talloc_zero(mem_ctx, union named_pipe_auth_rep_info);
	switch (level) {
		case 0:
			break;

		case 1:
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_named_pipe_auth_rep_get_length(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_named_pipe_auth_rep_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_magic(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyUnicode_Decode(object->magic, strlen(object->magic), "utf-8", "ignore");
	return py_magic;
}

static int py_named_pipe_auth_rep_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->magic = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_level(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyInt_FromLong(object->level);
	return py_level;
}

static int py_named_pipe_auth_rep_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->level = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_info(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_info;
	py_info = py_import_named_pipe_auth_rep_info(py_talloc_get_mem_ctx(obj), object->level, &object->info);
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_named_pipe_auth_rep_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	memcpy(&object->info, py_export_named_pipe_auth_rep_info(py_talloc_get_mem_ctx(py_obj), object->level, value), sizeof(object->info));
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_status(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_named_pipe_auth_rep_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	object->status = NT_STATUS(PyInt_AsLong(value));
	return 0;
}

static PyGetSetDef py_named_pipe_auth_rep_getsetters[] = {
	{ discard_const_p(char, "length"), py_named_pipe_auth_rep_get_length, py_named_pipe_auth_rep_set_length },
	{ discard_const_p(char, "magic"), py_named_pipe_auth_rep_get_magic, py_named_pipe_auth_rep_set_magic },
	{ discard_const_p(char, "level"), py_named_pipe_auth_rep_get_level, py_named_pipe_auth_rep_set_level },
	{ discard_const_p(char, "info"), py_named_pipe_auth_rep_get_info, py_named_pipe_auth_rep_set_info },
	{ discard_const_p(char, "status"), py_named_pipe_auth_rep_get_status, py_named_pipe_auth_rep_set_status },
	{ NULL }
};

static PyObject *py_named_pipe_auth_rep_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_rep, type);
}

static PyObject *py_named_pipe_auth_rep_ndr_pack(PyObject *py_obj)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_named_pipe_auth_rep);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_named_pipe_auth_rep_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_named_pipe_auth_rep);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_named_pipe_auth_rep_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_named_pipe_auth_rep_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_named_pipe_auth_rep_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject named_pipe_auth_rep_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.rep",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_rep_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_named_pipe_auth_rep_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_rep_new,
};

static PyMethodDef named_pipe_auth_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initnamed_pipe_auth(void)
{
	PyObject *m;
	PyObject *dep_netlogon;

	dep_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_netlogon == NULL)
		return;

	netr_SamInfo3_Type = (PyTypeObject *)PyObject_GetAttrString(dep_netlogon, "netr_SamInfo3");
	if (netr_SamInfo3_Type == NULL)
		return;

	if (PyType_Ready(&named_pipe_auth_req_Type) < 0)
		return;
	if (PyType_Ready(&named_pipe_auth_rep_Type) < 0)
		return;
#ifdef PY_REQ_PATCH
	PY_REQ_PATCH(&named_pipe_auth_req_Type);
#endif
#ifdef PY_REP_PATCH
	PY_REP_PATCH(&named_pipe_auth_rep_Type);
#endif

	m = Py_InitModule3("named_pipe_auth", named_pipe_auth_methods, "named_pipe_auth DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "NAMED_PIPE_AUTH_MAGIC", PyString_FromString("NPAM"));
	Py_INCREF((PyObject *)&named_pipe_auth_req_Type);
	PyModule_AddObject(m, "req", (PyObject *)&named_pipe_auth_req_Type);
	Py_INCREF((PyObject *)&named_pipe_auth_rep_Type);
	PyModule_AddObject(m, "rep", (PyObject *)&named_pipe_auth_rep_Type);
#ifdef PY_MOD_NAMED_PIPE_AUTH_PATCH
	PY_MOD_NAMED_PIPE_AUTH_PATCH(m);
#endif

}
