
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_misc.h"
#include "../librpc/gen_ndr/ndr_misc_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

staticforward PyTypeObject GUID_Type;
staticforward PyTypeObject ndr_syntax_id_Type;
staticforward PyTypeObject policy_handle_Type;
staticforward PyTypeObject KRB5_EDATA_NTSTATUS_Type;


static PyObject *py_GUID_get_time_low(PyObject *obj, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(obj);
	PyObject *py_time_low;
	py_time_low = PyInt_FromLong(object->time_low);
	return py_time_low;
}

static int py_GUID_set_time_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->time_low = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_GUID_get_time_mid(PyObject *obj, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(obj);
	PyObject *py_time_mid;
	py_time_mid = PyInt_FromLong(object->time_mid);
	return py_time_mid;
}

static int py_GUID_set_time_mid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->time_mid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_GUID_get_time_hi_and_version(PyObject *obj, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(obj);
	PyObject *py_time_hi_and_version;
	py_time_hi_and_version = PyInt_FromLong(object->time_hi_and_version);
	return py_time_hi_and_version;
}

static int py_GUID_set_time_hi_and_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->time_hi_and_version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_GUID_get_clock_seq(PyObject *obj, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(obj);
	PyObject *py_clock_seq;
	py_clock_seq = PyList_New(2);
	if (py_clock_seq == NULL) {
		return NULL;
	}
	{
		int clock_seq_cntr_0;
		for (clock_seq_cntr_0 = 0; clock_seq_cntr_0 < 2; clock_seq_cntr_0++) {
			PyObject *py_clock_seq_0;
			py_clock_seq_0 = PyInt_FromLong(object->clock_seq[clock_seq_cntr_0]);
			PyList_SetItem(py_clock_seq, clock_seq_cntr_0, py_clock_seq_0);
		}
	}
	return py_clock_seq;
}

static int py_GUID_set_clock_seq(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int clock_seq_cntr_0;
		for (clock_seq_cntr_0 = 0; clock_seq_cntr_0 < PyList_Size(value); clock_seq_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, clock_seq_cntr_0), return -1;);
			object->clock_seq[clock_seq_cntr_0] = PyInt_AsLong(PyList_GetItem(value, clock_seq_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_GUID_get_node(PyObject *obj, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(obj);
	PyObject *py_node;
	py_node = PyList_New(6);
	if (py_node == NULL) {
		return NULL;
	}
	{
		int node_cntr_0;
		for (node_cntr_0 = 0; node_cntr_0 < 6; node_cntr_0++) {
			PyObject *py_node_0;
			py_node_0 = PyInt_FromLong(object->node[node_cntr_0]);
			PyList_SetItem(py_node, node_cntr_0, py_node_0);
		}
	}
	return py_node;
}

static int py_GUID_set_node(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int node_cntr_0;
		for (node_cntr_0 = 0; node_cntr_0 < PyList_Size(value); node_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, node_cntr_0), return -1;);
			object->node[node_cntr_0] = PyInt_AsLong(PyList_GetItem(value, node_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_GUID_getsetters[] = {
	{ discard_const_p(char, "time_low"), py_GUID_get_time_low, py_GUID_set_time_low },
	{ discard_const_p(char, "time_mid"), py_GUID_get_time_mid, py_GUID_set_time_mid },
	{ discard_const_p(char, "time_hi_and_version"), py_GUID_get_time_hi_and_version, py_GUID_set_time_hi_and_version },
	{ discard_const_p(char, "clock_seq"), py_GUID_get_clock_seq, py_GUID_set_clock_seq },
	{ discard_const_p(char, "node"), py_GUID_get_node, py_GUID_set_node },
	{ NULL }
};

static PyObject *py_GUID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct GUID, type);
}

static PyObject *py_GUID_ndr_pack(PyObject *py_obj)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_GUID);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_GUID_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct GUID *object = (struct GUID *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_GUID);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_GUID_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_GUID_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_GUID_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject GUID_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "misc.GUID",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_GUID_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_GUID_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_GUID_new,
};


static PyObject *py_ndr_syntax_id_get_uuid(PyObject *obj, void *closure)
{
	struct ndr_syntax_id *object = (struct ndr_syntax_id *)py_talloc_get_ptr(obj);
	PyObject *py_uuid;
	py_uuid = py_talloc_import_ex(&GUID_Type, py_talloc_get_mem_ctx(obj), &object->uuid);
	return py_uuid;
}

static int py_ndr_syntax_id_set_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ndr_syntax_id *object = (struct ndr_syntax_id *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&GUID_Type, value, return -1;);
	memcpy(&object->uuid, talloc_ptrtype(py_talloc_get_ptr(value), &object->uuid), sizeof(object->uuid));
	return 0;
}

static PyObject *py_ndr_syntax_id_get_if_version(PyObject *obj, void *closure)
{
	struct ndr_syntax_id *object = (struct ndr_syntax_id *)py_talloc_get_ptr(obj);
	PyObject *py_if_version;
	py_if_version = PyInt_FromLong(object->if_version);
	return py_if_version;
}

static int py_ndr_syntax_id_set_if_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ndr_syntax_id *object = (struct ndr_syntax_id *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->if_version = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_ndr_syntax_id_getsetters[] = {
	{ discard_const_p(char, "uuid"), py_ndr_syntax_id_get_uuid, py_ndr_syntax_id_set_uuid },
	{ discard_const_p(char, "if_version"), py_ndr_syntax_id_get_if_version, py_ndr_syntax_id_set_if_version },
	{ NULL }
};

static PyObject *py_ndr_syntax_id_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct ndr_syntax_id, type);
}

static PyObject *py_ndr_syntax_id_ndr_pack(PyObject *py_obj)
{
	struct ndr_syntax_id *object = (struct ndr_syntax_id *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_ndr_syntax_id);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ndr_syntax_id_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct ndr_syntax_id *object = (struct ndr_syntax_id *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_ndr_syntax_id);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_ndr_syntax_id_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ndr_syntax_id_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ndr_syntax_id_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ndr_syntax_id_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "misc.ndr_syntax_id",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_ndr_syntax_id_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_ndr_syntax_id_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ndr_syntax_id_new,
};


static PyObject *py_policy_handle_get_handle_type(PyObject *obj, void *closure)
{
	struct policy_handle *object = (struct policy_handle *)py_talloc_get_ptr(obj);
	PyObject *py_handle_type;
	py_handle_type = PyInt_FromLong(object->handle_type);
	return py_handle_type;
}

static int py_policy_handle_set_handle_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct policy_handle *object = (struct policy_handle *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->handle_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_policy_handle_get_uuid(PyObject *obj, void *closure)
{
	struct policy_handle *object = (struct policy_handle *)py_talloc_get_ptr(obj);
	PyObject *py_uuid;
	py_uuid = py_talloc_import_ex(&GUID_Type, py_talloc_get_mem_ctx(obj), &object->uuid);
	return py_uuid;
}

static int py_policy_handle_set_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct policy_handle *object = (struct policy_handle *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&GUID_Type, value, return -1;);
	memcpy(&object->uuid, talloc_ptrtype(py_talloc_get_ptr(value), &object->uuid), sizeof(object->uuid));
	return 0;
}

static PyGetSetDef py_policy_handle_getsetters[] = {
	{ discard_const_p(char, "handle_type"), py_policy_handle_get_handle_type, py_policy_handle_set_handle_type },
	{ discard_const_p(char, "uuid"), py_policy_handle_get_uuid, py_policy_handle_set_uuid },
	{ NULL }
};

static PyObject *py_policy_handle_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct policy_handle, type);
}

static PyObject *py_policy_handle_ndr_pack(PyObject *py_obj)
{
	struct policy_handle *object = (struct policy_handle *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_policy_handle);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_policy_handle_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct policy_handle *object = (struct policy_handle *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_policy_handle);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_policy_handle_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_policy_handle_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_policy_handle_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject policy_handle_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "misc.policy_handle",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_policy_handle_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_policy_handle_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_policy_handle_new,
};


static PyObject *py_KRB5_EDATA_NTSTATUS_get_ntstatus(PyObject *obj, void *closure)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(obj);
	PyObject *py_ntstatus;
	py_ntstatus = PyErr_FromNTSTATUS(object->ntstatus);
	return py_ntstatus;
}

static int py_KRB5_EDATA_NTSTATUS_set_ntstatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(py_obj);
	object->ntstatus = NT_STATUS(PyInt_AsLong(value));
	return 0;
}

static PyObject *py_KRB5_EDATA_NTSTATUS_get_unknown1(PyObject *obj, void *closure)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_KRB5_EDATA_NTSTATUS_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_KRB5_EDATA_NTSTATUS_get_unknown2(PyObject *obj, void *closure)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyInt_FromLong(object->unknown2);
	return py_unknown2;
}

static int py_KRB5_EDATA_NTSTATUS_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown2 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_KRB5_EDATA_NTSTATUS_getsetters[] = {
	{ discard_const_p(char, "ntstatus"), py_KRB5_EDATA_NTSTATUS_get_ntstatus, py_KRB5_EDATA_NTSTATUS_set_ntstatus },
	{ discard_const_p(char, "unknown1"), py_KRB5_EDATA_NTSTATUS_get_unknown1, py_KRB5_EDATA_NTSTATUS_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_KRB5_EDATA_NTSTATUS_get_unknown2, py_KRB5_EDATA_NTSTATUS_set_unknown2 },
	{ NULL }
};

static PyObject *py_KRB5_EDATA_NTSTATUS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct KRB5_EDATA_NTSTATUS, type);
}

static PyObject *py_KRB5_EDATA_NTSTATUS_ndr_pack(PyObject *py_obj)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_KRB5_EDATA_NTSTATUS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_KRB5_EDATA_NTSTATUS_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct KRB5_EDATA_NTSTATUS *object = (struct KRB5_EDATA_NTSTATUS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_KRB5_EDATA_NTSTATUS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_KRB5_EDATA_NTSTATUS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_KRB5_EDATA_NTSTATUS_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_KRB5_EDATA_NTSTATUS_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject KRB5_EDATA_NTSTATUS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "misc.KRB5_EDATA_NTSTATUS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_KRB5_EDATA_NTSTATUS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_KRB5_EDATA_NTSTATUS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KRB5_EDATA_NTSTATUS_new,
};

static PyMethodDef misc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initmisc(void)
{
	PyObject *m;

	if (PyType_Ready(&GUID_Type) < 0)
		return;
	if (PyType_Ready(&ndr_syntax_id_Type) < 0)
		return;
	if (PyType_Ready(&policy_handle_Type) < 0)
		return;
	if (PyType_Ready(&KRB5_EDATA_NTSTATUS_Type) < 0)
		return;
#ifdef PY_GUID_PATCH
	PY_GUID_PATCH(&GUID_Type);
#endif
#ifdef PY_NDR_SYNTAX_ID_PATCH
	PY_NDR_SYNTAX_ID_PATCH(&ndr_syntax_id_Type);
#endif
#ifdef PY_POLICY_HANDLE_PATCH
	PY_POLICY_HANDLE_PATCH(&policy_handle_Type);
#endif
#ifdef PY_KRB5_EDATA_NTSTATUS_PATCH
	PY_KRB5_EDATA_NTSTATUS_PATCH(&KRB5_EDATA_NTSTATUS_Type);
#endif

	m = Py_InitModule3("misc", misc_methods, "misc DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "SEC_CHAN_DOMAIN", PyInt_FromLong(SEC_CHAN_DOMAIN));
	PyModule_AddObject(m, "SEC_CHAN_NULL", PyInt_FromLong(SEC_CHAN_NULL));
	PyModule_AddObject(m, "SEC_CHAN_DNS_DOMAIN", PyInt_FromLong(SEC_CHAN_DNS_DOMAIN));
	PyModule_AddObject(m, "SEC_CHAN_WKSTA", PyInt_FromLong(SEC_CHAN_WKSTA));
	PyModule_AddObject(m, "SEC_CHAN_BDC", PyInt_FromLong(SEC_CHAN_BDC));
	Py_INCREF((PyObject *)&GUID_Type);
	PyModule_AddObject(m, "GUID", (PyObject *)&GUID_Type);
	Py_INCREF((PyObject *)&ndr_syntax_id_Type);
	PyModule_AddObject(m, "ndr_syntax_id", (PyObject *)&ndr_syntax_id_Type);
	Py_INCREF((PyObject *)&policy_handle_Type);
	PyModule_AddObject(m, "policy_handle", (PyObject *)&policy_handle_Type);
	Py_INCREF((PyObject *)&KRB5_EDATA_NTSTATUS_Type);
	PyModule_AddObject(m, "KRB5_EDATA_NTSTATUS", (PyObject *)&KRB5_EDATA_NTSTATUS_Type);
#ifdef PY_MOD_MISC_PATCH
	PY_MOD_MISC_PATCH(m);
#endif

}
