/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_wmi.h"

NTSTATUS rpccli_Delete(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */,
		       const char *wszName /* [in] [ref,charset(UTF16)] */,
		       WERROR *werror)
{
	struct Delete r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszName = wszName;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Delete, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemClassObject,
				NDR_DELETE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Delete, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_OpenNamespace(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct BSTR strNamespace /* [in]  */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer **ppWorkingNamespace /* [in,out] [unique] */,
			      struct MInterfacePointer **ppResult /* [in,out] [unique] */,
			      WERROR *werror)
{
	struct OpenNamespace r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strNamespace = strNamespace;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppWorkingNamespace = ppWorkingNamespace;
	r.in.ppResult = ppResult;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(OpenNamespace, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_OPENNAMESPACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(OpenNamespace, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppWorkingNamespace && r.out.ppWorkingNamespace) {
		*ppWorkingNamespace = *r.out.ppWorkingNamespace;
	}
	if (ppResult && r.out.ppResult) {
		*ppResult = *r.out.ppResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_CancelAsyncCall(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct MInterfacePointer *pSink /* [in] [ref] */,
				WERROR *werror)
{
	struct CancelAsyncCall r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pSink = pSink;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CancelAsyncCall, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CANCELASYNCCALL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CancelAsyncCall, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_QueryObjectSink(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer **ppResponseHandler /* [out] [ref] */,
				WERROR *werror)
{
	struct QueryObjectSink r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lFlags = lFlags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(QueryObjectSink, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_QUERYOBJECTSINK,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(QueryObjectSink, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppResponseHandler = *r.out.ppResponseHandler;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetObject(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strObjectPath /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppObject /* [in,out] [unique] */,
			  struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			  WERROR *werror)
{
	struct GetObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppObject = ppObject;
	r.in.ppCallResult = ppCallResult;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetObject, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_GETOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetObject, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppObject && r.out.ppObject) {
		*ppObject = *r.out.ppObject;
	}
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetObjectAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror)
{
	struct GetObjectAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetObjectAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_GETOBJECTASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetObjectAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PutClass(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 struct MInterfacePointer *pObject /* [in] [ref] */,
			 int32_t lFlags /* [in]  */,
			 struct MInterfacePointer *pCtx /* [in] [ref] */,
			 struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			 WERROR *werror)
{
	struct PutClass r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pObject = pObject;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutClass, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTCLASS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutClass, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PutClassAsync(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct MInterfacePointer *pObject /* [in] [ref] */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			      WERROR *werror)
{
	struct PutClassAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pObject = pObject;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutClassAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTCLASSASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutClassAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DeleteClass(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct BSTR strClass /* [in]  */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror)
{
	struct DeleteClass r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strClass = strClass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteClass, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETECLASS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteClass, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DeleteClassAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct BSTR strClass /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror)
{
	struct DeleteClassAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strClass = strClass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteClassAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETECLASSASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteClassAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_CreateClassEnum(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strSuperclass /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer **ppEnum /* [out] [ref] */,
				WERROR *werror)
{
	struct CreateClassEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strSuperclass = strSuperclass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateClassEnum, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATECLASSENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateClassEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_CreateClassEnumAsync(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS ORPCthis /* [in]  */,
				     struct BSTR strSuperclass /* [in]  */,
				     int32_t lFlags /* [in]  */,
				     struct MInterfacePointer *pCtx /* [in] [ref] */,
				     struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				     WERROR *werror)
{
	struct CreateClassEnumAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strSuperclass = strSuperclass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateClassEnumAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATECLASSENUMASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateClassEnumAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PutInstance(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct MInterfacePointer *pInst /* [in] [ref] */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror)
{
	struct PutInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pInst = pInst;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutInstance, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PutInstanceAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct MInterfacePointer *pInst /* [in] [ref] */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror)
{
	struct PutInstanceAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pInst = pInst;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PutInstanceAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_PUTINSTANCEASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PutInstanceAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DeleteInstance(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			       WERROR *werror)
{
	struct DeleteInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.ppCallResult = ppCallResult;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteInstance, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DeleteInstanceAsync(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS ORPCthis /* [in]  */,
				    struct BSTR strObjectPath /* [in]  */,
				    int32_t lFlags /* [in]  */,
				    struct MInterfacePointer *pCtx /* [in] [ref] */,
				    struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				    WERROR *werror)
{
	struct DeleteInstanceAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteInstanceAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_DELETEINSTANCEASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteInstanceAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_CreateInstanceEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   struct BSTR strFilter /* [in]  */,
				   int32_t lFlags /* [in]  */,
				   struct MInterfacePointer *pCtx /* [in] [unique] */,
				   struct MInterfacePointer **ppEnum /* [out] [ref] */,
				   WERROR *werror)
{
	struct CreateInstanceEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strFilter = strFilter;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateInstanceEnum, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATEINSTANCEENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateInstanceEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_CreateInstanceEnumAsync(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					struct ORPCTHIS ORPCthis /* [in]  */,
					struct BSTR strSuperClass /* [in]  */,
					int32_t lFlags /* [in]  */,
					struct MInterfacePointer *pCtx /* [in] [ref] */,
					struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					WERROR *werror)
{
	struct CreateInstanceEnumAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strSuperClass = strSuperClass;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateInstanceEnumAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_CREATEINSTANCEENUMASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateInstanceEnumAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ExecQuery(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strQueryLanguage /* [in]  */,
			  struct BSTR strQuery /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppEnum /* [out] [ref] */,
			  WERROR *werror)
{
	struct ExecQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecQuery, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECQUERY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecQuery, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ExecQueryAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strQueryLanguage /* [in]  */,
			       struct BSTR strQuery /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror)
{
	struct ExecQueryAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecQueryAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECQUERYASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecQueryAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ExecNotificationQuery(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS ORPCthis /* [in]  */,
				      struct BSTR strQueryLanguage /* [in]  */,
				      struct BSTR strQuery /* [in]  */,
				      int32_t lFlags /* [in]  */,
				      struct MInterfacePointer *pCtx /* [in] [unique] */,
				      struct MInterfacePointer **ppEnum /* [out] [ref] */,
				      WERROR *werror)
{
	struct ExecNotificationQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecNotificationQuery, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECNOTIFICATIONQUERY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecNotificationQuery, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ExecNotificationQueryAsync(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct BSTR strQueryLanguage /* [in]  */,
					   struct BSTR strQuery /* [in]  */,
					   int32_t lFlags /* [in]  */,
					   struct MInterfacePointer *pCtx /* [in] [ref] */,
					   struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					   WERROR *werror)
{
	struct ExecNotificationQueryAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecNotificationQueryAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECNOTIFICATIONQUERYASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecNotificationQueryAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ExecMethod(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   struct BSTR strObjectPath /* [in]  */,
			   struct BSTR strMethodName /* [in]  */,
			   int32_t lFlags /* [in]  */,
			   struct MInterfacePointer *pCtx /* [in] [unique] */,
			   struct MInterfacePointer *pInParams /* [in] [unique] */,
			   struct MInterfacePointer **ppOutParams /* [in,out] [unique] */,
			   struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			   WERROR *werror)
{
	struct ExecMethod r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.strMethodName = strMethodName;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pInParams = pInParams;
	r.in.ppOutParams = ppOutParams;
	r.in.ppCallResult = ppCallResult;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecMethod, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECMETHOD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecMethod, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppOutParams && r.out.ppOutParams) {
		*ppOutParams = *r.out.ppOutParams;
	}
	if (ppCallResult && r.out.ppCallResult) {
		*ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ExecMethodAsync(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strObjectPath /* [in]  */,
				struct BSTR strMethodName /* [in]  */,
				uint32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer *pInParams /* [in] [ref] */,
				struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				WERROR *werror)
{
	struct ExecMethodAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.strObjectPath = strObjectPath;
	r.in.strMethodName = strMethodName;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;
	r.in.pInParams = pInParams;
	r.in.pResponseHandler = pResponseHandler;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ExecMethodAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemServices,
				NDR_EXECMETHODASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ExecMethodAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Reset(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      WERROR *werror)
{
	struct Reset r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Reset, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_RESET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Reset, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_IEnumWbemClassObject_Next(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS ORPCthis /* [in]  */,
					  int32_t lTimeout /* [in]  */,
					  uint32_t uCount /* [in]  */,
					  struct MInterfacePointer **apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
					  uint32_t *puReturned /* [out] [ref] */,
					  WERROR *werror)
{
	struct IEnumWbemClassObject_Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;
	r.in.uCount = uCount;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IEnumWbemClassObject_Next, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_IENUMWBEMCLASSOBJECT_NEXT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IEnumWbemClassObject_Next, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	memcpy(apObjects, r.out.apObjects, r.in.uCount * sizeof(*apObjects));
	*puReturned = *r.out.puReturned;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_NextAsync(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  uint32_t uCount /* [in]  */,
			  struct MInterfacePointer *pSink /* [in] [ref] */,
			  WERROR *werror)
{
	struct NextAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.uCount = uCount;
	r.in.pSink = pSink;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NextAsync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_NEXTASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NextAsync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_IEnumWbemClassObject_Clone(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct MInterfacePointer **ppEnum /* [out] [ref] */,
					   WERROR *werror)
{
	struct IEnumWbemClassObject_Clone r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IEnumWbemClassObject_Clone, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_IENUMWBEMCLASSOBJECT_CLONE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IEnumWbemClassObject_Clone, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Skip(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     int32_t lTimeout /* [in]  */,
		     uint32_t nCount /* [in]  */,
		     WERROR *werror)
{
	struct Skip r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;
	r.in.nCount = nCount;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Skip, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IEnumWbemClassObject,
				NDR_SKIP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Skip, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Clone(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppNewCopy /* [out] [ref] */,
		      WERROR *werror)
{
	struct Clone r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Clone, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_CLONE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Clone, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppNewCopy = *r.out.ppNewCopy;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetNames(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror)
{
	struct GetNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetNames, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_GETNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetNames, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_BeginEnumeration(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 WERROR *werror)
{
	struct BeginEnumeration r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lFlags = lFlags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(BeginEnumeration, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_BEGINENUMERATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(BeginEnumeration, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Next(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     WERROR *werror)
{
	struct Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Next, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_NEXT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Next, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EndEnumeration(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       WERROR *werror)
{
	struct EndEnumeration r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EndEnumeration, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_ENDENUMERATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EndEnumeration, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_SetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror)
{
	struct SetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(SetValue, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_SETVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(SetValue, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror)
{
	struct GetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetValue, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_GETVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetValue, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DeleteValue(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    WERROR *werror)
{
	struct DeleteValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteValue, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_DELETEVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteValue, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DeleteAll(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  WERROR *werror)
{
	struct DeleteAll r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DeleteAll, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemContext,
				NDR_DELETEALL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DeleteAll, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EstablishPosition(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  const char *wszLocaleList /* [in] [unique,charset(UTF16)] */,
				  uint32_t dwNumLocales /* [in]  */,
				  uint32_t *reserved /* [out] [ref] */,
				  WERROR *werror)
{
	struct EstablishPosition r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszLocaleList = wszLocaleList;
	r.in.dwNumLocales = dwNumLocales;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EstablishPosition, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_ESTABLISHPOSITION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EstablishPosition, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*reserved = *r.out.reserved;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_RequestChallenge(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
				 const char *wszUser /* [in] [unique,charset(UTF16)] */,
				 uint8_t *Nonce /* [out] [ref,length_is(16),size_is(16)] */,
				 WERROR *werror)
{
	struct RequestChallenge r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszNetworkResource = wszNetworkResource;
	r.in.wszUser = wszUser;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RequestChallenge, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_REQUESTCHALLENGE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RequestChallenge, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	memcpy(Nonce, r.out.Nonce, 16 * sizeof(*Nonce));

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_WBEMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  uint8_t *AccessToken /* [in] [unique,length_is(16),size_is(16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror)
{
	struct WBEMLogin r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszPreferredLocale = wszPreferredLocale;
	r.in.AccessToken = AccessToken;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(WBEMLogin, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_WBEMLOGIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(WBEMLogin, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppNamespace = *r.out.ppNamespace;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_NTLMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror)
{
	struct NTLMLogin r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.wszNetworkResource = wszNetworkResource;
	r.in.wszPreferredLocale = wszPreferredLocale;
	r.in.lFlags = lFlags;
	r.in.pCtx = pCtx;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NTLMLogin, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemLevel1Login,
				NDR_NTLMLOGIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NTLMLogin, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppNamespace = *r.out.ppNamespace;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_IWbemWCOSmartEnum_Next(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				       struct ORPCTHIS ORPCthis /* [in]  */,
				       struct GUID *gEWCO /* [in] [ref] */,
				       uint32_t lTimeOut /* [in]  */,
				       uint32_t uCount /* [in]  */,
				       uint32_t unknown /* [in]  */,
				       struct GUID *gWCO /* [in] [ref] */,
				       uint32_t *puReturned /* [out] [ref] */,
				       uint32_t *pSize /* [out] [ref] */,
				       uint8_t **pData /* [out] [noprint,ref,size_is(,*pSize)] */,
				       WERROR *werror)
{
	struct IWbemWCOSmartEnum_Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.gEWCO = gEWCO;
	r.in.lTimeOut = lTimeOut;
	r.in.uCount = uCount;
	r.in.unknown = unknown;
	r.in.gWCO = gWCO;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IWbemWCOSmartEnum_Next, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemWCOSmartEnum,
				NDR_IWBEMWCOSMARTENUM_NEXT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IWbemWCOSmartEnum_Next, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*puReturned = *r.out.puReturned;
	*pSize = *r.out.pSize;
	*pData = *r.out.pData;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Fetch(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppEnum /* [out] [ref] */,
		      WERROR *werror)
{
	struct Fetch r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Fetch, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemFetchSmartEnum,
				NDR_FETCH,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Fetch, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Test(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     struct MInterfacePointer **ppEnum /* [out] [ref] */,
		     WERROR *werror)
{
	struct Test r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Test, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemFetchSmartEnum,
				NDR_TEST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Test, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppEnum = *r.out.ppEnum;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetResultObject(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct MInterfacePointer **ppResultObject /* [out] [ref] */,
				WERROR *werror)
{
	struct GetResultObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetResultObject, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETRESULTOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetResultObject, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppResultObject = *r.out.ppResultObject;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetResultString(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct BSTR *pstrResultString /* [out] [ref] */,
				WERROR *werror)
{
	struct GetResultString r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetResultString, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETRESULTSTRING,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetResultString, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*pstrResultString = *r.out.pstrResultString;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetResultServices(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  int32_t lTimeout /* [in]  */,
				  struct MInterfacePointer **ppServices /* [out] [ref] */,
				  WERROR *werror)
{
	struct GetResultServices r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetResultServices, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETRESULTSERVICES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetResultServices, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*ppServices = *r.out.ppServices;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetCallStatus(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      int32_t lTimeout /* [in]  */,
			      int32_t *plStatus /* [out] [ref] */,
			      WERROR *werror)
{
	struct GetCallStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lTimeout = lTimeout;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetCallStatus, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemCallResult,
				NDR_GETCALLSTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetCallStatus, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*plStatus = *r.out.plStatus;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_SetStatus(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  WERROR hResult /* [in]  */,
			  struct BSTR strParam /* [in]  */,
			  struct MInterfacePointer *pObjParam /* [in] [ref] */,
			  WERROR *werror)
{
	struct SetStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lFlags = lFlags;
	r.in.hResult = hResult;
	r.in.strParam = strParam;
	r.in.pObjParam = pObjParam;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(SetStatus, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemObjectSink,
				NDR_SETSTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(SetStatus, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Indicate(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 int32_t lObjectCount /* [in]  */,
			 struct MInterfacePointer **apObjArray /* [in] [ref,size_is(lObjectCount)] */,
			 WERROR *werror)
{
	struct Indicate r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lObjectCount = lObjectCount;
	r.in.apObjArray = apObjArray;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Indicate, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IWbemObjectSink,
				NDR_INDICATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Indicate, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

