/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_remact.h"

NTSTATUS rpccli_RemoteActivation(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHIS this_object /* [in]  */,
				 struct ORPCTHAT *that /* [out] [ref] */,
				 struct GUID Clsid /* [in]  */,
				 const char *pwszObjectName /* [in] [ref,charset(UTF16)] */,
				 struct MInterfacePointer *pObjectStorage /* [in] [ref] */,
				 uint32_t ClientImpLevel /* [in]  */,
				 uint32_t Mode /* [in]  */,
				 uint32_t Interfaces /* [in] [range(1,32768)] */,
				 struct GUID *pIIDs /* [in] [ref,size_is(Interfaces)] */,
				 uint16_t num_protseqs /* [in]  */,
				 uint16_t *protseq /* [in] [size_is(num_protseqs)] */,
				 uint64_t *pOxid /* [out] [ref] */,
				 struct DUALSTRINGARRAY *pdsaOxidBindings /* [out] [ref] */,
				 struct GUID *ipidRemUnknown /* [out] [ref] */,
				 uint32_t *AuthnHint /* [out] [ref] */,
				 struct COMVERSION *ServerVersion /* [out] [ref] */,
				 WERROR *hr /* [out] [ref] */,
				 struct MInterfacePointer **ifaces /* [out] [ref,size_is(Interfaces)] */,
				 WERROR *results /* [out] [size_is(Interfaces)] */,
				 WERROR *werror)
{
	struct RemoteActivation r;
	NTSTATUS status;

	/* In parameters */
	r.in.this_object = this_object;
	r.in.Clsid = Clsid;
	r.in.pwszObjectName = pwszObjectName;
	r.in.pObjectStorage = pObjectStorage;
	r.in.ClientImpLevel = ClientImpLevel;
	r.in.Mode = Mode;
	r.in.Interfaces = Interfaces;
	r.in.pIIDs = pIIDs;
	r.in.num_protseqs = num_protseqs;
	r.in.protseq = protseq;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemoteActivation, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemoteActivation,
				NDR_REMOTEACTIVATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemoteActivation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*that = *r.out.that;
	*pOxid = *r.out.pOxid;
	*pdsaOxidBindings = *r.out.pdsaOxidBindings;
	*ipidRemUnknown = *r.out.ipidRemUnknown;
	*AuthnHint = *r.out.AuthnHint;
	*ServerVersion = *r.out.ServerVersion;
	*hr = *r.out.hr;
	memcpy(ifaces, r.out.ifaces, r.in.Interfaces * sizeof(*ifaces));
	memcpy(results, r.out.results, r.in.Interfaces * sizeof(*results));

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

