/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_dcom.h"

NTSTATUS rpccli_UseProtSeq(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx)
{
	struct UseProtSeq r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(UseProtSeq, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_dcom_Unknown,
				NDR_USEPROTSEQ,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(UseProtSeq, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetCustomProtseqInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx)
{
	struct GetCustomProtseqInfo r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetCustomProtseqInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_dcom_Unknown,
				NDR_GETCUSTOMPROTSEQINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetCustomProtseqInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_UpdateResolverBindings(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct UpdateResolverBindings r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(UpdateResolverBindings, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_dcom_Unknown,
				NDR_UPDATERESOLVERBINDINGS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(UpdateResolverBindings, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_QueryInterface(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct GUID *iid /* [in] [unique] */,
			       struct MInterfacePointer **data /* [out] [ref,iid_is(riid)] */,
			       WERROR *werror)
{
	struct QueryInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.iid = iid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(QueryInterface, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IUnknown,
				NDR_QUERYINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(QueryInterface, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*data = *r.out.data;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_AddRef(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */)
{
	struct AddRef r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(AddRef, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IUnknown,
				NDR_ADDREF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(AddRef, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Release(struct rpc_pipe_client *cli,
			TALLOC_CTX *mem_ctx,
			struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			struct ORPCTHIS ORPCthis /* [in]  */)
{
	struct Release r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Release, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IUnknown,
				NDR_RELEASE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Release, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_CreateInstance(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct MInterfacePointer *pUnknown /* [in] [unique] */,
			       struct GUID *iid /* [in] [unique] */,
			       struct MInterfacePointer *ppv /* [out] [unique,iid_is(riid)] */,
			       WERROR *werror)
{
	struct CreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pUnknown = pUnknown;
	r.in.iid = iid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateInstance, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_CREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppv && r.out.ppv) {
		*ppv = *r.out.ppv;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_RemoteCreateInstance(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS ORPCthis /* [in]  */,
				     WERROR *werror)
{
	struct RemoteCreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemoteCreateInstance, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_REMOTECREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemoteCreateInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_LockServer(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   uint8_t lock /* [in]  */,
			   WERROR *werror)
{
	struct LockServer r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lock = lock;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(LockServer, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_LOCKSERVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(LockServer, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_RemoteLockServer(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 WERROR *werror)
{
	struct RemoteLockServer r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemoteLockServer, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_REMOTELOCKSERVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemoteLockServer, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_RemQueryInterface(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  struct GUID *ripid /* [in] [unique] */,
				  uint32_t cRefs /* [in]  */,
				  uint16_t cIids /* [in]  */,
				  struct GUID *iids /* [in] [unique,size_is(cIids)] */,
				  struct MInterfacePointer *ip /* [out] [unique,size_is(cIids)] */,
				  WERROR *werror)
{
	struct RemQueryInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.ripid = ripid;
	r.in.cRefs = cRefs;
	r.in.cIids = cIids;
	r.in.iids = iids;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemQueryInterface, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown,
				NDR_REMQUERYINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemQueryInterface, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ip && r.out.ip) {
		memcpy(ip, r.out.ip, r.in.cIids * sizeof(*ip));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_RemAddRef(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  uint16_t cInterfaceRefs /* [in]  */,
			  struct REMINTERFACEREF *InterfaceRefs /* [in] [size_is(cInterfaceRefs)] */,
			  WERROR *pResults /* [out] [unique,size_is(cInterfaceRefs)] */,
			  WERROR *werror)
{
	struct RemAddRef r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.cInterfaceRefs = cInterfaceRefs;
	r.in.InterfaceRefs = InterfaceRefs;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemAddRef, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown,
				NDR_REMADDREF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemAddRef, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (pResults && r.out.pResults) {
		memcpy(pResults, r.out.pResults, r.in.cInterfaceRefs * sizeof(*pResults));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_RemRelease(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   uint16_t cInterfaceRefs /* [in]  */,
			   struct REMINTERFACEREF *InterfaceRefs /* [in] [size_is(cInterfaceRefs)] */,
			   WERROR *werror)
{
	struct RemRelease r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.cInterfaceRefs = cInterfaceRefs;
	r.in.InterfaceRefs = InterfaceRefs;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemRelease, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown,
				NDR_REMRELEASE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemRelease, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetClassObject(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct GUID clsid /* [in]  */,
			       uint32_t context /* [in]  */,
			       uint32_t locale /* [in]  */,
			       struct GUID iid /* [in]  */,
			       struct MInterfacePointer *data /* [out] [ref,iid_is(iid)] */)
{
	struct GetClassObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.clsid = clsid;
	r.in.context = context;
	r.in.locale = locale;
	r.in.iid = iid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetClassObject, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassActivator,
				NDR_GETCLASSOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetClassObject, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*data = *r.out.data;

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ISCMLocalActivator_CreateInstance(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
						  struct ORPCTHIS ORPCthis /* [in]  */,
						  WERROR *werror)
{
	struct ISCMLocalActivator_CreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ISCMLocalActivator_CreateInstance, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ISCMLocalActivator,
				NDR_ISCMLOCALACTIVATOR_CREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ISCMLocalActivator_CreateInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_IMachineLocalActivator_foo(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   WERROR *werror)
{
	struct IMachineLocalActivator_foo r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IMachineLocalActivator_foo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IMachineLocalActivator,
				NDR_IMACHINELOCALACTIVATOR_FOO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IMachineLocalActivator_foo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ILocalObjectExporter_Foo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct ILocalObjectExporter_Foo r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ILocalObjectExporter_Foo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ILocalObjectExporter,
				NDR_ILOCALOBJECTEXPORTER_FOO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ILocalObjectExporter_Foo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_ISystemActivatorRemoteCreateInstance(struct rpc_pipe_client *cli,
						     TALLOC_CTX *mem_ctx,
						     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
						     struct ORPCTHIS ORPCthis /* [in]  */,
						     uint64_t unknown1 /* [in]  */,
						     struct MInterfacePointer iface1 /* [in]  */,
						     uint64_t unknown2 /* [in]  */,
						     uint32_t *unknown3 /* [out] [ref] */,
						     struct MInterfacePointer *iface2 /* [out] [ref] */,
						     WERROR *werror)
{
	struct ISystemActivatorRemoteCreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.unknown1 = unknown1;
	r.in.iface1 = iface1;
	r.in.unknown2 = unknown2;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ISystemActivatorRemoteCreateInstance, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ISystemActivator,
				NDR_ISYSTEMACTIVATORREMOTECREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ISystemActivatorRemoteCreateInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*unknown3 = *r.out.unknown3;
	*iface2 = *r.out.iface2;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_RemQueryInterface2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   struct GUID *ripid /* [in] [unique] */,
				   uint16_t cIids /* [in]  */,
				   struct GUID *iids /* [in] [unique,size_is(cIids)] */,
				   WERROR *phr /* [out] [unique,size_is(cIids)] */,
				   struct MInterfacePointer *ppMIF /* [out] [unique,size_is(cIids)] */,
				   WERROR *werror)
{
	struct RemQueryInterface2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.ripid = ripid;
	r.in.cIids = cIids;
	r.in.iids = iids;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemQueryInterface2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown2,
				NDR_REMQUERYINTERFACE2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemQueryInterface2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (phr && r.out.phr) {
		memcpy(phr, r.out.phr, r.in.cIids * sizeof(*phr));
	}
	if (ppMIF && r.out.ppMIF) {
		memcpy(ppMIF, r.out.ppMIF, r.in.cIids * sizeof(*ppMIF));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetTypeInfoCount(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 uint16_t *pctinfo /* [out] [unique] */,
				 WERROR *werror)
{
	struct GetTypeInfoCount r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetTypeInfoCount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_GETTYPEINFOCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetTypeInfoCount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (pctinfo && r.out.pctinfo) {
		*pctinfo = *r.out.pctinfo;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetTypeInfo(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    uint16_t iTInfo /* [in]  */,
			    uint32_t lcid /* [in]  */,
			    struct REF_ITypeInfo *ppTInfo /* [out] [unique] */,
			    WERROR *werror)
{
	struct GetTypeInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.iTInfo = iTInfo;
	r.in.lcid = lcid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetTypeInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_GETTYPEINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetTypeInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppTInfo && r.out.ppTInfo) {
		*ppTInfo = *r.out.ppTInfo;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_GetIDsOfNames(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct GUID *riid /* [in] [unique] */,
			      uint16_t cNames /* [in]  */,
			      uint32_t lcid /* [in]  */,
			      uint32_t *rgDispId /* [out] [unique,size_is(cNames)] */,
			      WERROR *werror)
{
	struct GetIDsOfNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.riid = riid;
	r.in.cNames = cNames;
	r.in.lcid = lcid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetIDsOfNames, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_GETIDSOFNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetIDsOfNames, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (rgDispId && r.out.rgDispId) {
		memcpy(rgDispId, r.out.rgDispId, r.in.cNames * sizeof(*rgDispId));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Invoke(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */,
		       uint32_t dispIdMember /* [in]  */,
		       struct GUID *riid /* [in] [unique] */,
		       uint32_t lcid /* [in]  */,
		       uint16_t wFlags /* [in]  */,
		       struct DISPPARAMS *pDispParams /* [in,out] [unique] */,
		       struct VARIANT *pVarResult /* [out] [unique] */,
		       struct EXCEPINFO *pExcepInfo /* [out] [unique] */,
		       uint16_t *puArgErr /* [out] [unique] */,
		       WERROR *werror)
{
	struct Invoke r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.dispIdMember = dispIdMember;
	r.in.riid = riid;
	r.in.lcid = lcid;
	r.in.wFlags = wFlags;
	r.in.pDispParams = pDispParams;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Invoke, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_INVOKE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Invoke, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (pDispParams && r.out.pDispParams) {
		*pDispParams = *r.out.pDispParams;
	}
	if (pVarResult && r.out.pVarResult) {
		*pVarResult = *r.out.pVarResult;
	}
	if (pExcepInfo && r.out.pExcepInfo) {
		*pExcepInfo = *r.out.pExcepInfo;
	}
	if (puArgErr && r.out.puArgErr) {
		*puArgErr = *r.out.puArgErr;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_MarshalInterface(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 WERROR *werror)
{
	struct MarshalInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(MarshalInterface, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IMarshal,
				NDR_MARSHALINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(MarshalInterface, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_UnMarshalInterface(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   WERROR *werror)
{
	struct UnMarshalInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(UnMarshalInterface, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IMarshal,
				NDR_UNMARSHALINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(UnMarshalInterface, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_MakeCoffee(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   const char *flavor /* [in] [ref,charset(UTF16)] */,
			   WERROR *werror)
{
	struct MakeCoffee r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.flavor = flavor;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(MakeCoffee, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ICoffeeMachine,
				NDR_MAKECOFFEE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(MakeCoffee, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Read(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     uint8_t *pv /* [out] [length_is(*num_read),size_is(num_requested)] */,
		     uint32_t num_requested /* [in]  */,
		     uint32_t *num_readx /* [in] [unique] */,
		     uint32_t *num_read /* [out] [ref] */,
		     WERROR *werror)
{
	struct Read r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.num_requested = num_requested;
	r.in.num_readx = num_readx;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Read, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IStream,
				NDR_READ,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Read, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	memcpy(pv, r.out.pv, r.in.num_requested * sizeof(*pv));
	*num_read = *r.out.num_read;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_Write(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      uint8_t *data /* [in] [unique,size_is(num_requested)] */,
		      uint32_t num_requested /* [in]  */,
		      uint32_t *num_written /* [out] [ref] */,
		      WERROR *werror)
{
	struct Write r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.data = data;
	r.in.num_requested = num_requested;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Write, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IStream,
				NDR_WRITE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Write, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*num_written = *r.out.num_written;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

