/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_spoolss.h"

static bool api_spoolss_EnumPrinters(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPrinters *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPRINTERS];

	r = talloc(talloc_tos(), struct spoolss_EnumPrinters);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinters, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero_array(r, union spoolss_PrinterInfo, r->out.count);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumPrinters(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinters, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_OpenPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_OpenPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_OPENPRINTER];

	r = talloc(talloc_tos(), struct spoolss_OpenPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_OpenPrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = talloc_zero(r, struct policy_handle);
	if (r->out.handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_OpenPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_OpenPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_SetJob(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_SetJob *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_SETJOB];

	r = talloc(talloc_tos(), struct spoolss_SetJob);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetJob, r);
	}

	r->out.result = _spoolss_SetJob(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetJob, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetJob(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetJob *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETJOB];

	r = talloc(talloc_tos(), struct spoolss_GetJob);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetJob, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union spoolss_JobInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_GetJob(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetJob, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumJobs(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumJobs *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMJOBS];

	r = talloc(talloc_tos(), struct spoolss_EnumJobs);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumJobs, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero_array(r, union spoolss_JobInfo, r->out.count);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumJobs(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumJobs, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPRINTER];

	r = talloc(talloc_tos(), struct spoolss_AddPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinter, r);
	}

	r->out.result = _spoolss_AddPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTER];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinter, r);
	}

	r->out.result = _spoolss_DeletePrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_SetPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_SetPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_SETPRINTER];

	r = talloc(talloc_tos(), struct spoolss_SetPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetPrinter, r);
	}

	r->out.result = _spoolss_SetPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETPRINTER];

	r = talloc(talloc_tos(), struct spoolss_GetPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union spoolss_PrinterInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_GetPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPrinterDriver(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPrinterDriver *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPRINTERDRIVER];

	r = talloc(talloc_tos(), struct spoolss_AddPrinterDriver);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterDriver, r);
	}

	r->out.result = _spoolss_AddPrinterDriver(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterDriver, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumPrinterDrivers(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPrinterDrivers *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPRINTERDRIVERS];

	r = talloc(talloc_tos(), struct spoolss_EnumPrinterDrivers);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterDrivers, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero_array(r, union spoolss_DriverInfo, r->out.count);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumPrinterDrivers(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterDrivers, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetPrinterDriver(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetPrinterDriver *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETPRINTERDRIVER];

	r = talloc(talloc_tos(), struct spoolss_GetPrinterDriver);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDriver, r);
	}

	r->out.result = _spoolss_GetPrinterDriver(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDriver, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetPrinterDriverDirectory(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetPrinterDriverDirectory *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETPRINTERDRIVERDIRECTORY];

	r = talloc(talloc_tos(), struct spoolss_GetPrinterDriverDirectory);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDriverDirectory, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union spoolss_DriverDirectoryInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_GetPrinterDriverDirectory(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDriverDirectory, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinterDriver(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinterDriver *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTERDRIVER];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinterDriver);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterDriver, r);
	}

	r->out.result = _spoolss_DeletePrinterDriver(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterDriver, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPrintProcessor(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPrintProcessor *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPRINTPROCESSOR];

	r = talloc(talloc_tos(), struct spoolss_AddPrintProcessor);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrintProcessor, r);
	}

	r->out.result = _spoolss_AddPrintProcessor(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrintProcessor, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumPrintProcessors(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPrintProcessors *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPRINTPROCESSORS];

	r = talloc(talloc_tos(), struct spoolss_EnumPrintProcessors);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrintProcessors, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero_array(r, union spoolss_PrintProcessorInfo, r->out.count);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumPrintProcessors(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrintProcessors, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetPrintProcessorDirectory(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetPrintProcessorDirectory *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETPRINTPROCESSORDIRECTORY];

	r = talloc(talloc_tos(), struct spoolss_GetPrintProcessorDirectory);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrintProcessorDirectory, r);
	}

	r->out.result = _spoolss_GetPrintProcessorDirectory(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrintProcessorDirectory, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_StartDocPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_StartDocPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_STARTDOCPRINTER];

	r = talloc(talloc_tos(), struct spoolss_StartDocPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_StartDocPrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.job_id = talloc_zero(r, uint32_t);
	if (r->out.job_id == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_StartDocPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_StartDocPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_StartPagePrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_StartPagePrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_STARTPAGEPRINTER];

	r = talloc(talloc_tos(), struct spoolss_StartPagePrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_StartPagePrinter, r);
	}

	r->out.result = _spoolss_StartPagePrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_StartPagePrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_WritePrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_WritePrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_WRITEPRINTER];

	r = talloc(talloc_tos(), struct spoolss_WritePrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_WritePrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.num_written = talloc_zero(r, uint32_t);
	if (r->out.num_written == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_WritePrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_WritePrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EndPagePrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EndPagePrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENDPAGEPRINTER];

	r = talloc(talloc_tos(), struct spoolss_EndPagePrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EndPagePrinter, r);
	}

	r->out.result = _spoolss_EndPagePrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EndPagePrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AbortPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AbortPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ABORTPRINTER];

	r = talloc(talloc_tos(), struct spoolss_AbortPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AbortPrinter, r);
	}

	r->out.result = _spoolss_AbortPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AbortPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ReadPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ReadPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_READPRINTER];

	r = talloc(talloc_tos(), struct spoolss_ReadPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ReadPrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.data = talloc_zero(r, DATA_BLOB);
	if (r->out.data == NULL) {
		talloc_free(r);
		return false;
	}

	r->out._data_size = talloc_zero(r, uint32_t);
	if (r->out._data_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_ReadPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ReadPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EndDocPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EndDocPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENDDOCPRINTER];

	r = talloc(talloc_tos(), struct spoolss_EndDocPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EndDocPrinter, r);
	}

	r->out.result = _spoolss_EndDocPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EndDocPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddJob(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddJob *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDJOB];

	r = talloc(talloc_tos(), struct spoolss_AddJob);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddJob, r);
	}

	r->out.result = _spoolss_AddJob(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddJob, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ScheduleJob(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ScheduleJob *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_SCHEDULEJOB];

	r = talloc(talloc_tos(), struct spoolss_ScheduleJob);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ScheduleJob, r);
	}

	r->out.result = _spoolss_ScheduleJob(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ScheduleJob, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetPrinterData(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetPrinterData *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETPRINTERDATA];

	r = talloc(talloc_tos(), struct spoolss_GetPrinterData);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterData, r);
	}

	ZERO_STRUCT(r->out);
	r->out.type = talloc_zero(r, enum spoolss_PrinterDataType);
	if (r->out.type == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data = talloc_zero(r, union spoolss_PrinterData);
	if (r->out.data == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_GetPrinterData(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterData, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_SetPrinterData(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_SetPrinterData *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_SETPRINTERDATA];

	r = talloc(talloc_tos(), struct spoolss_SetPrinterData);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetPrinterData, r);
	}

	r->out.result = _spoolss_SetPrinterData(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetPrinterData, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_WaitForPrinterChange(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_WaitForPrinterChange *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_WAITFORPRINTERCHANGE];

	r = talloc(talloc_tos(), struct spoolss_WaitForPrinterChange);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_WaitForPrinterChange, r);
	}

	r->out.result = _spoolss_WaitForPrinterChange(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_WaitForPrinterChange, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ClosePrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ClosePrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_CLOSEPRINTER];

	r = talloc(talloc_tos(), struct spoolss_ClosePrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ClosePrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = r->in.handle;
	r->out.result = _spoolss_ClosePrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ClosePrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddForm(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddForm *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDFORM];

	r = talloc(talloc_tos(), struct spoolss_AddForm);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddForm, r);
	}

	r->out.result = _spoolss_AddForm(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddForm, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeleteForm(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeleteForm *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEFORM];

	r = talloc(talloc_tos(), struct spoolss_DeleteForm);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeleteForm, r);
	}

	r->out.result = _spoolss_DeleteForm(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeleteForm, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetForm(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetForm *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETFORM];

	r = talloc(talloc_tos(), struct spoolss_GetForm);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetForm, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union spoolss_FormInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_GetForm(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetForm, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_SetForm(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_SetForm *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_SETFORM];

	r = talloc(talloc_tos(), struct spoolss_SetForm);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetForm, r);
	}

	r->out.result = _spoolss_SetForm(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetForm, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumForms(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumForms *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMFORMS];

	r = talloc(talloc_tos(), struct spoolss_EnumForms);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumForms, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero_array(r, union spoolss_FormInfo, r->out.count);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumForms(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumForms, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumPorts(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPorts *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPORTS];

	r = talloc(talloc_tos(), struct spoolss_EnumPorts);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPorts, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero_array(r, union spoolss_PortInfo, r->out.count);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumPorts(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPorts, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumMonitors(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumMonitors *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMMONITORS];

	r = talloc(talloc_tos(), struct spoolss_EnumMonitors);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumMonitors, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero_array(r, union spoolss_MonitorInfo, r->out.count);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumMonitors(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumMonitors, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPort(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPort *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPORT];

	r = talloc(talloc_tos(), struct spoolss_AddPort);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPort, r);
	}

	r->out.result = _spoolss_AddPort(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPort, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ConfigurePort(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ConfigurePort *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_CONFIGUREPORT];

	r = talloc(talloc_tos(), struct spoolss_ConfigurePort);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ConfigurePort, r);
	}

	r->out.result = _spoolss_ConfigurePort(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ConfigurePort, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePort(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePort *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPORT];

	r = talloc(talloc_tos(), struct spoolss_DeletePort);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePort, r);
	}

	r->out.result = _spoolss_DeletePort(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePort, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_CreatePrinterIC(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_CreatePrinterIC *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_CREATEPRINTERIC];

	r = talloc(talloc_tos(), struct spoolss_CreatePrinterIC);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_CreatePrinterIC, r);
	}

	r->out.result = _spoolss_CreatePrinterIC(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_CreatePrinterIC, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_PlayGDIScriptOnPrinterIC(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_PlayGDIScriptOnPrinterIC *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_PLAYGDISCRIPTONPRINTERIC];

	r = talloc(talloc_tos(), struct spoolss_PlayGDIScriptOnPrinterIC);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, r);
	}

	r->out.result = _spoolss_PlayGDIScriptOnPrinterIC(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinterIC(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinterIC *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTERIC];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinterIC);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterIC, r);
	}

	r->out.result = _spoolss_DeletePrinterIC(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterIC, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPrinterConnection(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPrinterConnection *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPRINTERCONNECTION];

	r = talloc(talloc_tos(), struct spoolss_AddPrinterConnection);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterConnection, r);
	}

	r->out.result = _spoolss_AddPrinterConnection(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterConnection, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinterConnection(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinterConnection *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTERCONNECTION];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinterConnection);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterConnection, r);
	}

	r->out.result = _spoolss_DeletePrinterConnection(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterConnection, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_PrinterMessageBox(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_PrinterMessageBox *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_PRINTERMESSAGEBOX];

	r = talloc(talloc_tos(), struct spoolss_PrinterMessageBox);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_PrinterMessageBox, r);
	}

	r->out.result = _spoolss_PrinterMessageBox(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_PrinterMessageBox, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddMonitor(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddMonitor *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDMONITOR];

	r = talloc(talloc_tos(), struct spoolss_AddMonitor);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddMonitor, r);
	}

	r->out.result = _spoolss_AddMonitor(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddMonitor, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeleteMonitor(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeleteMonitor *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEMONITOR];

	r = talloc(talloc_tos(), struct spoolss_DeleteMonitor);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeleteMonitor, r);
	}

	r->out.result = _spoolss_DeleteMonitor(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeleteMonitor, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrintProcessor(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrintProcessor *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTPROCESSOR];

	r = talloc(talloc_tos(), struct spoolss_DeletePrintProcessor);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrintProcessor, r);
	}

	r->out.result = _spoolss_DeletePrintProcessor(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrintProcessor, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPrintProvidor(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPrintProvidor *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPRINTPROVIDOR];

	r = talloc(talloc_tos(), struct spoolss_AddPrintProvidor);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrintProvidor, r);
	}

	r->out.result = _spoolss_AddPrintProvidor(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrintProvidor, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrintProvidor(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrintProvidor *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTPROVIDOR];

	r = talloc(talloc_tos(), struct spoolss_DeletePrintProvidor);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrintProvidor, r);
	}

	r->out.result = _spoolss_DeletePrintProvidor(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrintProvidor, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumPrintProcDataTypes(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPrintProcDataTypes *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPRINTPROCDATATYPES];

	r = talloc(talloc_tos(), struct spoolss_EnumPrintProcDataTypes);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrintProcDataTypes, r);
	}

	r->out.result = _spoolss_EnumPrintProcDataTypes(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrintProcDataTypes, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ResetPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ResetPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_RESETPRINTER];

	r = talloc(talloc_tos(), struct spoolss_ResetPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ResetPrinter, r);
	}

	r->out.result = _spoolss_ResetPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ResetPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetPrinterDriver2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetPrinterDriver2 *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETPRINTERDRIVER2];

	r = talloc(talloc_tos(), struct spoolss_GetPrinterDriver2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDriver2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, DATA_BLOB);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.server_major_version = talloc_zero(r, uint32_t);
	if (r->out.server_major_version == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.server_minor_version = talloc_zero(r, uint32_t);
	if (r->out.server_minor_version == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_GetPrinterDriver2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDriver2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_FindFirstPrinterChangeNotification(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_FindFirstPrinterChangeNotification *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_FINDFIRSTPRINTERCHANGENOTIFICATION];

	r = talloc(talloc_tos(), struct spoolss_FindFirstPrinterChangeNotification);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_FindFirstPrinterChangeNotification, r);
	}

	r->out.result = _spoolss_FindFirstPrinterChangeNotification(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_FindFirstPrinterChangeNotification, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_FindNextPrinterChangeNotification(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_FindNextPrinterChangeNotification *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_FINDNEXTPRINTERCHANGENOTIFICATION];

	r = talloc(talloc_tos(), struct spoolss_FindNextPrinterChangeNotification);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_FindNextPrinterChangeNotification, r);
	}

	r->out.result = _spoolss_FindNextPrinterChangeNotification(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_FindNextPrinterChangeNotification, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_FindClosePrinterNotify(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_FindClosePrinterNotify *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_FINDCLOSEPRINTERNOTIFY];

	r = talloc(talloc_tos(), struct spoolss_FindClosePrinterNotify);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_FindClosePrinterNotify, r);
	}

	r->out.result = _spoolss_FindClosePrinterNotify(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_FindClosePrinterNotify, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_RouterFindFirstPrinterChangeNotificationOld(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATIONOLD];

	r = talloc(talloc_tos(), struct spoolss_RouterFindFirstPrinterChangeNotificationOld);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, r);
	}

	r->out.result = _spoolss_RouterFindFirstPrinterChangeNotificationOld(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ReplyOpenPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ReplyOpenPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_REPLYOPENPRINTER];

	r = talloc(talloc_tos(), struct spoolss_ReplyOpenPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ReplyOpenPrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = talloc_zero(r, struct policy_handle);
	if (r->out.handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_ReplyOpenPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ReplyOpenPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_RouterReplyPrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_RouterReplyPrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ROUTERREPLYPRINTER];

	r = talloc(talloc_tos(), struct spoolss_RouterReplyPrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterReplyPrinter, r);
	}

	r->out.result = _spoolss_RouterReplyPrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterReplyPrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ReplyClosePrinter(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ReplyClosePrinter *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_REPLYCLOSEPRINTER];

	r = talloc(talloc_tos(), struct spoolss_ReplyClosePrinter);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ReplyClosePrinter, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = r->in.handle;
	r->out.result = _spoolss_ReplyClosePrinter(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ReplyClosePrinter, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPortEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPortEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPORTEX];

	r = talloc(talloc_tos(), struct spoolss_AddPortEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPortEx, r);
	}

	r->out.result = _spoolss_AddPortEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPortEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_RouterFindFirstPrinterChangeNotification(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_RouterFindFirstPrinterChangeNotification *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATION];

	r = talloc(talloc_tos(), struct spoolss_RouterFindFirstPrinterChangeNotification);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, r);
	}

	r->out.result = _spoolss_RouterFindFirstPrinterChangeNotification(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_SpoolerInit(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_SpoolerInit *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_SPOOLERINIT];

	r = talloc(talloc_tos(), struct spoolss_SpoolerInit);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SpoolerInit, r);
	}

	r->out.result = _spoolss_SpoolerInit(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SpoolerInit, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_ResetPrinterEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_ResetPrinterEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_RESETPRINTEREX];

	r = talloc(talloc_tos(), struct spoolss_ResetPrinterEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ResetPrinterEx, r);
	}

	r->out.result = _spoolss_ResetPrinterEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ResetPrinterEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_RemoteFindFirstPrinterChangeNotifyEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_REMOTEFINDFIRSTPRINTERCHANGENOTIFYEX];

	r = talloc(talloc_tos(), struct spoolss_RemoteFindFirstPrinterChangeNotifyEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, r);
	}

	r->out.result = _spoolss_RemoteFindFirstPrinterChangeNotifyEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_RouterRefreshPrinterChangeNotification(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_RouterRefreshPrinterChangeNotification *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ROUTERREFRESHPRINTERCHANGENOTIFICATION];

	r = talloc(talloc_tos(), struct spoolss_RouterRefreshPrinterChangeNotification);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterRefreshPrinterChangeNotification, r);
	}

	r->out.result = _spoolss_RouterRefreshPrinterChangeNotification(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterRefreshPrinterChangeNotification, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_RemoteFindNextPrinterChangeNotifyEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_RemoteFindNextPrinterChangeNotifyEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_REMOTEFINDNEXTPRINTERCHANGENOTIFYEX];

	r = talloc(talloc_tos(), struct spoolss_RemoteFindNextPrinterChangeNotifyEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RemoteFindNextPrinterChangeNotifyEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct spoolss_NotifyInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_RemoteFindNextPrinterChangeNotifyEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RemoteFindNextPrinterChangeNotifyEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_44(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_44 *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_44];

	r = talloc(talloc_tos(), struct spoolss_44);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_44, r);
	}

	r->out.result = _spoolss_44(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_44, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_OpenPrinterEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_OpenPrinterEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_OPENPRINTEREX];

	r = talloc(talloc_tos(), struct spoolss_OpenPrinterEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_OpenPrinterEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = talloc_zero(r, struct policy_handle);
	if (r->out.handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_OpenPrinterEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_OpenPrinterEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPrinterEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPrinterEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPRINTEREX];

	r = talloc(talloc_tos(), struct spoolss_AddPrinterEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterEx, r);
	}

	r->out.result = _spoolss_AddPrinterEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_47(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_47 *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_47];

	r = talloc(talloc_tos(), struct spoolss_47);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_47, r);
	}

	r->out.result = _spoolss_47(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_47, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumPrinterData(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPrinterData *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPRINTERDATA];

	r = talloc(talloc_tos(), struct spoolss_EnumPrinterData);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterData, r);
	}

	ZERO_STRUCT(r->out);
	r->out.value_name = talloc_zero_array(r, const char, r->in.value_offered / 2);
	if (r->out.value_name == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.value_needed = talloc_zero(r, uint32_t);
	if (r->out.value_needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.printerdata_type = talloc_zero(r, uint32_t);
	if (r->out.printerdata_type == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.buffer = talloc_zero(r, DATA_BLOB);
	if (r->out.buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data_needed = talloc_zero(r, uint32_t);
	if (r->out.data_needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumPrinterData(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterData, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinterData(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinterData *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTERDATA];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinterData);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterData, r);
	}

	r->out.result = _spoolss_DeletePrinterData(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterData, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_4a(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_4a *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_4A];

	r = talloc(talloc_tos(), struct spoolss_4a);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_4a, r);
	}

	r->out.result = _spoolss_4a(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_4a, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_4b(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_4b *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_4B];

	r = talloc(talloc_tos(), struct spoolss_4b);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_4b, r);
	}

	r->out.result = _spoolss_4b(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_4b, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_4c(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_4c *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_4C];

	r = talloc(talloc_tos(), struct spoolss_4c);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_4c, r);
	}

	r->out.result = _spoolss_4c(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_4c, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_SetPrinterDataEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_SetPrinterDataEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_SETPRINTERDATAEX];

	r = talloc(talloc_tos(), struct spoolss_SetPrinterDataEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetPrinterDataEx, r);
	}

	r->out.result = _spoolss_SetPrinterDataEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetPrinterDataEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_GetPrinterDataEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_GetPrinterDataEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_GETPRINTERDATAEX];

	r = talloc(talloc_tos(), struct spoolss_GetPrinterDataEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDataEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.type = talloc_zero(r, uint32_t);
	if (r->out.type == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.buffer = talloc_zero(r, DATA_BLOB);
	if (r->out.buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_GetPrinterDataEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDataEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumPrinterDataEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPrinterDataEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPRINTERDATAEX];

	r = talloc(talloc_tos(), struct spoolss_EnumPrinterDataEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterDataEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.buffer = talloc_zero(r, DATA_BLOB);
	if (r->out.buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count = talloc_zero(r, uint32_t);
	if (r->out.count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumPrinterDataEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterDataEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_EnumPrinterKey(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_EnumPrinterKey *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ENUMPRINTERKEY];

	r = talloc(talloc_tos(), struct spoolss_EnumPrinterKey);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterKey, r);
	}

	ZERO_STRUCT(r->out);
	r->out.needed = r->in.needed;
	r->out.key_buffer_size = talloc_zero(r, uint32_t);
	if (r->out.key_buffer_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.key_buffer = talloc_zero_array(r, uint16_t, r->out.key_buffer_size);
	if (r->out.key_buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_EnumPrinterKey(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterKey, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinterDataEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinterDataEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTERDATAEX];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinterDataEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterDataEx, r);
	}

	r->out.result = _spoolss_DeletePrinterDataEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterDataEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinterKey(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinterKey *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTERKEY];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinterKey);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterKey, r);
	}

	r->out.result = _spoolss_DeletePrinterKey(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterKey, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_53(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_53 *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_53];

	r = talloc(talloc_tos(), struct spoolss_53);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_53, r);
	}

	r->out.result = _spoolss_53(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_53, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_DeletePrinterDriverEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_DeletePrinterDriverEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_DELETEPRINTERDRIVEREX];

	r = talloc(talloc_tos(), struct spoolss_DeletePrinterDriverEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterDriverEx, r);
	}

	r->out.result = _spoolss_DeletePrinterDriverEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterDriverEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_55(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_55 *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_55];

	r = talloc(talloc_tos(), struct spoolss_55);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_55, r);
	}

	r->out.result = _spoolss_55(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_55, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_56(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_56 *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_56];

	r = talloc(talloc_tos(), struct spoolss_56);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_56, r);
	}

	r->out.result = _spoolss_56(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_56, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_57(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_57 *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_57];

	r = talloc(talloc_tos(), struct spoolss_57);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_57, r);
	}

	r->out.result = _spoolss_57(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_57, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_XcvData(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_XcvData *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_XCVDATA];

	r = talloc(talloc_tos(), struct spoolss_XcvData);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_XcvData, r);
	}

	ZERO_STRUCT(r->out);
	r->out.out_data = talloc_zero(r, DATA_BLOB);
	if (r->out.out_data == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.needed = talloc_zero(r, uint32_t);
	if (r->out.needed == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.unknown2 = talloc_zero(r, uint32_t);
	if (r->out.unknown2 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _spoolss_XcvData(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_XcvData, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_AddPrinterDriverEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_AddPrinterDriverEx *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_ADDPRINTERDRIVEREX];

	r = talloc(talloc_tos(), struct spoolss_AddPrinterDriverEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterDriverEx, r);
	}

	r->out.result = _spoolss_AddPrinterDriverEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterDriverEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_5a(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_5a *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_5A];

	r = talloc(talloc_tos(), struct spoolss_5a);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5a, r);
	}

	r->out.result = _spoolss_5a(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5a, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_5b(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_5b *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_5B];

	r = talloc(talloc_tos(), struct spoolss_5b);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5b, r);
	}

	r->out.result = _spoolss_5b(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5b, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_5c(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_5c *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_5C];

	r = talloc(talloc_tos(), struct spoolss_5c);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5c, r);
	}

	r->out.result = _spoolss_5c(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5c, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_5d(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_5d *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_5D];

	r = talloc(talloc_tos(), struct spoolss_5d);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5d, r);
	}

	r->out.result = _spoolss_5d(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5d, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_5e(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_5e *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_5E];

	r = talloc(talloc_tos(), struct spoolss_5e);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5e, r);
	}

	r->out.result = _spoolss_5e(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5e, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_spoolss_5f(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct spoolss_5f *r;

	call = &ndr_table_spoolss.calls[NDR_SPOOLSS_5F];

	r = talloc(talloc_tos(), struct spoolss_5f);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5f, r);
	}

	r->out.result = _spoolss_5f(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5f, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_spoolss_cmds[] = 
{
	{"SPOOLSS_ENUMPRINTERS", NDR_SPOOLSS_ENUMPRINTERS, api_spoolss_EnumPrinters},
	{"SPOOLSS_OPENPRINTER", NDR_SPOOLSS_OPENPRINTER, api_spoolss_OpenPrinter},
	{"SPOOLSS_SETJOB", NDR_SPOOLSS_SETJOB, api_spoolss_SetJob},
	{"SPOOLSS_GETJOB", NDR_SPOOLSS_GETJOB, api_spoolss_GetJob},
	{"SPOOLSS_ENUMJOBS", NDR_SPOOLSS_ENUMJOBS, api_spoolss_EnumJobs},
	{"SPOOLSS_ADDPRINTER", NDR_SPOOLSS_ADDPRINTER, api_spoolss_AddPrinter},
	{"SPOOLSS_DELETEPRINTER", NDR_SPOOLSS_DELETEPRINTER, api_spoolss_DeletePrinter},
	{"SPOOLSS_SETPRINTER", NDR_SPOOLSS_SETPRINTER, api_spoolss_SetPrinter},
	{"SPOOLSS_GETPRINTER", NDR_SPOOLSS_GETPRINTER, api_spoolss_GetPrinter},
	{"SPOOLSS_ADDPRINTERDRIVER", NDR_SPOOLSS_ADDPRINTERDRIVER, api_spoolss_AddPrinterDriver},
	{"SPOOLSS_ENUMPRINTERDRIVERS", NDR_SPOOLSS_ENUMPRINTERDRIVERS, api_spoolss_EnumPrinterDrivers},
	{"SPOOLSS_GETPRINTERDRIVER", NDR_SPOOLSS_GETPRINTERDRIVER, api_spoolss_GetPrinterDriver},
	{"SPOOLSS_GETPRINTERDRIVERDIRECTORY", NDR_SPOOLSS_GETPRINTERDRIVERDIRECTORY, api_spoolss_GetPrinterDriverDirectory},
	{"SPOOLSS_DELETEPRINTERDRIVER", NDR_SPOOLSS_DELETEPRINTERDRIVER, api_spoolss_DeletePrinterDriver},
	{"SPOOLSS_ADDPRINTPROCESSOR", NDR_SPOOLSS_ADDPRINTPROCESSOR, api_spoolss_AddPrintProcessor},
	{"SPOOLSS_ENUMPRINTPROCESSORS", NDR_SPOOLSS_ENUMPRINTPROCESSORS, api_spoolss_EnumPrintProcessors},
	{"SPOOLSS_GETPRINTPROCESSORDIRECTORY", NDR_SPOOLSS_GETPRINTPROCESSORDIRECTORY, api_spoolss_GetPrintProcessorDirectory},
	{"SPOOLSS_STARTDOCPRINTER", NDR_SPOOLSS_STARTDOCPRINTER, api_spoolss_StartDocPrinter},
	{"SPOOLSS_STARTPAGEPRINTER", NDR_SPOOLSS_STARTPAGEPRINTER, api_spoolss_StartPagePrinter},
	{"SPOOLSS_WRITEPRINTER", NDR_SPOOLSS_WRITEPRINTER, api_spoolss_WritePrinter},
	{"SPOOLSS_ENDPAGEPRINTER", NDR_SPOOLSS_ENDPAGEPRINTER, api_spoolss_EndPagePrinter},
	{"SPOOLSS_ABORTPRINTER", NDR_SPOOLSS_ABORTPRINTER, api_spoolss_AbortPrinter},
	{"SPOOLSS_READPRINTER", NDR_SPOOLSS_READPRINTER, api_spoolss_ReadPrinter},
	{"SPOOLSS_ENDDOCPRINTER", NDR_SPOOLSS_ENDDOCPRINTER, api_spoolss_EndDocPrinter},
	{"SPOOLSS_ADDJOB", NDR_SPOOLSS_ADDJOB, api_spoolss_AddJob},
	{"SPOOLSS_SCHEDULEJOB", NDR_SPOOLSS_SCHEDULEJOB, api_spoolss_ScheduleJob},
	{"SPOOLSS_GETPRINTERDATA", NDR_SPOOLSS_GETPRINTERDATA, api_spoolss_GetPrinterData},
	{"SPOOLSS_SETPRINTERDATA", NDR_SPOOLSS_SETPRINTERDATA, api_spoolss_SetPrinterData},
	{"SPOOLSS_WAITFORPRINTERCHANGE", NDR_SPOOLSS_WAITFORPRINTERCHANGE, api_spoolss_WaitForPrinterChange},
	{"SPOOLSS_CLOSEPRINTER", NDR_SPOOLSS_CLOSEPRINTER, api_spoolss_ClosePrinter},
	{"SPOOLSS_ADDFORM", NDR_SPOOLSS_ADDFORM, api_spoolss_AddForm},
	{"SPOOLSS_DELETEFORM", NDR_SPOOLSS_DELETEFORM, api_spoolss_DeleteForm},
	{"SPOOLSS_GETFORM", NDR_SPOOLSS_GETFORM, api_spoolss_GetForm},
	{"SPOOLSS_SETFORM", NDR_SPOOLSS_SETFORM, api_spoolss_SetForm},
	{"SPOOLSS_ENUMFORMS", NDR_SPOOLSS_ENUMFORMS, api_spoolss_EnumForms},
	{"SPOOLSS_ENUMPORTS", NDR_SPOOLSS_ENUMPORTS, api_spoolss_EnumPorts},
	{"SPOOLSS_ENUMMONITORS", NDR_SPOOLSS_ENUMMONITORS, api_spoolss_EnumMonitors},
	{"SPOOLSS_ADDPORT", NDR_SPOOLSS_ADDPORT, api_spoolss_AddPort},
	{"SPOOLSS_CONFIGUREPORT", NDR_SPOOLSS_CONFIGUREPORT, api_spoolss_ConfigurePort},
	{"SPOOLSS_DELETEPORT", NDR_SPOOLSS_DELETEPORT, api_spoolss_DeletePort},
	{"SPOOLSS_CREATEPRINTERIC", NDR_SPOOLSS_CREATEPRINTERIC, api_spoolss_CreatePrinterIC},
	{"SPOOLSS_PLAYGDISCRIPTONPRINTERIC", NDR_SPOOLSS_PLAYGDISCRIPTONPRINTERIC, api_spoolss_PlayGDIScriptOnPrinterIC},
	{"SPOOLSS_DELETEPRINTERIC", NDR_SPOOLSS_DELETEPRINTERIC, api_spoolss_DeletePrinterIC},
	{"SPOOLSS_ADDPRINTERCONNECTION", NDR_SPOOLSS_ADDPRINTERCONNECTION, api_spoolss_AddPrinterConnection},
	{"SPOOLSS_DELETEPRINTERCONNECTION", NDR_SPOOLSS_DELETEPRINTERCONNECTION, api_spoolss_DeletePrinterConnection},
	{"SPOOLSS_PRINTERMESSAGEBOX", NDR_SPOOLSS_PRINTERMESSAGEBOX, api_spoolss_PrinterMessageBox},
	{"SPOOLSS_ADDMONITOR", NDR_SPOOLSS_ADDMONITOR, api_spoolss_AddMonitor},
	{"SPOOLSS_DELETEMONITOR", NDR_SPOOLSS_DELETEMONITOR, api_spoolss_DeleteMonitor},
	{"SPOOLSS_DELETEPRINTPROCESSOR", NDR_SPOOLSS_DELETEPRINTPROCESSOR, api_spoolss_DeletePrintProcessor},
	{"SPOOLSS_ADDPRINTPROVIDOR", NDR_SPOOLSS_ADDPRINTPROVIDOR, api_spoolss_AddPrintProvidor},
	{"SPOOLSS_DELETEPRINTPROVIDOR", NDR_SPOOLSS_DELETEPRINTPROVIDOR, api_spoolss_DeletePrintProvidor},
	{"SPOOLSS_ENUMPRINTPROCDATATYPES", NDR_SPOOLSS_ENUMPRINTPROCDATATYPES, api_spoolss_EnumPrintProcDataTypes},
	{"SPOOLSS_RESETPRINTER", NDR_SPOOLSS_RESETPRINTER, api_spoolss_ResetPrinter},
	{"SPOOLSS_GETPRINTERDRIVER2", NDR_SPOOLSS_GETPRINTERDRIVER2, api_spoolss_GetPrinterDriver2},
	{"SPOOLSS_FINDFIRSTPRINTERCHANGENOTIFICATION", NDR_SPOOLSS_FINDFIRSTPRINTERCHANGENOTIFICATION, api_spoolss_FindFirstPrinterChangeNotification},
	{"SPOOLSS_FINDNEXTPRINTERCHANGENOTIFICATION", NDR_SPOOLSS_FINDNEXTPRINTERCHANGENOTIFICATION, api_spoolss_FindNextPrinterChangeNotification},
	{"SPOOLSS_FINDCLOSEPRINTERNOTIFY", NDR_SPOOLSS_FINDCLOSEPRINTERNOTIFY, api_spoolss_FindClosePrinterNotify},
	{"SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATIONOLD", NDR_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATIONOLD, api_spoolss_RouterFindFirstPrinterChangeNotificationOld},
	{"SPOOLSS_REPLYOPENPRINTER", NDR_SPOOLSS_REPLYOPENPRINTER, api_spoolss_ReplyOpenPrinter},
	{"SPOOLSS_ROUTERREPLYPRINTER", NDR_SPOOLSS_ROUTERREPLYPRINTER, api_spoolss_RouterReplyPrinter},
	{"SPOOLSS_REPLYCLOSEPRINTER", NDR_SPOOLSS_REPLYCLOSEPRINTER, api_spoolss_ReplyClosePrinter},
	{"SPOOLSS_ADDPORTEX", NDR_SPOOLSS_ADDPORTEX, api_spoolss_AddPortEx},
	{"SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATION", NDR_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATION, api_spoolss_RouterFindFirstPrinterChangeNotification},
	{"SPOOLSS_SPOOLERINIT", NDR_SPOOLSS_SPOOLERINIT, api_spoolss_SpoolerInit},
	{"SPOOLSS_RESETPRINTEREX", NDR_SPOOLSS_RESETPRINTEREX, api_spoolss_ResetPrinterEx},
	{"SPOOLSS_REMOTEFINDFIRSTPRINTERCHANGENOTIFYEX", NDR_SPOOLSS_REMOTEFINDFIRSTPRINTERCHANGENOTIFYEX, api_spoolss_RemoteFindFirstPrinterChangeNotifyEx},
	{"SPOOLSS_ROUTERREFRESHPRINTERCHANGENOTIFICATION", NDR_SPOOLSS_ROUTERREFRESHPRINTERCHANGENOTIFICATION, api_spoolss_RouterRefreshPrinterChangeNotification},
	{"SPOOLSS_REMOTEFINDNEXTPRINTERCHANGENOTIFYEX", NDR_SPOOLSS_REMOTEFINDNEXTPRINTERCHANGENOTIFYEX, api_spoolss_RemoteFindNextPrinterChangeNotifyEx},
	{"SPOOLSS_44", NDR_SPOOLSS_44, api_spoolss_44},
	{"SPOOLSS_OPENPRINTEREX", NDR_SPOOLSS_OPENPRINTEREX, api_spoolss_OpenPrinterEx},
	{"SPOOLSS_ADDPRINTEREX", NDR_SPOOLSS_ADDPRINTEREX, api_spoolss_AddPrinterEx},
	{"SPOOLSS_47", NDR_SPOOLSS_47, api_spoolss_47},
	{"SPOOLSS_ENUMPRINTERDATA", NDR_SPOOLSS_ENUMPRINTERDATA, api_spoolss_EnumPrinterData},
	{"SPOOLSS_DELETEPRINTERDATA", NDR_SPOOLSS_DELETEPRINTERDATA, api_spoolss_DeletePrinterData},
	{"SPOOLSS_4A", NDR_SPOOLSS_4A, api_spoolss_4a},
	{"SPOOLSS_4B", NDR_SPOOLSS_4B, api_spoolss_4b},
	{"SPOOLSS_4C", NDR_SPOOLSS_4C, api_spoolss_4c},
	{"SPOOLSS_SETPRINTERDATAEX", NDR_SPOOLSS_SETPRINTERDATAEX, api_spoolss_SetPrinterDataEx},
	{"SPOOLSS_GETPRINTERDATAEX", NDR_SPOOLSS_GETPRINTERDATAEX, api_spoolss_GetPrinterDataEx},
	{"SPOOLSS_ENUMPRINTERDATAEX", NDR_SPOOLSS_ENUMPRINTERDATAEX, api_spoolss_EnumPrinterDataEx},
	{"SPOOLSS_ENUMPRINTERKEY", NDR_SPOOLSS_ENUMPRINTERKEY, api_spoolss_EnumPrinterKey},
	{"SPOOLSS_DELETEPRINTERDATAEX", NDR_SPOOLSS_DELETEPRINTERDATAEX, api_spoolss_DeletePrinterDataEx},
	{"SPOOLSS_DELETEPRINTERKEY", NDR_SPOOLSS_DELETEPRINTERKEY, api_spoolss_DeletePrinterKey},
	{"SPOOLSS_53", NDR_SPOOLSS_53, api_spoolss_53},
	{"SPOOLSS_DELETEPRINTERDRIVEREX", NDR_SPOOLSS_DELETEPRINTERDRIVEREX, api_spoolss_DeletePrinterDriverEx},
	{"SPOOLSS_55", NDR_SPOOLSS_55, api_spoolss_55},
	{"SPOOLSS_56", NDR_SPOOLSS_56, api_spoolss_56},
	{"SPOOLSS_57", NDR_SPOOLSS_57, api_spoolss_57},
	{"SPOOLSS_XCVDATA", NDR_SPOOLSS_XCVDATA, api_spoolss_XcvData},
	{"SPOOLSS_ADDPRINTERDRIVEREX", NDR_SPOOLSS_ADDPRINTERDRIVEREX, api_spoolss_AddPrinterDriverEx},
	{"SPOOLSS_5A", NDR_SPOOLSS_5A, api_spoolss_5a},
	{"SPOOLSS_5B", NDR_SPOOLSS_5B, api_spoolss_5b},
	{"SPOOLSS_5C", NDR_SPOOLSS_5C, api_spoolss_5c},
	{"SPOOLSS_5D", NDR_SPOOLSS_5D, api_spoolss_5d},
	{"SPOOLSS_5E", NDR_SPOOLSS_5E, api_spoolss_5e},
	{"SPOOLSS_5F", NDR_SPOOLSS_5F, api_spoolss_5f},
};

void spoolss_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_spoolss_cmds;
	*n_fns = sizeof(api_spoolss_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_spoolss_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "spoolss", "spoolss", &ndr_table_spoolss, api_spoolss_cmds, sizeof(api_spoolss_cmds) / sizeof(struct api_struct));
}
