/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_remact.h"

static bool api_RemoteActivation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemoteActivation *r;

	call = &ndr_table_IRemoteActivation.calls[NDR_REMOTEACTIVATION];

	r = talloc(talloc_tos(), struct RemoteActivation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemoteActivation, r);
	}

	ZERO_STRUCT(r->out);
	r->out.that = talloc_zero(r, struct ORPCTHAT);
	if (r->out.that == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pOxid = talloc_zero(r, uint64_t);
	if (r->out.pOxid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pdsaOxidBindings = talloc_zero(r, struct DUALSTRINGARRAY);
	if (r->out.pdsaOxidBindings == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ipidRemUnknown = talloc_zero(r, struct GUID);
	if (r->out.ipidRemUnknown == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.AuthnHint = talloc_zero(r, uint32_t);
	if (r->out.AuthnHint == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ServerVersion = talloc_zero(r, struct COMVERSION);
	if (r->out.ServerVersion == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.hr = talloc_zero(r, WERROR);
	if (r->out.hr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ifaces = talloc_zero_array(r, struct MInterfacePointer *, r->in.Interfaces);
	if (r->out.ifaces == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.results = talloc_zero_array(r, WERROR, r->in.Interfaces);
	if (r->out.results == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemoteActivation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemoteActivation, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IRemoteActivation_cmds[] = 
{
	{"REMOTEACTIVATION", NDR_REMOTEACTIVATION, api_RemoteActivation},
};

void IRemoteActivation_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IRemoteActivation_cmds;
	*n_fns = sizeof(api_IRemoteActivation_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IRemoteActivation_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IRemoteActivation", "IRemoteActivation", &ndr_table_IRemoteActivation, api_IRemoteActivation_cmds, sizeof(api_IRemoteActivation_cmds) / sizeof(struct api_struct));
}
