
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_eventlog.h"
#include "../librpc/gen_ndr/ndr_eventlog_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject eventlog_OpenUnknown0_Type;
staticforward PyTypeObject eventlog_Record_Type;
staticforward PyTypeObject eventlog_InterfaceType;

static PyTypeObject *lsa_String_Type;
static PyTypeObject *policy_handle_Type;

static PyObject *py_eventlog_OpenUnknown0_get_unknown0(PyObject *obj, void *closure)
{
	struct eventlog_OpenUnknown0 *object = py_talloc_get_ptr(obj);
	PyObject *py_unknown0;
	py_unknown0 = PyInt_FromLong(object->unknown0);
	return py_unknown0;
}

static int py_eventlog_OpenUnknown0_set_unknown0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_OpenUnknown0 *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_OpenUnknown0_get_unknown1(PyObject *obj, void *closure)
{
	struct eventlog_OpenUnknown0 *object = py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_eventlog_OpenUnknown0_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_OpenUnknown0 *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_eventlog_OpenUnknown0_getsetters[] = {
	{ discard_const_p(char, "unknown0"), py_eventlog_OpenUnknown0_get_unknown0, py_eventlog_OpenUnknown0_set_unknown0 },
	{ discard_const_p(char, "unknown1"), py_eventlog_OpenUnknown0_get_unknown1, py_eventlog_OpenUnknown0_set_unknown1 },
	{ NULL }
};

static PyObject *py_eventlog_OpenUnknown0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog_OpenUnknown0, type);
}


static PyTypeObject eventlog_OpenUnknown0_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.OpenUnknown0",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_eventlog_OpenUnknown0_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_eventlog_OpenUnknown0_new,
};


static PyObject *py_eventlog_Record_get_size(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_eventlog_Record_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_reserved(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyUnicode_Decode(object->reserved, strlen(object->reserved), "utf-8", "ignore");
	return py_reserved;
}

static int py_eventlog_Record_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->reserved = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_eventlog_Record_get_record_number(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_record_number;
	py_record_number = PyInt_FromLong(object->record_number);
	return py_record_number;
}

static int py_eventlog_Record_set_record_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->record_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_time_generated(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_time_generated;
	py_time_generated = PyInt_FromLong(object->time_generated);
	return py_time_generated;
}

static int py_eventlog_Record_set_time_generated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->time_generated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_time_written(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_time_written;
	py_time_written = PyInt_FromLong(object->time_written);
	return py_time_written;
}

static int py_eventlog_Record_set_time_written(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->time_written = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_event_id(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_event_id;
	py_event_id = PyInt_FromLong(object->event_id);
	return py_event_id;
}

static int py_eventlog_Record_set_event_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->event_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_event_type(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_event_type;
	py_event_type = PyInt_FromLong(object->event_type);
	return py_event_type;
}

static int py_eventlog_Record_set_event_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->event_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_num_of_strings(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_num_of_strings;
	py_num_of_strings = PyInt_FromLong(object->num_of_strings);
	return py_num_of_strings;
}

static int py_eventlog_Record_set_num_of_strings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_of_strings = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_event_category(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_event_category;
	py_event_category = PyInt_FromLong(object->event_category);
	return py_event_category;
}

static int py_eventlog_Record_set_event_category(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->event_category = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_reserved_flags(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_reserved_flags;
	py_reserved_flags = PyInt_FromLong(object->reserved_flags);
	return py_reserved_flags;
}

static int py_eventlog_Record_set_reserved_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_closing_record_number(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_closing_record_number;
	py_closing_record_number = PyInt_FromLong(object->closing_record_number);
	return py_closing_record_number;
}

static int py_eventlog_Record_set_closing_record_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->closing_record_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_stringoffset(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_stringoffset;
	py_stringoffset = PyInt_FromLong(object->stringoffset);
	return py_stringoffset;
}

static int py_eventlog_Record_set_stringoffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->stringoffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_sid_size(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_sid_size;
	py_sid_size = PyInt_FromLong(object->sid_size);
	return py_sid_size;
}

static int py_eventlog_Record_set_sid_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_sid_offset(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_sid_offset;
	py_sid_offset = PyInt_FromLong(object->sid_offset);
	return py_sid_offset;
}

static int py_eventlog_Record_set_sid_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_data_length(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_data_length;
	py_data_length = PyInt_FromLong(object->data_length);
	return py_data_length;
}

static int py_eventlog_Record_set_data_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_data_offset(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_data_offset;
	py_data_offset = PyInt_FromLong(object->data_offset);
	return py_data_offset;
}

static int py_eventlog_Record_set_data_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_get_source_name(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_source_name;
	py_source_name = PyString_FromString(object->source_name);
	return py_source_name;
}

static int py_eventlog_Record_set_source_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	object->source_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_eventlog_Record_get_computer_name(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromString(object->computer_name);
	return py_computer_name;
}

static int py_eventlog_Record_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	object->computer_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_eventlog_Record_get_sid(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = NULL;
	return py_sid;
}

static int py_eventlog_Record_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	memset(&object->sid, 0, sizeof(object->sid));
	return 0;
}

static PyObject *py_eventlog_Record_get_strings(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_strings;
	py_strings = PyList_New(object->num_of_strings);
	if (py_strings == NULL) {
		return NULL;
	}
	{
		int strings_cntr_0;
		for (strings_cntr_0 = 0; strings_cntr_0 < object->num_of_strings; strings_cntr_0++) {
			PyObject *py_strings_0;
			py_strings_0 = PyString_FromString(object->strings[strings_cntr_0]);
			PyList_SetItem(py_strings, strings_cntr_0, py_strings_0);
		}
	}
	return py_strings;
}

static int py_eventlog_Record_set_strings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int strings_cntr_0;
		object->strings = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->strings, PyList_Size(value));
		for (strings_cntr_0 = 0; strings_cntr_0 < PyList_Size(value); strings_cntr_0++) {
			object->strings[strings_cntr_0] = talloc_strdup(object->strings, PyString_AsString(PyList_GetItem(value, strings_cntr_0)));
		}
	}
	return 0;
}

static PyObject *py_eventlog_Record_get_raw_data(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_raw_data;
	py_raw_data = PyString_FromString(object->raw_data);
	return py_raw_data;
}

static int py_eventlog_Record_set_raw_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	object->raw_data = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_eventlog_Record_get__padding(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py__padding;
	py__padding = PyString_FromStringAndSize((char *)(object->_padding).data, (object->_padding).length);
	return py__padding;
}

static int py_eventlog_Record_set__padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	object->_padding = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyObject *py_eventlog_Record_get_size2(PyObject *obj, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(obj);
	PyObject *py_size2;
	py_size2 = PyInt_FromLong(object->size2);
	return py_size2;
}

static int py_eventlog_Record_set_size2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size2 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_eventlog_Record_getsetters[] = {
	{ discard_const_p(char, "size"), py_eventlog_Record_get_size, py_eventlog_Record_set_size },
	{ discard_const_p(char, "reserved"), py_eventlog_Record_get_reserved, py_eventlog_Record_set_reserved },
	{ discard_const_p(char, "record_number"), py_eventlog_Record_get_record_number, py_eventlog_Record_set_record_number },
	{ discard_const_p(char, "time_generated"), py_eventlog_Record_get_time_generated, py_eventlog_Record_set_time_generated },
	{ discard_const_p(char, "time_written"), py_eventlog_Record_get_time_written, py_eventlog_Record_set_time_written },
	{ discard_const_p(char, "event_id"), py_eventlog_Record_get_event_id, py_eventlog_Record_set_event_id },
	{ discard_const_p(char, "event_type"), py_eventlog_Record_get_event_type, py_eventlog_Record_set_event_type },
	{ discard_const_p(char, "num_of_strings"), py_eventlog_Record_get_num_of_strings, py_eventlog_Record_set_num_of_strings },
	{ discard_const_p(char, "event_category"), py_eventlog_Record_get_event_category, py_eventlog_Record_set_event_category },
	{ discard_const_p(char, "reserved_flags"), py_eventlog_Record_get_reserved_flags, py_eventlog_Record_set_reserved_flags },
	{ discard_const_p(char, "closing_record_number"), py_eventlog_Record_get_closing_record_number, py_eventlog_Record_set_closing_record_number },
	{ discard_const_p(char, "stringoffset"), py_eventlog_Record_get_stringoffset, py_eventlog_Record_set_stringoffset },
	{ discard_const_p(char, "sid_size"), py_eventlog_Record_get_sid_size, py_eventlog_Record_set_sid_size },
	{ discard_const_p(char, "sid_offset"), py_eventlog_Record_get_sid_offset, py_eventlog_Record_set_sid_offset },
	{ discard_const_p(char, "data_length"), py_eventlog_Record_get_data_length, py_eventlog_Record_set_data_length },
	{ discard_const_p(char, "data_offset"), py_eventlog_Record_get_data_offset, py_eventlog_Record_set_data_offset },
	{ discard_const_p(char, "source_name"), py_eventlog_Record_get_source_name, py_eventlog_Record_set_source_name },
	{ discard_const_p(char, "computer_name"), py_eventlog_Record_get_computer_name, py_eventlog_Record_set_computer_name },
	{ discard_const_p(char, "sid"), py_eventlog_Record_get_sid, py_eventlog_Record_set_sid },
	{ discard_const_p(char, "strings"), py_eventlog_Record_get_strings, py_eventlog_Record_set_strings },
	{ discard_const_p(char, "raw_data"), py_eventlog_Record_get_raw_data, py_eventlog_Record_set_raw_data },
	{ discard_const_p(char, "_padding"), py_eventlog_Record_get__padding, py_eventlog_Record_set__padding },
	{ discard_const_p(char, "size2"), py_eventlog_Record_get_size2, py_eventlog_Record_set_size2 },
	{ NULL }
};

static PyObject *py_eventlog_Record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog_Record, type);
}

static PyObject *py_eventlog_Record_ndr_pack(PyObject *py_obj)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_eventlog_Record);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_eventlog_Record_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct eventlog_Record *object = py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_eventlog_Record);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_eventlog_Record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_eventlog_Record_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_eventlog_Record_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject eventlog_Record_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.Record",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_eventlog_Record_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_eventlog_Record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_eventlog_Record_new,
};


static bool pack_py_eventlog_ClearEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_ClearEventLogW *r)
{
	PyObject *py_handle;
	PyObject *py_backupfile;
	const char *kwnames[] = {
		"handle", "backupfile", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog_ClearEventLogW", discard_const_p(char *, kwnames), &py_handle, &py_backupfile)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	if (py_backupfile == Py_None) {
		r->in.backupfile = NULL;
	} else {
		r->in.backupfile = talloc_ptrtype(r, r->in.backupfile);
		PY_CHECK_TYPE(lsa_String_Type, py_backupfile, return false;);
		r->in.backupfile = py_talloc_get_ptr(py_backupfile);
	}
	return true;
}

static PyObject *unpack_py_eventlog_ClearEventLogW_args_out(struct eventlog_ClearEventLogW *r)
{
	PyObject *result = Py_None;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_CloseEventLog_args_in(PyObject *args, PyObject *kwargs, struct eventlog_CloseEventLog *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_CloseEventLog", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_CloseEventLog_args_out(struct eventlog_CloseEventLog *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_GetNumRecords_args_in(PyObject *args, PyObject *kwargs, struct eventlog_GetNumRecords *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_GetNumRecords", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_GetNumRecords_args_out(struct eventlog_GetNumRecords *r)
{
	PyObject *result = Py_None;
	PyObject *py_number;
	py_number = PyInt_FromLong(*r->out.number);
	result = py_number;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_GetOldestRecord_args_in(PyObject *args, PyObject *kwargs, struct eventlog_GetOldestRecord *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_GetOldestRecord", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_GetOldestRecord_args_out(struct eventlog_GetOldestRecord *r)
{
	PyObject *result = Py_None;
	PyObject *py_oldest_entry;
	py_oldest_entry = PyInt_FromLong(*r->out.oldest_entry);
	result = py_oldest_entry;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_OpenEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_OpenEventLogW *r)
{
	PyObject *py_unknown0;
	PyObject *py_logname;
	PyObject *py_servername;
	PyObject *py_major_version;
	PyObject *py_minor_version;
	const char *kwnames[] = {
		"unknown0", "logname", "servername", "major_version", "minor_version", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:eventlog_OpenEventLogW", discard_const_p(char *, kwnames), &py_unknown0, &py_logname, &py_servername, &py_major_version, &py_minor_version)) {
		return false;
	}

	if (py_unknown0 == Py_None) {
		r->in.unknown0 = NULL;
	} else {
		r->in.unknown0 = talloc_ptrtype(r, r->in.unknown0);
		PY_CHECK_TYPE(&eventlog_OpenUnknown0_Type, py_unknown0, return false;);
		r->in.unknown0 = py_talloc_get_ptr(py_unknown0);
	}
	r->in.logname = talloc_ptrtype(r, r->in.logname);
	PY_CHECK_TYPE(lsa_String_Type, py_logname, return false;);
	r->in.logname = py_talloc_get_ptr(py_logname);
	r->in.servername = talloc_ptrtype(r, r->in.servername);
	PY_CHECK_TYPE(lsa_String_Type, py_servername, return false;);
	r->in.servername = py_talloc_get_ptr(py_servername);
	PY_CHECK_TYPE(&PyInt_Type, py_major_version, return false;);
	r->in.major_version = PyInt_AsLong(py_major_version);
	PY_CHECK_TYPE(&PyInt_Type, py_minor_version, return false;);
	r->in.minor_version = PyInt_AsLong(py_minor_version);
	return true;
}

static PyObject *unpack_py_eventlog_OpenEventLogW_args_out(struct eventlog_OpenEventLogW *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_ReadEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_ReadEventLogW *r)
{
	PyObject *py_handle;
	PyObject *py_flags;
	PyObject *py_offset;
	PyObject *py_number_of_bytes;
	const char *kwnames[] = {
		"handle", "flags", "offset", "number_of_bytes", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog_ReadEventLogW", discard_const_p(char *, kwnames), &py_handle, &py_flags, &py_offset, &py_number_of_bytes)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_offset, return false;);
	r->in.offset = PyInt_AsLong(py_offset);
	PY_CHECK_TYPE(&PyInt_Type, py_number_of_bytes, return false;);
	r->in.number_of_bytes = PyInt_AsLong(py_number_of_bytes);
	return true;
}

static PyObject *unpack_py_eventlog_ReadEventLogW_args_out(struct eventlog_ReadEventLogW *r)
{
	PyObject *result = Py_None;
	PyObject *py_data;
	PyObject *py_sent_size;
	PyObject *py_real_size;
	result = PyTuple_New(3);
	py_data = PyList_New(r->in.number_of_bytes);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_1;
		for (data_cntr_1 = 0; data_cntr_1 < r->in.number_of_bytes; data_cntr_1++) {
			PyObject *py_data_1;
			py_data_1 = PyInt_FromLong(r->out.data[data_cntr_1]);
			PyList_SetItem(py_data, data_cntr_1, py_data_1);
		}
	}
	PyTuple_SetItem(result, 0, py_data);
	py_sent_size = PyInt_FromLong(*r->out.sent_size);
	PyTuple_SetItem(result, 1, py_sent_size);
	py_real_size = PyInt_FromLong(*r->out.real_size);
	PyTuple_SetItem(result, 2, py_real_size);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_FlushEventLog_args_in(PyObject *args, PyObject *kwargs, struct eventlog_FlushEventLog *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_FlushEventLog", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_FlushEventLog_args_out(struct eventlog_FlushEventLog *r)
{
	PyObject *result = Py_None;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_eventlog_methods[] = {
	{ "ClearEventLogW", "S.ClearEventLogW(handle, backupfile) -> None", (dcerpc_call_fn)dcerpc_eventlog_ClearEventLogW, (py_data_pack_fn)pack_py_eventlog_ClearEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_ClearEventLogW_args_out, 0, &ndr_table_eventlog },
	{ "BackupEventLogW", NULL, (dcerpc_call_fn)dcerpc_eventlog_BackupEventLogW, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 1, &ndr_table_eventlog },
	{ "CloseEventLog", "S.CloseEventLog(handle) -> handle", (dcerpc_call_fn)dcerpc_eventlog_CloseEventLog, (py_data_pack_fn)pack_py_eventlog_CloseEventLog_args_in, (py_data_unpack_fn)unpack_py_eventlog_CloseEventLog_args_out, 2, &ndr_table_eventlog },
	{ "DeregisterEventSource", NULL, (dcerpc_call_fn)dcerpc_eventlog_DeregisterEventSource, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 3, &ndr_table_eventlog },
	{ "GetNumRecords", "S.GetNumRecords(handle) -> number", (dcerpc_call_fn)dcerpc_eventlog_GetNumRecords, (py_data_pack_fn)pack_py_eventlog_GetNumRecords_args_in, (py_data_unpack_fn)unpack_py_eventlog_GetNumRecords_args_out, 4, &ndr_table_eventlog },
	{ "GetOldestRecord", "S.GetOldestRecord(handle) -> oldest_entry", (dcerpc_call_fn)dcerpc_eventlog_GetOldestRecord, (py_data_pack_fn)pack_py_eventlog_GetOldestRecord_args_in, (py_data_unpack_fn)unpack_py_eventlog_GetOldestRecord_args_out, 5, &ndr_table_eventlog },
	{ "ChangeNotify", NULL, (dcerpc_call_fn)dcerpc_eventlog_ChangeNotify, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 6, &ndr_table_eventlog },
	{ "OpenEventLogW", "S.OpenEventLogW(unknown0, logname, servername, major_version, minor_version) -> handle", (dcerpc_call_fn)dcerpc_eventlog_OpenEventLogW, (py_data_pack_fn)pack_py_eventlog_OpenEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_OpenEventLogW_args_out, 7, &ndr_table_eventlog },
	{ "RegisterEventSourceW", NULL, (dcerpc_call_fn)dcerpc_eventlog_RegisterEventSourceW, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 8, &ndr_table_eventlog },
	{ "OpenBackupEventLogW", NULL, (dcerpc_call_fn)dcerpc_eventlog_OpenBackupEventLogW, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 9, &ndr_table_eventlog },
	{ "ReadEventLogW", "S.ReadEventLogW(handle, flags, offset, number_of_bytes) -> (data, sent_size, real_size)", (dcerpc_call_fn)dcerpc_eventlog_ReadEventLogW, (py_data_pack_fn)pack_py_eventlog_ReadEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_ReadEventLogW_args_out, 10, &ndr_table_eventlog },
	{ "ReportEventW", NULL, (dcerpc_call_fn)dcerpc_eventlog_ReportEventW, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 11, &ndr_table_eventlog },
	{ "ClearEventLogA", NULL, (dcerpc_call_fn)dcerpc_eventlog_ClearEventLogA, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 12, &ndr_table_eventlog },
	{ "BackupEventLogA", NULL, (dcerpc_call_fn)dcerpc_eventlog_BackupEventLogA, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 13, &ndr_table_eventlog },
	{ "OpenEventLogA", NULL, (dcerpc_call_fn)dcerpc_eventlog_OpenEventLogA, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 14, &ndr_table_eventlog },
	{ "RegisterEventSourceA", NULL, (dcerpc_call_fn)dcerpc_eventlog_RegisterEventSourceA, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 15, &ndr_table_eventlog },
	{ "OpenBackupEventLogA", NULL, (dcerpc_call_fn)dcerpc_eventlog_OpenBackupEventLogA, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 16, &ndr_table_eventlog },
	{ "ReadEventLogA", NULL, (dcerpc_call_fn)dcerpc_eventlog_ReadEventLogA, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 17, &ndr_table_eventlog },
	{ "ReportEventA", NULL, (dcerpc_call_fn)dcerpc_eventlog_ReportEventA, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 18, &ndr_table_eventlog },
	{ "RegisterClusterSvc", NULL, (dcerpc_call_fn)dcerpc_eventlog_RegisterClusterSvc, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 19, &ndr_table_eventlog },
	{ "DeregisterClusterSvc", NULL, (dcerpc_call_fn)dcerpc_eventlog_DeregisterClusterSvc, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 20, &ndr_table_eventlog },
	{ "WriteClusterEvents", NULL, (dcerpc_call_fn)dcerpc_eventlog_WriteClusterEvents, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 21, &ndr_table_eventlog },
	{ "GetLogIntormation", NULL, (dcerpc_call_fn)dcerpc_eventlog_GetLogIntormation, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 22, &ndr_table_eventlog },
	{ "FlushEventLog", "S.FlushEventLog(handle) -> None", (dcerpc_call_fn)dcerpc_eventlog_FlushEventLog, (py_data_pack_fn)pack_py_eventlog_FlushEventLog_args_in, (py_data_unpack_fn)unpack_py_eventlog_FlushEventLog_args_out, 23, &ndr_table_eventlog },
	{ NULL }
};

static PyObject *interface_eventlog_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_eventlog);
}

#define PY_DOC_EVENTLOG "Event Logger"
static PyTypeObject eventlog_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.eventlog",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "eventlog(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_EVENTLOG,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_eventlog_new,
};

static PyMethodDef eventlog_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initeventlog(void)
{
	PyObject *m;
	PyObject *dep_lsa;
	PyObject *dep_security;
	PyObject *dep_misc;

	dep_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_lsa == NULL)
		return;

	dep_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_security == NULL)
		return;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	lsa_String_Type = (PyTypeObject *)PyObject_GetAttrString(dep_lsa, "String");
	if (lsa_String_Type == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	if (PyType_Ready(&eventlog_OpenUnknown0_Type) < 0)
		return;
	if (PyType_Ready(&eventlog_Record_Type) < 0)
		return;
	if (PyType_Ready(&eventlog_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&eventlog_InterfaceType, py_ndr_eventlog_methods))
		return;

#ifdef PY_OPENUNKNOWN0_PATCH
	PY_OPENUNKNOWN0_PATCH(&eventlog_OpenUnknown0_Type);
#endif
#ifdef PY_RECORD_PATCH
	PY_RECORD_PATCH(&eventlog_Record_Type);
#endif
#ifdef PY_EVENTLOG_PATCH
	PY_EVENTLOG_PATCH(&eventlog_InterfaceType);
#endif

	m = Py_InitModule3("eventlog", eventlog_methods, "eventlog DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "EVENTLOG_SUCCESS", PyInt_FromLong(EVENTLOG_SUCCESS));
	PyModule_AddObject(m, "EVENTLOG_WARNING_TYPE", PyInt_FromLong(EVENTLOG_WARNING_TYPE));
	PyModule_AddObject(m, "EVENTLOG_AUDIT_FAILURE", PyInt_FromLong(EVENTLOG_AUDIT_FAILURE));
	PyModule_AddObject(m, "EVENTLOG_FORWARDS_READ", PyInt_FromLong(EVENTLOG_FORWARDS_READ));
	PyModule_AddObject(m, "EVENTLOG_INFORMATION_TYPE", PyInt_FromLong(EVENTLOG_INFORMATION_TYPE));
	PyModule_AddObject(m, "EVENTLOG_BACKWARDS_READ", PyInt_FromLong(EVENTLOG_BACKWARDS_READ));
	PyModule_AddObject(m, "EVENTLOG_SEQUENTIAL_READ", PyInt_FromLong(EVENTLOG_SEQUENTIAL_READ));
	PyModule_AddObject(m, "EVENTLOG_SEEK_READ", PyInt_FromLong(EVENTLOG_SEEK_READ));
	PyModule_AddObject(m, "EVENTLOG_AUDIT_SUCCESS", PyInt_FromLong(EVENTLOG_AUDIT_SUCCESS));
	PyModule_AddObject(m, "EVENTLOG_ERROR_TYPE", PyInt_FromLong(EVENTLOG_ERROR_TYPE));
	Py_INCREF((PyObject *)&eventlog_OpenUnknown0_Type);
	PyModule_AddObject(m, "OpenUnknown0", (PyObject *)&eventlog_OpenUnknown0_Type);
	Py_INCREF((PyObject *)&eventlog_Record_Type);
	PyModule_AddObject(m, "Record", (PyObject *)&eventlog_Record_Type);
	Py_INCREF((PyObject *)&eventlog_InterfaceType);
	PyModule_AddObject(m, "eventlog", (PyObject *)&eventlog_InterfaceType);
#ifdef PY_MOD_EVENTLOG_PATCH
	PY_MOD_EVENTLOG_PATCH(m);
#endif

}
