/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_srvsvc.h"

NTSTATUS rpccli_srvsvc_NetCharDevEnum(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc /* [in] [unique,charset(UTF16)] */,
				      struct srvsvc_NetCharDevInfoCtr *info_ctr /* [in,out] [ref] */,
				      uint32_t max_buffer /* [in]  */,
				      uint32_t *totalentries /* [out] [ref] */,
				      uint32_t *resume_handle /* [in,out] [unique] */,
				      WERROR *werror)
{
	struct srvsvc_NetCharDevEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.info_ctr = info_ctr;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_ctr = *r.out.info_ctr;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetCharDevGetInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *device_name /* [in] [charset(UTF16)] */,
					 uint32_t level /* [in]  */,
					 union srvsvc_NetCharDevInfo *info /* [out] [ref,switch_is(level)] */,
					 WERROR *werror)
{
	struct srvsvc_NetCharDevGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.device_name = device_name;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevGetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevGetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetCharDevControl(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *device_name /* [in] [charset(UTF16)] */,
					 uint32_t opcode /* [in]  */,
					 WERROR *werror)
{
	struct srvsvc_NetCharDevControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.device_name = device_name;
	r.in.opcode = opcode;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevControl, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVCONTROL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevControl, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetCharDevQEnum(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *user /* [in] [unique,charset(UTF16)] */,
				       struct srvsvc_NetCharDevQInfoCtr *info_ctr /* [in,out] [ref] */,
				       uint32_t max_buffer /* [in]  */,
				       uint32_t *totalentries /* [out] [ref] */,
				       uint32_t *resume_handle /* [in,out] [unique] */,
				       WERROR *werror)
{
	struct srvsvc_NetCharDevQEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.user = user;
	r.in.info_ctr = info_ctr;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevQEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVQENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevQEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_ctr = *r.out.info_ctr;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetCharDevQGetInfo(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *queue_name /* [in] [charset(UTF16)] */,
					  const char *user /* [in] [charset(UTF16)] */,
					  uint32_t level /* [in]  */,
					  union srvsvc_NetCharDevQInfo *info /* [out] [ref,switch_is(level)] */,
					  WERROR *werror)
{
	struct srvsvc_NetCharDevQGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.queue_name = queue_name;
	r.in.user = user;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevQGetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVQGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevQGetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetCharDevQSetInfo(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *queue_name /* [in] [charset(UTF16)] */,
					  uint32_t level /* [in]  */,
					  union srvsvc_NetCharDevQInfo info /* [in] [switch_is(level)] */,
					  uint32_t *parm_error /* [in,out] [unique] */,
					  WERROR *werror)
{
	struct srvsvc_NetCharDevQSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.queue_name = queue_name;
	r.in.level = level;
	r.in.info = info;
	r.in.parm_error = parm_error;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevQSetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVQSETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevQSetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (parm_error && r.out.parm_error) {
		*parm_error = *r.out.parm_error;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetCharDevQPurge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					const char *queue_name /* [in] [charset(UTF16)] */,
					WERROR *werror)
{
	struct srvsvc_NetCharDevQPurge r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.queue_name = queue_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevQPurge, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVQPURGE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevQPurge, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetCharDevQPurgeSelf(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_unc /* [in] [unique,charset(UTF16)] */,
					    const char *queue_name /* [in] [charset(UTF16)] */,
					    const char *computer_name /* [in] [charset(UTF16)] */,
					    WERROR *werror)
{
	struct srvsvc_NetCharDevQPurgeSelf r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.queue_name = queue_name;
	r.in.computer_name = computer_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetCharDevQPurgeSelf, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCHARDEVQPURGESELF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetCharDevQPurgeSelf, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetConnEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *path /* [in] [unique,charset(UTF16)] */,
				   struct srvsvc_NetConnInfoCtr *info_ctr /* [in,out] [ref] */,
				   uint32_t max_buffer /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror)
{
	struct srvsvc_NetConnEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.path = path;
	r.in.info_ctr = info_ctr;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetConnEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETCONNENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetConnEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_ctr = *r.out.info_ctr;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetFileEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *path /* [in] [unique,charset(UTF16)] */,
				   const char *user /* [in] [unique,charset(UTF16)] */,
				   struct srvsvc_NetFileInfoCtr *info_ctr /* [in,out] [ref] */,
				   uint32_t max_buffer /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror)
{
	struct srvsvc_NetFileEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.path = path;
	r.in.user = user;
	r.in.info_ctr = info_ctr;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetFileEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETFILEENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetFileEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_ctr = *r.out.info_ctr;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetFileGetInfo(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc /* [in] [unique,charset(UTF16)] */,
				      uint32_t fid /* [in]  */,
				      uint32_t level /* [in]  */,
				      union srvsvc_NetFileInfo *info /* [out] [ref,switch_is(level)] */,
				      WERROR *werror)
{
	struct srvsvc_NetFileGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.fid = fid;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetFileGetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETFILEGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetFileGetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetFileClose(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    uint32_t fid /* [in]  */,
				    WERROR *werror)
{
	struct srvsvc_NetFileClose r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.fid = fid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetFileClose, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETFILECLOSE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetFileClose, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetSessEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *client /* [in] [unique,charset(UTF16)] */,
				   const char *user /* [in] [unique,charset(UTF16)] */,
				   struct srvsvc_NetSessInfoCtr *info_ctr /* [in,out] [ref] */,
				   uint32_t max_buffer /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror)
{
	struct srvsvc_NetSessEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.client = client;
	r.in.user = user;
	r.in.info_ctr = info_ctr;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetSessEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSESSENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetSessEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_ctr = *r.out.info_ctr;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetSessDel(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc /* [in] [unique,charset(UTF16)] */,
				  const char *client /* [in] [unique,charset(UTF16)] */,
				  const char *user /* [in] [unique,charset(UTF16)] */,
				  WERROR *werror)
{
	struct srvsvc_NetSessDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.client = client;
	r.in.user = user;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetSessDel, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSESSDEL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetSessDel, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareAdd(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   uint32_t level /* [in]  */,
				   union srvsvc_NetShareInfo *info /* [in] [ref,switch_is(level)] */,
				   uint32_t *parm_error /* [in,out] [unique] */,
				   WERROR *werror)
{
	struct srvsvc_NetShareAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.level = level;
	r.in.info = info;
	r.in.parm_error = parm_error;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareAdd, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREADD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareAdd, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (parm_error && r.out.parm_error) {
		*parm_error = *r.out.parm_error;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareEnumAll(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       struct srvsvc_NetShareInfoCtr *info_ctr /* [in,out] [ref] */,
				       uint32_t max_buffer /* [in]  */,
				       uint32_t *totalentries /* [out] [ref] */,
				       uint32_t *resume_handle /* [in,out] [unique] */,
				       WERROR *werror)
{
	struct srvsvc_NetShareEnumAll r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.info_ctr = info_ctr;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareEnumAll, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREENUMALL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareEnumAll, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_ctr = *r.out.info_ctr;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareGetInfo(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *share_name /* [in] [charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       union srvsvc_NetShareInfo *info /* [out] [ref,switch_is(level)] */,
				       WERROR *werror)
{
	struct srvsvc_NetShareGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.share_name = share_name;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareGetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareGetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareSetInfo(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *share_name /* [in] [charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       union srvsvc_NetShareInfo *info /* [in] [ref,switch_is(level)] */,
				       uint32_t *parm_error /* [in,out] [unique] */,
				       WERROR *werror)
{
	struct srvsvc_NetShareSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.share_name = share_name;
	r.in.level = level;
	r.in.info = info;
	r.in.parm_error = parm_error;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareSetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHARESETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareSetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (parm_error && r.out.parm_error) {
		*parm_error = *r.out.parm_error;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareDel(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *share_name /* [in] [charset(UTF16)] */,
				   uint32_t reserved /* [in]  */,
				   WERROR *werror)
{
	struct srvsvc_NetShareDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.share_name = share_name;
	r.in.reserved = reserved;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareDel, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREDEL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareDel, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareDelSticky(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *share_name /* [in] [charset(UTF16)] */,
					 uint32_t reserved /* [in]  */,
					 WERROR *werror)
{
	struct srvsvc_NetShareDelSticky r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.share_name = share_name;
	r.in.reserved = reserved;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareDelSticky, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREDELSTICKY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareDelSticky, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareCheck(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     const char *device_name /* [in] [charset(UTF16)] */,
				     enum srvsvc_ShareType *type /* [out] [ref] */,
				     WERROR *werror)
{
	struct srvsvc_NetShareCheck r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.device_name = device_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareCheck, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHARECHECK,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareCheck, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*type = *r.out.type;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetSrvGetInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     uint32_t level /* [in]  */,
				     union srvsvc_NetSrvInfo *info /* [out] [ref,switch_is(level)] */,
				     WERROR *werror)
{
	struct srvsvc_NetSrvGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetSrvGetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSRVGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetSrvGetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetSrvSetInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     uint32_t level /* [in]  */,
				     union srvsvc_NetSrvInfo *info /* [in] [ref,switch_is(level)] */,
				     uint32_t *parm_error /* [in,out] [unique] */,
				     WERROR *werror)
{
	struct srvsvc_NetSrvSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.level = level;
	r.in.info = info;
	r.in.parm_error = parm_error;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetSrvSetInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSRVSETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetSrvSetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (parm_error && r.out.parm_error) {
		*parm_error = *r.out.parm_error;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetDiskEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   uint32_t level /* [in]  */,
				   struct srvsvc_NetDiskInfo *info /* [in,out] [ref] */,
				   uint32_t maxlen /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror)
{
	struct srvsvc_NetDiskEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.level = level;
	r.in.info = info;
	r.in.maxlen = maxlen;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetDiskEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETDISKENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetDiskEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetServerStatisticsGet(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_unc /* [in] [unique,charset(UTF16)] */,
					      const char *service /* [in] [unique,charset(UTF16)] */,
					      uint32_t level /* [in]  */,
					      uint32_t options /* [in]  */,
					      struct srvsvc_Statistics **stats /* [out] [ref] */,
					      WERROR *werror)
{
	struct srvsvc_NetServerStatisticsGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.service = service;
	r.in.level = level;
	r.in.options = options;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetServerStatisticsGet, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSERVERSTATISTICSGET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetServerStatisticsGet, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*stats = *r.out.stats;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetTransportAdd(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       union srvsvc_NetTransportInfo info /* [in] [switch_is(level)] */,
				       WERROR *werror)
{
	struct srvsvc_NetTransportAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetTransportAdd, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETTRANSPORTADD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetTransportAdd, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetTransportEnum(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					struct srvsvc_NetTransportInfoCtr *transports /* [in,out] [ref] */,
					uint32_t max_buffer /* [in]  */,
					uint32_t *totalentries /* [out] [ref] */,
					uint32_t *resume_handle /* [in,out] [unique] */,
					WERROR *werror)
{
	struct srvsvc_NetTransportEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.transports = transports;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetTransportEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETTRANSPORTENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetTransportEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*transports = *r.out.transports;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetTransportDel(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       struct srvsvc_NetTransportInfo0 *info0 /* [in] [ref] */,
				       WERROR *werror)
{
	struct srvsvc_NetTransportDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.level = level;
	r.in.info0 = info0;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetTransportDel, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETTRANSPORTDEL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetTransportDel, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetRemoteTOD(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    struct srvsvc_NetRemoteTODInfo **info /* [out] [ref] */,
				    WERROR *werror)
{
	struct srvsvc_NetRemoteTOD r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetRemoteTOD, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETREMOTETOD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetRemoteTOD, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetSetServiceBits(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *transport /* [in] [unique,charset(UTF16)] */,
					 uint32_t servicebits /* [in]  */,
					 uint32_t updateimmediately /* [in]  */,
					 WERROR *werror)
{
	struct srvsvc_NetSetServiceBits r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.transport = transport;
	r.in.servicebits = servicebits;
	r.in.updateimmediately = updateimmediately;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetSetServiceBits, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSETSERVICEBITS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetSetServiceBits, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetPathType(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *path /* [in] [charset(UTF16)] */,
				   uint32_t pathflags /* [in]  */,
				   uint32_t *pathtype /* [out] [ref] */,
				   WERROR *werror)
{
	struct srvsvc_NetPathType r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.path = path;
	r.in.pathflags = pathflags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetPathType, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETPATHTYPE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetPathType, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pathtype = *r.out.pathtype;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetPathCanonicalize(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_unc /* [in] [unique,charset(UTF16)] */,
					   const char *path /* [in] [charset(UTF16)] */,
					   uint8_t *can_path /* [out] [size_is(maxbuf)] */,
					   uint32_t maxbuf /* [in]  */,
					   const char *prefix /* [in] [charset(UTF16)] */,
					   uint32_t *pathtype /* [in,out] [ref] */,
					   uint32_t pathflags /* [in]  */,
					   WERROR *werror)
{
	struct srvsvc_NetPathCanonicalize r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.path = path;
	r.in.maxbuf = maxbuf;
	r.in.prefix = prefix;
	r.in.pathtype = pathtype;
	r.in.pathflags = pathflags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetPathCanonicalize, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETPATHCANONICALIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetPathCanonicalize, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(can_path, r.out.can_path, r.in.maxbuf * sizeof(*can_path));
	*pathtype = *r.out.pathtype;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetPathCompare(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc /* [in] [unique,charset(UTF16)] */,
				      const char *path1 /* [in] [charset(UTF16)] */,
				      const char *path2 /* [in] [charset(UTF16)] */,
				      uint32_t pathtype /* [in]  */,
				      uint32_t pathflags /* [in]  */,
				      WERROR *werror)
{
	struct srvsvc_NetPathCompare r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.path1 = path1;
	r.in.path2 = path2;
	r.in.pathtype = pathtype;
	r.in.pathflags = pathflags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetPathCompare, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETPATHCOMPARE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetPathCompare, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetNameValidate(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *name /* [in] [charset(UTF16)] */,
				       uint32_t name_type /* [in]  */,
				       uint32_t flags /* [in]  */,
				       WERROR *werror)
{
	struct srvsvc_NetNameValidate r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.name = name;
	r.in.name_type = name_type;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetNameValidate, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETNAMEVALIDATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetNameValidate, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRPRNAMECANONICALIZE(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror)
{
	struct srvsvc_NETRPRNAMECANONICALIZE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRPRNAMECANONICALIZE, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRPRNAMECANONICALIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRPRNAMECANONICALIZE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetPRNameCompare(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					const char *name1 /* [in] [charset(UTF16)] */,
					const char *name2 /* [in] [charset(UTF16)] */,
					uint32_t name_type /* [in]  */,
					uint32_t flags /* [in]  */,
					WERROR *werror)
{
	struct srvsvc_NetPRNameCompare r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.name1 = name1;
	r.in.name2 = name2;
	r.in.name_type = name_type;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetPRNameCompare, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETPRNAMECOMPARE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetPRNameCompare, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareEnum(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    struct srvsvc_NetShareInfoCtr *info_ctr /* [in,out] [ref] */,
				    uint32_t max_buffer /* [in]  */,
				    uint32_t *totalentries /* [out] [ref] */,
				    uint32_t *resume_handle /* [in,out] [unique] */,
				    WERROR *werror)
{
	struct srvsvc_NetShareEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.info_ctr = info_ctr;
	r.in.max_buffer = max_buffer;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareEnum, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_ctr = *r.out.info_ctr;
	*totalentries = *r.out.totalentries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareDelStart(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					const char *share /* [in] [charset(UTF16)] */,
					uint32_t reserved /* [in]  */,
					struct policy_handle *hnd /* [out] [unique] */,
					WERROR *werror)
{
	struct srvsvc_NetShareDelStart r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.share = share;
	r.in.reserved = reserved;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareDelStart, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREDELSTART,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareDelStart, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (hnd && r.out.hnd) {
		*hnd = *r.out.hnd;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetShareDelCommit(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *hnd /* [in,out] [unique] */,
					 WERROR *werror)
{
	struct srvsvc_NetShareDelCommit r;
	NTSTATUS status;

	/* In parameters */
	r.in.hnd = hnd;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetShareDelCommit, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSHAREDELCOMMIT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetShareDelCommit, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (hnd && r.out.hnd) {
		*hnd = *r.out.hnd;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetGetFileSecurity(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *share /* [in] [unique,charset(UTF16)] */,
					  const char *file /* [in] [charset(UTF16)] */,
					  uint32_t securityinformation /* [in]  */,
					  struct sec_desc_buf **sd_buf /* [out] [ref] */,
					  WERROR *werror)
{
	struct srvsvc_NetGetFileSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.share = share;
	r.in.file = file;
	r.in.securityinformation = securityinformation;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetGetFileSecurity, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETGETFILESECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetGetFileSecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sd_buf = *r.out.sd_buf;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetSetFileSecurity(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *share /* [in] [unique,charset(UTF16)] */,
					  const char *file /* [in] [charset(UTF16)] */,
					  uint32_t securityinformation /* [in]  */,
					  struct sec_desc_buf *sd_buf /* [in] [ref] */,
					  WERROR *werror)
{
	struct srvsvc_NetSetFileSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.share = share;
	r.in.file = file;
	r.in.securityinformation = securityinformation;
	r.in.sd_buf = sd_buf;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetSetFileSecurity, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSETFILESECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetSetFileSecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetServerTransportAddEx(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_unc /* [in] [unique,charset(UTF16)] */,
					       uint32_t level /* [in]  */,
					       union srvsvc_NetTransportInfo info /* [in] [switch_is(level)] */,
					       WERROR *werror)
{
	struct srvsvc_NetServerTransportAddEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetServerTransportAddEx, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSERVERTRANSPORTADDEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetServerTransportAddEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NetServerSetServiceBitsEx(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *emulated_server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *transport /* [in] [unique,charset(UTF16)] */,
						 uint32_t servicebitsofinterest /* [in]  */,
						 uint32_t servicebits /* [in]  */,
						 uint32_t updateimmediately /* [in]  */,
						 WERROR *werror)
{
	struct srvsvc_NetServerSetServiceBitsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.emulated_server_unc = emulated_server_unc;
	r.in.transport = transport;
	r.in.servicebitsofinterest = servicebitsofinterest;
	r.in.servicebits = servicebits;
	r.in.updateimmediately = updateimmediately;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NetServerSetServiceBitsEx, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETSERVERSETSERVICEBITSEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NetServerSetServiceBitsEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSGETVERSION(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct srvsvc_NETRDFSGETVERSION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSGETVERSION, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSGETVERSION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSGETVERSION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSCREATELOCALPARTITION(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   WERROR *werror)
{
	struct srvsvc_NETRDFSCREATELOCALPARTITION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSCREATELOCALPARTITION, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSCREATELOCALPARTITION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSCREATELOCALPARTITION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSDELETELOCALPARTITION(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   WERROR *werror)
{
	struct srvsvc_NETRDFSDELETELOCALPARTITION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSDELETELOCALPARTITION, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSDELETELOCALPARTITION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSDELETELOCALPARTITION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct srvsvc_NETRDFSSETLOCALVOLUMESTATE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSSETLOCALVOLUMESTATE, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSSETLOCALVOLUMESTATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSSETLOCALVOLUMESTATE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSSETSERVERINFO(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror)
{
	struct srvsvc_NETRDFSSETSERVERINFO r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSSETSERVERINFO, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSSETSERVERINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSSETSERVERINFO, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSCREATEEXITPOINT(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror)
{
	struct srvsvc_NETRDFSCREATEEXITPOINT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSCREATEEXITPOINT, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSCREATEEXITPOINT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSCREATEEXITPOINT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSDELETEEXITPOINT(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror)
{
	struct srvsvc_NETRDFSDELETEEXITPOINT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSDELETEEXITPOINT, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSDELETEEXITPOINT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSDELETEEXITPOINT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSMODIFYPREFIX(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   WERROR *werror)
{
	struct srvsvc_NETRDFSMODIFYPREFIX r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSMODIFYPREFIX, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSMODIFYPREFIX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSMODIFYPREFIX, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSFIXLOCALVOLUME(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct srvsvc_NETRDFSFIXLOCALVOLUME r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSFIXLOCALVOLUME, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSFIXLOCALVOLUME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSFIXLOCALVOLUME, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct rpc_pipe_client *cli,
						    TALLOC_CTX *mem_ctx,
						    WERROR *werror)
{
	struct srvsvc_NETRDFSMANAGERREPORTSITEINFO r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRDFSMANAGERREPORTSITEINFO, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRDFSMANAGERREPORTSITEINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRDFSMANAGERREPORTSITEINFO, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_srvsvc_NETRSERVERTRANSPORTDELEX(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						WERROR *werror)
{
	struct srvsvc_NETRSERVERTRANSPORTDELEX r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(srvsvc_NETRSERVERTRANSPORTDELEX, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_srvsvc,
				NDR_SRVSVC_NETRSERVERTRANSPORTDELEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(srvsvc_NETRSERVERTRANSPORTDELEX, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

