/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_frsapi.h"

NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_VERIFY_PROMOTION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSAPI_VERIFY_PROMOTION, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_VERIFY_PROMOTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSAPI_VERIFY_PROMOTION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_PROMOTION_STATUS(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_PROMOTION_STATUS r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSAPI_PROMOTION_STATUS, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_PROMOTION_STATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSAPI_PROMOTION_STATUS, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_START_DEMOTION(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_START_DEMOTION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSAPI_START_DEMOTION, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_START_DEMOTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSAPI_START_DEMOTION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_COMMIT_DEMOTION(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_COMMIT_DEMOTION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSAPI_COMMIT_DEMOTION, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_COMMIT_DEMOTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSAPI_COMMIT_DEMOTION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_SetDsPollingIntervalW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     uint32_t CurrentInterval /* [in]  */,
					     uint32_t DsPollingLongInterval /* [in]  */,
					     uint32_t DsPollingShortInterval /* [in]  */,
					     WERROR *werror)
{
	struct frsapi_SetDsPollingIntervalW r;
	NTSTATUS status;

	/* In parameters */
	r.in.CurrentInterval = CurrentInterval;
	r.in.DsPollingLongInterval = DsPollingLongInterval;
	r.in.DsPollingShortInterval = DsPollingShortInterval;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frsapi_SetDsPollingIntervalW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_SETDSPOLLINGINTERVALW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frsapi_SetDsPollingIntervalW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_frsapi_GetDsPollingIntervalW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     uint32_t *CurrentInterval /* [out] [ref] */,
					     uint32_t *DsPollingLongInterval /* [out] [ref] */,
					     uint32_t *DsPollingShortInterval /* [out] [ref] */,
					     WERROR *werror)
{
	struct frsapi_GetDsPollingIntervalW r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frsapi_GetDsPollingIntervalW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_GETDSPOLLINGINTERVALW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frsapi_GetDsPollingIntervalW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*CurrentInterval = *r.out.CurrentInterval;
	*DsPollingLongInterval = *r.out.DsPollingLongInterval;
	*DsPollingShortInterval = *r.out.DsPollingShortInterval;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION_W(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_VERIFY_PROMOTION_W r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSAPI_VERIFY_PROMOTION_W, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_VERIFY_PROMOTION_W,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSAPI_VERIFY_PROMOTION_W, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_InfoW(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     uint32_t length /* [in] [range(0,0x10000)] */,
			     struct frsapi_Info *info /* [in,out] [unique] */,
			     WERROR *werror)
{
	struct frsapi_InfoW r;
	NTSTATUS status;

	/* In parameters */
	r.in.length = length;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frsapi_InfoW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_INFOW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frsapi_InfoW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_frsapi_IsPathReplicated(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *path /* [in] [unique,charset(UTF16)] */,
					enum frsapi_ReplicaSetType replica_set_type /* [in]  */,
					uint32_t *unknown1 /* [out] [ref] */,
					uint32_t *unknown2 /* [out] [ref] */,
					uint32_t *unknown3 /* [out] [ref] */,
					struct GUID *replica_set_guid /* [out] [ref] */,
					WERROR *werror)
{
	struct frsapi_IsPathReplicated r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = path;
	r.in.replica_set_type = replica_set_type;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frsapi_IsPathReplicated, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_ISPATHREPLICATED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frsapi_IsPathReplicated, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*unknown1 = *r.out.unknown1;
	*unknown2 = *r.out.unknown2;
	*unknown3 = *r.out.unknown3;
	*replica_set_guid = *r.out.replica_set_guid;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_FRSAPI_WRITER_COMMAND(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_WRITER_COMMAND r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSAPI_WRITER_COMMAND, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_WRITER_COMMAND,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSAPI_WRITER_COMMAND, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_ForceReplication(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct GUID *guid1 /* [in] [unique] */,
					struct GUID *guid2 /* [in] [unique] */,
					const char *replica_set /* [in] [unique,charset(UTF16)] */,
					const char *partner_name /* [in] [unique,charset(UTF16)] */,
					WERROR *werror)
{
	struct frsapi_ForceReplication r;
	NTSTATUS status;

	/* In parameters */
	r.in.guid1 = guid1;
	r.in.guid2 = guid2;
	r.in.replica_set = replica_set;
	r.in.partner_name = partner_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frsapi_ForceReplication, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_FORCEREPLICATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frsapi_ForceReplication, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

