#include "../librpc/gen_ndr/ndr_efs.h"
#ifndef __CLI_EFS__
#define __CLI_EFS__
NTSTATUS rpccli_EfsRpcOpenFileRaw(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *pvContext /* [out] [ref] */,
				  const char *FileName /* [in] [charset(UTF16)] */,
				  uint32_t Flags /* [in]  */,
				  WERROR *werror);
NTSTATUS rpccli_EfsRpcReadFileRaw(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *pvContext /* [in] [ref] */,
				  WERROR *werror);
NTSTATUS rpccli_EfsRpcWriteFileRaw(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *pvContext /* [in] [ref] */,
				   WERROR *werror);
NTSTATUS rpccli_EfsRpcCloseRaw(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *pvContext /* [in,out] [ref] */);
NTSTATUS rpccli_EfsRpcEncryptFileSrv(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *Filename /* [in] [charset(UTF16)] */,
				     WERROR *werror);
NTSTATUS rpccli_EfsRpcDecryptFileSrv(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *FileName /* [in] [charset(UTF16)] */,
				     uint32_t Reserved /* [in]  */,
				     WERROR *werror);
NTSTATUS rpccli_EfsRpcQueryUsersOnFile(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *FileName /* [in] [charset(UTF16)] */,
				       struct ENCRYPTION_CERTIFICATE_HASH_LIST **pUsers /* [out] [unique,ref] */,
				       WERROR *werror);
NTSTATUS rpccli_EfsRpcQueryRecoveryAgents(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *FileName /* [in] [charset(UTF16)] */,
					  struct ENCRYPTION_CERTIFICATE_HASH_LIST **pRecoveryAgents /* [out] [unique,ref] */,
					  WERROR *werror);
NTSTATUS rpccli_EfsRpcRemoveUsersFromFile(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *FileName /* [in] [charset(UTF16)] */,
					  WERROR *werror);
NTSTATUS rpccli_EfsRpcAddUsersToFile(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *FileName /* [in] [charset(UTF16)] */,
				     WERROR *werror);
NTSTATUS rpccli_EfsRpcSetFileEncryptionKey(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ENCRYPTION_CERTIFICATE *pEncryptionCertificate /* [in] [unique] */,
					   WERROR *werror);
NTSTATUS rpccli_EfsRpcNotSupported(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror);
NTSTATUS rpccli_EfsRpcFileKeyInfo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror);
NTSTATUS rpccli_EfsRpcDuplicateEncryptionInfoFile(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
#endif /* __CLI_EFS__ */
