/* 
   Unix SMB/CIFS implementation.
   Samba utility functions
   Copyright (C) Jelmer Vernooij <jelmer@samba.org> 2007

     ** NOTE! The following LGPL license applies to the ldb
     ** library. This does NOT imply that all of Samba is released
     ** under the LGPL
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

#include "ldb_includes.h"
#include "ldb.h"
#include "ldb_errors.h"

int sample_add(struct ldb_module *mod, struct ldb_request *req)
{
	ldb_msg_add_fmt(req->op.add.message, "touchedBy", "sample");

	return ldb_next_request(mod, req);
}

const struct ldb_module_ops ldb_sample_module_ops = {
	.name              = "sample",
	.add		   = sample_add,
};
