/* parser auto-generated by pidl */

#include "includes.h"
#include "autoconf/librpc/gen_ndr/ndr_ioctl.h"

_PUBLIC_ enum ndr_err_code ndr_push_req_resume_key_rsp(struct ndr_push *ndr, int ndr_flags, const struct req_resume_key_rsp *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->resume_key, 24));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->context_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->context, 4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_req_resume_key_rsp(struct ndr_pull *ndr, int ndr_flags, struct req_resume_key_rsp *r)
{
	uint32_t size_resume_key_0 = 0;
	uint32_t size_context_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		size_resume_key_0 = 24;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->resume_key, size_resume_key_0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->context_len));
		size_context_0 = 4;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->context, size_context_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_req_resume_key_rsp(struct ndr_print *ndr, const char *name, const struct req_resume_key_rsp *r)
{
	ndr_print_struct(ndr, name, "req_resume_key_rsp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "resume_key", r->resume_key, 24);
	ndr_print_uint32(ndr, "context_len", r->context_len);
	ndr_print_array_uint8(ndr, "context", r->context, 4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srv_copychunk(struct ndr_push *ndr, int ndr_flags, const struct srv_copychunk *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->source_off));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->target_off));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srv_copychunk(struct ndr_pull *ndr, int ndr_flags, struct srv_copychunk *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->source_off));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->target_off));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srv_copychunk(struct ndr_print *ndr, const char *name, const struct srv_copychunk *r)
{
	ndr_print_struct(ndr, name, "srv_copychunk");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "source_off", r->source_off);
	ndr_print_hyper(ndr, "target_off", r->target_off);
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_srv_copychunk_copy(struct ndr_push *ndr, int ndr_flags, const struct srv_copychunk_copy *r)
{
	uint32_t cntr_chunks_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->source_key, 24));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chunk_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_chunks_0 = 0; cntr_chunks_0 < r->chunk_count; cntr_chunks_0++) {
			NDR_CHECK(ndr_push_srv_copychunk(ndr, NDR_SCALARS, &r->chunks[cntr_chunks_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_srv_copychunk_copy(struct ndr_pull *ndr, int ndr_flags, struct srv_copychunk_copy *r)
{
	uint32_t size_source_key_0 = 0;
	uint32_t size_chunks_0 = 0;
	uint32_t cntr_chunks_0;
	TALLOC_CTX *_mem_save_chunks_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		size_source_key_0 = 24;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->source_key, size_source_key_0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chunk_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		size_chunks_0 = r->chunk_count;
		NDR_PULL_ALLOC_N(ndr, r->chunks, size_chunks_0);
		_mem_save_chunks_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->chunks, 0);
		for (cntr_chunks_0 = 0; cntr_chunks_0 < size_chunks_0; cntr_chunks_0++) {
			NDR_CHECK(ndr_pull_srv_copychunk(ndr, NDR_SCALARS, &r->chunks[cntr_chunks_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_chunks_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srv_copychunk_copy(struct ndr_print *ndr, const char *name, const struct srv_copychunk_copy *r)
{
	uint32_t cntr_chunks_0;
	ndr_print_struct(ndr, name, "srv_copychunk_copy");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "source_key", r->source_key, 24);
	ndr_print_uint32(ndr, "chunk_count", r->chunk_count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%d)", "chunks", (int)r->chunk_count);
	ndr->depth++;
	for (cntr_chunks_0=0;cntr_chunks_0<r->chunk_count;cntr_chunks_0++) {
		ndr_print_srv_copychunk(ndr, "chunks", &r->chunks[cntr_chunks_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_srv_copychunk_rsp(struct ndr_push *ndr, int ndr_flags, const struct srv_copychunk_rsp *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chunks_written));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chunk_bytes_written));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_bytes_written));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_srv_copychunk_rsp(struct ndr_pull *ndr, int ndr_flags, struct srv_copychunk_rsp *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chunks_written));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chunk_bytes_written));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_bytes_written));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srv_copychunk_rsp(struct ndr_print *ndr, const char *name, const struct srv_copychunk_rsp *r)
{
	ndr_print_struct(ndr, name, "srv_copychunk_rsp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "chunks_written", r->chunks_written);
	ndr_print_uint32(ndr, "chunk_bytes_written", r->chunk_bytes_written);
	ndr_print_uint32(ndr, "total_bytes_written", r->total_bytes_written);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_device_copy_offload_descriptor(struct ndr_push *ndr, int ndr_flags, const struct device_copy_offload_descriptor *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_token_lifetime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->default_token_lifetime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->maximum_xfer_size));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->optimal_xfer_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_data_descriptors));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_xfer_length_per_descriptor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->optimal_xfer_length_per_descriptor));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->optimal_xfer_length_granularity));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->reserved, 2));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_device_copy_offload_descriptor(struct ndr_pull *ndr, int ndr_flags, struct device_copy_offload_descriptor *r)
{
	uint32_t size_reserved_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_token_lifetime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->default_token_lifetime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->maximum_xfer_size));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->optimal_xfer_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_data_descriptors));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_xfer_length_per_descriptor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->optimal_xfer_length_per_descriptor));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->optimal_xfer_length_granularity));
		size_reserved_0 = 2;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->reserved, size_reserved_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_device_copy_offload_descriptor(struct ndr_print *ndr, const char *name, const struct device_copy_offload_descriptor *r)
{
	ndr_print_struct(ndr, name, "device_copy_offload_descriptor");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "maximum_token_lifetime", r->maximum_token_lifetime);
	ndr_print_uint32(ndr, "default_token_lifetime", r->default_token_lifetime);
	ndr_print_hyper(ndr, "maximum_xfer_size", r->maximum_xfer_size);
	ndr_print_hyper(ndr, "optimal_xfer_count", r->optimal_xfer_count);
	ndr_print_uint32(ndr, "maximum_data_descriptors", r->maximum_data_descriptors);
	ndr_print_uint32(ndr, "maximum_xfer_length_per_descriptor", r->maximum_xfer_length_per_descriptor);
	ndr_print_uint32(ndr, "optimal_xfer_length_per_descriptor", r->optimal_xfer_length_per_descriptor);
	ndr_print_uint16(ndr, "optimal_xfer_length_granularity", r->optimal_xfer_length_granularity);
	ndr_print_array_uint8(ndr, "reserved", r->reserved, 2);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_storage_offload_token(struct ndr_push *ndr, int ndr_flags, const struct storage_offload_token *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->token_id_len));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->token_type));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->reserved, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->token_id_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->token, r->token_id_len));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_storage_offload_token(struct ndr_pull *ndr, int ndr_flags, struct storage_offload_token *r)
{
	uint32_t size_reserved_0 = 0;
	uint32_t size_token_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->token));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->token_type));
		size_reserved_0 = 2;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->reserved, size_reserved_0));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->token_id_len));
		size_token_0 = ndr_get_array_size(ndr, &r->token);
		NDR_PULL_ALLOC_N(ndr, r->token, size_token_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->token, size_token_0));
		if (r->token) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->token, r->token_id_len));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_storage_offload_token(struct ndr_print *ndr, const char *name, const struct storage_offload_token *r)
{
	ndr_print_struct(ndr, name, "storage_offload_token");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "token_type", r->token_type);
	ndr_print_array_uint8(ndr, "reserved", r->reserved, 2);
	ndr_print_uint16(ndr, "token_id_len", r->token_id_len);
	ndr_print_array_uint8(ndr, "token", r->token, r->token_id_len);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_read_input(struct ndr_push *ndr, int ndr_flags, const struct fsctl_offload_read_input *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->token_time_to_live));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_offset));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_read_input(struct ndr_pull *ndr, int ndr_flags, struct fsctl_offload_read_input *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->token_time_to_live));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_offset));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_offload_read_input(struct ndr_print *ndr, const char *name, const struct fsctl_offload_read_input *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_read_input");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "token_time_to_live", r->token_time_to_live);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_hyper(ndr, "file_offset", r->file_offset);
	ndr_print_hyper(ndr, "length", r->length);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_read_output(struct ndr_push *ndr, int ndr_flags, const struct fsctl_offload_read_output *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->xfer_length));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->token, 512));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_read_output(struct ndr_pull *ndr, int ndr_flags, struct fsctl_offload_read_output *r)
{
	uint32_t size_token_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->xfer_length));
		size_token_0 = 512;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->token, size_token_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_offload_read_output(struct ndr_print *ndr, const char *name, const struct fsctl_offload_read_output *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_read_output");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_hyper(ndr, "xfer_length", r->xfer_length);
	ndr_print_array_uint8(ndr, "token", r->token, 512);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_write_input(struct ndr_push *ndr, int ndr_flags, const struct fsctl_offload_write_input *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_offset));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->copy_length));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->xfer_offset));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->token, 512));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_write_input(struct ndr_pull *ndr, int ndr_flags, struct fsctl_offload_write_input *r)
{
	uint32_t size_token_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_offset));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->copy_length));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->xfer_offset));
		size_token_0 = 512;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->token, size_token_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_offload_write_input(struct ndr_print *ndr, const char *name, const struct fsctl_offload_write_input *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_write_input");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_hyper(ndr, "file_offset", r->file_offset);
	ndr_print_hyper(ndr, "copy_length", r->copy_length);
	ndr_print_hyper(ndr, "xfer_offset", r->xfer_offset);
	ndr_print_array_uint8(ndr, "token", r->token, 512);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_write_output(struct ndr_push *ndr, int ndr_flags, const struct fsctl_offload_write_output *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->length_written));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_write_output(struct ndr_pull *ndr, int ndr_flags, struct fsctl_offload_write_output *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->length_written));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_offload_write_output(struct ndr_print *ndr, const char *name, const struct fsctl_offload_write_output *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_write_output");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_hyper(ndr, "length_written", r->length_written);
	ndr->depth--;
}

