/* pam_smb_queue.h -- pam_smb queueing header file

   Copyright (c) Dave Airlie 2000
   airlied@samba.org
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
   
#ifndef _VALID_H_
#define _VALID_H_
/* SMB User verification function */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define NTV_NO_ERROR 0
#define NTV_SERVER_ERROR 1
#define NTV_PROTOCOL_ERROR 2
#define NTV_LOGON_ERROR 3

#define SEED 'k'
#define SERVER 1L

#define PAMSMBKEY 0x12121212

typedef struct {
  long msg_to;
  long msg_fm;
  int return_code;
  char username[MAX_UU_LEN];
  char password[MAX_PASS_LEN];
  char domain[MAX_NTDOM_LEN];
} MESSAGE;

#define PAMSMB_SERVERTIMEOUT 10

#endif
