/* 
Unix file server for Pathworks for DOS. 
Version 0.5.
Copyright (C) Andrew Tridgell 1992.
Permission to use, copy and distribute this software is given to anyone
who wants to, for NON-PROFIT only. You may not charge for this software
or any derivatives of it without first contacting the Author.
*/


#ifndef MAX_SERVICES
#define MAX_SERVICES 10
#endif

#ifndef MAX_CONNECTIONS
#define MAX_CONNECTIONS 50
#endif

#ifndef MAX_OPEN_FILES
#define MAX_OPEN_FILES 50
#endif

#ifndef DEBUGLEVEL
#define DEBUGLEVEL 0
#endif

#ifndef DEBUGFILE
#define DEBUGFILE "/usr/local/pcsa/debug"
#endif

#ifndef PCSAIN
#define PCSAIN "/usr/local/pcsa/pcsa.in"
#endif

#ifndef PCSAOUT
#define PCSAOUT "/usr/local/pcsa/pcsa.out"
#endif

#ifndef SERVICES
#define SERVICES "/usr/local/pcsa/services"
#endif

#ifndef GUEST_ACCOUNT
#define GUEST_ACCOUNT "pcuser"
#endif

#define BUFFER_SIZE 0xFFFF

#ifndef EXTERN
#	define EXTERN extern
#endif

#define True (0==0)
#define False (!True)

typedef unsigned char BOOL;
typedef short int16;
typedef int int32;

#ifndef CREATE_DIR_MODE
#define CREATE_DIR_MODE (0755)
#endif

#ifndef CREATE_FILE_MODE
#define CREATE_FILE_MODE (0644)
#endif

/* these are some file handles where debug info will be stored */
EXTERN FILE *pcsain;
EXTERN FILE *pcsaout;
EXTERN FILE *dbf;

/* trans_num  keeps track of the transaction number for debugging */
EXTERN int trans_num;

/* this is set to true on a big_endian machine (like a sun sparcstation)
this means that all shorts and ints must be byte swapped before being
put in the buffer */
EXTERN BOOL NeedSwap;

/* these macros make access to the packet buffers easier. See also the
functions SSVAL() and SIVAL(). */
#define PVAL(buf,pos,type) (*((type *)(buf + pos)))
#define ISWP(x) (NeedSwap? int32_byte_swap((int32)x):(x))
#define SSWP(x) (NeedSwap? int16_byte_swap((int16)x):(x))
#define SCVAL(buf,pos,x) PVAL(buf,pos,char) = (x)
#define CVAL(buf,pos) PVAL(buf,pos,char)

#define DIR_STRUCT_SIZE 43

/* these define all the command types recognised by the server - there
are lots of gaps so probably there are some rare commands that are not
implemented */
#define pHELLO 114
#define pCONNECT 112
#define pFSTAT 16
#define pDIR -127
#define pDFREE -128
#define pOPEN 2
#define pCREATE 3
#define pCLOSE 4
#define pREAD 10
#define pWRITE 11
#define pMKDIR 0
#define pRMDIR 1
#define pDELETE 6
#define pGOODBYE 113
#define pACCESS 8
#define pCHMOD 9
#define pRENAME 7
#define pSETDIR '\377'

/* these define the attribute byte as seen by DOS */
#define aRONLY (1L<<0)
#define aHIDDEN (1L<<1)
#define aSYSTEM (1L<<2)
#define aVOLID (1L<<3)
#define aDIR (1L<<4)
#define aARCH (1L<<5)

/* these define some DOS error codes */
#define eINVALID_FUNCTION	1
#define eFILE_NOT_FOUND		2
#define eINVALID_PATH		3
#define eTOO_MANY_FILES_OPEN	4
#define eACCESS_DENIED		5
#define eINVALID_FILE_HANDLE	6
#define eMCB_DESTROYED		7
#define eNOT_ENOUGH_MEMORY	8
#define eMEM_ADDRESS_INVALID	9
#define eENV_STRING_INVALID	10
#define eFORMAT_INVALID		11
#define eACCESS_CODE_INVALID	12
#define eDATA_INVALID		13
#define eINVALID_DRIVE		15
#define eREMOVE_CURRENT_DIR	16
#define eNOT_SAME_DEVICE	17
#define eNO_MORE_FILES		18

/* this is the structure dos uses to hold dates */
typedef struct
	{
	unsigned year : 7;
	unsigned month : 4;
	unsigned day : 5;
	unsigned hour : 5;
	unsigned minute : 6;
	unsigned second : 5;
	} dosdate;

/* these structures are used to store the state of the server */
typedef struct
	{
	BOOL available;
	char service[255];
	char path[255];
	BOOL read_only;
	BOOL no_set_dir;
	BOOL guest_ok;
	} services_struct;

typedef struct
	{
	BOOL open;
	int cnum;
	int fd;
	} files_struct;

typedef struct
	{
	BOOL open;
	int service;
	int connect_num;
	int uid;
	int gid;
	void *dirptr;
	char dirpath[200];
	char connectpath[200];
	} connection_struct;


EXTERN services_struct Services[MAX_SERVICES];
EXTERN connection_struct Connections[MAX_CONNECTIONS];
EXTERN files_struct Files[MAX_OPEN_FILES];


/* these are useful macros for checking validity of handles */
#define VALID_FNUM(fnum) ((fnum >= 0) && (fnum < MAX_OPEN_FILES))
#define OPEN_FNUM(fnum) (VALID_FNUM(fnum) && Files[fnum].open)
#define VALID_CNUM(cnum) ((cnum >= 0) && (cnum < MAX_CONNECTIONS))
#define OPEN_CNUM(cnum) (VALID_CNUM(cnum) && Connections[cnum].open)
#define CAN_WRITE(cnum) (OPEN_CNUM(cnum) && !Services[Connections[cnum].service].read_only)
#define VALID_SNUM(snum) ((snum >= 0) && (snum < MAX_SERVICES) && Services[snum].available)
#define GUEST_OK(snum) (VALID_SNUM(snum) && Services[snum].guest_ok)

/* this is how errors are generated */
#define ERROR(x) error_packet(inbuf,outbuf,x)
