Summary: SMB client and server
Name: samba
Version: 1.9.18p6
Release: 40.1
Copyright: GPL
Group: Networking
Source: ftp://samba.anu.edu.au/pub/samba/samba-1.9.18p5.tar.gz
Patch: samba-make.patch
Packager: John H Terpstra [Samba-Team] <jht@samba.anu.edu.au>

%description
Samba provides an SMB server which can be used to provide
network services to SMB (sometimes called "Lan Manager")
clients, including various versions of MS Windows, OS/2,
and other Linux machines. Samba also provides some SMB
clients, which complement the built-in SMB filesystem
in Linux. Samba uses NetBIOS over TCP/IP (NetBT) protocols
and does NOT need NetBEUI (Microsoft Raw NetBIOS frame)
protocol.

This release is known as the "Locking Update" and has full
support for Opportunistic File Locking. In addition this update
includes native support for Microsoft encrypted passwords,
improved browse list and WINS database management.

Please refer to the WHATSNEW.txt document for fixup information.
This binary release includes encrypted password support.
Please read the smb.conf file and ENCRYPTION.txt in the
docs directory for implementation details.

NOTE: Red Hat Linux 4.2 Uses PAM which has integrated support
for Shadow passwords. Do NOT recompile with the SHADOW_PWD option
enabled. Red Hat Linux has built in support for quotas in PAM.

%prep
%setup
%patch -p1

%build
cd source
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc
mkdir -p $RPM_BUILD_ROOT/etc/codepages/src
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc0.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc1.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc2.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc3.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc5.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc6.d
mkdir -p $RPM_BUILD_ROOT/home/samba
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/sbin
mkdir -p $RPM_BUILD_ROOT/usr/man/man1
mkdir -p $RPM_BUILD_ROOT/usr/man/man5
mkdir -p $RPM_BUILD_ROOT/usr/man/man7
mkdir -p $RPM_BUILD_ROOT/usr/man/man8
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/{help,images}
mkdir -p $RPM_BUILD_ROOT/var/lock/samba
mkdir -p $RPM_BUILD_ROOT/var/log/samba
mkdir -p $RPM_BUILD_ROOT/var/spool/samba

for i in nmblookup smbclient smbpasswd smbrun smbstatus testparm testprns
do
install -m755 -s source/$i $RPM_BUILD_ROOT/usr/bin
done

for i in addtosmbpass mksmbpasswd.sh smbtar make_smbcodepage make_printerdef
do
install -m755 source/$i $RPM_BUILD_ROOT/usr/bin
done

for i in smbd nmbd swat
do
install -m755 -s source/$i $RPM_BUILD_ROOT/usr/sbin
done

for i in smbclient.1 smbrun.1 smbstatus.1 smbtar.1 testparm.1 testprns.1 make_smbcodepage.1
do
install -m644 docs/$i $RPM_BUILD_ROOT/usr/man/man1
done

for i in 437 850 852 866 932 936 949 950
do
install -m644 source/codepage_def.$i $RPM_BUILD_ROOT/etc/codepages/src
done

for i in swat/help/*.html
do
install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/help
done

for i in swat/images/*.{jpg,gif}
do
install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/images
done

install -m644 docs/smb.conf.5 $RPM_BUILD_ROOT/usr/man/man5
install -m644 docs/samba.7 $RPM_BUILD_ROOT/usr/man/man7
install -m644 docs/smbd.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/nmbd.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/smbpasswd.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 packaging/redhat/RH40/smb.conf $RPM_BUILD_ROOT/etc/smb.conf
install -m644 packaging/redhat/RH40/smbusers $RPM_BUILD_ROOT/etc/smbusers
install -m755 packaging/redhat/RH40/smbprint $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/redhat/RH40/smbadduser $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/redhat/RH40/smb.init $RPM_BUILD_ROOT/etc/rc.d/init.d/smb
install -m755 packaging/redhat/RH40/smb.init $RPM_BUILD_ROOT/usr/sbin/samba
install -m644 packaging/redhat/RH40/samba.pamd $RPM_BUILD_ROOT/etc/pam.d/samba
install -m644 packaging/redhat/RH40/samba.log $RPM_BUILD_ROOT/etc/logrotate.d/samba

ln -sf /etc/rc.d/init.d/smb $RPM_BUILD_ROOT/etc/rc.d/rc0.d/K35smb
ln -sf /etc/rc.d/init.d/smb $RPM_BUILD_ROOT/etc/rc.d/rc1.d/K35smb
ln -sf /etc/rc.d/init.d/smb $RPM_BUILD_ROOT/etc/rc.d/rc2.d/K35smb
ln -sf /etc/rc.d/init.d/smb $RPM_BUILD_ROOT/etc/rc.d/rc3.d/S91smb
ln -sf /etc/rc.d/init.d/smb $RPM_BUILD_ROOT/etc/rc.d/rc5.d/S91smb
ln -sf /etc/rc.d/init.d/smb $RPM_BUILD_ROOT/etc/rc.d/rc6.d/K35smb

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ "$1" = 0 ] ; then
      /sbin/pamconfig --add --service=samba --password=none --sesslist=none
fi
for i in 437 850 852 866 932 936 949 950
do
/usr/bin/make_smbcodepage c $i /etc/codepages/src/codepage_def.$i /etc/codepages/codepage.$i
done

# Add swat entry to /etc/services if not already there
if !( grep ^[:space:]*swat /etc/services > /dev/null ) then
	echo 'swat		901/tcp				# Add swat service used via inetd' >> /etc/services
fi

# Add swat entry to /etc/inetd.conf if needed
if !( grep ^[:space:]*swat /etc/inetd.conf > /dev/null ) then
	echo 'swat	stream	tcp	nowait.400	root	/usr/sbin/swat swat' >> /etc/inetd.conf
killall -1 inetd
fi


%postun
if [ "$1" = 0 ] ; then
  if [ -x /etc/pam.d/samba ]; then
    rm -f /etc/pam.d/samba
  else
    if [ -x /etc/pam.conf ]; then
      /sbin/pamconfig --remove --service=samba --password=none --sesslist=none
    fi
  fi
  if [ -e /etc/codepages ]; then
    rm -rf /etc/codepages
  fi
  if [ -e /var/log/samba ]; then
    rm -rf /var/log/samba
  fi
  if [ -e /var/lock/samba ]; then
    rm -rf /var/lock/samba
  fi
fi

%files
%doc README COPYING Manifest Read-Manifest-Now
%doc WHATSNEW.txt Roadmap
%doc docs
%doc examples
/usr/sbin/smbd
/usr/sbin/nmbd
/usr/sbin/swat
/usr/bin/addtosmbpass
/usr/bin/mksmbpasswd.sh
/usr/bin/smbclient
/usr/bin/testparm
/usr/bin/testprns
/usr/bin/smbrun
/usr/bin/smbstatus
/usr/bin/nmblookup
/usr/bin/make_smbcodepage
/usr/bin/make_printerdef
/usr/bin/smbpasswd
/usr/bin/smbtar
/usr/bin/smbprint
/usr/bin/smbadduser
%config /etc/smb.conf
%config /etc/smbusers
%config /etc/rc.d/init.d/smb
%config /usr/sbin/samba
%config /etc/rc.d/rc3.d/S91smb
%config /etc/rc.d/rc5.d/S91smb
%config /etc/rc.d/rc0.d/K35smb
%config /etc/rc.d/rc1.d/K35smb
%config /etc/rc.d/rc6.d/K35smb
%config /etc/rc.d/rc2.d/K35smb
%config /etc/logrotate.d/samba
%config /etc/pam.d/samba
%config /etc/codepages/src/codepage_def.437
%config /etc/codepages/src/codepage_def.850
%config /etc/codepages/src/codepage_def.852
%config /etc/codepages/src/codepage_def.866
%config /etc/codepages/src/codepage_def.932
%config /etc/codepages/src/codepage_def.936
%config /etc/codepages/src/codepage_def.949
%config /etc/codepages/src/codepage_def.950
/usr/man/man1/smbstatus.1
/usr/man/man1/smbclient.1
/usr/man/man1/make_smbcodepage.1
/usr/man/man1/smbrun.1
/usr/man/man1/smbtar.1
/usr/man/man1/testparm.1
/usr/man/man1/testprns.1
/usr/man/man5/smb.conf.5
/usr/man/man7/samba.7
/usr/man/man8/smbd.8
/usr/man/man8/nmbd.8
/usr/man/man8/smbpasswd.8
%dir /home/samba
%dir /etc/codepages
%dir /etc/codepages/src
%dir /var/lock/samba
%dir /var/log/samba
%dir /var/spool/samba
