/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   Copyright (C) Andrew Tridgell 1992,1993,1994
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "includes.h"
extern int DEBUGLEVEL;


static void (*cont_fn)();


/*******************************************************************
report a fault
********************************************************************/
static void fault_report(int sig,unsigned addr)
{
  DEBUG(0,("===============================================================\n"));
  DEBUG(0,("INTERNAL ERROR: Signal %d in pid %d",sig,getpid()));
  if (!addr)
    {
      DEBUG(0,("\nPlease report this!\n"));
      DEBUG(0,("Please email this info "));
    }
  else
    {
      DEBUG(0,(" at 0x%X\n",sig,addr));
      DEBUG(0,("Please email this info along with the output of \"nm -n smbd\"\n"));
      DEBUG(0,("and \"nm -n nmbd\" "));
    }
  DEBUG(0,("to Andrew.Tridgell@anu.edu.au.\nPlease describe your setup and how to reproduce the problem (if possible)\n"));
  DEBUG(0,("===============================================================\n"));
  
  if (cont_fn)
    {
      fault_setup(cont_fn);
      cont_fn(NULL);
    }
  exit(1);
}

/****************************************************************************
catch serious errors
****************************************************************************/
#ifdef LINUX
static void sig_fault(int sig,struct sigcontext_struct scp)
{
  fault_report(sig,(unsigned)scp.eip);
}
#else
static void sig_fault(int sig)
{
  fault_report(sig,0);
}
#endif


/*******************************************************************
setup our fault handlers
********************************************************************/
void fault_setup(void (*fn)())
{
  cont_fn = fn;
#ifdef SIGSEGV
  signal(SIGSEGV,SIGNAL_CAST sig_fault);
#endif
#ifdef SIGBUS
  signal(SIGBUS,SIGNAL_CAST sig_fault);
#endif
}
