/* 
   Unix SMB/Netbios implementation.
   Version 0.1
   WINS server routines and daemon - version 3
   Copyright (C) Andrew Tridgell 1994-1996 Luke Leighton 1996
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   Module name: winsstat.c

   Revision History:

   14 jan 96: lkcl@pires.co.uk
   added multiple workgroup domain master support

   04 jul 96: lkcl@pires.co.uk
   created module nameservreply containing NetBIOS reply functions

*/

#include "includes.h"

extern int DEBUGLEVEL;


/****************************************************************************
  reply to a name status query

  combine the list of the local interface on which the query was made with
  the names registered via wins.
  ****************************************************************************/
void reply_name_status(struct packet_struct *p)
{
  struct nmb_packet *nmb = &p->packet.nmb;

  if (!nmb->header.nm_flags.recursion_desired)
  {
    DEBUG(4,("name status request to nmbd received from %s\n",
			inet_ntoa(p->ip)));
    /* packet is not for name server. */
    proxy_forward_packet(p->timestamp,p);
    return;
  }

  /* RD set: packet is intended for NBNS (rfc1002.txt 4.2.1.1 p9) */

  DEBUG(2,("name status request to WINS server received from %s PANIC!\n",
			inet_ntoa(p->ip)));
}
