/* 
   Unix SMB/Netbios implementation.
   Version 3.0
   NBT netbios routines and daemon - version 3
   Copyright (C) Andrew Tridgell 1994-1996 Luke Leighton 1996
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   Module name: namerel.c

   Revision History:

   14 jan 96: lkcl@pires.co.uk
   added multiple workgroup domain master support

   09 oct 96: lkcl@pires.co.uk
   created module namerel containing NetBIOS release reply 

*/

#include "includes.h"

extern int DEBUGLEVEL;


/****************************************************************************
reply to a name release
****************************************************************************/
void reply_name_release(struct packet_struct *p)
{
  struct nmb_packet *nmb = &p->packet.nmb;
  struct nmb_name *question = &nmb->question.question_name;
  struct in_addr ip;
  int nb_flags = nmb->additional->rdata[0];
  BOOL bcast = nmb->header.nm_flags.bcast;
  BOOL wins  = nmb->header.nm_flags.recursion_desired;
  struct name_record *n;
  struct subnet_record *d = NULL;
  int idx;
  BOOL success = False;
  int rcode;
  
  putip((char *)&ip,&nmb->additional->rdata[2]);  
  
  DEBUG(3,("Name release on %s name %s\n",inet_ntoa(ip),namestr(question)));
  
  if (wins && !bcast)
  {
    DEBUG(2,("nmbd received packet intended for winsd!\n"));
    return;
  }

  if (!(d = find_req_subnet(p->ip, False)))
  {
    DEBUG(3,("Name release packet: %s not known\n", inet_ntoa(p->ip)));
    return;
  }

  n = find_name_search(&d, question,FIND_WINS|FIND_LOCAL|FIND_SELF,ip,&idx);
  
  /* XXXX under what conditions should we reject the removal?? */
  if (n)
  {
      success = True;
      
      remove_name(p->timestamp,&d->namelist,&d->names_last_modified,n,ip,False);
      n = NULL;
  }
  
  if (bcast) return;
  
  rcode = success ? RCODE_REL_OK : RCODE_REL_ACT_ERR;

  /* Send a NAME RELEASE RESPONSE (pos/neg) see rfc1002.txt 4.2.10-11 */
  send_name_response(p, nmb->header.name_trn_id, NMB_REL,
						rcode, False, False,
						&nmb->question.question_name, nb_flags, 0, ip);
}
