/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Coded by Jean-Marc Jacquet <jeanmarcj@usa.net>
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,#include <gdk/gdkx.h>
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include "protos.h"
#include "pixmaps/icon_256.xpm"
#include "pixmaps/icon_16.xpm"
#include <gdk/gdkx.h>		// Only used by the iconify_window function just below...



void
iconify_window (GtkWidget * widget, GtkWidget * this_window)
{
/* -- is there a better method to do this? Let me know ... -- */
  XIconifyWindow (GDK_WINDOW_XDISPLAY (window->window), GDK_WINDOW_XWINDOW (window->window), 0);
  gdk_flush ();
}



void
deiconify_window (GtkWidget * this_window)
{
  gdk_window_raise (this_window->window);
  gdk_window_show (this_window->window);
  gdk_flush ();
}



void
main_quit (GtkWidget * widget, int *data)
{
  gtk_timeout_remove (check_for_new_message_timeout);
  gtk_main_quit ();
}



int
main (int argc, char *argv[])
{
  GtkWidget *vbox;
  GtkWidget *text;
  GtkWidget *toolbar;
  GtkWidget *table;
  GdkPixmap *icon_pixmap;
  GdkBitmap *icon_mask;

#ifdef DEBUG
  int f;
  char buf[50];

  debug_log = fopen ("/tmp/linpopup.log", "a+");
  fprintf (debug_log, "\n==NEW==\n");
  for (f = 0; f <= argc; f++)
    {
      sprintf (buf, "Arg[%i] : %s \n", f, argv[f]);
      fprintf (debug_log, buf);
    }
  fprintf (debug_log, "=======\n");
#endif

  if (argc > 3)
    trap_message (argc, argv);

#ifdef DEBUG
  fprintf (debug_log, ">>> MSG NOT TRAPPED <<<\n");
  fclose (debug_log);
#endif


  /* -- gtk initialisation -- */
  gtk_set_locale ();
  gtk_init (&argc, &argv);


  /* -- Initialisation of user preferences -- */
  rc_init ();


  /* -- here comes the main window -- */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (GTK_WIDGET (window), 425, 400);
  gtk_window_set_title (GTK_WINDOW (window), "LinPopUp");
  gtk_container_border_width (GTK_CONTAINER (window), 0);
  gtk_widget_realize (window);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event", (GtkSignalFunc) main_quit, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy", (GtkSignalFunc) main_quit, NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show (vbox);

  /* -- create the menu (MENU.C) --*/
  create_menu (vbox);

  /* -- create toolbar widget, and marking it for further retrieval -- */
  toolbar = create_toolbar (window, vbox);
  gtk_object_set_data (GTK_OBJECT (window), "toolbar", toolbar);

  /* -- create text widget, and marking it for further retrieval -- */
  text = create_text (vbox);
  gtk_object_set_data (GTK_OBJECT (window), "text", text);

  /* -- create statusbar (4 cols  in a table) -- */
  {
    int f;
    for (f = 0; f < 4; f++)
      {
	main_statusbar[f] = gtk_statusbar_new ();
	gtk_widget_show (main_statusbar[f]);
	main_context_id[f] = gtk_statusbar_get_context_id (GTK_STATUSBAR (main_statusbar[f]), " ");
	main_message_id[f] = gtk_statusbar_push (GTK_STATUSBAR (main_statusbar[f]), main_context_id[f], " ");
      }
  }

  table = gtk_table_new (1, 6, TRUE);
  gtk_table_set_col_spacings (GTK_TABLE (table), 1);

  gtk_table_attach (GTK_TABLE (table), main_statusbar[0], 0, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (table), main_statusbar[1], 2, 3, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (table), main_statusbar[2], 3, 5, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (table), main_statusbar[3], 5, 6, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);

  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, TRUE, 1);
  gtk_widget_show (table);

  /* -- show the main window -- */
  gtk_widget_show (window);

  /* -- set icon pixmap, and iconify window if required  -- */
  if (user_rc.hcolors)
    icon_pixmap = gdk_pixmap_create_from_xpm_d (window->window, &icon_mask, &window->style->bg[GTK_STATE_NORMAL], icon_256);
  else
    icon_pixmap = gdk_pixmap_create_from_xpm_d (window->window, &icon_mask, &window->style->bg[GTK_STATE_NORMAL], icon_16);

  gdk_window_set_icon (window->window, NULL, icon_pixmap, icon_mask);
  if (argc > 1)
    if (strstr (argv[1], "min"))
      iconify_window (NULL, window);

  /* -- initialisation -- */
  processing_new_message = FALSE;
  is_it_a_reply = FALSE;
  strcpy (wrote, "wrote : ");
  total_number_of_messages = count_total_number_of_messages ();
  if ((new_messages = are_there_new_messages_in_data_file ()))
    show_message (first_new_message);
  else if (total_number_of_messages)
    show_message (total_number_of_messages);
  else
    show_no_message ();

  /* -- start the check_for_new_message timeout -- */
  if (user_rc.message_check_interval)
    check_for_new_message_timeout = gtk_timeout_add (user_rc.message_check_interval, check_for_new_message, NULL);

  /* -- main loop -- */
  gtk_main ();

  return 0;
}
