/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Coded by Jean-Marc Jacquet <jeanmarcj@usa.net>
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include "protos.h"
#include "pixmaps/icon_256.xpm"
#include "pixmaps/icon_16.xpm"
#include "pixmaps/about_256.xpm"



static void
alert_first (GtkWidget * widget, int *data)
{
  *data = 1;
}



static void
alert_second (GtkWidget * widget, int *data)
{
  *data = 2;
}



static GtkWidget *
make_linpopup_icon (GtkWidget * this_window)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *icon;

  if (user_rc.hcolors)
    {
      pixmap = gdk_pixmap_create_from_xpm_d (this_window->window, &mask,
	    &this_window->style->bg[GTK_STATE_NORMAL], (gchar **) icon_256);
    }
  else
    {
      pixmap = gdk_pixmap_create_from_xpm_d (this_window->window, &mask,
	     &this_window->style->bg[GTK_STATE_NORMAL], (gchar **) icon_16);
    }
  icon = gtk_pixmap_new (pixmap, mask);
  return icon;
}



int
alert_dialog (gchar * title, gchar * alert_message, gchar * first_button, gchar * second_button, int default_button)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_hbox;
  GtkWidget *alert_pixmap;
  GtkWidget *alert_label;
  GtkWidget *alert_separator;
  GtkWidget *alert_button;

  gint selected = default_button;

  alert_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (alert_window), title);
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 250, 150);
  gtk_window_position (GTK_WINDOW (alert_window), GTK_WIN_POS_MOUSE);
  gtk_widget_realize (alert_window);

  gdk_window_set_decorations (alert_window->window, GDK_DECOR_BORDER | GDK_DECOR_TITLE);
  alert_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (alert_window), alert_vbox);
  gtk_container_border_width (GTK_CONTAINER (alert_vbox), 0);
  gtk_widget_show (alert_vbox);

  gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

  alert_hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (alert_vbox), alert_hbox);
  gtk_container_border_width (GTK_CONTAINER (alert_hbox), 5);
  gtk_widget_show (alert_hbox);

  alert_pixmap = make_linpopup_icon (alert_window);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_pixmap, FALSE, FALSE, 0);
  gtk_widget_show (alert_pixmap);

  alert_label = gtk_label_new (alert_message);
  gtk_misc_set_alignment (GTK_MISC (alert_label), 0, 0);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_label, FALSE, FALSE, 0);
  gtk_widget_show (alert_label);

  alert_separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (alert_vbox), alert_separator, FALSE, TRUE, 0);
  gtk_widget_show (alert_separator);

  alert_hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (alert_vbox), alert_hbox);
  gtk_container_border_width (GTK_CONTAINER (alert_hbox), 5);
  gtk_widget_show (alert_hbox);

  alert_button = gtk_button_new_with_label (first_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (alert_first), &selected);
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_button, TRUE, TRUE, 0);
  gtk_widget_show (alert_button);

  if (default_button == 1)
    {
      GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (alert_button);
    }

  alert_button = gtk_button_new_with_label (second_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (alert_second), &selected);
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_button, TRUE, TRUE, 0);
  gtk_widget_show (alert_button);

  if (default_button == 2)
    {
      GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (alert_button);
    }

  gtk_widget_show (alert_window);

  gtk_grab_add (alert_window);

  gtk_main ();

  gtk_grab_remove (alert_window);
  gtk_widget_destroy (alert_window);
  return selected;
}



void
alert_ok (gchar * title, gchar * alert_message, gchar * alert_button_label)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_hbox;
  GtkWidget *alert_pixmap;
  GtkWidget *alert_label;
  GtkWidget *alert_separator;
  GtkWidget *alert_button;

  alert_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (alert_window), title);
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 250, 150);
  gtk_window_position (GTK_WINDOW (alert_window), GTK_WIN_POS_MOUSE);
  gtk_widget_realize (alert_window);

  gdk_window_set_decorations (alert_window->window, GDK_DECOR_BORDER | GDK_DECOR_TITLE);
  alert_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (alert_window), alert_vbox);
  gtk_container_border_width (GTK_CONTAINER (alert_vbox), 0);
  gtk_widget_show (alert_vbox);

  alert_hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (alert_vbox), alert_hbox);
  gtk_container_border_width (GTK_CONTAINER (alert_hbox), 5);
  gtk_widget_show (alert_hbox);

  alert_pixmap = make_linpopup_icon (alert_window);

  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_pixmap, FALSE, FALSE, 0);
  gtk_widget_show (alert_pixmap);

  alert_label = gtk_label_new (alert_message);
  gtk_misc_set_alignment (GTK_MISC (alert_label), 0, 0);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_label, FALSE, FALSE, 0);
  gtk_widget_show (alert_label);

  alert_separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (alert_vbox), alert_separator, FALSE, TRUE, 0);
  gtk_widget_show (alert_separator);

  alert_hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (alert_vbox), alert_hbox);
  gtk_container_border_width (GTK_CONTAINER (alert_hbox), 5);
  gtk_widget_show (alert_hbox);

  alert_button = gtk_button_new_with_label (alert_button_label);
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_button, TRUE, TRUE, 0);
  gtk_widget_show (alert_button);

  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);

  gtk_widget_show (alert_window);
}



void
about_dialog (void)
{
  GtkWidget *about_window = 0;
  GtkWidget *about_vbox, *vbox;
  GtkWidget *about_hbox;
  GtkWidget *about_pixmap;
  GtkWidget *about_label;
  GtkWidget *about_separator;
  GtkWidget *about_button;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  char buf[128];

  about_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (about_window), " About LinPopUp");
  gtk_window_position (GTK_WINDOW (about_window), GTK_WIN_POS_MOUSE);
  gtk_widget_realize (about_window);
  gdk_window_set_decorations (about_window->window, GDK_DECOR_BORDER | GDK_DECOR_TITLE);
  gdk_window_set_functions (about_window->window, 0);

  about_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (about_window), about_vbox);
  gtk_widget_show (about_vbox);

  gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

  about_hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (about_vbox), about_hbox);
  gtk_widget_show (about_hbox);


  pixmap = gdk_pixmap_create_from_xpm_d (about_window->window, &mask,
	   &about_window->style->bg[GTK_STATE_NORMAL], (gchar **) icon_256);
  about_pixmap = gtk_pixmap_new (pixmap, mask);
  gtk_box_pack_start (GTK_BOX (about_hbox), about_pixmap, FALSE, FALSE, 5);
  gtk_widget_show (about_pixmap);


  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (about_hbox), vbox);
  gtk_container_border_width (GTK_CONTAINER (vbox), 8);
  gtk_widget_show (vbox);

  about_label = gtk_label_new (a_little_version_infos (buf));
  gtk_misc_set_alignment (GTK_MISC (about_label), 0, 0);
  gtk_box_pack_start (GTK_BOX (vbox), about_label, TRUE, TRUE, 0);
  gtk_widget_show (about_label);


  pixmap = gdk_pixmap_create_from_xpm_d (about_window->window, &mask,
	  &about_window->style->bg[GTK_STATE_NORMAL], (gchar **) about_256);
  about_pixmap = gtk_pixmap_new (pixmap, mask);
  gtk_box_pack_start (GTK_BOX (vbox), about_pixmap, FALSE, FALSE, 0);
  gtk_widget_show (about_pixmap);


  about_separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (about_vbox), about_separator, FALSE, TRUE, 0);
  gtk_widget_show (about_separator);

  about_hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (about_vbox), about_hbox);
  gtk_container_border_width (GTK_CONTAINER (about_hbox), 5);
  gtk_widget_show (about_hbox);

  about_button = gtk_button_new_with_label ("Close");
  gtk_signal_connect_object (GTK_OBJECT (about_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (about_window));
  gtk_box_pack_start (GTK_BOX (about_hbox), about_button, TRUE, TRUE, 0);
  gtk_widget_show (about_button);
  GTK_WIDGET_SET_FLAGS (about_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (about_button);

  gtk_widget_show (about_window);
}



void
doc_dialog (GtkWidget * widget, int index)
{
#include "user_guide_doc.h"
#include "changes_doc.h"
#include "copying_doc.h"
#include "faq_doc.h"
  GtkWidget *doc_window = 0;
  GtkWidget *doc_vbox;
  GtkWidget *doc_hbox;
  GtkWidget *doc_text;
  GtkWidget *doc_separator;
  GtkWidget *doc_button;
  GtkWidget *doc_pixmap;

  doc_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (doc_window), " LinPopUp Help");
  gtk_widget_set_usize (GTK_WIDGET (doc_window), 600, 500);
  gtk_widget_realize (doc_window);
  gtk_window_position (GTK_WINDOW (doc_window), GTK_WIN_POS_MOUSE);

  doc_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (doc_window), doc_vbox);
  gtk_container_border_width (GTK_CONTAINER (doc_vbox), 5);
  gtk_widget_show (doc_vbox);

  doc_text = create_text (doc_vbox);

  doc_separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (doc_vbox), doc_separator, FALSE, TRUE, 0);
  gtk_widget_show (doc_separator);

  doc_hbox = gtk_hbox_new (FALSE, 10);

  gtk_box_pack_start (GTK_BOX (doc_vbox), doc_hbox, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (doc_hbox), 5);
  gtk_widget_show (doc_hbox);


  doc_pixmap = make_linpopup_icon (doc_window);
  gtk_box_pack_start (GTK_BOX (doc_hbox), doc_pixmap, FALSE, FALSE, 0);
  gtk_widget_show (doc_pixmap);

  doc_button = gtk_button_new_with_label ("Close");
  gtk_signal_connect_object (GTK_OBJECT (doc_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (doc_window));
  gtk_box_pack_start (GTK_BOX (doc_hbox), doc_button, TRUE, TRUE, 0);
  gtk_widget_show (doc_button);

  GTK_WIDGET_SET_FLAGS (doc_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (doc_button);

  gtk_widget_show (doc_window);

  switch (index)
    {
    case 1:
      realize_text (doc_text, USER_GUIDE_STRING);
      break;
    case 2:
      realize_text (doc_text, FAQ_STRING);
      break;
    case 3:
      realize_text (doc_text, CHANGES_STRING);
      break;
    case 4:
      realize_text (doc_text, COPYING_STRING);
      break;
    default:
      realize_text (doc_text, "Not yet available ...");
    }
}



void
alert_ok_text (gchar * message)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_hbox;
  GtkWidget *alert_text;
  GtkWidget *alert_separator;
  GtkWidget *alert_button;
  GtkWidget *alert_pixmap;

  alert_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (alert_window), " LinPopUp - Smbclient output");
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 350, 200);
  gtk_widget_realize (alert_window);
  gtk_window_position (GTK_WINDOW (alert_window), GTK_WIN_POS_MOUSE);

  alert_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (alert_window), alert_vbox);
  gtk_container_border_width (GTK_CONTAINER (alert_vbox), 5);
  gtk_widget_show (alert_vbox);

  alert_text = create_text (alert_vbox);

  alert_separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (alert_vbox), alert_separator, FALSE, TRUE, 0);
  gtk_widget_show (alert_separator);

  alert_hbox = gtk_hbox_new (FALSE, 10);

  gtk_box_pack_start (GTK_BOX (alert_vbox), alert_hbox, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (alert_hbox), 5);
  gtk_widget_show (alert_hbox);

  alert_pixmap = make_linpopup_icon (alert_window);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_pixmap, FALSE, FALSE, 0);
  gtk_widget_show (alert_pixmap);

  alert_button = gtk_button_new_with_label ("Ok");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_button, TRUE, TRUE, 0);
  gtk_widget_show (alert_button);

  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);

  gtk_widget_show (alert_window);

  realize_text (alert_text, message);

  gdk_window_raise (alert_window->window);
}
