/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Coded by Jean-Marc Jacquet <jeanmarcj@usa.net>
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include "protos.h"


static char rc_path[2048];
static GtkWidget *rc_window;
static struct linpopup_custom previous_user_rc;



static void
save_rc (void)
{
  int file_handle;
  file_handle = open (rc_path, O_CREAT | O_TRUNC | O_WRONLY, RC_PERM);
  write (file_handle, &user_rc, sizeof (user_rc));
  close (file_handle);
}



static void
read_rc (void)
{
  int file_handle;
  file_handle = open (rc_path, O_RDONLY, RC_PERM);
  read (file_handle, &user_rc, sizeof (user_rc));
  close (file_handle);
#ifdef DEBUG
  printf ("\npath :%s\n\n", rc_path);
  printf("\n version :%s\n check : %i\n quote : %c\n", user_rc.version, user_rc.message_check_interval, user_rc.quote);
#endif
}



static void
create_rc (void)
{
  version (user_rc.version);
  user_rc.toolbar_style = GTK_TOOLBAR_BOTH;
  user_rc.message_check_interval = 2000;
  user_rc.hcolors = TRUE;
  user_rc.quote = '>';
  save_rc ();
}



void
rc_init (void)
{
  if (!getenv ("HOME"))
    fatal_error (2, "HOME");
  sprintf (rc_path, "%s/.linpopuprc", getenv ("HOME"));
#ifdef DEBUG
  printf ("\n%s\n", rc_path);
#endif
  if (access (rc_path, F_OK))
    create_rc ();
  else
    read_rc ();
}



static void
toolbar_set_style (GtkWidget * widget, GtkToolbarStyle style)
{
  GtkWidget *this_toolbar;

/*-- retrieving main window  toolbar previously marqued with gtk_object_set_data(...) --*/
  this_toolbar = gtk_object_get_data (GTK_OBJECT (window), "toolbar");
  gtk_toolbar_set_style (GTK_TOOLBAR (this_toolbar), style);
  user_rc.toolbar_style = style;
}



static void
icons_set_colors (GtkWidget * widget, char IS_HEIGHT)
{
  user_rc.hcolors = IS_HEIGHT;
}



static void
custom_ok (GtkWidget * widget)
{
  save_rc ();
  gtk_widget_destroy (rc_window);
}



static void
custom_cancel (GtkWidget * widget)
{
  user_rc = previous_user_rc;
  toolbar_set_style (widget, user_rc.toolbar_style);
  save_rc ();
  gtk_widget_destroy (rc_window);
}



void
custom_notebook (void)
{
  GtkWidget *rc_table;
  GtkWidget *rc_notebook;
  GtkWidget *rc_vbox;
  GtkWidget *rc_frame;
  GtkWidget *rc_frame_table;
  GtkWidget *rc_radio_text;
  GtkWidget *rc_radio_icons;
  GtkWidget *rc_radio_both;
  GtkWidget *rc_radio_hcolors;
  GtkWidget *rc_radio_mcolors;
  GtkWidget *rc_label;
  GtkWidget *rc_button_ok;
  GtkWidget *rc_button_cancel;
  gint x, y;

  previous_user_rc = user_rc;

  /* -- create the window and place it -- */
  rc_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_set_usize (GTK_WIDGET (rc_window), 425, 400);
  gtk_widget_realize (rc_window);
  gtk_window_set_title (GTK_WINDOW (rc_window), "Preferences");
  gtk_container_border_width (GTK_CONTAINER (rc_window), 1);
  gdk_window_get_origin (window->window, &x, &y);
  gtk_widget_set_uposition (rc_window, x, y);

  gtk_signal_connect (GTK_OBJECT (rc_window), "delete_event", GTK_SIGNAL_FUNC (custom_cancel), NULL);
  

  /* -- a table to pack widgets -- */
  rc_table = gtk_table_new (15, 17, FALSE);
  gtk_container_add (GTK_CONTAINER (rc_window), rc_table);
  gtk_container_border_width (GTK_CONTAINER (rc_table), 5);

  /* -- Create a new notebook, and pack it to the table -- */
  rc_notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (rc_notebook), GTK_POS_TOP);
  gtk_table_attach (GTK_TABLE (rc_table), rc_notebook, 0, 15, 0, 16, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
  gtk_widget_show (rc_notebook);



  /* -- Toolbar properties  page -- */
  rc_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (rc_vbox), 5);
  gtk_widget_show (rc_vbox);

  /* -- The view Frame -- */
  rc_frame = gtk_frame_new (" View :  ");
  gtk_container_border_width (GTK_CONTAINER (rc_frame), 0);
  gtk_widget_set_usize (rc_frame, 400, 150);
  gtk_box_pack_start (GTK_BOX (rc_vbox), rc_frame, FALSE, FALSE, 0);
  gtk_widget_show (rc_frame);

  rc_frame_table = gtk_table_new (1, 5, TRUE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  rc_radio_both = gtk_radio_button_new_with_label (NULL, "Icons and text");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_both, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);

  gtk_widget_show (rc_radio_both);

  rc_radio_icons = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_both)), "Icons only");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_icons, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_icons);

  rc_radio_text = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_both)), "Text only");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_text, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_text);

  gtk_signal_connect_object (GTK_OBJECT (rc_radio_both), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_BOTH));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_icons), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_ICONS));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_text), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_TEXT));

  switch (user_rc.toolbar_style)
    {
    case GTK_TOOLBAR_TEXT:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_text), TRUE);
      break;
    case GTK_TOOLBAR_ICONS:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_icons), TRUE);
      break;
    default:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_both), TRUE);
    }

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);


  /* -- the icons default frame -- */
  rc_frame = gtk_frame_new (" Icons default :   ( need to restart LinPopup to take effect ) ");
  gtk_container_border_width (GTK_CONTAINER (rc_frame), 0);
  gtk_widget_set_usize (rc_frame, 400, 125);
  gtk_box_pack_start (GTK_BOX (rc_vbox), rc_frame, TRUE, FALSE, 0);
  gtk_widget_show (rc_frame);

  rc_frame_table = gtk_table_new (1, 4, TRUE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  rc_radio_hcolors = gtk_radio_button_new_with_label (NULL, "High colors set");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_hcolors, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_hcolors);

  rc_radio_mcolors = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_hcolors)), "Minimum colors set");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_mcolors, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_mcolors);

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);

  gtk_signal_connect_object (GTK_OBJECT (rc_radio_hcolors), "clicked", GTK_SIGNAL_FUNC (icons_set_colors), GINT_TO_POINTER (TRUE));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_mcolors), "clicked", GTK_SIGNAL_FUNC (icons_set_colors), GINT_TO_POINTER (FALSE));

  if (user_rc.hcolors)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_hcolors), TRUE);
  else
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_mcolors), TRUE);

  rc_label = gtk_label_new (" Toolbar properties  ");
  gtk_notebook_append_page (GTK_NOTEBOOK (rc_notebook), rc_vbox, rc_label);


  /* -- General  setting  page -- */
  rc_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (rc_vbox), 5);
  gtk_widget_show (rc_vbox);

  rc_label = gtk_label_new (" General settings  ");
  gtk_notebook_append_page (GTK_NOTEBOOK (rc_notebook), rc_vbox, rc_label);

  /* -- and here are the 2 buttons -- */
  rc_button_ok = gtk_button_new_with_label ("Done");
  gtk_table_attach (GTK_TABLE (rc_table), rc_button_ok, 0, 7, 16, 17, GTK_FILL,
		    GTK_FILL | GTK_EXPAND, 0, 5);
  gtk_widget_show (rc_button_ok);

  GTK_WIDGET_SET_FLAGS (rc_button_ok, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (rc_button_ok);

  rc_button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_table_attach (GTK_TABLE (rc_table), rc_button_cancel, 8, 15, 16, 17, GTK_FILL,
		    GTK_FILL | GTK_EXPAND, 0, 5);
  gtk_widget_show (rc_button_cancel);

  gtk_signal_connect_object (GTK_OBJECT (rc_button_ok), "clicked", GTK_SIGNAL_FUNC (custom_ok), NULL);
  gtk_signal_connect_object (GTK_OBJECT (rc_button_cancel), "clicked", GTK_SIGNAL_FUNC (custom_cancel), NULL);


  gtk_widget_show (rc_table);
  gtk_widget_show (rc_window);
}
