H55601
s 00018/00002/00449
d D 1.15 03/11/02 14:55:37 stevef 16 15
c Do not treat invalid handle on oplock break as an error.  After writing out dirty file data for file that has been cached locally it is harmless for close and response to oplock break to be sent out of order
cC
cHlinux.local
cK10247
cZ-06:00
e
s 00007/00007/00444
d D 1.14 03/09/08 19:01:20 stevef 15 14
c Fix spinlock usage for SMP safety
cC
cHstevef95.austin.ibm.com
cK32751
e
s 00002/00002/00449
d D 1.13 03/08/29 01:50:52 stevef 14 13
c Match smb pid to current->tgid
cC
cHsmfhome2.austin.rr.com
cK33461
e
s 00002/00000/00449
d D 1.12 03/08/06 12:45:33 stevef 13 12
c disable unneeded debug code
cC
cHlinux.local
cK33113
e
s 00002/00002/00447
d D 1.11 03/07/21 22:36:09 stevef 12 11
c fix create/open/lookup to use namei intent flags
cC
cHstevef95.austin.ibm.com
cK29934
cZ-07:00
e
s 00047/00000/00402
d D 1.10 03/07/16 20:32:33 stevef 11 10
c fix multiuser mount option
cC
cHsteveft21.ltcsamba
cK30011
cZ-05:00
e
s 00003/00008/00399
d D 1.9 03/07/11 19:24:02 stevef 10 9
c send oplock release on oplock break from server
cC
cK58962
e
s 00004/00004/00403
d D 1.8 03/05/27 17:41:17 stevef 9 8
c Cleanup compiler warnings generated by new gcc
cC
cHstevef95.austin.ibm.com
cK15876
cZ-07:00
e
s 00011/00000/00396
d D 1.7 03/03/31 21:52:27 stevef 8 7
c Add more oplock handling
cC
cK10656
e
s 00002/00001/00394
d D 1.6 03/03/07 17:01:07 stevef 7 6
c Clarify comment about readsize
cC
cK40691
e
s 00002/00000/00393
d D 1.5 03/02/18 21:15:11 stevef 6 5
c Autoreconnect tids after temporary session drop
cC
cK33795
e
s 00067/00054/00326
d D 1.4 03/02/15 16:10:24 stevef 5 4
c Improve error logging
cC
cHsmfhome1.austin.rr.com
cK28656
e
s 00033/00033/00347
d D 1.3 02/10/31 16:10:08 stevef 4 3
c Formatting changes to whitespace
cC
cHsteveft21.ltcsamba
cK11858
cZ-06:00
e
s 00068/00050/00312
d D 1.2 02/10/20 00:14:50 stevef 3 2
c Fix locking of global smb list
cC
cK63136
e
s 00362/00000/00000
d D 1.1 02/10/10 14:16:13 stevef 2 1
cC
cF1
cK09859
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 02/10/10 14:16:13 stevef 1 0
c BitKeeper file /home/stevef/bk/linux-2.5-with-cifs/fs/cifs/misc.c
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cHsmfhome1.austin.rr.com
cK64320
cPfs/cifs/misc.c
cR6701b68ce5b74dc5
cV4
cX0x821
cZ-05:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *   fs/cifs/misc.c
 *
D 14
 *   Copyright (c) International Business Machines  Corp., 2002
E 14
I 14
D 15
 *   Copyright (c) International Business Machines  Corp., 2002,2003
E 15
I 15
 *   Copyright (C) International Business Machines  Corp., 2002,2003
E 15
E 14
 *   Author(s): Steve French (sfrench@us.ibm.com)
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#include <linux/slab.h>
#include <linux/ctype.h>
#include "cifspdu.h"
#include "cifsglob.h"
#include "cifsproto.h"
#include "cifs_debug.h"
I 16
#include "smberr.h"
#include "nterr.h"
E 16

extern kmem_cache_t *cifs_req_cachep;
I 8
extern struct task_struct * oplockThread;
E 8

D 3
static DECLARE_MUTEX(GlobalMid_Sem);	/* also protects XID globals */
E 3
__u16 GlobalMid;		/* multiplex id - rotating counter */

/* The xid serves as a useful identifier for each incoming vfs request, 
   in a similar way to the mid which is useful to track each sent smb, 
   and CurrentXid can also provide a running counter (although it 
   will eventually wrap past zero) of the total vfs operations handled 
   since the cifs fs was mounted */

unsigned int
_GetXid(void)
{
	unsigned int xid;

D 3
	down(&GlobalMid_Sem);
E 3
I 3
D 15
	write_lock(&GlobalMid_Lock);
E 15
I 15
	spin_lock(&GlobalMid_Lock);
E 15
E 3
	GlobalTotalActiveXid++;
	if (GlobalTotalActiveXid > GlobalMaxActiveXid)
		GlobalMaxActiveXid = GlobalTotalActiveXid;	/* keep high water mark for number of simultaneous vfs ops in our filesystem */
	xid = GlobalCurrentXid++;
D 3
	up(&GlobalMid_Sem);
E 3
I 3
D 15
	write_unlock(&GlobalMid_Lock);
E 15
I 15
	spin_unlock(&GlobalMid_Lock);
E 15
E 3
	return xid;
}

void
_FreeXid(unsigned int xid)
{
D 3
	down(&GlobalMid_Sem);
E 3
I 3
D 15
	write_lock(&GlobalMid_Lock);
E 15
I 15
	spin_lock(&GlobalMid_Lock);
E 15
I 13
	/* if(GlobalTotalActiveXid == 0)
		BUG(); */
E 13
E 3
	GlobalTotalActiveXid--;
D 3
	up(&GlobalMid_Sem);
E 3
I 3
D 15
	write_unlock(&GlobalMid_Lock);
E 15
I 15
	spin_unlock(&GlobalMid_Lock);
E 15
E 3
}

struct cifsSesInfo *
sesInfoAlloc(void)
{
	struct cifsSesInfo *ret_buf;

	ret_buf =
	    (struct cifsSesInfo *) kmalloc(sizeof (struct cifsSesInfo),
					   GFP_KERNEL);
	if (ret_buf) {
		memset(ret_buf, 0, sizeof (struct cifsSesInfo));
I 3
		write_lock(&GlobalSMBSeslock);
E 3
		atomic_inc(&sesInfoAllocCount);
I 6
		ret_buf->status = CifsNew;
E 6
		list_add(&ret_buf->cifsSessionList, &GlobalSMBSessionList);
		init_MUTEX(&ret_buf->sesSem);
I 3
		write_unlock(&GlobalSMBSeslock);
E 3
	}
	return ret_buf;
}

void
sesInfoFree(struct cifsSesInfo *buf_to_free)
{
	if (buf_to_free == NULL) {
D 5
		cFYI(1, ("\nNull buffer passed to sesInfoFree"));
E 5
I 5
		cFYI(1, ("Null buffer passed to sesInfoFree"));
E 5
		return;
	}

I 3
	write_lock(&GlobalSMBSeslock);
E 3
	atomic_dec(&sesInfoAllocCount);
	list_del(&buf_to_free->cifsSessionList);
I 3
	write_unlock(&GlobalSMBSeslock);
E 3
	if (buf_to_free->serverOS)
		kfree(buf_to_free->serverOS);
	if (buf_to_free->serverDomain)
		kfree(buf_to_free->serverDomain);
	if (buf_to_free->serverNOS)
		kfree(buf_to_free->serverNOS);
	kfree(buf_to_free);
}

struct cifsTconInfo *
tconInfoAlloc(void)
{
	struct cifsTconInfo *ret_buf;
	ret_buf =
	    (struct cifsTconInfo *) kmalloc(sizeof (struct cifsTconInfo),
					    GFP_KERNEL);
	if (ret_buf) {
		memset(ret_buf, 0, sizeof (struct cifsTconInfo));
I 3
		write_lock(&GlobalSMBSeslock);
E 3
		atomic_inc(&tconInfoAllocCount);
		list_add(&ret_buf->cifsConnectionList,
			 &GlobalTreeConnectionList);
I 6
		ret_buf->tidStatus = CifsNew;
E 6
D 3
        INIT_LIST_HEAD(&ret_buf->openFileList);
E 3
I 3
		INIT_LIST_HEAD(&ret_buf->openFileList);
E 3
		init_MUTEX(&ret_buf->tconSem);
I 3
		write_unlock(&GlobalSMBSeslock);
E 3
	}
	return ret_buf;
}

void
tconInfoFree(struct cifsTconInfo *buf_to_free)
{
	if (buf_to_free == NULL) {
D 5
		cFYI(1, ("\nNull buffer passed to tconInfoFree"));
E 5
I 5
		cFYI(1, ("Null buffer passed to tconInfoFree"));
E 5
		return;
	}
D 3

E 3
I 3
	write_lock(&GlobalSMBSeslock);
E 3
	atomic_dec(&tconInfoAllocCount);
	list_del(&buf_to_free->cifsConnectionList);
I 3
	write_unlock(&GlobalSMBSeslock);
E 3
	if (buf_to_free->nativeFileSystem)
		kfree(buf_to_free->nativeFileSystem);
	kfree(buf_to_free);
}

void *
kcalloc(size_t size, int type)
{
	void *addr;
	addr = kmalloc(size, type);
	if (addr)
		memset(addr, 0, size);
	return addr;
}

struct smb_hdr *
buf_get(void)
{
	struct smb_hdr *ret_buf;

/* We could use negotiated size instead of max_msgsize - 
   but it may be more efficient to always alloc same size 
D 7
   albeit slightly larger */
E 7
I 7
   albeit slightly larger than necessary and maxbuffersize 
   defaults to this and can not be bigger */
E 7
	ret_buf =
	    (struct smb_hdr *) kmem_cache_alloc(cifs_req_cachep, SLAB_KERNEL);

	/* clear the first few header bytes */
	if (ret_buf) {
		memset(ret_buf, 0, sizeof (struct smb_hdr));
		atomic_inc(&bufAllocCount);
	}

	return ret_buf;
}

void
buf_release(void *buf_to_free)
{

	if (buf_to_free == NULL) {
D 5
		cFYI(1, ("\nNull buffer passed to buf_release"));
E 5
I 5
		cFYI(1, ("Null buffer passed to buf_release"));
E 5
		return;
	}
	kmem_cache_free(cifs_req_cachep, buf_to_free);

	atomic_dec(&bufAllocCount);
	return;
}

void
header_assemble(struct smb_hdr *buffer, char smb_command /* command */ ,
		const struct cifsTconInfo *treeCon, int word_count
		/* length of fixed section (word count) in two byte units  */
    )
{
	int i;
	__u32 tmp;
I 11
	struct list_head* temp_item;
	struct cifsSesInfo * ses;
E 11
	char *temp = (char *) buffer;

	for (i = 0; i < MAX_CIFS_HDR_SIZE; i++) {
		temp[i] = 0;	/* BB is this needed ?? */
	}

	buffer->smb_buf_length =
	    (2 * word_count) + sizeof (struct smb_hdr) -
	    4 /*  RFC 1001 length field does not count */  +
	    2 /* for bcc field itself */ ;
	/* Note that this is the only network field that has to be converted to big endian and it is done just before we send it */

	buffer->Protocol[0] = 0xFF;
	buffer->Protocol[1] = 'S';
	buffer->Protocol[2] = 'M';
	buffer->Protocol[3] = 'B';
	buffer->Command = smb_command;
	buffer->Flags = 0x00;	/* case sensitive */
	buffer->Flags2 = SMBFLG2_KNOWS_LONG_NAMES;
D 14
	tmp = cpu_to_le32(current->pid);
E 14
I 14
	tmp = cpu_to_le32(current->tgid);
E 14
	buffer->Pid = tmp & 0xFFFF;
	tmp >>= 16;
	buffer->PidHigh = tmp & 0xFFFF;
D 3
	down(&GlobalMid_Sem);
E 3
I 3
D 15
	write_lock(&GlobalMid_Lock);
E 15
I 15
	spin_lock(&GlobalMid_Lock);
E 15
E 3
	GlobalMid++;
	buffer->Mid = GlobalMid;
I 3
D 15
	write_unlock(&GlobalMid_Lock);
E 15
I 15
	spin_unlock(&GlobalMid_Lock);
E 15
E 3
	if (treeCon) {
		buffer->Tid = treeCon->tid;
		if (treeCon->ses) {
			if (treeCon->ses->capabilities & CAP_UNICODE)
				buffer->Flags2 |= SMBFLG2_UNICODE;
			if (treeCon->ses->capabilities & CAP_STATUS32) {
				buffer->Flags2 |= SMBFLG2_ERR_STATUS;
			}
I 11

E 11
			buffer->Uid = treeCon->ses->Suid;	/* always in LE format */
I 11
			if(multiuser_mount != 0) {
		/* For the multiuser case, there are few obvious technically  */
		/* possible mechanisms to match the local linux user (uid)    */
		/* to a valid remote smb user (smb_uid):		      */
		/* 	1) Query Winbind (or other local pam/nss daemon       */
		/* 	  for userid/password/logon_domain or credential      */
		/*      2) Query Winbind for uid to sid to username mapping   */
		/* 	   and see if we have a matching password for existing*/
		/*         session for that user perhas getting password by   */
		/*         adding a new pam_cifs module that stores passwords */
		/*         so that the cifs vfs can get at that for all logged*/
		/*	   on users					      */
		/*	3) (Which is the mechanism we have chosen)	      */
		/*	   Search through sessions to the same server for a   */
		/*	   a match on the uid that was passed in on mount     */
		/*         with the current processes uid (or euid?) and use  */
		/* 	   that smb uid.   If no existing smb session for     */
		/* 	   that uid found, use the default smb session ie     */
		/*         the smb session for the volume mounted which is    */
		/* 	   the same as would be used if the multiuser mount   */
		/* 	   flag were disabled.  */

		/*  BB Add support for establishing new tCon and SMB Session  */
		/*      with userid/password pairs found on the smb session   */ 
		/*	for other target tcp/ip addresses 		BB    */
				if(current->uid != treeCon->ses->linux_uid) {
					cFYI(1,("Multiuser mode and UID did not match tcon uid "));
					read_lock(&GlobalSMBSeslock);
					list_for_each(temp_item, &GlobalSMBSessionList) {
						ses = list_entry(temp_item, struct cifsSesInfo, cifsSessionList);
						if(ses->linux_uid == current->uid) {
							if(ses->server == treeCon->ses->server) {
								cFYI(1,("found matching uid substitute right smb_uid"));  
								buffer->Uid = ses->Suid;
								break;
							} else {
								/* BB eventually call setup_session here */
								cFYI(1,("local UID found but smb sess with this server does not exist"));  
							}
						}
					}
					read_unlock(&GlobalSMBSeslock);
				}
			}
E 11
		}
		if (treeCon->Flags & SMB_SHARE_IS_IN_DFS)
			buffer->Flags2 |= SMBFLG2_DFS;
D 3
        if(treeCon->ses->secMode & (SECMODE_SIGN_REQUIRED | SECMODE_SIGN_ENABLED))
            buffer->Flags2 |= SMBFLG2_SECURITY_SIGNATURE;

E 3
I 3
D 5
		if(treeCon->ses->secMode & (SECMODE_SIGN_REQUIRED | SECMODE_SIGN_ENABLED))
			buffer->Flags2 |= SMBFLG2_SECURITY_SIGNATURE;
E 5
I 5
		if(treeCon->ses->server)
			if(treeCon->ses->server->secMode & 
			  (SECMODE_SIGN_REQUIRED | SECMODE_SIGN_ENABLED))
				buffer->Flags2 |= SMBFLG2_SECURITY_SIGNATURE;
E 5
E 3
	}

/*  endian conversion of flags is now done just before sending */
D 3
	up(&GlobalMid_Sem);
E 3
	buffer->WordCount = (char) word_count;
	return;
}

int
checkSMBhdr(struct smb_hdr *smb, __u16 mid)
{
	/* Make sure that this really is an SMB, that it is a response, 
D 3
        and that the message ids match */
	if ((*(unsigned int *) smb->Protocol == cpu_to_le32(0x424d53ff)) && (mid == smb->Mid)) {    
        if(smb->Flags & SMBFLG_RESPONSE)
            return 0;                    
        else {        
    /* only one valid case where server sends us request */
            if(smb->Command == SMB_COM_LOCKING_ANDX)
                return 0;
            else
                cERROR(1, ("\n Rcvd Request not response "));         
        }
E 3
I 3
	   and that the message ids match */
	if ((*(unsigned int *) smb->Protocol == cpu_to_le32(0x424d53ff)) && 
		(mid == smb->Mid)) {    
		if(smb->Flags & SMBFLG_RESPONSE)
			return 0;                    
		else {        
		/* only one valid case where server sends us request */
			if(smb->Command == SMB_COM_LOCKING_ANDX)
				return 0;
			else
D 5
				cERROR(1, ("\n Rcvd Request not response "));         
E 5
I 5
				cERROR(1, ("Rcvd Request not response "));         
E 5
		}
E 3
	} else { /* bad signature or mid */
		if (*(unsigned int *) smb->Protocol != cpu_to_le32(0x424d53ff))
			cERROR(1,
D 5
			       ("\nBad protocol string signature header %x ",
E 5
I 5
			       ("Bad protocol string signature header %x ",
E 5
				*(unsigned int *) smb->Protocol));
		if (mid != smb->Mid)
D 5
			cERROR(1, ("\n Mids do not match \n"));
E 5
I 5
			cERROR(1, ("Mids do not match"));
E 5
	}
D 3
    cERROR(1, ("\nCIFS: bad smb detected. The Mid=%d\n", smb->Mid));
    return 1;
E 3
I 3
D 5
	cERROR(1, ("\nCIFS: bad smb detected. The Mid=%d\n", smb->Mid));
E 5
I 5
	cERROR(1, ("bad smb detected. The Mid=%d", smb->Mid));
E 5
	return 1;
E 3
}

int
checkSMB(struct smb_hdr *smb, __u16 mid, int length)
{
	cFYI(0,
D 5
	     ("\nEntering checkSMB with Length: %x, smb_buf_length: %x ",
E 5
I 5
	     ("Entering checkSMB with Length: %x, smb_buf_length: %x ",
E 5
	      length, ntohl(smb->smb_buf_length)));
D 9
	if ((length < 2 + sizeof (struct smb_hdr))
E 9
I 9
	if (((unsigned int)length < 2 + sizeof (struct smb_hdr))
E 9
	    || (4 + ntohl(smb->smb_buf_length) >
		CIFS_MAX_MSGSIZE + MAX_CIFS_HDR_SIZE)) {
D 9
		if (length < 2 + sizeof (struct smb_hdr)) {
E 9
I 9
		if ((unsigned int)length < 2 + sizeof (struct smb_hdr)) {
E 9
D 5
			cERROR(1, ("\n Length less than 2 + sizeof smb_hdr "));
E 5
I 5
			cERROR(1, ("Length less than 2 + sizeof smb_hdr "));
E 5
D 9
			if ((length >= sizeof (struct smb_hdr) - 1)
E 9
I 9
			if (((unsigned int)length >= sizeof (struct smb_hdr) - 1)
E 9
			    && (smb->Status.CifsError != 0))
D 3
				return 0;	/* this is ok - some error cases do not return wct and bcc */
E 3
I 3
				return 0;	/* some error cases do not return wct and bcc */
E 3

		}
		if (4 + ntohl(smb->smb_buf_length) >
		    CIFS_MAX_MSGSIZE + MAX_CIFS_HDR_SIZE)
			cERROR(1,
D 5
			       ("\n smb_buf_length greater than CIFS_MAX_MSGSIZE ... "));
E 5
I 5
			       ("smb_buf_length greater than CIFS_MAX_MSGSIZE ... "));
E 5
		cERROR(1,
D 5
		       ("CIFS: bad smb detected. Illegal length. The mid=%d\n",
E 5
I 5
		       ("bad smb detected. Illegal length. The mid=%d",
E 5
			smb->Mid));
		return 1;
	}

	if (checkSMBhdr(smb, mid))
		return 1;

	if ((4 + ntohl(smb->smb_buf_length) != smbCalcSize(smb))
D 9
	    || (4 + ntohl(smb->smb_buf_length) != length)) {
E 9
I 9
	    || (4 + ntohl(smb->smb_buf_length) != (unsigned int)length)) {
E 9
		return 0;
	} else {
D 5
		cERROR(1, ("\nCIFS: smbCalcSize %x ", smbCalcSize(smb)));
E 5
I 5
		cERROR(1, ("smbCalcSize %x ", smbCalcSize(smb)));
E 5
		cERROR(1,
D 5
		       ("CIFS: bad smb size detected. The Mid=%d\n", smb->Mid));
E 5
I 5
		       ("bad smb size detected. The Mid=%d", smb->Mid));
E 5
		return 1;
	}
}
int
is_valid_oplock_break(struct smb_hdr *buf)
{    
D 3
    struct smb_com_lock_req * pSMB = (struct smb_com_lock_req *)buf;

    /* could add check for smb response flag 0x80 */
    cFYI(1,("\nChecking for oplock break"));    
    if(pSMB->hdr.Command != SMB_COM_LOCKING_ANDX)
        return FALSE;
    if(pSMB->hdr.Flags & SMBFLG_RESPONSE)
        return FALSE; /* server sends us "request" here */
    if(pSMB->hdr.WordCount != 8)
        return FALSE;

    cFYI(1,(" oplock type 0x%d level 0x%d",pSMB->LockType,pSMB->OplockLevel));
    if(!(pSMB->LockType & LOCKING_ANDX_OPLOCK_RELEASE))
        return FALSE;    

    /* BB Add following logic: 
       1) look up tcon based on tid & uid 
       2) look up inode from tcon->openFileList->file->f_dentry->d_inode 
       3) flush dirty pages and cached byte range locks and mark inode   
       4) depending on break type change to r/o caching or no caching
       5) send oplock break response to server */
    cFYI(1,("\nNeed to process oplock break "));

    return TRUE;
E 3
I 3
D 4
	struct smb_com_lock_req * pSMB = (struct smb_com_lock_req *)buf;
	struct list_head *tmp;
	struct cifsTconInfo *tcon;
E 4
I 4
D 5
       struct smb_com_lock_req * pSMB = (struct smb_com_lock_req *)buf;
       struct list_head *tmp;
       struct cifsTconInfo *tcon;
E 4

D 4
	/* could add check for smb response flag 0x80 */
	cFYI(1,("\nChecking for oplock break"));    
	if(pSMB->hdr.Command != SMB_COM_LOCKING_ANDX)
		return FALSE;
	if(pSMB->hdr.Flags & SMBFLG_RESPONSE)
		return FALSE; /* server sends us "request" here */
	if(pSMB->hdr.WordCount != 8)
		return FALSE;
E 4
I 4
       /* could add check for smb response flag 0x80 */
       cFYI(1,("\nChecking for oplock break"));    
       if(pSMB->hdr.Command != SMB_COM_LOCKING_ANDX)
               return FALSE;
       if(pSMB->hdr.Flags & SMBFLG_RESPONSE)
               return FALSE; /* server sends us "request" here */
       if(pSMB->hdr.WordCount != 8)
               return FALSE;
E 4

D 4
	cFYI(1,(" oplock type 0x%d level 0x%d",pSMB->LockType,pSMB->OplockLevel));
	if(!(pSMB->LockType & LOCKING_ANDX_OPLOCK_RELEASE))
		return FALSE;    
E 4
I 4
       cFYI(1,(" oplock type 0x%d level 0x%d",pSMB->LockType,pSMB->OplockLevel));
       if(!(pSMB->LockType & LOCKING_ANDX_OPLOCK_RELEASE))
               return FALSE;    
E 4

D 4
	/* look up tcon based on tid & uid */
	read_lock(&GlobalSMBSeslock);
	list_for_each(tmp, &GlobalTreeConnectionList) {
		tcon = list_entry(tmp, struct cifsTconInfo, cifsConnectionList);
		if (tcon->tid == buf->Tid)
			if(tcon->ses->Suid == buf->Uid) {
			/* BB Add following logic: 
			  2) look up inode from tcon->openFileList->file->f_dentry->d_inode
			  3) flush dirty pages and cached byte range locks and mark inode
			  4) depending on break type change to r/o caching or no caching
			  5) send oplock break response to server */
				read_unlock(&GlobalSMBSeslock);
				cFYI(1,("\nFound matching connection, process oplock break"));
				return TRUE;
			}
	}
	read_unlock(&GlobalSMBSeslock);
	cFYI(1,("\nProcessing oplock break for non-existent connection"));
	return TRUE;
E 4
I 4
       /* look up tcon based on tid & uid */
       read_lock(&GlobalSMBSeslock);
       list_for_each(tmp, &GlobalTreeConnectionList) {
               tcon = list_entry(tmp, struct cifsTconInfo, cifsConnectionList);
               if (tcon->tid == buf->Tid)
                       if(tcon->ses->Suid == buf->Uid) {
                       /* BB Add following logic: 
                         2) look up inode from tcon->openFileList->file->f_dentry->d_inode
                         3) flush dirty pages and cached byte range locks and mark inode
                         4) depending on break type change to r/o caching or no caching
                         5) send oplock break response to server */
                               read_unlock(&GlobalSMBSeslock);
                               cFYI(1,("\nFound matching connection, process oplock break"));
                               return TRUE;
                       }
       }
       read_unlock(&GlobalSMBSeslock);
       cFYI(1,("\nProcessing oplock break for non-existent connection"));
       return TRUE;
E 5
I 5
	struct smb_com_lock_req * pSMB = (struct smb_com_lock_req *)buf;
	struct list_head *tmp;
	struct list_head *tmp1;
	struct cifsTconInfo *tcon;
	struct cifsFileInfo *netfile;

	/* could add check for smb response flag 0x80 */
	cFYI(1,("Checking for oplock break"));    
	if(pSMB->hdr.Command != SMB_COM_LOCKING_ANDX)
		return FALSE;
D 16
	if(pSMB->hdr.Flags & SMBFLG_RESPONSE)
		return FALSE; /* server sends us "request" here */
E 16
I 16
	if(pSMB->hdr.Flags & SMBFLG_RESPONSE) {
		/* no sense logging error on invalid handle on oplock
		   break - harmless race between close request and oplock
		   break response is expected from time to time writing out
		   large dirty files cached on the client */
		if ((NT_STATUS_INVALID_HANDLE) == 
		   le32_to_cpu(pSMB->hdr.Status.CifsError)) { 
			cFYI(1,("invalid handle on oplock break"));
			return TRUE;
		} else if (ERRbadfid == 
		   le16_to_cpu(pSMB->hdr.Status.DosError.Error)) {
			return TRUE;	  
		} else {
			return FALSE; /* on valid oplock brk we get "request" */
		}
	}
E 16
	if(pSMB->hdr.WordCount != 8)
		return FALSE;

	cFYI(1,(" oplock type 0x%d level 0x%d",pSMB->LockType,pSMB->OplockLevel));
	if(!(pSMB->LockType & LOCKING_ANDX_OPLOCK_RELEASE))
		return FALSE;    

	/* look up tcon based on tid & uid */
	read_lock(&GlobalSMBSeslock);
	list_for_each(tmp, &GlobalTreeConnectionList) {
		tcon = list_entry(tmp, struct cifsTconInfo, cifsConnectionList);
		if (tcon->tid == buf->Tid) {
			list_for_each(tmp1,&tcon->openFileList){
				netfile = list_entry(tmp1,struct cifsFileInfo,tlist);
				if(pSMB->Fid == netfile->netfid) {
I 8
					struct cifsInodeInfo *pCifsInode;
E 8
D 10
			/* BB Add following logic: 
			  2) look up inode from tcon->openFileList->file->f_dentry->d_inode
			  3) flush dirty pages and cached byte range locks and mark inode
			  4) depending on break type change to r/o caching or no caching
                  cifsinode->clientCanCacheAll = 0
              5)  inode->i_data.a_ops = &cifs_addr_ops_writethrough;
			  6) send oplock break response to server */
E 10
I 10
			/* BB Add following logic to mark inode for write through 
              		    inode->i_data.a_ops = &cifs_addr_ops_writethrough; */
E 10
					read_unlock(&GlobalSMBSeslock);
					cFYI(1,("Matching file id, processing oplock break"));
I 8
					pCifsInode = 
D 12
						CIFS_I(netfile->pfile->f_dentry->d_inode);
E 12
I 12
						CIFS_I(netfile->pInode);
E 12
					pCifsInode->clientCanCacheAll = FALSE;
					if(pSMB->OplockLevel == 0)
						pCifsInode->clientCanCacheRead = FALSE;
					pCifsInode->oplockPending = TRUE;
D 12
					AllocOplockQEntry(netfile->pfile, tcon);
E 12
I 12
					AllocOplockQEntry(netfile->pInode, netfile->netfid, tcon);
E 12
D 10
                    cFYI(1,("about to wake up oplock thd"));
E 10
I 10
					cFYI(1,("about to wake up oplock thd"));
E 10
					wake_up_process(oplockThread);               
E 8
					return TRUE;
				}
			}
			read_unlock(&GlobalSMBSeslock);
			cFYI(1,("No matching file for oplock break on connection"));
			return TRUE;
		}
	}
	read_unlock(&GlobalSMBSeslock);
	cFYI(1,("Can not process oplock break for non-existent connection"));
	return TRUE;
E 5
E 4
E 3
}

void
dump_smb(struct smb_hdr *smb_buf, int smb_buf_length)
{
	int i, j;
	char debug_line[17];
	unsigned char *buffer;

	if (traceSMB == 0)
		return;

	buffer = (unsigned char *) smb_buf;
	for (i = 0, j = 0; i < smb_buf_length; i++, j++) {
		if (i % 8 == 0) {	/* we have reached the beginning of line  */
D 5
			printk("\n| ");
E 5
I 5
			printk(KERN_DEBUG "| ");
E 5
			j = 0;
		}
		printk("%0#4x ", buffer[i]);
		debug_line[2 * j] = ' ';
		if (isprint(buffer[i]))
			debug_line[1 + (2 * j)] = buffer[i];
		else
			debug_line[1 + (2 * j)] = '_';

		if (i % 8 == 7) {	/* we have reached end of line, time to print ascii */
			debug_line[16] = 0;
D 5
			printk(" | %s", debug_line);
E 5
I 5
			printk(" | %s\n", debug_line);
E 5
		}
	}
	for (; j < 8; j++) {
		printk("     ");
		debug_line[2 * j] = ' ';
		debug_line[1 + (2 * j)] = ' ';
	}
D 5
	printk(" | %s\n", debug_line);
E 5
I 5
	printk( " | %s\n", debug_line);
E 5
	return;
}
E 2
I 1
E 1
