H41020
s 00001/00001/00130
d D 1.3 03/06/27 00:52:19 stevef 4 3
c Fix compiler warning
cC
cHlinux.local
cK43027
cZ-07:00
e
s 00001/00006/00130
d D 1.2 03/02/15 16:10:23 stevef 3 2
c Improve error logging
cC
cK42134
cZ-06:00
e
s 00136/00000/00000
d D 1.1 02/10/10 14:16:09 stevef 2 1
cC
cF1
cK53409
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 02/10/10 14:16:09 stevef 1 0
c BitKeeper file /home/stevef/bk/linux-2.5-with-cifs/fs/cifs/cifs_unicode.c
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cHsmfhome1.austin.rr.com
cK31697
cPfs/cifs/cifs_unicode.c
cR4d20bd58fbf42380
cV4
cX0x821
cZ-05:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *   fs/cifs/cifs_unicode.c
 *
 *   Copyright (c) International Business Machines  Corp., 2000,2002
 *   Modified by Steve French (sfrench@us.ibm.com)
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#include <linux/fs.h>
#include "cifs_unicode.h"
#include "cifs_uniupr.h"
#include "cifspdu.h"
#include "cifs_debug.h"

/*
 * NAME:	toUpper()
 *
 * FUNCTION:	Upper case ASCII string (in place) using the current codepage
 *
 */

void
toUpper(const struct nls_table *n, char *mixed_string)
{
D 4
	int i;
E 4
I 4
	unsigned int i;
E 4
	char temp;

	for (i = 0; i < strlen(mixed_string); i++) {
		temp = mixed_string[i];
		mixed_string[i] = n->charset2upper[(int) temp];
	}
}

/*
 * NAME:	cifs_strfromUCS()
 *
 * FUNCTION:	Convert little-endian unicode string to character string
 *
 */
int
cifs_strfromUCS_le(char *to, const wchar_t * from,	/* LITTLE ENDIAN */
		   int len, const struct nls_table *codepage)
{
	int i;
	int outlen = 0;

	for (i = 0; (i < len) && from[i]; i++) {
		int charlen;
		/* 2.4.0 kernel or greater */
		charlen =
		    codepage->uni2char(le16_to_cpu(from[i]), &to[outlen],
				       NLS_MAX_CHARSET_SIZE);
		if (charlen > 0) {
			outlen += charlen;
		} else {
			to[outlen++] = '?';
		}
	}
	to[outlen] = 0;
D 3
	cEVENT(0, ("cifs_strfromUCS returning %d - '%s'\n", outlen, to));
E 3
	return outlen;
}

/*
 * NAME:	cifs_strtoUCS()
 *
 * FUNCTION:	Convert character string to unicode string
 *
 */
int
cifs_strtoUCS(wchar_t * to, const char *from, int len,
	      const struct nls_table *codepage)
{
	int charlen;
	int i;

D 3
	cEVENT(0, ("cifs_strtoUCS - '%s'\n", from));

E 3
	for (i = 0; len && *from; i++, from += charlen, len -= charlen) {

		/* works for 2.4.0 kernel or later */
		charlen = codepage->char2uni(from, len, &to[i]);
		if (charlen < 1) {
			cERROR(1,
D 3
			       ("cifs_strtoUCS: char2uni returned %d.\n",
E 3
I 3
			       ("cifs_strtoUCS: char2uni returned %d",
E 3
				charlen));
			to[i] = cpu_to_le16(0x003f);	/* a question mark */
			charlen = 1;
		}
		to[i] = cpu_to_le16(to[i]);

	}
D 3

	cEVENT(0, (" returning %d\n", i));
E 3

	to[i] = 0;
	return i;
}

/*
 * NAME:	get_UCSname2()
 *
 * FUNCTION:	Allocate and translate to unicode string
 *
 */
/*int
get_UCSname2(struct component_name *uniName, struct dentry *dentry,
	    struct nls_table *nls_tab)
{
	int length = dentry->d_name.len;

	if (length > 255)
		return ENAMETOOLONG;

	uniName->name = kmalloc((length + 1) * sizeof (wchar_t), GFP_KERNEL);

	if (uniName->name == NULL)
		return ENOSPC;

	uniName->namlen = cifs_strtoUCS(uniName->name, dentry->d_name.name,
					length, nls_tab);

	return 0;
} */
E 2
I 1
E 1
