H35018
s 00005/00002/00282
d D 1.7 03/09/02 13:34:10 stevef 8 7
c fix bad return code mapping when server lacks hard link support
cC
cHsteveft21.ltcsamba
cK43077
cZ-05:00
e
s 00002/00002/00282
d D 1.6 03/07/21 22:32:20 stevef 7 6
c cifs enablement for lookup intents (new 2.5 create/lookup flags) final part
cC
cHstevef95.austin.ibm.com
cK40248
cZ-07:00
e
s 00040/00003/00244
d D 1.5 03/05/13 13:00:11 stevef 6 5
c Fix readlink of dfs junctions
cC
cHsteveft21.ltcsamba
cK39466
cZ-05:00
e
s 00028/00013/00219
d D 1.4 03/03/31 21:52:27 stevef 5 4
c Decrease stack usage
cC
cK31245
e
s 00005/00005/00227
d D 1.3 03/02/15 16:10:24 stevef 4 3
c Improve error logging
cC
cHsmfhome1.austin.rr.com
cK13478
e
s 00018/00005/00214
d D 1.2 02/11/21 16:58:07 stevef 3 2
c Support for readlink to Windows directory symlinks (junction points)
cC
cHsteveft21.ltcsamba
cK14924
cZ-06:00
e
s 00219/00000/00000
d D 1.1 02/10/10 14:16:13 stevef 2 1
cC
cF1
cK56468
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 02/10/10 14:16:13 stevef 1 0
c BitKeeper file /home/stevef/bk/linux-2.5-with-cifs/fs/cifs/link.c
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cHsmfhome1.austin.rr.com
cK09673
cPfs/cifs/link.c
cRb0dbff9f12b2b4d5
cV4
cX0x821
cZ-05:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *   fs/cifs/link.c
 *
D 8
 *   Copyright (c) International Business Machines  Corp., 2002
E 8
I 8
 *   Copyright (C) International Business Machines  Corp., 2002,2003
E 8
 *   Author(s): Steve French (sfrench@us.ibm.com)
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#include <linux/fs.h>
#include <linux/stat.h>
#include "cifsfs.h"
#include "cifspdu.h"
#include "cifsglob.h"
#include "cifsproto.h"
#include "cifs_debug.h"
#include "cifs_fs_sb.h"

int
cifs_hardlink(struct dentry *old_file, struct inode *inode,
	      struct dentry *direntry)
{
	int rc = -EACCES;
	int xid;
	char *fromName = NULL;
	char *toName = NULL;
	struct cifs_sb_info *cifs_sb_target;
	struct cifsTconInfo *pTcon;
	struct cifsInodeInfo *cifsInode;

	xid = GetXid();

	cifs_sb_target = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb_target->tcon;

/* No need to check for cross device links since server will do that - BB note DFS case in future though (when we may have to check) */

	fromName = build_path_from_dentry(old_file);
	toName = build_path_from_dentry(direntry);
	if (cifs_sb_target->tcon->ses->capabilities & CAP_UNIX)
		rc = CIFSUnixCreateHardLink(xid, pTcon, fromName, toName,
					    cifs_sb_target->local_nls);
D 8
	else
E 8
I 8
	else {
E 8
		rc = CIFSCreateHardLink(xid, pTcon, fromName, toName,
					cifs_sb_target->local_nls);
I 8
		if(rc == -EIO)
			rc = -EOPNOTSUPP;  
	}
E 8

/* if (!rc)     */
	{
		/*   renew_parental_timestamps(old_file);
		   inode->i_nlink++;
		   mark_inode_dirty(inode);
		   d_instantiate(direntry, inode); */
		/* BB add call to either mark inode dirty or refresh its data and timestamp to current time */
	}
	d_drop(direntry);	/* force new lookup from server */
	cifsInode = CIFS_I(old_file->d_inode);
	cifsInode->time = 0;	/* will force revalidate to go get info when needed */

	if (fromName)
		kfree(fromName);
	if (toName)
		kfree(toName);
	FreeXid(xid);
	return rc;
}

int
cifs_follow_link(struct dentry *direntry, struct nameidata *nd)
{
	struct inode *inode = direntry->d_inode;
	int rc = -EACCES;
	int xid;
	char *full_path = NULL;
D 5
	char target_path[257];
E 5
I 5
	char * target_path;
E 5
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;

	xid = GetXid();
	full_path = build_path_from_dentry(direntry);
D 4
	cFYI(1, ("\nFull path: %s inode = 0x%p\n", full_path, inode));
E 4
I 4
	cFYI(1, ("Full path: %s inode = 0x%p", full_path, inode));
E 4
	cifs_sb = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb->tcon;
D 5

E 5
I 5
	target_path = kmalloc(PATH_MAX, GFP_KERNEL);
	if(target_path == NULL) {
		FreeXid(xid);
		return -ENOMEM;
	}
E 5
	/* can not call the following line due to EFAULT in vfs_readlink which is presumably expecting a user space buffer */
	/* length = cifs_readlink(direntry,target_path, sizeof(target_path) - 1);    */

/* BB add read reparse point symlink code and Unix extensions symlink code here BB */
	if (pTcon->ses->capabilities & CAP_UNIX)
		rc = CIFSSMBUnixQuerySymLink(xid, pTcon, full_path,
					     target_path,
D 5
					     sizeof (target_path) - 1,
E 5
I 5
					     PATH_MAX-1,
E 5
					     cifs_sb->local_nls);
	else {
		/* rc = CIFSSMBQueryReparseLinkInfo */
		/* BB Add code to Query ReparsePoint info */
	}
	/* BB Anything else to do to handle recursive links? */
	/* BB Should we be using page symlink ops here? */

	if (rc == 0) {
I 6

/* BB Add special case check for Samba DFS symlinks */

E 6
D 5
		target_path[256] = 0;
E 5
I 5
		target_path[PATH_MAX-1] = 0;
E 5
		rc = vfs_follow_link(nd, target_path);
	}
	/* else EACCESS */

I 5
	if (target_path)
		kfree(target_path);
E 5
	if (full_path)
		kfree(full_path);
	FreeXid(xid);
	return rc;
}

int
cifs_symlink(struct inode *inode, struct dentry *direntry, const char *symname)
{
	int rc = -EOPNOTSUPP;
	int xid;
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;
	char *full_path = NULL;
	struct inode *newinode = NULL;

	xid = GetXid();

	cifs_sb = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb->tcon;

	full_path = build_path_from_dentry(direntry);
D 4
	cFYI(1, ("\nFull path: %s ", full_path));
	cFYI(1, (" symname is %s\n", symname));
E 4
I 4
	cFYI(1, ("Full path: %s ", full_path));
	cFYI(1, ("symname is %s", symname));
E 4

	/* BB what if DFS and this volume is on different share? BB */
	if (cifs_sb->tcon->ses->capabilities & CAP_UNIX)
		rc = CIFSUnixCreateSymLink(xid, pTcon, full_path, symname,
					   cifs_sb->local_nls);
	/* else
	   rc = CIFSCreateReparseSymLink(xid, pTcon, fromName, toName,cifs_sb_target->local_nls); */

	if (rc == 0) {
		if (pTcon->ses->capabilities & CAP_UNIX)
			rc = cifs_get_inode_info_unix(&newinode, full_path,
						      inode->i_sb);
		else
D 7
			rc = cifs_get_inode_info(&newinode, full_path,
E 7
I 7
			rc = cifs_get_inode_info(&newinode, full_path, NULL,
E 7
						 inode->i_sb);

		if (rc != 0) {
			cFYI(1,
D 4
			     ("\nCreate symlink worked but get_inode_info failed with rc = %d ",
E 4
I 4
			     ("Create symlink worked but get_inode_info failed with rc = %d ",
E 4
			      rc));
		} else {
			direntry->d_op = &cifs_dentry_ops;
			d_instantiate(direntry, newinode);
		}
	}

	if (full_path)
		kfree(full_path);
	FreeXid(xid);
	return rc;
}

int
cifs_readlink(struct dentry *direntry, char *pBuffer, int buflen)
{
	struct inode *inode = direntry->d_inode;
	int rc = -EACCES;
	int xid;
I 3
	int oplock = FALSE;
E 3
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;
	char *full_path = NULL;
I 6
	char *tmp_path =  NULL;
E 6
D 5
	char tmpbuffer[256];
E 5
I 5
	char * tmpbuffer;
I 6
	unsigned char * referrals = NULL;
	int num_referrals = 0;
E 6
	int len;
E 5
I 3
	__u16 fid;
E 3

	xid = GetXid();
	cifs_sb = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb->tcon;
	full_path = build_path_from_dentry(direntry);
	cFYI(1,
D 4
	     ("\nFull path: %s inode = 0x%p pBuffer = 0x%p buflen = %d\n",
E 4
I 4
	     ("Full path: %s inode = 0x%p pBuffer = 0x%p buflen = %d",
E 4
	      full_path, inode, pBuffer, buflen));
D 5

E 5
I 5
	if(buflen > PATH_MAX)
		len = PATH_MAX;
	else
		len = buflen;
	tmpbuffer = kmalloc(len,GFP_KERNEL);   
	if(tmpbuffer == NULL) {
		FreeXid(xid);
		return -ENOMEM;
	}
I 6

E 6
E 5
/* BB add read reparse point symlink code and Unix extensions symlink code here BB */
	if (cifs_sb->tcon->ses->capabilities & CAP_UNIX)
		rc = CIFSSMBUnixQuerySymLink(xid, pTcon, full_path,
D 3
					     tmpbuffer,
					     sizeof (tmpbuffer) - 1,
					     cifs_sb->local_nls);
E 3
I 3
D 5
					tmpbuffer,
					sizeof (tmpbuffer) - 1,
					cifs_sb->local_nls);
E 5
I 5
				tmpbuffer,
				len - 1,
				cifs_sb->local_nls);
E 5
E 3
	else {
D 3
		/* rc = CIFSSMBQueryReparseLinkInfo */
		/* BB Add code to Query ReparsePoint info */
E 3
I 3
		rc = CIFSSMBOpen(xid, pTcon, full_path, FILE_OPEN, GENERIC_READ,
D 7
				OPEN_REPARSE_POINT,&fid, &oplock, cifs_sb->local_nls);
E 7
I 7
				OPEN_REPARSE_POINT,&fid, &oplock, NULL, cifs_sb->local_nls);
E 7
		if(!rc) {
			rc = CIFSSMBQueryReparseLinkInfo(xid, pTcon, full_path,
				tmpbuffer,
D 5
				sizeof(tmpbuffer) - 1, 
E 5
I 5
				len - 1, 
E 5
				fid,
				cifs_sb->local_nls);
			if(CIFSSMBClose(xid, pTcon, fid)) {
				cFYI(1,("Error closing junction point (open for ioctl)"));
			}
I 6
			if(rc == -EIO) {
				/* Query if DFS Junction */
				tmp_path =
					kmalloc(MAX_TREE_SIZE + MAX_PATHCONF + 1,
						GFP_KERNEL);
				if (tmp_path) {
					strncpy(tmp_path, pTcon->treeName, MAX_TREE_SIZE);
					strncat(tmp_path, full_path, MAX_PATHCONF);
					rc = get_dfs_path(xid, pTcon->ses, tmp_path,
						cifs_sb->local_nls, &num_referrals, &referrals);
					cFYI(1,("Get DFS for %s rc = %d ",tmp_path, rc));
					if((num_referrals == 0) && (rc == 0))
						rc = -EACCES;
					else {
						cFYI(1,("num referral: %d",num_referrals));
						if(referrals) {
							cFYI(1,("referral string: %s ",referrals));
							strncpy(tmpbuffer, referrals, len-1);
						}
					}

					kfree(tmp_path);
					if(referrals) {
						kfree(referrals);
					}
				}
				/* BB add code like else decode referrals then memcpy to
				  tmpbuffer and free referrals string array BB */
			}
E 6
		}
D 6

E 6
E 3
	}
	/* BB Anything else to do to handle recursive links? */
	/* BB Should we be using page ops here? */

	/* BB null terminate returned string in pBuffer? BB */
D 5
	if (buflen > sizeof (tmpbuffer))
		buflen = sizeof (tmpbuffer);
E 5
	if (rc == 0) {
D 5
		rc = vfs_readlink(direntry, pBuffer, buflen, tmpbuffer);
E 5
I 5
		rc = vfs_readlink(direntry, pBuffer, len, tmpbuffer);
E 5
		cFYI(1,
		     ("vfs_readlink called from cifs_readlink returned %d",
		      rc));
	}

I 5
D 6
	if (tmpbuffer)
E 6
I 6
	if (tmpbuffer) {
E 6
		kfree(tmpbuffer);
E 5
D 6
	if (full_path)
E 6
I 6
	}
	if (full_path) {
E 6
		kfree(full_path);
I 6
	}
E 6
	FreeXid(xid);
	return rc;
}
E 2
I 1
E 1
