
/* Lib functions for divers programs. */

#include <stdio.h>
#include <string.h>

/* Use prototypes if available.  */
#if defined (__cplusplus) || (defined (__STDC__) && __STDC__)
#undef  PARAMS
#define PARAMS(protos)  protos
#else /* Not C++ or ANSI C.  */
#undef  PARAMS
#define PARAMS(protos)  ()
#endif /* C++ or ANSI C.  */

#if HAVE_MALLOC_H
#   include <malloc.h>
#elif defined STDC_HEADERS
    extern void free PARAMS ((char *));
    extern char *malloc PARAMS ((int));
    extern char *realloc PARAMS ((char*, int));
#endif

extern void close_file (FILE * f);
extern void error (char const *fmt,...);
extern void error_setprogname (char const *fmt);
extern FILE *open_file (char const *name, char const *mode);
extern void output (FILE * f, char const *s,...);
extern char *str_addchar (char *str, int ch);
extern char *str_concat (char *str, char const *tail);
extern char *str_replace (char *str, char const *search, char const *replace);
extern char *str_short (char const *s);
extern char **strtab_add (char **tab, int *ntab, char const *newstr);
extern void strtab_del (char **tab, int *ntab, char const *what);
extern int strtab_find (char **tab, int ntab, char const *string);
extern void strtab_free (char **tab, int ntab);
extern void warning (char const *fmt,...);
extern void *xrealloc (void *mem, int newsz);
extern char *xstrdup (char const *s);
extern void warranty ();
