#!@SHELL@

POST_BIN=${LIBEXEC_DIR-@bindir@}

####################################################### Print error and die.
error()
{
    echo $@ 1>&2
    exit 1
}

#################################################### Run a process or abort.
run()
{
    $* || error "$1 failed!"
}

########################################################### Start of script.
# Must have exactly one argument.
if [ "$1" = "" -o "$2" != "" ] ; then
    cat << ENDUSAGE 1>&2

Yodl2txt-post @TOPLEVEL_VERSION@

Usage: yodl2txt-post FILE
This script must be started by yodl2txt.
ENDUSAGE
    
    exit 1
fi

# Have yodlfixlables fix stuff.
# Then, have awk remove multiple empty lines.
$POST_BIN/yodlfixlabels -labels -tableofcontents $1 - | \
awk '{
    if (NF == 0)
    {
        emptylines++;
    }
    else if (emptylines)
    {
        printf("\n%s\n", $0);
        emptylines = 0;
    }
    else
        print;
}' > $1.new || error "postprocessing failed!"

run mv $1.new $1
