
#include <ctype.h>
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "../lib/lib.h"

typedef enum                        /* document type */
{
    type_unknown,
    type_article,
    type_book,
} DOCTYPE;

typedef struct                      /* table of strings */
{
    char **str;
    int nstr;
} STRINGTAB;

typedef struct                      /* label representation */
{
    char *label;
    char *value;
    char *fname;
} LABEL;

#ifndef EXTERN
#   define EXTERN extern
#endif

EXTERN LABEL
    *lab;                           /* array of labels */
EXTERN int
    nlab;                           /* array size */

EXTERN DOCTYPE
    doctype;                        /* document type */

EXTERN char
    *yytext;                        /* buffer of lexical analyzer */

EXTERN FILE
    *outf,                          /* output file */
    *tocf,                          /* table of contents file */
    *yyin;                          /* input file */
EXTERN char
    *tocfname,                      /* table of contents file */
    *curfile,                       /* current output file */
    *inputfile,                     /* true input file (.in) */
    *fname;                         /* original name of input file */
EXTERN int
    outf_count,                     /* counter for output files */
    outf_max;                       /* max output file count */
    
EXTERN char
    **tempfiles;                    /* tmp files, to be removed later */
EXTERN int
    ntempfiles;                     /* counter of temporary files */
                         
EXTERN int
    pass,                           /* parsing pass number */
    lineno;                         /* line number in input file */
    
EXTERN char
    *lastnum;                       /* last sectioning number */
    
EXTERN int
    lastlabelnr;                    /* number of last internal label */
    
EXTERN STRINGTAB
    doctitle,                       /* document title */
    bodyopt;                        /* options for <body ..> tag */

extern void bodytagopt (STRINGTAB tab);
extern void chapterlinks (void);
extern void cleanup (int iserror);
extern void documenttype (STRINGTAB tab);
extern void handletag (STRINGTAB tags);
extern void init (void);
extern void label (STRINGTAB t);
extern void lastnumber (STRINGTAB t);
extern void newfile (STRINGTAB t);
extern char *outputfilename (int count);
extern void stringtab_addstr (STRINGTAB *t, char const *str);
extern void stringtab_reset (STRINGTAB *t);
extern void stringtab_setstr (STRINGTAB *t, char const *str);
extern void ref (STRINGTAB t);
extern void solvelink (STRINGTAB t);
extern void tableofcontents (STRINGTAB t);
extern void title (STRINGTAB t);
extern void tocentry (STRINGTAB t);
extern void unknowntag (STRINGTAB t);
extern void usage (void);
extern int  yyerror (char const *msg);
extern int  yyparse ();
extern void yyrestart (FILE *f);
