
#include "yodl.h"

void sighandler (int sig)
{
    fflush (outf);

    if (sig == SIGSEGV)
    {
        fprintf (stderr, 
"\n"
"Oops! YODL caused a segment violation. This is of course an internal bug.\n"
"Please send the following info to the current maintainer\n"
"                   %s\n"
"and the bug will hopefully be fixed. Send the following info:\n"
"   - the version of your YODL package\n"
"   - all the sourcefiles that YODL parses, including macro definition files\n"
"\n",
                 MAINTAINER
);
    
        signal (SIGSEGV, SIG_DFL);
        kill (getpid (), SIGSEGV);
        exit (1);
    }

    error ("caught signal %d", sig);
}
