
#include "yodl.h"

void lexer_pushstr (char const *s)
{
    char
        *beyondAlpha,                           /* for smuggling the '+' */
        *cp,                                    /* tmp memory pointer */
        *lexbuf_target;                         /* where we are in */
                                                /* pushed info of lexer */

    if (! s || ! *s)                            /* no string, nogo */
        return;
        
    if (! lexer_pushed)                         /* nothing pushed yet? */
        lexer_pushed = xstrdup (s);
    else                                        /* already pushed pre-input: */
    {                                           /* add as head of buffer */
        cp = xstrdup (s);
        
        if (lexer_pushedp && *lexer_pushedp)    /* determine next part of */
            lexbuf_target = lexer_pushedp;      /* prepushed lexer info */
        else
            lexbuf_target = lexer_pushed;

        
        for                                     /* FBB: find the next char  */
        (                                       /* beyond tha alphas, to    */
            beyondAlpha = lexbuf_target;        /* check for a SYMBOL(      */
                isIdentChar(*beyondAlpha);      /* below                    */
                    ++beyondAlpha
        )
            ;

        if 
        (
            *beyondAlpha == '('                 /* Needed for a symbol(     */
            &&
            gram_hasident (lexbuf_target)       /* smuggle in + if needed */
        )
            cp = str_addchar (cp, '+');

        cp = str_concat (cp, lexbuf_target);    /* add new string as head */

        free (lexer_pushed);                    /* set new lexer_pushed */
        lexer_pushed = cp;
    }
    
    lexer_pushedp = 0;                          /* ptr into lexer_pushed */
                                                /* must now restart */

    message (4, "stacking input: %s (now: %s)\n", 
             str_short (s), str_short (lexer_pushed));
}



