
#include "yodl.h"

int lexer_eof ()
{
    int
        ch;                                 /* look-ahead char */

    if (lexer_pushed)                       /* more pushed chars: never EOF */
        return (0);
        
    if (! inf)                              /* no input file: all done */
        return (1);                         /* THANX, Matthias Lindner */
	                                    /* <lindner@forwiss.uni-erlangen.de> */
        
    ch = fgetc (inf);                       /* try to read */
    if (feof (inf))                         /* failed? */
        return (1);                         /* yup.. EOF found */
        
    ungetc (ch, inf);                       /* succeeded: push back char */
    return (0);                             /* not at EOF yet */
}